#!/usr/local/bin/perl

#
### CONTROL PANEL SCRIPT FOR ULTIMATE BULLETIN BOARD ##
#
# Ultimate Bulletin Board is copyright Madrona Park, Inc., 1997, 1998.
#
#       ------------ cpanel3.cgi -------------
#
#  This file contains some of the control panel functionality for
#  the UBB.  It is called from the controlpanel pages (cp.html).
#
#  NOTE: you MAY NOT redistribute this script under any
#  circumstance.  This means that you may not sell, trade, or in
#  any other way give this script to another user who is not
#  licensed to use it.  Madrona Park, Inc. offers no
#  warranties on this script.  The owner/licensee of the script is
#  solely responsible for any problems caused by installation of
#  the script or use of the script, including messages that may be
#  posted on the BB.
#
#  All copyright notices regarding the Ultimate Bulletin Board
#  must remain intact on the scripts and in the HTML
#  for the scripts.
#
# For more info on the Ultimate BB, 
# see http://www.UltimateBB.com
#
###############################################################
#If you are running UBB on IIS,
#you may need to add the following line
#if so, just remove the "#" sign before the print line below
#print "HTTP/1.0 200 OK\n";

print ("Content-type: text/html\n\n");
eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file

require "mods.file";
require "UltBB.setup";
require "Styles.file";
require "ubb_library.pl";
require "ubb_library2.pl";
require "Date.pl";
};

if ($@) {
    print "Error including required files: $@\n";
    print "Make sure these files exist, permissions are set properly, and paths are set correctly.";
 exit;
}

&ReadParse;

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	
	if ($Name eq "ViewEntire") {
			$ViewEntire = $Value;
		}
	if ($Name eq "NN") {
			$SearchName = $Value;
			$SearchName =~tr/A-Z/a-z/; 
			}
	if ($Name eq "BBEmail") {
			$BBEmail = $Value;
			$BBEmail =~ s/@/\\@/;
			}
			
	if ($Name eq "Forum1") {
			$Forum1 = $Value;
			$Forum1 =~ s/"/&quot;/g;
		}
	
	if ($Name eq "BBRules") {
			$BBRules = $Value;
			$BBRules =~ s/"/&quot;/g;
			$BBRules =~ s/\@/\\@/g;
			$BBRules = &ConvertReturns($BBRules);
			}
		if ($Name eq "censorwords") {
			$censorwords = $Value;
			$censorwords = &EliminateReturns($censorwords);
			$censorwords =~ s/<BR>//ig;
			$censorwords =~ s/<P>//ig;
			$censorwords =~ s/"/&quot;/g;
			$censorwords =~ s/\@/\\@/g;
			}
		if ($Name eq "YourCopyrightNotice") {
			$YourCopyrightNotice = $Value;
			$YourCopyrightNotice = &EliminateReturns($YourCopyrightNotice);
			$YourCopyrightNotice =~ s/"/&quot;/g;
			$YourCopyrightNotice =~ s/<BR>//ig;
			$YourCopyrightNotice =~ s/<P>//ig;
			$YourCopyrightNotice =~ s/\@/\\@/g;
			}
		if ($Name eq "Header") {
			$Header = $Value;
			$Header =~ s/"/\\"/g;
			$Header =~ s/\@/\\@/g;
			}
		if ($Name eq "Footer") {
			$Footer = $Value;
			$Footer =~ s/"/\\"/g;
			$Footer =~ s/\@/\\@/g;
			}
	if ($Name eq "ForumStatus1") {
			$ForumStatus1 = $Value;
			}
	
	
	if ($Name eq "MyHomePage") {
			$MyHomePage = $Value;
			}
	
	if ($Name eq "HomePageURL") {
			$HomePageURL = $Value;
			}
	
	if ($Name eq "number") {
			$number = $Value;
			}

	if ($Name eq "UpdateType") {
			$UpdateType = $Value;
			}		
	if ($Name eq "TotalForums") {
			$TotalForums = $Value;
			}
	if ($Name eq "BBName") {
			$BBName = $Value;
			}
	if ($Name eq "ForumsPath") {
			$ForumsPath = $Value;
			}
			if ($Name eq "MembersPath") {
			$MembersPath = $Value;
			}
			if ($Name eq "CGIPath") {
			$CGIPath = $Value;
			}
				if ($Name eq "VariablesPath") {
			$VariablesPath = $Value;
			}
	if ($Name eq "MembersCGIPath") {
			$MembersCGIPath = $Value;
			}
			if ($Name eq "NonCGIPath") {
			$NonCGIPath = $Value;
			}
			if ($Name eq "CGIURL") {
			$CGIURL = $Value;
			}
			if ($Name eq "NonCGIURL") {
			$NonCGIURL = $Value;
			}
		
		if ($Name eq "UserNameCheck") {
			$UserNameCheck = $Value;
			$UserNameCheckFile = $UserNameCheck;
			$UserNameCheckFile =~ s/ /_/g; #remove spaces
			}

		if ($Name eq "UserName") {
			$UserName = $Value;
			$UserName = &UNHTMLIFY($UserName);
			$UserNameFile = $UserName;
			$UserNameFile =~ s/ /_/g; #remove spaces
		}
			if ($Name eq "Password") {
			$Password = $Value;
			$Password = &UNHTMLIFY($Password);
			}
			if ($Name eq "PasswordCheck") {
			$PasswordCheck = $Value;
			}
				if ($Name eq "action") {
			$action = $Value;
			}
			
} #end foreach loop

if ($VariablesPath eq "") {
	$VariablesPath = "$CGIPath";
}

if ($action eq "forums") {
&Forums;
}
if ($action eq "sendforums") {
&SendForums;
}
if ($action eq "addnewforum") {
&AddNewForum;
}
if ($action eq "ContinueLastTimes") {
&SetLastTimesCycle;
}
if ($action eq "ContinueThreadNums") {
&SetLastThreadNumsCycle;
}
if ($action eq "viewbanlist") {
&ViewBanList;
}
if ($action eq "submitbans") {
&SubmitBans;
}

sub SubmitBans {
&VerifyAdmin($UserNameCheck, $PasswordCheck);
if ($Proceed eq "true") {
$EmailBans = $in{'EmailBan'};
$EmailBans =~ s/\@/\\@/g;
@EmailBanList = split(/\s/, $EmailBans);

$IPBans = $in{'IPBan'};
$IPBans =~ s/\@/\\@/g;
@IPBanList = split(/\s/, $IPBans);

&Lock("lock.file");
open(EMAILBAN, ">$NonCGIPath/BanLists/EmailBan.cgi");
foreach $one(@EmailBanList) {
	chomp($one);
	if ($one ne "") {
	print EMAILBAN "$one\n";
	}
}
close(EMAILBAN);
&Unlock("lock.file");
chmod (0777, "$NonCGIPath/BanLists/EmailBan.cgi");

&Lock("lock.file");
open(IPBAN, ">$NonCGIPath/BanLists/IPBan.cgi");
foreach $uno(@IPBanList) {
	chomp($uno);
	if ($uno ne "") {
	print IPBAN "$uno\n";
	}
}
close(IPBAN);
&Unlock("lock.file");
chmod (0777, "$NonCGIPath/BanLists/IPBan.cgi");

&EndUpdate("B A N &nbsp;&nbsp;&nbsp;&nbsp; L I S T S &nbsp;&nbsp;&nbsp;&nbsp; U P D A T E D", "Your registration ban lists have been successully updated!");
}
} #end Submit Bans

sub ViewBanList {
&VerifyAdmin($UserName, $Password);
if ($Proceed eq "true") {
#get current ban lists

@emailbans = &OpenFile("$NonCGIPath/BanLists/EmailBan.cgi");
@IPbans = &OpenFile("$NonCGIPath/BanLists/IPBan.cgi");

$Count = 0;
foreach $one(@emailbans) {
	$emailbans[$Count] =~ s/\\@/@/sg;
	$Count++;
}

$EmailBan = join(/\n/, @emailbans);
$IPBan = join(/\n/, @IPbans);

$PageTitle = "B A N &nbsp;&nbsp;&nbsp;&nbsp; L I S T S";
&HEADER2HTML;

print<<BANNED;
<FONT SIZE="2" FACE="Verdana, Arial">You can prevent certain users from being registered, based on email addresses they attempt to register with or their IP numbers. </FONT> 
<P>

<FORM ACTION="cpanel3.cgi" METHOD="POST" NAME="THEFORM">

<CENTER>
<table border=0 cellpadding=0 cellspacing=0 width="95%"><TR><td bgcolor="#000000">
<table border=0 cellpadding=4 border=0 cellspacing=1 width=100%>
<TR bgcolor="#B0BB9D">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<B>Email Ban Lists:  You may ban certain email addresses from registering on your forums.  To ban a specific email, type the full email address (as in, waldo\@whereiswaldo.com).  To ban all email addresses from certain domains, such as hotmail, simply type the domain name (as in hotmail.com)- that will prevent anyone using a hotmail address from registering.  Put each banned email on its own line (hit the carriage return after each email entry to be banned).</B></FONT>
</TD>
</tr>
BANNED

&InputAreaRow("#f7f7f7", "Email Ban List:", "", "EmailBan", "30", "5");

print<<NEXT;
<TR bgcolor="#B0BB9D">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<B>IP Number Ban Lists:  You may ban any IP numbers from registering and posting.  Type in the complete IP number (as in 243.21.31.7), or use a partial IP number (as in 243.21.31).  The UBB will do matches from the beginning of each IP number that you enter.  Thus, If you enter a partial IP of 243.21.31, someone attempting to register who has an IP number of 243.21.31.5 will not be able to register.  Similarly, if you have an IP ban on 243.21, someone registering who has an IP of 243.21.3.44 will not be able to register.  Thus, be careful when you add IPs to your ban list and be as specific as possible.  As with the email ban list, put each IP number on its own line (hit the carriage return after each entry).  The IP Ban prevents anyone with matching IP number from registering and posting.</B></FONT>
</TD>
</tr>
NEXT

&InputAreaRow("#f7f7f7", "IP Number Ban List:", "", "IPBan", "30", "5");

print<<BOTTOM;
<TR bgcolor="#C7C6BA">
<TD><FONT Size="2" FACE="Verdana, Arial">
UserName:</font></TD><TD><INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25></td></tr>
<TR bgcolor="#C7C6BA">
<TD><FONT Size="2" FACE="Verdana, Arial">Password</font></TD><TD><INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></TD></tr>
</table>
</td></tr></table>
<P>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="submitbans">

<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Ban Lists">
</FORM>
<P><BR>
<FONT SIZE="1" FACE="Verdana, Arial">&copy; Madrona Park, Inc., 1998-1999.</FONT></CENTER>
</body></html>
BOTTOM


}  
}  #end ViewBanList

sub Forums {
# Verify that user is ADMIN first!
&VerifyAdmin($UserName, $Password);
if ($Proceed eq "true") {
	&DoForums;
}  
} #end Forums sr

sub DoForums {

if ($UserNameCheck ne "") {
$UserNameFill = "$UserNameCheck";
}  else {
$UserNameFill = "$UserName";
}
$UserNameFill = &HTMLIFY($UserNameFill);

if ($PasswordCheck ne "") {
$PasswordFill = "$PasswordCheck";
}  else {
$PasswordFill = "$Password";
}
$PasswordFill = &HTMLIFY($PasswordFill);

# check to see how many forums are currently listed
@forums = &OpenForumsFile;
$ForumTotal = @forums;
	$StartPoint = $in{'StartPoint'};
	$EndPoint = $StartPoint + 10;		
	$RecordStart = $StartPoint + 1;
	
if ($EndPoint >= $ForumTotal) {
	$NoMore = "true";
	$EndPoint = $ForumTotal;
}
if (($NoMore eq "true") && ($StartPoint eq "0")) {
	$NextForums = "";
	}
elsif ($ForumTotal >= ($EndPoint + 10)) {
	$NextTotal = 10;
	$PrefixWord = "Next";
	$NextForums  = qq(<FORM ACTION="cpanel3.cgi" METHOD="POST"><INPUT TYPE="HIDDEN" NAME="UserName" VALUE="$UserNameFill"><INPUT TYPE="HIDDEN" NAME="Password" VALUE="$PasswordFill"><INPUT TYPE="HIDDEN" NAME="PrefixWord" VALUE="Next"><INPUT TYPE="HIDDEN" NAME="action" VALUE="forums"><INPUT TYPE="HIDDEN" NAME="StartPoint" VALUE="$EndPoint"><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Next $NextTotal Forums"></form>);
}
elsif ($ForumTotal <= $EndPoint) {
		$NextTotal = 10;
		$NextPoint = $StartPoint - 10;
		$PrefixWord = "Previous";
		$NextForums  = qq(<FORM ACTION="cpanel3.cgi" METHOD="POST"><INPUT TYPE="HIDDEN" NAME="UserName" VALUE="$UserNameFill"><INPUT TYPE="HIDDEN" NAME="Password" VALUE="$PasswordFill"><INPUT TYPE="HIDDEN" NAME="action" VALUE="forums"><INPUT TYPE="HIDDEN" NAME="StartPoint" VALUE="$EndPoint"><INPUT TYPE="HIDDEN" NAME="PrefixWord" VALUE="Previous"><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Previous 10 Forums"></form>);
}  else {
	$NextTotal = $ForumTotal - $EndPoint;
	$NextPoint = $EndPoint;
	$PrefixWord = "Next";
		$NextForums  = qq(<FORM ACTION="cpanel3.cgi" METHOD="POST"><INPUT TYPE="HIDDEN" NAME="UserName" VALUE="$UserNameFill"><INPUT TYPE="HIDDEN" NAME="Password" VALUE="$PasswordFill"><INPUT TYPE="HIDDEN" NAME="action" VALUE="forums"><INPUT TYPE="HIDDEN" NAME="PrefixWord" VALUE="Next"><INPUT TYPE="HIDDEN" NAME="StartPoint" VALUE="$EndPoint"><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Next $NextTotal Forums"></form>);
}

$PageTitle = "S E T &nbsp;&nbsp;&nbsp;&nbsp; F O R U M &nbsp;&nbsp;&nbsp;&nbsp; V A R I A B L E S";
&HEADER2HTML;

print<<ForumHTML;
<FONT SIZE="1" FACE="Verdana, Arial">You can easily assign/change forum names, descriptions, and properties through this control panel area.</FONT> 
<P><FONT SIZE="2" FACE="Verdana, Arial">
<B>To Add A New Forum,  <A HREF="cpanel.cgi?action=addforums">Click Here.</a></font></B>
<P>
<table border=0 width=95%><TR><TD>
<B><FONT SIZE="2" FACE="Verdana, Arial">Update Existing Forums Below</FONT></B></td><TD align=center><FONT SIZE="1" FACE="Verdana, Arial">[<A HREF="$NonCGIURL/forumterms.html" target=_new>forum variable terms</A>]</FONT></td></TR></table>
<P>
<FONT SIZE="2" FACE="Verdana, Arial">You currently have $ForumTotal total forums (either active or inactive).  Forums are listed in blocks of 10 per page.  If you need to add new forums, <A HREF="cpanel.cgi?action=addforums">click here</A>.</FONT>
<P>
<TABLE BORDER=0 cellspacing=0 cellpadding=0 width=95%><TR><td bgcolor="#000000">
<table border=0 width=100%>
<TR bgcolor="#CAB5A6"><TD>
<B><FONT SIZE="2" FACE="Verdana, Arial">Forums $RecordStart to $EndPoint (of $ForumTotal Total)</FONT></B></td>
<td align=center><FONT SIZE="1" FACE="Verdana, Arial">$NextForums</FONT></td></tr></table>
<FORM ACTION="cpanel3.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
ForumHTML

	$ForumCounter = 0;
	for $forumline(@forums) {
		$ForumCounter++;
		if (($StartPoint < $ForumCounter) && ($ForumCounter <= $EndPoint)) {
	my $ForumActive = "";
	my $ForumInactive = "";
	my $HTMLOn = "";
	my $HTMLOff = "";
	my $UBBOn = "";
	my $UBBOff = "";
	my $PrivateOn = "";
	my $TRrestrictOn = "";
	my $TRallregOn = "";
	my $TRallOn = "";
	my $RRrestrictOn = "";
	my $RRallregOn = "";
	my $RRallOn = "";
	my $RRnoneOn = "";
	my $PrivateMaxYes = "";
	my $PrivateMaxNo = "";
	my $UBBImagesOn = "";
	my $UBBImagesOff = "";
	my $ModNotifyOn = "";
	my $ModNotifyOff = "";

		@thisforum = split(/\|/, $forumline);
		chomp($thisforum[10]);
		chomp($thisforum[11]);
		chomp($thisforum[12]);
		chomp($thisforum[13]);
		if ($thisforum[3] eq "On") {
			$ForumActive = "CHECKED";
		}  else {
			$ForumInactive = "CHECKED";
		}
		if ($thisforum[13] eq "no") {
			$PrivateMaxNo = "CHECKED";
		}  else {
			$PrivateMaxYes = "CHECKED";
		}
		if ($thisforum[4] eq "is") {
			$HTMLOn = "CHECKED";
		}  else {
			$HTMLOff = "CHECKED";
		}
		if ($thisforum[5] eq "is") {
			$UBBOn = "CHECKED";
		}  else {
			$UBBOff = "CHECKED";
			}
if ($thisforum[10] eq "OFF") {
			$UBBImagesOff = "CHECKED";
		}  else {
			$UBBImagesOn = "CHECKED";
		}

if ($thisforum[11] eq "yes") {
			$ModNotifyOn = "CHECKED";
		}  else {
			$ModNotifyOff = "CHECKED";
		}
		
if ($thisforum[6] eq "yes") {
	$TRrestrictOn = "SELECTED";
	$RRrestrictOn = "SELECTED";
}
if ($thisforum[6] eq "private") {
	$PrivateOn = "CHECKED";
	$TRrestrictOn = "SELECTED";
	$RRrestrictOn = "SELECTED";
}
if ($thisforum[6] eq "partly") {
	$TRrestrictOn = "SELECTED";
	$RRallregOn = "SELECTED";
}
if ($thisforum[6] eq "includenonreg") {
	$TRallOn = "SELECTED";
	$RRallOn = "SELECTED";
}
if ($thisforum[6] eq "no") {
	$TRallregOn = "SELECTED";
	$RRallregOn = "SELECTED";
}
		
if (($thisforum[6] =~ /\&/) && ($thisforum[6] ne "private")){
		($TopicRestrict, $ReplyRestrict) = split(/\&/, $thisforum[6]);
		if ($TopicRestrict eq "restrict") {
			$TRrestrictOn = "SELECTED";
		}
		elsif ($TopicRestrict eq "allreg") {
			$TRallregOn = "SELECTED";
		} else  {
			$TRallOn = "SELECTED";
		}
		if ($ReplyRestrict eq "restrict") {
			$RRrestrictOn = "SELECTED";
		}
		elsif ($ReplyRestrict eq "allreg") {
			$RRallregOn = "SELECTED";
		}
		elsif ($ReplyRestrict eq "all") {
			$RRallOn = "SELECTED";
		}  else  {
			$RRnoneOn = "SELECTED";
		}
	}
			$TitleGraphic = "$thisforum[9]";


### If UBB Code is off, UBB Code for Images must also be off! ###
	if ($UBBOff eq "CHECKED") {
			$UBBImagesOn = "";
			$UBBImagesOff = "CHECKED";
		}
#############################################################

 
print<<ForumGuts;
<table border=0 width=100%>
<tr bgcolor="#D3CE87">
<td colspan=2 valign=top>
<FONT SIZE="2" FACE="Verdana, Arial">
<B>Forum $ForumCounter</B></td></tr>
<TR bgcolor="#D5D2BB">
<TD>
<FONT SIZE="1" FACE="Verdana, Arial"><B>Name:</B></FONT></td>
<td><INPUT TYPE="TEXT" NAME="Name||$ForumCounter" VALUE="$thisforum[1]" SIZE=30 MAXLENGTH=100></td></tr>
<tr bgcolor="#C7C6BA"><td><FONT SIZE="1" FACE="Verdana, Arial"><B>
Category:</B></FONT></td>
<td><INPUT TYPE="TEXT" NAME="Category||$ForumCounter" VALUE="$thisforum[0]" SIZE=30 MAXLENGTH=100></td></tr>

<tr bgcolor="#D5D2BB"><td><FONT SIZE="1" FACE="Verdana, Arial"><B>
Custom Title Graphic:</B><BR>Leave field blank if you want to use your primary title graphic (set in the Styles area).</FONT></td>
<td><INPUT TYPE="TEXT" NAME="TitleGraphic||$ForumCounter" VALUE="$TitleGraphic" SIZE=30 MAXLENGTH=100></td></tr>

<TR bgcolor="#C7C6BA"><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>Status:</B></FONT></td>
<td><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="Status||$ForumCounter" VALUE="On" $ForumActive> On &nbsp;&nbsp;&nbsp;&nbsp;
<INPUT TYPE="RADIO" NAME="Status||$ForumCounter" VALUE="Off" $ForumInactive> Off</B></FONT></td></tr>

<TR bgcolor="#D5D2BB"><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>HTML Allowed?</B></FONT></td><TD><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="HTML||$ForumCounter" VALUE="is" $HTMLOn> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="HTML||$ForumCounter" VALUE="is not" $HTMLOff> No</B></FONT></td></tr>

<TR bgcolor="#C7C6BA"><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>UBB Code Allowed?</B></FONT></td><TD><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="UBB||$ForumCounter" VALUE="is" $UBBOn> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="UBB||$ForumCounter" VALUE="is not" $UBBOff> No</B></FONT></td></tr>

<TR bgcolor="#D5D2BB"><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>UBB Code Images Allowed?</B></FONT></td><TD><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="UBBImages||$ForumCounter" VALUE="ON" $UBBImagesOn> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="UBBImages||$ForumCounter" VALUE="OFF" $UBBImagesOff> No</B></FONT></td></tr>

<TR bgcolor="#C7C6BA" ><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>Moderator Notification? <BR></B><FONT SIZE="1" FACE="Verdana, Arial">If yes, an email will be sent to the moderator every time someone posts a note to the forum (not recommended!)</FONT></FONT></td><TD valign=top><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="ModNotify||$ForumCounter" VALUE="yes" $ModNotifyOn> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="ModNotify||$ForumCounter" VALUE="no" $ModNotifyOff> No</B></FONT></td></tr>

<TR bgcolor="#D5D2BB"><TD valign=top><FONT SIZE="1" FACE="Verdana, Arial" color="#800000"><B>Access Limits</B></font><BR><FONT SIZE="1" FACE="Verdana, Arial">You may make the forum completely private- which means that only admins, moderators and those that you grant permission to view (using the User Permissions area in this control panel) may view and post notes in the forum.  If you set a forum password, you can also grant access to private forums and other restricted access forums to those that know the forum password.
<P>
If you do not need to make the forum completely private, you may still restrict posting permissions in various ways. 
<P>
<BR><FONT SIZE="1" FACE="Verdana, Arial" COLOR="#800000">Forum Password:</font> <INPUT TYPE="TEXT" NAME="forumpw||$ForumCounter" VALUE="$thisforum[12]" SIZE=12 MAXLENGTH=12>
</FONT></td><TD valign=top><FONT SIZE="1" FACE="Verdana, Arial"><B>
<CENTER>Completely Private - Read/Write</CENTER><P>
<INPUT TYPE="CHECKBOX" NAME="Private||$ForumCounter" VALUE="private" $PrivateOn>
Restrict Viewing and Writing of Posts To Admins, Moderators and other authorized<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#800000">*</FONT> users
<P>
If private, you can select maximum privacy, which means that all topics are displayed dynamically, checking user identification before displaying any page, or minimum privacy, which means that topics are stored as HTML (not dynamcially created) for improved server performance, but at a security risk.
<blockquote>
<INPUT TYPE="RADIO" NAME="PrivateMax||$ForumCounter" VALUE="yes" $PrivateMaxYes>Maximum Security<BR>
<INPUT TYPE="RADIO" NAME="PrivateMax||$ForumCounter" VALUE="no" $PrivateMaxNo>Minimum Security
</blockquote>
<HR>
<BR>
<CENTER>Posting Restrictions (With Viewing of Posts Open to All)</CENTER>
<P>
If forum is not completely private, you can determine which users can post topics and replies within the forum.
<P>
Who Can Post Topics?
<BR>
<SELECT NAME="TopicRestrict||$ForumCounter">
<option value="restrict" $TRrestrictOn>Only admins, moderators and authorized users
<option value="allreg" $TRallregOn>Any registered users
<option value="all" $TRallOn>Any users (including unregistered)
</SELECT>
<P>

Who Can Post Replies?
<BR>
<SELECT NAME="ReplyRestrict||$ForumCounter">
<option value="restrict" $RRrestrictOn>Only admins, moderators and authorized users 
<option value="allreg" $RRallregOn>Any registered users
<option value="all" $RRallOn>Any users (including unregistered)
<option value="none" $RRnoneOn>No one can post replies
</SELECT>

</B></FONT>
<P>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#800000">* An authorized user is someone who is not an administrator or moderator who has either been given specific authority to use a private forum or otherwise-restricted forum.  Administrators can give this permission to a user by either specifically assigning the permission to the user in the control panel User Permissions area or by giving the user the Forum Password to gain entrance.  You can set a forum password in the field to the left.</FONT>
</td></tr>

<TR bgcolor="#c7c6ba" ><TD valign=top><FONT SIZE="1" FACE="Verdana, Arial"><B>Forum Description:</B></FONT><BR><FONT SIZE="1" FACE="Verdana, Arial">This is displayed on your the intro page that summarizes all forums when users visit.  Be sure to set Forum Descriptions "on" in the General Variables section, if you want your visitors to see this description.</font></td><td valign=top><TEXTAREA NAME="Description||$ForumCounter" ROWS=3 COLS=30 wrap="VIRTUAL">$thisforum[2]</TEXTAREA></td></tr>
</table>

ForumGuts
} # if greater than start point, less than end point
} #for forumline

print<<BottomForumHTML;
</td></tr></table>
<BR>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="sendforums">
<INPUT TYPE="HIDDEN" NAME="StartPoint" VALUE="$EndPoint">
<INPUT TYPE="HIDDEN" NAME="ForumTotal" VALUE="$ForumTotal">
<INPUT TYPE="HIDDEN" NAME="PrefixWord" VALUE="$PrefixWord">
<INPUT TYPE="HIDDEN" NAME="NextTotal" VALUE="$NextTotal">
<INPUT TYPE="HIDDEN" NAME="NextPoint" VALUE="$EndPoint">
<CENTER>
<P>
<HR>
<CENTER><FONT Size="2" FACE="Verdana, Arial" COLOR="#000080"><B>Enter Your UserName & Password:</font>
<p>
<FONT Size="2" FACE="Verdana, Arial" COLOR="#000080">
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT></B>
<p><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Forum Variables Now"></form>
<P>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000000">Ultimate Bulletin Board, &copy; Madrona Park, Inc., 1998 - 1999.</FONT>
</CENTER></font>
</BODY>
</HTML>
BottomForumHTML
}  ## END DoForums


sub HEADER2HTML {
&GetCookieInfo;
print<<HEADER2HTML;
<HTML>
<HEAD>
	<TITLE>$BBName</TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
var testUserNameCP = getCookie("UserNameCP");
var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if (testUserNameCP == null) {
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";domain=$TheDomain;path=/$ThePath;";
		document.cookie = "PasswordCP=" + CookiePWCP + ";domain=$TheDomain;path=/$ThePath;";
	}

function SetCursor() {
var testUserNameCP = getCookie("UserNameCP");

if (testUserNameCP != null) {  
	document.THEFORM.UserNameCheck.value = getCookie("UserNameCP");
document.THEFORM.PasswordCheck.value = getCookie("PasswordCP");
	}  
}
function Check(form)  {
if ((form.PasswordCheck.value == "") || (form.UserNameCheck.value == ""))  {
	alert ("You forgot to fill in the Username and/or Password fields.  These are required entries!");
	return false
	}  else  {
	return true
	}
}
function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}
// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</HEAD>
<BODY bgcolor="#FFFFFF" link="#000080" vlink="#000080" onLoad="SetCursor()">
<BR><center>
<FONT SIZE="2" FACE="Verdana, Arial">$PageTitle</FONT>
</center>
<p>
HEADER2HTML
} #end HEADERHTML2 sr


sub SendForums {
&VerifyAdmin($in{'UserNameCheck'}, $in{'PasswordCheck'});
if ($Proceed eq "true") {
	 &DoProcessForums;
}
}  ##END SendForums sr


sub DoProcessForums {
### write forum info to forums.cgi
foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	
	if ($Name =~ m/Name/) {
	($Trash, $ForumNumber) = split(/\|\|/, $Name);
	push (@AdjustForums, $ForumNumber);
	}
} # end foreach $row

# now we have list of forum numbers to adjust (e.g., 1 - 9)

#read current forum data
@forums = &OpenForumsFile;

#assemble new line for each revised forum
for $num(@AdjustForums) {

	$Found = "false";
	$ThisPrivate = "";
foreach $row2(@in) {
	($Name, $Value) = split ("=", $row2);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	
	if ($Name eq "Name||$num") {
		$ThisName = $Value;
		$ThisName =~ s/"/&quot;/g;
		$Found = "true";
	}
	if ($Name eq "Category||$num") {
		$ThisCategory = $Value;
	}
	if ($Name eq "Status||$num") {
		$ThisStatus = $Value;
	}
	if ($Name eq "HTML||$num") {
		$ThisHTML = $Value;
	}
	if ($Name eq "UBB||$num") {
		$ThisUBB = $Value;
	}
	if ($Name eq "ModNotify||$num") {
		$ThisModNotify = $Value;
	}
if ($Name eq "UBBImages||$num") {
		$ThisUBBImages = $Value;
	}
	if ($Name eq "TitleGraphic||$num") {
		$TitleGraphic = $Value;
	}
	if ($Name eq "Private||$num") {
		$ThisPrivate = $Value;
	}
	if ($Name eq "TopicRestrict||$num") {
		$ThisTopic = $Value;
	}
	if ($Name eq "ReplyRestrict||$num") {
		$ThisReply = $Value;
	}
	if ($Name eq "forumpw||$num") {
		$ForumPW = $Value;
		if ($ForumPW =~ /\|/) {
			&StandardHTML("You can not use a pipestem- \"|\" - in a forum password.  Please try again.");
exit;
		}
	}
	if ($Name eq "PrivateMax||$num") {
		$PrivateMax = $Value;
	}
	if ($Name eq "Description||$num") {
		$ThisDescription = $Value;
		$ThisDescription =~ s/"/&quot;/g;
		$ThisDescription =~ s/\n\r\n//g;
		$ThisDescription =~ s/\n//g;
		$ThisDescription =~ s/\r//g;
		$ThisDescription =~ s/  / /g;
	}
} # end foreach $row2

$arrayrow = ($num - 1);

$ThisForumLine = $forums[$arrayrow];
chomp($ThisForumLine);
@thisforum = split(/\|/, $ThisForumLine);

#create private directory alternate to keep contents hidden,
#if necessary

if (($ThisPrivate eq "private") && ($thisforum[7] eq "")) {
$DIRPW = &GeneratePassword;
$DescLength = length($ThisDescription);
$DIRPW .= "$DescLength";

mkdir("$ForumsPath/Forum$thisforum[8]/private-$DIRPW", 0777);
chmod (0777, "$ForumsPath/Forum$thisforum[8]/private-$DIRPW");
mkdir("$ForumsPath/Forum$thisforum[8]/private-$DIRPW/ANNC", 0777);
chmod (0777, "$ForumsPath/Forum$thisforum[8]/private-$DIRPW/ANNC");
mkdir("$ForumsPath/Forum$thisforum[8]/private-$DIRPW/HTML", 0777);
chmod (0777, "$ForumsPath/Forum$thisforum[8]/private-$DIRPW/HTML");

open (INDEX, ">$ForumsPath/Forum$thisforum[8]/index.html"); 
print INDEX "";
close (INDEX);

open (INDEX, ">$ForumsPath/Forum$thisforum[8]/private-$DIRPW/ANNC/index.html"); 
print INDEX "";
close (INDEX);
open (INDEX, ">$ForumsPath/Forum$thisforum[8]/private-$DIRPW/HTML/index.html"); 
print INDEX "";
close (INDEX);
open (INDEX, ">$ForumsPath/Forum$thisforum[8]/private-$DIRPW/index.html"); 
print INDEX "";
close (INDEX);

}
elsif (($ThisPrivate eq "private") && ($thisforum[7] ne "")) {

$DIRPW = "$thisforum[7]";

unless (-e "$ForumsPath/Forum$thisforum[8]/private-$DIRPW") {

mkdir("$ForumsPath/Forum$thisforum[8]/private-$DIRPW", 0777);
chmod (0777, "$ForumsPath/Forum$thisforum[8]/private-$DIRPW");
mkdir("$ForumsPath/Forum$thisforum[8]/private-$DIRPW/ANNC", 0777);
chmod (0777, "$ForumsPath/Forum$thisforum[8]/private-$DIRPW/ANNC");
mkdir("$ForumsPath/Forum$thisforum[8]/private-$DIRPW/HTML", 0777);
chmod (0777, "$ForumsPath/Forum$thisforum[8]/private-$DIRPW/HTML");

open (INDEX, ">$ForumsPath/Forum$thisforum[8]/index.html"); 
print INDEX "";
close (INDEX);

open (INDEX, ">$ForumsPath/Forum$thisforum[8]/private-$DIRPW/ANNC/index.html"); 
print INDEX "";
close (INDEX);
open (INDEX, ">$ForumsPath/Forum$thisforum[8]/private-$DIRPW/HTML/index.html"); 
print INDEX "";
close (INDEX);
open (INDEX, ">$ForumsPath/Forum$thisforum[8]/private-$DIRPW/index.html"); 
print INDEX "";
close (INDEX);
} # check if exists


}  else {
$DIRPW = "$thisforum[7]";


}

if ($Found eq "true") {
if ($ThisPrivate eq "private") {
	$ThisPermission = "private";
} else {
	$ThisPermission = "$ThisTopic\&$ThisReply";
}

$forums[$arrayrow] = ("$ThisCategory|$ThisName|$ThisDescription|$ThisStatus|$ThisHTML|$ThisUBB|$ThisPermission|$DIRPW|$num|$TitleGraphic|$ThisUBBImages|$ThisModNotify|$ForumPW|$PrivateMax\n");
}
}  #end for each @AdjustForum

#write to forums file

&Lock("lock.file");
open (FORUMS, ">$VariablesPath/forums.cgi"); 
print FORUMS (@forums);
close (FORUMS);
&Unlock("lock.file");

$UserNameCoded = &HTMLIFY($UserNameCheck);
$PasswordCoded = &HTMLIFY($PasswordCheck);

if ($in{'PrefixWord'} eq "Next") {
	$Additional = qq(Additional Forums To Set: <FORM ACTION="cpanel3.cgi" METHOD="POST"><INPUT TYPE="HIDDEN" NAME="UserName" VALUE="$UserNameCoded"><INPUT TYPE="HIDDEN" NAME="Password" VALUE="$PasswordCoded"><INPUT TYPE="HIDDEN" NAME="action" VALUE="forums"><INPUT TYPE="HIDDEN" NAME="StartPoint" VALUE="$in{'NextPoint'}"><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Next $in{'NextTotal'} Forums"></form>);
} else {
	$Additional = "";
}

&EndUpdate("F O R U M S &nbsp;&nbsp;&nbsp;&nbsp; S E T T I N G S  &nbsp;&nbsp;&nbsp;&nbsp; U P D A T E D", "Thank you!  Your UBB Forum Settings have now been updated as you requested.<P><FONT COLOR=\"#800000\">Note: if you are changing any  private forums from Minimum to Maximum Security (or from Maximum to Minimum), you must Update Threads after you are finished making changes to all forum variables.  Otherwise, your topic pages will not display properly!</FONT><P>$Additional");
exit;
} ## END DO PROCESS FORUMS SR

sub AddNewForum {
### CHECK USERNAME - must be an admin
##verify that this user is an administrator

$NameFound = "no";
$ProfileNumber = &GetUserNumber($in{'UserName'});

if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}


if ($NameFound eq "yes") {
	@profilestats = &OpenProfile("$ProfileNumber.cgi");			
	if ($Password eq "$profilestats[1]") {
	$Permission = "$profilestats[4]";
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   &DoAddNewForum;
	   }  else {
	    &StandardHTML("Sorry, but you are not an administrator.");
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again. Use your Back button.");
	}
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
}  ##END IF/ELSE NAME CHECK BLOCK

}  ##END AddNewForum sr

sub DoAddNewForum {
$ForumTotal = &GetTotalForums;
$ForumTotal++;

if ($in{'forumpw'} =~ /\|/) {
&StandardHTML("You may not use a pipestem- \"|\"- in a forum password. Please go back and try again.");
exit;
}
### write forum info to forums.cgi
	$Description = &decodeURL($in{'Description'});
		$Description =~ s/"/&quot;/g;
		$Description =~ s/\n\r\n//g;
		$Description =~ s/\n//g;
		$Description =~ s/\r//g;
		$Description =~ s/  / /g;
		
	$Name = &decodeURL($in{'Name'});
	$Name =~ s/"/&quot;/g;
	$Category = &decodeURL($in{'Category'});
	
	
$ThisForumLine = $forums[$arrayrow];
@thisforum = split(/\|/, $ThisForumLine);

if ($in{'Private'} eq "private") {
#create HTML directory alternate to keep contents hidden
$DIRPW = &GeneratePassword;
$DescLength = length($Description);
$DIRPW .= "$DescLength";
}  else {
$DIRPW = "";
}

if ($in{'Private'} eq "private") {
	$ForumPermission = "private";
}  else {
	$ForumPermission = "$in{'TopicRestrict'}&$in{'ReplyRestrict'}";
}
$newforumline = ("$Category|$Name|$Description|$in{'Status'}|$in{'HTML'}|$in{'UBB'}|$ForumPermission|$DIRPW|$ForumTotal|$in{'TitleGraphic'}|$in{'UBBImages'}|$in{'ModNotify'}|$in{'forumpw'}|$in{'PrivateMax'}");

#write to forums file

open (NEWFORUM, ">>$VariablesPath/forums.cgi"); 
print NEWFORUM ("$newforumline\n");
close (NEWFORUM);

#create new Forum Directory with permissions for UNIX servers
mkdir("$ForumsPath/Forum$in{'Number'}", 0777);
chmod (0777, "$ForumsPath/Forum$in{'Number'}");
mkdir("$ForumsPath/Forum$in{'Number'}/ANNC", 0777);
chmod (0777, "$ForumsPath/Forum$in{'Number'}/ANNC");
mkdir("$ForumsPath/Forum$in{'Number'}/HTML", 0777);
chmod (0777, "$ForumsPath/Forum$in{'Number'}/HTML");

#create index files to hide contents of directories
open (INDEX, ">$ForumsPath/Forum$in{'Number'}/ANNC/index.html"); 
print INDEX "";
close (INDEX);
open (INDEX, ">$ForumsPath/Forum$in{'Number'}/HTML/index.html"); 
print INDEX "";
close (INDEX);
open (INDEX, ">$ForumsPath/Forum$in{'Number'}/index.html"); 
print INDEX "";
close (INDEX);

#create private directories, if necessary
if ($DIRPW ne "") {
mkdir("$ForumsPath/Forum$in{'Number'}/private-$DIRPW", 0777);
chmod (0777, "$ForumsPath/Forum$in{'Number'}/private-$DIRPW");
mkdir("$ForumsPath/Forum$in{'Number'}/private-$DIRPW/ANNC", 0777);
chmod (0777, "$ForumsPath/Forum$in{'Number'}/private-$DIRPW/ANNC");
mkdir("$ForumsPath/Forum$in{'Number'}/private-$DIRPW/HTML", 0777);
chmod (0777, "$ForumsPath/Forum$in{'Number'}/private-$DIRPW/HTML");

open (INDEX, ">$ForumsPath/Forum$in{'Number'}/private-$DIRPW/ANNC/index.html"); 
print INDEX "";
close (INDEX);
open (INDEX, ">$ForumsPath/Forum$in{'Number'}/private-$DIRPW/HTML/index.html"); 
print INDEX "";
close (INDEX);
open (INDEX, ">$ForumsPath/Forum$in{'Number'}/private-$DIRPW/index.html"); 
print INDEX "";
close (INDEX);
}
$ConfirmLine = "New forum successfully added!<P>";
&ConfirmHTML2;
exit;
} ## END DO ADD NEW FORUM SR


sub InputAreaRow {
my $RowColor = shift;
my $FieldName = shift;
my $Notes = shift;
my $InputField = shift;
my $Cols = shift;
my $Rows = shift;

if ($Notes ne "") {
	$Notes = "<BR>$Notes";
}
print<<ROW;
<TR bgcolor="$RowColor">
<td valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>$FieldName</B></FONT>
<FONT SIZE="1" FACE="Verdana, Arial">$Notes</FONT>
</td>
<td valign=top>
<TEXTAREA NAME="$InputField" COLS="$Cols" ROWS="$Rows" WRAP="VIRTUAL">$$InputField</TEXTAREA>
</td></tr>
ROW
}
