#!/usr/local/bin/perl

print ("Content-type: text/html\n\n");
eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file
require "mods.file";
require "UltBB.setup";
require "Date.pl";
require "ubb_library.pl";
require "ubb_library2.pl";
require "Styles.file";
};

if ($@) {
    print "Error including required files: $@\n";
    print "Make sure these files exist, permissions are set properly, and paths are set correctly.";
 exit;
}
&ReadParse;

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
		if ($Name eq "forum") {
			$Forum = $Value;
			$Forum =~ s/\/\\//g;
			$ForumCoded = &HTMLIFY($Forum);
			$ForumCoded =~ tr/ /+/;
			$Forum = &UNHTMLIFY($Forum);
	}
	if ($Name eq "Password") {
		$Password = $Value;
	}
		if ($Name eq "TopicSubject") {
			$TopicSubject = $Value;
			$TopicSubject =~ s/<.+?>//g;
			$TopicSubject = &UNHTMLIFY($TopicSubject);
	}
	if ($Name eq "UserName") {
		$UserName = $Value;
		$UserNameFile = $UserName;
		$UserNameFile =~ s/ /_/g; #remove spaces
	}
	if ($Name eq "number") {
		$number = $Value;
	}
	if ($Name eq "topic") {
			$topic = $Value;
	}

}  # end FOREACH $row

if ($VariablesPath eq "") {
	$VariablesPath = $CGIPath;
}
#create random numbers for headers/footers
$RandomNumber = &MakeRandomNumber;
$RandomNumber2 = $RandomNumber + 100074;

if ($Header ne "") {
$Header =~ s/UBBrandomX/$RandomNumber/isg;
$Header =~ s/UBBrandomY/$RandomNumber2/isg;
}
if ($Footer ne "") {
$Footer =~ s/UBBrandomX/$RandomNumber/isg;
$Footer =~ s/UBBrandomY/$RandomNumber2/isg;
}

#adjust bgcolor variables
if ($BGColor ne ""){
$BGColor = qq(bgcolor="$BGColor");
}
if ($AltColumnColor1 ne ""){
$AltColumnColor1 = qq(bgcolor="$AltColumnColor1");
}
if ($AltColumnColor2 ne ""){
$AltColumnColor2 = qq(bgcolor="$AltColumnColor2");
}
if ($CategoryStripColor ne ""){
$CategoryStripColor = qq(bgcolor="$CategoryStripColor");
}
if ($TableColorStrip ne ""){
$TableColorStrip = qq(bgcolor="$TableColorStrip");
}
if ($PageBackground ne ""){
$PageBackground = qq(background="$NonCGIURL/$PageBackground");
}

if ($TableBorderColor ne ""){
$TableWidth2 = "100%";
$BorderTop = qq(<table border=0 cellpadding=0 cellspacing=0 width="$TableWidth"><TR><td bgcolor="$TableBorderColor">);
$BorderBottom = qq(</td></tr></table> );
}  else {
$TableWidth2 = $TableWidth;
$BorderTop = "";
$BorderBottom = "";
}

if (($in{'action'} eq "transfer") || ($in{'action'} eq "submittransfer")) {
if ($BBStatus eq "OFF") {
&StandardHTML("Sorry, this bulletin board is temporarily unavailable, while we perform some routine maintenance.  Please try back again later.  Feel free to email us at <A HREF=\"mailto:$BBEmail\">$BBEmail</A>.");
exit;
}
}

if ($in{'action'} eq "transfer") {
   &Transfer;
}
if ($in{'action'} eq "submittransfer") {
   &SubmitTransfer;
}
if ($in{'action'} eq "enterarchive") {
   &EnterArchive;
}
if ($in{'action'} eq "archivecenter") {
   &ArchiveCenter;
}
if ($in{'action'} eq "ContinueArchiveUpdate") {
  &ConvertArch2HTML("$in{'ArchiveRow'}", "$in{'TotalArchives'}", "$in{'StartWith'}");
  exit;
}
if ($in{'action'} eq "UpdateArchiveThreads") {
  &UpdateArchThreads("$in{'ArchiveRow'}", "$in{'TotalArchives'}", "$in{'StartWith'}");
  exit;
}
if ($in{'action'} eq "ContinueArchiveIndex") {
	&ReArchiveIndex("$in{'ArchiveRow'}", "$in{'TotalArchives'}", "$in{'StartWith'}");
exit;
}

sub ConvertArch2HTML {
my($ArchRow) = shift;
my($ArchTotal) = shift;
my($StartWith) = shift;

$ArchRow = $ArchRow + 0;
$ArchTotal = $ArchTotal + 0;
$StartWith = $StartWith + 0;

#is this the last archive?
if ($ArchRow == $ArchTotal) {
	$LastArchive = "true";
}  else {
	$LastArchive = "false";
}

my @archives = &OpenFile("$NonCGIPath/Archives/archives.pl");
my $uno = "";
my $Count = 0;

foreach $uno(@archives) {
$Count++;
	if ($Count == $ArchRow) {
		($ThisNumber, $ThisName, $ThisDesc) = split(/\|\#\|/, $uno);
	}
}

#retrieve all topics 
opendir (GETTHREADS, "$NonCGIPath/Archives/Archive-$ThisNumber");
	@threads1 = readdir (GETTHREADS);
closedir (GETTHREADS);

@threads2 = grep(/\.cgi/, @threads1);
@threads = sort(@threads2);

$TotalThreads = @threads; #total topics in archive
$LastArrayNum = $TotalThreads - 1;

#limit processing to Cycle rate
$Cycle = $in{'Cycle'} + 0;
$ThisCycle = $Cycle - 1;
$ArrayStart = $StartWith - 1;
$End = $StartWith + $ThisCycle;
$ArrayEnd = $End - 1;

if ($LastArrayNum <= $ArrayEnd) {
	$ArrayEnd = $LastArrayNum;
	$FinishedArchive = "true";
}  else {
	$FinishedArchive = "false";
}

@truncated = @threads[$ArrayStart... $ArrayEnd];
$StartPoint = $StartWith;
$LastOne = $ArrayEnd + 1;
$NextStart = $ArrayEnd + 1;

for $eachthread(@truncated) {
	&CreateArchiveHTML("$ThisNumber", "$eachthread", "0", "1");
} #end for threads loop

if ($FinishedArchive eq "true") {
	if ($LastArchive eq "true") {
		&EndUpdate("T H R E A D S &nbsp;&nbsp;&nbsp;&nbsp; U P D A T E D", "Thank you for your patience.  All topic threads have now been updated to reflect your current UBB Control Panel settings.");
	} else {
		$ArchRow++;
		&ContinueArchUpdate("$ArchRow", "1", "$ArchTotal", "$Cycle");
	}
} else {
		&ContinueArchUpdate("$ArchRow", "$NextStart", "$ArchTotal", "$Cycle");
}

}

sub ContinueArchUpdate {
my $ArchRow = shift;
my $NextStart = shift;
my $TotalArchie = shift;
my $CycleRate = shift;

$ActionWording = qq(We are updating each of your existing threads to reflect all current settings in the control panel.<P>Archive <FONT FACE="Verdana" SIZE="2" COLOR="Navy">$ThisNumber</FONT> is currently being updated.  Please wait while we continue updating!</B><P>We just finished updating topics <FONT FACE="Verdana" SIZE="2" COLOR="Navy">$StartPoint</font> through<FONT FACE="Verdana" SIZE="2" COLOR="Navy"> $LastOne </font> in Archive <FONT FACE="Verdana" SIZE="2" COLOR="Navy">$ThisNumber</font>
</FONT>);
$ForwardURL = "$CGIURL/archive.cgi?action=ContinueArchiveUpdate&ArchiveRow=$ArchRow&TotalArchives=$TotalArchie&StartWith=$NextStart&Cycle=$Cycle";
&ContinueThis($ForwardURL, $ActionWording);

}


sub ArchiveCenter {

&VerifyAdmin($in{'UserNameCheck'}, $in{'PasswordCheck'});

if ($Proceed eq "true") {

if ($in{'ArchiveOption'} eq "Create") {

#validate fields
if ( ($in{'ArchiveName'} eq "") || ($in{'ArchiveName'} !~ /[a-zA-Z0-9]/) || ($in{'UserNameCheck'} eq "") || ($in{'PasswordCheck'} eq "") ) {
&StandardHTML("We could not process your request.  You did not properly complete all fields.  Please go back and try again.");
exit;
}
if ( ($in{'ArchiveName'} =~ /\|\#\|/) || ($in{'ArchiveDesc'} =~ /\|\#\|/) )  {
&StandardHTML("We could not process your request.  You may not include a |#| sequence in your archive name or description!  Please go back and try again.");
exit;
}

#add archive directory if necessary
unless (-e "$NonCGIPath/Archives") {
mkdir ("$NonCGIPath/Archives", 0777);
chmod(0777, "$NonCGIPath/Archives");
}

#add new archive
#get current archive facts
if (-e "$NonCGIPath/Archives/archives.pl") {
@archiveinfo = &OpenFile("$NonCGIPath/Archives/archives.pl");
@sortarch = sort(@archiveinfo);
@reversearch = reverse(@sortarch);

$LastArch = $reversearch[0];

@thisarch = split(/\|\#\|/, $LastArch);
$LastNumber = $thisarch[0];
}  else {
	$LastNumber = "000000";
}

$LastNumber++;  #add 1 to last post number
$ArchNum = sprintf("%6d", $LastNumber);
$ArchNum =~tr/ /0/;

mkdir ("$NonCGIPath/Archives/Archive-$ArchNum", 0777);
chmod(0777, "$NonCGIPath/Archives/Archive-$ArchNum");

$ArchiveName = $in{'ArchiveName'};
$ArchiveName =~ s/<.+?>//g;
$ArchiveDesc = $in{'ArchiveDesc'};
$ArchiveDesc =~ s/"/&quot;/g;
$ArchiveDesc =~ s/\n\r\n//g;
$ArchiveDesc =~ s/\n//g;
$ArchiveDesc =~ s/\r//g;
$ArchiveDesc =~ s/  / /g;
$ArchiveDesc =~ s/\|/&#0124;/sg;
$ArchiveName =~ s/\|/&#0124;/sg;
$NewArchive = "$ArchNum|#|$ArchiveName|#|$ArchiveDesc";

#append archives.pl file 
&Lock("lock.file");
open(ARCHIVES, ">>$NonCGIPath/Archives/archives.pl");
print ARCHIVES "$NewArchive\n";
close(ARCHIVES);
&Unlock("lock.file");
chmod(0777, "$NonCGIPath/Archives/archives.pl");

&EndUpdate("A R C H I V E &nbsp;&nbsp;&nbsp;&nbsp; A D D E D", "Thank you!  We have added the archive that you requested.");

}  else {

#process all actions (archives already exist)

#get current archive info--
@archiveinfo = &OpenFile("$NonCGIPath/Archives/archives.pl");
@sortarch = sort(@archiveinfo);
@reversearch = reverse(@sortarch);
$ArchiveTotal = @reversearch;

$LastArch = $reversearch[0];

@thisarch = split(/\|\#\|/, $LastArch);
$LastNumber = $thisarch[0];

if ($LastNumber eq "") {
	$LastNumber = 0;
}
#Figure Next Number, for use in adding archives
$LastNumber++;  #add 1 to last post number
$NextNum = sprintf("%6d", $LastNumber);
$NextNum =~tr/ /0/;

#check names
$ArchiveCount = 0;
foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	if ($Name =~ m/ThisArchiveName/) {
	($Trash, $ThisNumber) = split(/\:/, $Name);
	$Value =~ s/<.+?>//g;
	$Value =~ s/\|/&#0124;/sg;
	$Combine = ("$ThisNumber" . "|#|" . "$Value");
	push (@ArchNames, $Combine);
	$ArchiveCount++;
	}
	if ($Name eq "NewArchiveName") {
		$Value =~ s/<.+?>//g;
		$Value =~ s/\|/&#0124;/sg;
		if (($Value ne "") && ($Value =~ /[a-zA-Z0-9]/)) {
		$NewOne = ("$NextNum" . "|#|" . "$Value");
		$AddNew = "true";
		push (@ArchNames, $NewOne);
		#create directory!
		mkdir ("$NonCGIPath/Archives/Archive-$NextNum", 0777);
chmod(0777, "$NonCGIPath/Archives/Archive-$NextNum");
		}
	}
	if ($Name =~ m/Delete/) {
		push(@deletelist, $Value);
	}
	#check for double pipestems- don't allow
	if ($Value =~ /\|\#\|/) {
		&StandardHTML("You are attempting to use an Archive Name or Description that contains a |#| sequence, which is not permitted.  Please go back and try again.");
exit;
	}
} # end foreach $row

if ($ArchiveTotal ne "$ArchiveCount") {
&StandardHTML("You are trying to submit an incomplete archive summary.  Perhaps you used your back button prior to submitting this page.  <A HREF=\"$CGIURL/cpanel.cgi?action=archives\">Please try again, by identifying yourself first.</A>");
exit;
}

if (@deletelist) {
foreach $uno(@deletelist) {
	chomp($uno);
	foreach $one(@ArchNames) {
		chomp($one);
		unless ($one =~ /^$uno/) {
			push(@AdjustNames, $one);
		}
	}
}
} else {
@AdjustNames = @ArchNames;
}

#Now add archive descriptions--
foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	if ($Name =~ m/ThisArchiveDesc/) {
	($Trash, $ThisNumber) = split(/\:/, $Name);
		foreach $check(@AdjustNames) {
		chomp($check);
			if ($check =~ /^$ThisNumber/) {
				$Value =~ s/"/&quot;/g;
				$Value =~ s/\n\r\n//g;
				$Value =~ s/\n//g;
				$Value =~ s/\r//g;
				$Value =~ s/  / /g;
				$Value =~ s/\|/&#0124;/sg;
				$NewLine = ("$check" . "|#|$Value");
				push(@FinalArch, $NewLine);
			}
		}
	}
	if ($AddNew eq "true") {
		if ($Name eq "NewArchiveDesc") {
			foreach $check2(@AdjustNames) {
				chomp($check2);
				if ($check2 =~ /^$NextNum/) {
					$Value =~ s/"/&quot;/g;
					$Value =~ s/\n\r\n//g;
					$Value =~ s/\n//g;
					$Value =~ s/\r//g;
					$Value =~ s/  / /g;
					$Value =~ s/\|/&#0124;/sg;
					$AddLine = ("$check2" . "|#|$Value");
					push (@FinalArch, $AddLine);
				}
			}
		}
	}

} # end foreach $row

@SortFinal = sort(@FinalArch);
#adjust archives.pl file--
&Lock("lock.file");
open(ARCHIVES, ">$NonCGIPath/Archives/archives.pl");
foreach $iota(@SortFinal) {
chomp($iota);
print ARCHIVES "$iota\n";
}
close(ARCHIVES);
&Unlock("lock.file");
chmod(0777, "$NonCGIPath/Archives/archives.pl");

		&EndUpdate("A R C H I V E S &nbsp;&nbsp;&nbsp;&nbsp; U P D A T E D", "<center>Thank you!  We have made the changes that you requested.</center>");
}

} # end if proceed eq true

}  #end Archive Center

sub EnterArchive {
&VerifyAdmin($UserName, $Password);

if ($Proceed eq "true") {

$PageTitle = "A R C H I V E S";
&HEADERHTML;


print<<MIDDLE;
<center>
<FORM ACTION="archive.cgi" NAME="THEFORM" METHOD="POST">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="archivecenter">
<table border=0 cellpadding=0 cellspacing=0 width="95%"><TR><td bgcolor="#000000">
<table border=0 cellpadding=4 border=0 cellspacing=1 width=100%>
MIDDLE

# check to see if archives.pl file exists
if (-e "$NonCGIPath/Archives/archives.pl") {
# open it
@archives = &OpenFile("$NonCGIPath/Archives/archives.pl");
$ArchiveTotal = @archives;

if ($ArchiveTotal <= 40) {
	$AddArchive = qq(<TR bgcolor="#B0BB9D"><td colspan=3><FONT SIZE="2" FACE="Verdana, Arial"><A NAME="#addit">To Create a New Archive, Add A New Archive Name Below!</A></font></TD></tr>
<TR bgcolor="#C7C6BA">
<TD colspan=2 valign=top><FONT SIZE="1" FACE="Verdana, Arial"><B>New Archive:</B></font></td>
<td>
<TABLE BORDER=0><TR><TD valign=top><FONT SIZE="1" FACE="Verdana, Arial">Name:</font></td><td valign=top><INPUT TYPE="TEXT" NAME="NewArchiveName" VALUE="" SIZE=40 MAXLENGTH=120></td></tr><TR><TD valign=top><FONT SIZE="1" FACE="Verdana, Arial">Description:</font></td><td><TEXTAREA NAME="NewArchiveDesc" ROWS=3 COLS=30></TEXTAREA></td></tr></table></TD></tr>);
$StatusLine = qq!You currently have $ArchiveTotal archive(s).  Listed below under Current Archives.  You may use HTML in your forum descriptions (UBB Code not permitted).  To add a new archive, <A HREF="#addit">click here</A>.!;
}  else {
	$AddArchive = "";
	$StatusLine = qq"You currently have $ArchiveTotal archives (listed below under Current Archives).  You may not add any additional archives, since there is a 40-archive limit.  You may use HTML in your forum descriptions (UBB Code not permitted).";
}
print<<HEADER;
<INPUT TYPE="HIDDEN" NAME="ArchiveOption" VALUE="ALL">
<TR bgcolor="#FFFFFF"><TD colspan=3><FONT SIZE="2" FACE="Verdana, Arial">$StatusLine</font></td></tr>
<TR bgcolor="#B0BB9D">
<td colspan=3><CENTER><FONT SIZE="2" FACE="Verdana, Arial"><B>- CURRENT ARCHIVES -</B></font></CENTER></td></tr>
<TR bgcolor="#B0BB9D">
<td><FONT SIZE="1" FACE="Verdana, Arial">Delete?</font></td>
<TD><FONT SIZE="1" FACE="Verdana, Arial">Archive Number</FONT></TD>
<TD><FONT SIZE="1" FACE="Verdana, Arial">Archive Name/Description</font></TD></tr>
HEADER

foreach $uno(@archives) {
@thisarch = split(/\|\#\|/, $uno);
chomp($thisarch[2]);

if ($thisarch[0] ne "") {
print<<ROW;
<TR bgcolor="#C7C6BA">
<td valign=top><INPUT TYPE="CHECKBOX" NAME="Delete" VALUE="$thisarch[0]"></td>
<TD valign=top><FONT SIZE="1" FACE="Verdana, Arial">$thisarch[0]</FONT></TD>
<TD valign=top><TABLE BORDER=0><TR><TD valign=top><FONT SIZE="1" FACE="Verdana, Arial">Name:</font></td><td valign=top><INPUT TYPE="TEXT" NAME="ThisArchiveName:$thisarch[0]" VALUE="$thisarch[1]" SIZE=40 MAXLENGTH=120></td></tr><TR><TD valign=top><FONT SIZE="1" FACE="Verdana, Arial">Description:</font></td><td><TEXTAREA NAME="ThisArchiveDesc:$thisarch[0]" ROWS=3 COLS=30>$thisarch[2]
</TEXTAREA></td></tr></table></TD></tr>
ROW
}
}

#print New Archive Option row--
print<<ROW;
$AddArchive
<TR bgcolor="#B0BB9D"><TD colspan=2><FONT SIZE="2" FACE="Verdana, Arial">Your UserName</FONT></td><td><INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=50></td></tr>
<TR bgcolor="#B0BB9D"><TD colspan=2><FONT SIZE="2" FACE="Verdana, Arial">Your Password</FONT></td><td><INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></td></tr>

ROW

}  else {
#no archives have been created...
print<<MIDDLE2;
<TR bgcolor="#C7C6BA"><TD colspan=2><FONT SIZE="2" FACE="Verdana, Arial">
No archives have been created yet.  To create a new archive, provide a name and description for your new archive.  The Description will appear below your archive name in your list of archives.  Leave it blank if you do not want a description to appear.  You may use HTML in your forum description (UBB Code will not work, however).</font></td></tr>
<INPUT TYPE="HIDDEN" NAME="ArchiveOption" VALUE="Create">
<TR bgcolor="#C7C6BA"><TD><FONT SIZE="2" FACE="Verdana, Arial">Archive Name</FONT></td><td><INPUT TYPE="TEXT" NAME="ArchiveName" SIZE=25 MAXLENGTH=120></td></tr>
<TR bgcolor="#C7C6BA"><TD><FONT SIZE="2" FACE="Verdana, Arial">Archive Description</FONT></td><td><TEXTAREA NAME="ArchiveDesc" ROWS=3 COLS=25></TEXTAREA></td></tr>
<TR bgcolor="#C7C6BA"><TD><FONT SIZE="2" FACE="Verdana, Arial">Your UserName</FONT></td><td><INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=50></td></tr>
<TR bgcolor="#C7C6BA"><TD><FONT SIZE="2" FACE="Verdana, Arial">Your Password</FONT></td><td><INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></td></tr>
MIDDLE2

}




print<<BOTTOM;
</table>
</td></tr></table>
<P>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Now!">
</FORM>
</center>
</font></BODY></HTML>
BOTTOM
}  #end if admin
}

sub SubmitTransfer {
if ( ($in{'UserName'} eq "") || ($in{'Password'} eq "") || ($in{'Option'} eq "") )  {
&StandardHTML("You did not complete all required form fields!  Please go back and re-enter.");
exit;
}		

$ProfileNumber = &GetUserNumber($UserName);
if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}

unless ($NameFound eq "yes") {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
exit;
}

@profilestats = &OpenProfile("$ProfileNumber.cgi");
	
	unless ($in{'Password'} eq "$profilestats[1]") {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
	exit;
	}
	
	$Status = "$profilestats[8]";
	
	#get moderator for this forum
	$Moderator = ("Forum" . "$number" . "Moderator");
	$Moderator = $$Moderator;

unless (($Status eq "Administrator") || ($Moderator eq "$UserName")) {
	   &StandardHTML("Sorry, but you are not authorized to perform this function.  Use your Back button.");
	exit;
}

if ($topic !~ /\d\d\.[m|n|ubb|cgi]/) {
&StandardHTML("You seem to be trying to hack our forums.  Please stop!");
exit;
}

if ($in{'Option'} eq "Transfer") {
#do transfer--

#check to make sure they selected a forum!
$NewNumber = $in{'TransferToForumNum'};

if ($NewNumber eq "") {
&StandardHTML("You forgot to select the name of the forum where you wish to transfer the topic.  Go back and try again.");
exit;
}

#first get info on old forum
@oldforum = &GetForumRecord($number);
$OldLWA = $oldforum[6];
$OldLWAPassword = &decodeURL($oldforum[7]);
$OldForumStatus = $oldforum[3];
$OldPrivateMax = $oldforum[13];
chomp($OldPrivateMax);
$OrigForum= $Forum;
$OrigForumCoded = $ForumCoded;

#then get info on forum to transfer into
@newforum = &GetForumRecord($NewNumber);
$NewLWA = $newforum[6];
$NewForumStatus = $newforum[3];
$NewLWAPassword = &decodeURL($newforum[7]);
$NewPrivateMax = $newforum[13];
chomp($NewPrivateMax);
$NewForumName = $newforum[1];

#set proper path(s) if forum is private
if ($OldLWA eq "private") {
	$OldPath = "Forum$number/private-$OldLWAPassword";
}  else {
	$OldPath = "Forum$number";
}
if ($NewLWA eq "private") {
	$NewPath = "Forum$NewNumber/private-$NewLWAPassword";
}  else {
	$NewPath = "Forum$NewNumber";
}

#open old topic
open (THETOPIC, "$ForumsPath/$OldPath/$topic"); 
    @thetopic = <THETOPIC>;
close (THETOPIC);


#get new forum stats - last topic number
##determine last topic number and increment by 1
if (-e "$ForumsPath/$NewPath/lastnumber.file") {
open (FORUMCOUNT, "$ForumsPath/$NewPath/lastnumber.file"); 
    @forumcounter = <FORUMCOUNT>;
close (FORUMCOUNT);
$lastthreadnum = $forumcounter[0];
chomp($lastthreadnum);

}  else {
$lastthreadnum = 0;
}

$count = $lastthreadnum + 0;

#determine new topic number
if ($count > 0) {
$lastthreadnum++;
$newtopic = sprintf("%6d", $lastthreadnum);
$newtopic =~tr/ /0/;
}  else {
$newtopic = "000001";
}

#write old file in new directory
open (THETOPIC, ">$ForumsPath/$NewPath/$newtopic.cgi"); 
foreach $uno(@thetopic) {
chomp($uno);
print THETOPIC "$uno\n";
}
close (THETOPIC);
chmod(0777, "$ForumsPath/$NewPath/$newtopic.cgi");

if ($in{'TransferChoiceOption'} eq "Delete") {

$TotalPosts = @thetopic;
$TotalPosts--;

($topicnumber, $junk) = split(/\./, $topic);

#delete old topic and HTML files
unlink ("$ForumsPath/$OldPath/$topic");
unlink ("$ForumsPath/$OldPath/HTML/$topicnumber.html");
unlink ("$ForumsPath/$OldPath/HTML/$topicnumber.cgi");


#update old stats, threads file, etc.
$ExactPath = "$OldPath";
&UpdateForumDetails($number);
&UpdateForumTotals("$number", 1, $TotalPosts, "yes");
&RemoveThreadFromIndex($number, $topicnumber);

}  else {
#keep old message in old forum, but close it!

#close it--
@stats = split(/\|\|/, $thetopic[0]);
$Notes = $stats[1];
chomp($stats[4]);
chomp($stats[5]);
chomp($stats[6]);
chomp($stats[7]);

if ($Notes =~ /N/) {
	$AddN = "N";
}  else {
	$AddN = "";
}

$CloseNote = "This topic has been transferred to this forum: $NewForumName.";
#prepare new stats line
$StatsLine = "A||X$AddN||$stats[2]||$stats[3]||$stats[4]||$stats[5]||$stats[6]||$CloseNote";

foreach $row(@thetopic) {
chomp($row);
if ($row =~ m/^A/) {
	push(@revised, $StatsLine);
}  else {
	push(@revised, $row);
}
}

# update ubb file
&Lock("lock.file");
open (FORUM, ">$ForumsPath/$OldPath/$topic"); 
foreach $ubbline(@revised) {
chomp($ubbline);
print FORUM ("$ubbline\n");
}
close (FORUM);
&Unlock("lock.file");
chmod(0666, "$ForumsPath/$OldPath/$topic");

#redo HTML page
&CreateThreadHTML("Forum$number", "$topic", "0", "1");

#update threads summary file
&CurrentDate;
if (-e "$ForumsPath/$OldPath/forum$number.threads") {
&AdjustForClose($number, $topic, "close");
}  else {
&ForumSummary($number);
}

} #end if delete/keep


#update new stats, threads file, etc.
$ExactPath = "$NewPath";
$Forum = $NewForumName;
$ForumCoded = &HTMLIFY($NewForumName);
$ForumCoded =~ tr/ /+/;
$oldnumber = $number;
$number = $NewNumber;
#create NEW HTML Page

$LWA = "$NewLWA";
$PrivateMax = "$NewPrivateMax";

&CreateThreadHTML("Forum$NewNumber", "$newtopic.cgi", "0", "1");

&UpdateForumDetails($NewNumber);
&IncreaseForumTotals("$NewNumber", 1, $TotalPosts, "yes");

if ($NewLWA eq "private") {
&AppendPrivateIndex("$NewNumber", "$newtopic.cgi", "$LWAPassword");
}  else {
&AppendIndex("$NewNumber", "$newtopic.cgi");
}

#send onscreen confirmation
&Forward("$CGIURL/forumdisplay.cgi?action=topics&forum=$OrigForumCoded&number=$oldnumber", "The topic has been successfully moved!  We are now sending you back automatically to the topic list for $OrigForum.");
exit;

}  else {
#do archive---
if ($in{'ArchiveSelect'} eq "") {
&StandardHTML("You did not select an archive in which to transfer this topic.  Please go back and try again.");
exit;
}

#first get info on forum
@oldforum = &GetForumRecord($number);
$OldLWA = $oldforum[6];
$OldLWAPassword = &decodeURL($oldforum[7]);
$OldForumStatus = $oldforum[3];
$OldPrivateMax = $oldforum[13];
chomp($OldPrivateMax);
$OrigForumCoded = $ForumCoded;
if ($OldLWA eq "private") {
	$OldPath = "Forum$number/private-$OldLWAPassword";
}  else {
	$OldPath = "Forum$number";
}

#print topic file to archive--
@topicfile = &OpenFile("$ForumsPath/$OldPath/$topic");
$Top = $topicfile[0];
@checkthis = split(/\|\|/, $Top);
$TotReplies = $checkthis[2];
$ArchiveNumber = $in{'ArchiveSelect'};

if ($checkthis[5] =~ /$ArchiveNumber\:/) {
	&StandardHTML("This topic has already been archived there.  We cannot archive a topic more than once to the same archive.  Please go back!");
exit;
}

&CurrentDate;
($topicnumber, $junk) = split(/\./, $topic);

$NewArchiveName = "$Today-$number-$topicnumber.cgi";

open(ARCH, ">$NonCGIPath/Archives/Archive-$ArchiveNumber/$NewArchiveName");
foreach $topline(@topicfile) {
chomp($topline);
print ARCH "$topline\n";
}
close(ARCH);

chmod (0666, "$NonCGIPath/Archives/Archive-$ArchiveNumber/$NewArchiveName");

#add to archive threads file--
&AppendArchiveSumm("$ArchiveNumber", "$NewArchiveName");

#create archive HTML file
&CreateArchiveHTML("$ArchiveNumber", "$NewArchiveName", "0", "1");

#add to archive index--
&AppendArchiveIndex("$ArchiveNumber", "$NewArchiveName");

if ($in{'ArchiveChoiceOption'} eq "Keep") {
#mark topic to note that it has already been archived
&MarkForumTopic("$ForumsPath/$OldPath/$topic", "$ArchiveNumber", "$NewArchiveName");
&EndUpdate("T O P I C &nbsp;&nbsp;&nbsp;&nbsp; A R C H I V E D", "We have stored the requested topic in the archive.  This topic is still listed in its original forum, as well, since you elected not to delete it from its forum.<P>Hop to: <A HREF=\"$CGIURL/Ultimate.cgi?action=intro&BypassCookies=true\">Forum Summary Page</A>");
}  else {
#delete old topic and HTML file, and remove from forum index
unlink("$ForumsPath/$OldPath/$topic");
if (-e "$ForumsPath/$OldPath/HTML/$topicnumber.html") {
unlink("$ForumsPath/$OldPath/HTML/$topicnumber.html");
}  else {
unlink("$ForumsPath/$OldPath/HTML/$topicnumber.cgi");
}
$ExactPath = "$OldPath";
&UpdateForumDetails($number);

#update lastnumber.file
$TotReplies = $TotReplies + 0;
$TotThreadPosts = $TotReplies + 1;
&UpdateForumTotals("$number", 1, $TotThreadPosts, "yes");
&RemoveThreadFromIndex($number, $topicnumber);
&EndUpdate("T O P I C &nbsp;&nbsp;&nbsp;&nbsp; A R C H I V E D", "We have stored the requested topic in the archive and removed the topic from its previous forum, per your request.<P>Hop to: <A HREF=\"$CGIURL/Ultimate.cgi?action=intro&BypassCookies=true\">Forum Summary Page</A>");
}
}
}  #end SubmitTransfer

sub Transfer {
print<<TransferIt;
<HTML><HEAD>
<TITLE>
$BBName - Transfer This Topic
</TITLE>
</HEAD>
 <BODY $BGColor $PageBackground text="$TextColor" link="$LinkColor" alink="$ActiveLinkColor" vlink="$VisitedLinkColor">
<FONT SIZE="$TextSize" FACE="$FontFace" color="$TextColor">
$Header</font>
<table border=0>
<TR><TD>
<A HREF="Ultimate.cgi?action=intro&BypassCookie=true"><IMG SRC="$NonCGIURL/$BBTitle"  BORDER=0></A></td>
<td valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace" color="$TextColor">
<B>
Forum: <FONT COLOR="$VisitedLinkColor">$Forum </FONT>
<BR>
Topic: <FONT COLOR="$VisitedLinkColor">$TopicSubject</FONT>
</B>
</FONT>

</td></tr></table>
<P>
<CENTER><FONT SIZE="1" FACE="$FontFace"><B>Note: Only forum leaders ($AdminTitle, $ModeratorTitle) may transfer or archive a topic.</B><br>
</FONT>

<FORM ACTION="archive.cgi" NAME="REPLIER" METHOD="POST">
$BorderTop
<table border=0 cellspacing=1 cellpadding=4 width="$TableWidth2">
<TR $TableColorStrip><TD colspan=3><CENTER><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TableStripTextColor"><B>Select One (Transfer or Archive)</B>
</font></CENTER>
</td></tr>
<tr $AltColumnColor1><td valign=top><INPUT TYPE="RADIO" NAME="Option" VALUE="Transfer"></td><td><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TextColor">Transfer Topic To This Forum:</FONT>
<BR>
<BR>
<FONT SIZE="1" FACE="$FontFace" COLOR="$TextColor">
Note: You have the option of either deleting the topic entirely from the current forum after it is transferred, or keeping the topic in the current forum as well (it will be closed in the current forum, however).</font>
<blockquote>
<INPUT TYPE="RADIO" NAME="TransferChoiceOption" VALUE="Keep" CHECKED><FONT SIZE="1" FACE="$FontFace" COLOR="$TextColor">Keep topic in current forum after transferring. The topic will be closed in its current forum.<BR>
<INPUT TYPE="RADIO" NAME="TransferChoiceOption" VALUE="Delete">Delete topic from current forum after transferring.</FONT>

</blockquote></td>
<td valign=top>
<SELECT NAME="TransferToForumNum">
<OPTION value="">Select Forum To Transfer To:
TransferIt

&GetForumList;

print<<Transfer2;
</select>
</td>
</tr>
<tr $AltColumnColor2>
<td valign=top><INPUT TYPE="RADIO" NAME="Option" VALUE="Archive"></td><td><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TextColor">Archive Topic To This Archive: </FONT><BR>
<BR>
<FONT SIZE="1" FACE="$FontFace" COLOR="$TextColor">
Note: The topic will be moved to a read-only archive and either deleted or kept in the current forum (below, select whether you want to delete the topic from the forum after it is archived or whether you want to keep it "alive" in this forum, as well.)</font>
<blockquote>
<INPUT TYPE="RADIO" NAME="ArchiveChoiceOption" VALUE="Keep" CHECKED><FONT SIZE="1" FACE="$FontFace" COLOR="$TextColor">Keep topic in current forum after archiving.<BR>
<INPUT TYPE="RADIO" NAME="ArchiveChoiceOption" VALUE="Delete">Delete topic from current forum after archiving.</FONT>

</blockquote>
</td>
<td valign=top>
<SELECT NAME="ArchiveSelect">

Transfer2

@archives = &OpenFile("$NonCGIPath/Archives/archives.pl");
if  ($archives[0] ne "") {
print qq(<OPTION VALUE="">Select An Archive:);

foreach $arch(@archives) {
($ArchNum, $ArchName, $ArchDesc) = split(/\|\#\|/, $arch);
	print qq(<OPTION VALUE="$ArchNum">$ArchName);
}
} else {
print qq(<OPTION VALUE="">No Archives Have Been Created);
}

print<<Transfer3;
</SELECT>
</td>
</tr>
<TR $BGColor>
<TD colspan=2><B><FONT FACE="$FontFace" SIZE="$TextSize">
Your User Name</FONT>
</B>
</TD>
<TD>
<INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
</tr>
<TR $BGColor><TD colspan=2><B><FONT FACE="$FontFace" SIZE="$TextSize">
Your Password</FONT>
</B>
</TD>
<TD>
<INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td>
</tr>
</table>
$BorderBottom
<p>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="submittransfer">
<INPUT TYPE="HIDDEN" NAME="TopicSubject" VALUE="$TopicSubject">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$Forum">
<INPUT TYPE="HIDDEN" NAME="number" VALUE="$number">
<INPUT TYPE="HIDDEN" NAME="topic" VALUE="$topic">
<p>
<INPUT TYPE="Submit" NAME="SUBMIT" VALUE="Submit Now">
<INPUT TYPE="RESET" NAME="RESET" VALUE="Clear Fields">
</form>
<P>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
var dc = document.cookie;
var testUserName = getCookie("UserName");
var testPassword = getCookie("Password");

if (document.cookie) {

	if (testUserName == null) {  
document.REPLIER.UserName.focus();
	} else {
	document.REPLIER.UserName.value = getCookie("UserName");
document.REPLIER.Password.value = getCookie("Password");
	}
}  else {
document.REPLIER.UserName.focus();
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length;
            return unescape(dc.substring(begin, end));        }
}
return null;
}

// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>

</blockquote>
<P>
Transfer3

&PageBottomHTML;
}

sub GetForumList {
@forums = &OpenForumsFile;

for $each(@forums) {
	@ForumLine = split(/\|/, $each);
	chomp($ForumLine[8]);
		if (($ForumLine[3] eq "On") && ($number != $ForumLine[8])) {
print<<SelectHTML;
<OPTION value="$ForumLine[8]">$ForumLine[1]
SelectHTML
		}
}  #end for loop

}


sub IncreaseForumTotals {
## Used to add thread and/or posts totals in lastnumber.file

my $number = shift;
my $AddThreads = shift;
my $AddPosts = shift;
my $UpdateRow1 = shift;

###

open(FORUM, "$ForumsPath/$ExactPath/lastnumber.file");
	@currnumber = <FORUM>;
close(FORUM);

my $threadfilenum = $currnumber[0];
chomp($threadfilenum);
my $totalthreads = $currnumber[1];
chomp($totalthreads);
my $totalposts = $currnumber[2];
chomp($totalposts);

$totalthreads = $totalthreads + $AddThreads;
$totalposts = $totalposts + $AddPosts;

if ($UpdateRow1 eq "yes") {

opendir (FORUMDIR, "$ForumsPath/$ExactPath"); 
    my @theubbfiles = grep(/\.[cgi|ubb]/, readdir(FORUMDIR));
closedir (FORUMDIR);

#sort the ubb files
@ubbfiles = sort(@theubbfiles);
#reverse array so that largest number is first
@ubbfiles = reverse(@ubbfiles);
my $lastnumber = $ubbfiles[0];
($lastnumber, $junk) = split(/\./, $lastnumber);
$threadfilenum = $lastnumber;
}

&Lock("lock.file");
open(FORUM, ">$ForumsPath/$ExactPath/lastnumber.file");
print FORUM ("$threadfilenum\n");
print FORUM ("$totalthreads\n");
print FORUM ("$totalposts\n");
close(FORUM);
&Unlock("lock.file");

chmod(0666, "$ForumsPath/$ExactPath/lastnumber.file");
} #end IncreaseForumTotals

sub HEADERHTML {

if ($in{'UserName'} eq "") {
$UserName = "";
$Password = "";

}
print<<HEADER;
<HTML>
<HEAD>
	<TITLE>$BBName</TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE

var testUserNameCP = getCookie("UserNameCP");

var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if ((testUserNameCP == null) && (CookieUNCP != "")){
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";";
		document.cookie = "PasswordCP=" + CookiePWCP + ";";
	} 
	
function SetCursor() {
var thisUserNameCP = getCookie("UserNameCP");
var thisPasswordCP = getCookie("PasswordCP");

if (thisUserNameCP != null) {  
thisUserNameCP = unescape(thisUserNameCP);
thisPasswordCP = unescape(thisPasswordCP);

	document.THEFORM.UserNameCheck.value = thisUserNameCP;
document.THEFORM.PasswordCheck.value = thisPasswordCP;
	}  
}

function Check(form)  {
if ((form.Password.value == "") || (form.UserName.value == ""))  {
	alert ("You forgot to fill in the Username and/or Password fields.  These are required entries!");
	return false
	}  else  {
	return true
	}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}
// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</HEAD>
<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000" onLoad="SetCursor()">
<BR>
<center>
<FONT SIZE="2" FACE="Verdana, Arial">$PageTitle</FONT>
</center>
<P>
<FONT SIZE="2" FACE="Verdana, Arial">
HEADER
} #end HEADERHTML sr


sub CreateArchiveHTML {
my $ArchiveNumber = shift;
my $ArchiveTopic = shift;
my $ArrayStart = shift;
my $PageNumber = shift;

$PageNumber = $PageNumber + 0;
$ArrayStart = $ArrayStart + 0;

($ThisTopicNumber, $junk) = split(/\./, $ArchiveTopic);

($junk, $thisforumnumber, $junk2) = split(/-/, $ThisTopicNumber);
@thisforum = &GetForumRecord($thisforumnumber);
$ThisForumName = $thisforum[1];

#create random numbers for headers/footers
if ($RandomNumber) {
$RandomNumber = $RandomNumber + 2;
$RandomNumber2 = $RandomNumber2 + 2;
}  else {
@digit = (0..9);
srand(time);
$num1 = rand(10);
$num2 = rand(10); 
$num3 = rand(10);
$num4 = rand(10); 
$RandomNumber = ("$digit[$num1]" . "$digit[$num2]" . "$digit[$num3]" . "$digit[$num4]");

$RandomNumber2 = $RandomNumber + 1004;
}

if ($Header ne "") {
$Header2 = $Header;
$Header2 =~ s/UBBrandomX/$RandomNumber/isg;
$Header2 =~ s/UBBrandomY/$RandomNumber2/isg;
}
if ($Footer ne "") {
$Footer2 = $Footer;
$Footer2 =~ s/UBBrandomX/$RandomNumber/isg;
$Footer2 =~ s/UBBrandomY/$RandomNumber2/isg;
}

@archivelist = &OpenFile("$NonCGIPath/Archives/archives.pl");
foreach $archie(@archivelist) {
	if ($archie =~ /^$ArchiveNumber/) {
		@thisarchie = split(/\|\#\|/, $archie);
		$ArchiveName = $thisarchie[1];
	}
}

@threadinformation = &OpenFile("$NonCGIPath/Archives/Archive-$ArchiveNumber/$ArchiveTopic");

@statarray = split(/\|\|/, $threadinformation[0]);

if ($ReverseThreads eq "TRUE") {
	@threadinfo = reverse(@threadinformation);
	$ALine = pop(@threadinfo);
	chomp($ALine);
	unshift(@threadinfo, $ALine);

}  else {
	@threadinfo = @threadinformation;
}

#adjust for max post per page, if necessary
if (($HTMLDisplayMax ne "") && ($HTMLDisplayMax ne "NONE")) {
my $PostTotal = @threadinfo - 1;
if ($PostTotal > $HTMLDisplayMax) {

$TotalPages = $PostTotal / $HTMLDisplayMax;

if ($TotalPages =~ /\./) {
	($Whole, $junk) = split(/\./, $TotalPages);
	$TotalPages = $Whole + 1;
}  else {
	$TotalPages = $TotalPages;
}

$TopicPageTotal = "This topic is $TotalPages pages long:";
$eachpage = "";
for ($eachpage == 1; $eachpage <= $TotalPages; $eachpage++) {
if ($eachpage == 1) {
	$PageName = "$ThisTopicNumber";
}  else {
	$PageName = "$ThisTopicNumber-$eachpage";
}
if ($PageNumber == $eachpage) {
$TopicPageTotal .= qq(&nbsp;$eachpage&nbsp;);
}  else {
$TopicPageTotal .= qq(&nbsp;<A HREF="$NonCGIURL/Archives/Archive-$ArchiveNumber/HTML/$PageName.html">$eachpage</A>&nbsp;)
}
}

$ThisPage = "(Page $PageNumber)";

	if (($ArrayStart eq "") || ($ArrayStart eq "0")) {
	$MaxPoint = $HTMLDisplayMax;
	@postinfo = @threadinfo[1... $MaxPoint];
	$ContinueAt = $MaxPoint + 1;
	$NextPage = $PageNumber + 1;
	}  else {
	$MaxPoint = ($ArrayStart + $HTMLDisplayMax) - 1;
		if ($MaxPoint >= $#threadinfo) {
			$MaxPoint = $#threadinfo;
			@postinfo = @threadinfo[$ArrayStart... $MaxPoint];
			$ContinueAt = "";
		}  else {
			@postinfo = @threadinfo[$ArrayStart... $MaxPoint];
			$ContinueAt = $MaxPoint + 1;
			$NextPage = $PageNumber + 1;
		}
  }
}  else {
	@postinfo = @threadinfo[1... $#threadinfo];
	$ContinueAt = "";
	$TotalPages = 1;
}

} else {
	@postinfo = @threadinfo[1... $#threadinfo];
	$ContinueAt = "";
	$TotalPages = 1;
}  #end if HTML max display

$TopicWriter = "$statarray[3]";
$UNCoded = $TopicWriter;
$UNCoded =~ tr/ /+/;
$TopicSubject = $statarray[4];
chomp($TopicSubject);
	$SubjectCoded = &HTMLIFY($TopicSubject);
			$SubjectCoded =~ tr/ /+/;

#if Email is ON, display email thread wording
if (($UseEmail eq "ON") && ($ThisRestrict ne "private")) {
	$EmailThreadWording = qq(<P><IMG SRC="$NonCGIURL/ubbfriendminiicon.gif" BORDER=0> <A HREF="$CGIURL/ubbmisc.cgi?action=sendthread&thread=$NonCGIURL/Archives/Archive-$ArchiveNumber/HTML/$ThisTopicNumber.html&Subject=$SubjectCoded">UBBFriend: Email This Page to Someone!</A>);
}  else {
	$EmailThreadWording = "";
}

unless (-d "$NonCGIPath/Archives/Archive-$ArchiveNumber/HTML") {
mkdir("$NonCGIPath/Archives/Archive-$ArchiveNumber/HTML", 0777);
chmod (0777, "$NonCGIPath/Archives/Archive-$ArchiveNumber/HTML");
}

$FolderLine = qq(<IMG SRC="$NonCGIURL/open.gif"  BORDER=0>&nbsp;&nbsp;<A HREF="$CGIURL/Ultimate.cgi?action=intro&BypassCookie=true">$BBName</A>
<br><IMG SRC="$NonCGIURL/tline.gif" BORDER=0><IMG SRC="$NonCGIURL/open.gif"  BORDER=0>&nbsp;&nbsp;<A HREF="$CGIURL/forumdisplay.cgi?action=topics&number=A:$ArchiveNumber">$ArchiveName</A>
<br>
<IMG SRC="$NonCGIURL/tline3.gif" BORDER=0><IMG SRC="$NonCGIURL/open.gif" BORDER=0>&nbsp;&nbsp;$TopicSubject $ThisPage);


if ($DisplayRegistration eq "NO") {
$RegLinkHere = "";
}  else {
$RegLinkHere = qq(<A HREF="$CGIURL/ubbmisc.cgi?action=editbio&Browser=$Browser&DaysPrune=$DaysPrune&LastLogin=$in{'LastLogin'}"><ACRONYM TITLE="Click here to edit your profile.">profile</ACRONYM></A> | <A HREF="$CGIURL/Ultimate.cgi?action=agree"><ACRONYM TITLE="Registration is free!">register</ACRONYM></A> |);
}

$ThisThread = qq(<HTML><HEAD><TITLE>Archive: $TopicSubject - $BBName</title><META HTTP-EQUIV="Pragma" CONTENT="no-cache"></head> <BODY $BGColor  $PageBackground text="$TextColor" link="$LinkColor" alink="$ActiveLinkColor" vlink="$VisitedLinkColor">
<FONT SIZE="$TextSize" FACE="$FontFace">
$Header2<table border=0 width=$TableWidth><TR>
<td valign=top align=left><A HREF="$CGIURL/Ultimate.cgi?action=intro&BypassCookie=true"><IMG SRC="$NonCGIURL/$BBTitle" BORDER=0></A>
<BR><center><FONT SIZE="1" FACE="$FontFace" COLOR="$LinkColor">Note: This is an archived topic.  It is read-only.</FONT></center>
</FONT>
</td>
<td valign=top NOWRAP>
<FONT SIZE="1" FACE="$FontFace">
$FolderLine
<center>
$EmailThreadWording
<P><FONT SIZE="1" FACE="$FontFace">
$RegLinkHere <A HREF="$CGIURL/ubbmisc.cgi?action=setprefs"><ACRONYM TITLE="Set your preferences.">preferences</ACRONYM></A> | <A HREF="$NonCGIURL/faq.html" target=_blank><ACRONYM TITLE="Frequently Asked Questions">faq</ACRONYM></A> | <A HREF="$CGIURL/search.cgi?action=intro"><ACRONYM TITLE="Perform a search by keyword, date, or name.">search</ACRONYM></A>
<P>
</font>
</center>
</td></tr></table><center>
<BR>
<TABLE BORDER=0 WIDTH=$TableWidth>
<TR><TD valign=bottom><FONT SIZE="1" face="$FontFace">$TopicPageTotal<BR>This topic was originally posted in this forum: <A HREF="$CGIURL/forumdisplay.cgi?action=topics&number=$thisforumnumber">$ThisForumName</A></font></TD></TABLE>
$BorderTop
<table width=$TableWidth2 border=0 cellspacing=1 cellpadding=4>
<TR $TableColorStrip>
<TD valign=middle width=18%>
<FONT SIZE="1" face="$FontFace" color="$TableStripTextColor"><B>Author</B></FONT>
</TD>
<TD valign=middle>
<FONT SIZE="1" face="$FontFace" color="$TableStripTextColor"><B>Topic:&nbsp;&nbsp; $TopicSubject</B></FONT>
</TD>
</TR>);

$AlternateColor = "$AltColumnColor2";
##
foreach $line(@postinfo) {
	@thisline = split(/\|\|/, $line);
		$UserNameCoded = $thisline[2];
		$UserNameCoded = &HTMLIFY($UserNameCoded);
		$UserNameCoded =~ tr/ /+/;
		$theDate = "$thisline[3]";
		
		$RegName = "$thisline[8]";
		chomp($RegName);

		#format date
if ($DateFormat eq "US") {
	$ThisDate = "$theDate";
}
elsif ($DateFormat eq "Euro") {
	$ThisDate = &DateFormat("$theDate", "Euro");
}
elsif ($DateFormat eq "USX") {
	$ThisDate = &DateFormat("$theDate", "USExpanded");
} else {
	$ThisDate = &DateFormat("$theDate", "EuroExpanded");
}	
		#format time
		if ($TimeFormat eq "24HR")  {
			@timearray = split(/ /, $thisline[4]);
			chomp($timearray[1]);
			($gethour, $getmin) = split(/:/, $timearray[0]);
		if ($timearray[1] eq "PM") {		
			if ($gethour < 12) {
				$gethour = ($gethour  + 12);
			}
		}
		if ($AMpm eq "AM") {		
			if ($gethour == 12) {
				$gethour = "0";
			}
		}
		$gethour = sprintf ("%2d", $gethour);
		$gethour =~tr/ /0/;
		$getmin = sprintf ("%2d", $getmin);
		$getmin =~tr/ /0/;
		$FormatTime = "$gethour:$getmin";
		} else {
		$FormatTime = "$thisline[4]";
		}
		$theTime = "thisline[4]";
	
		$ReplyText = $thisline[6];
#get reply writer's email view status
my $ProfileNumber = &GetUserNumber($thisline[2]);

if ($ProfileNumber ne "") {

@thisprofile = &OpenProfile("$ProfileNumber.cgi");
$EmailView = $thisprofile[11];
$ThisStatus = $thisprofile[8];

if ($ThisStatus eq "Administrator") {
	$ThisStatus = "$AdminTitle";
}
elsif ($ThisStatus eq "Moderator") {
	$ThisStatus = "$ModeratorTitle";
}
elsif ($ThisStatus eq "Member") {
	$ThisStatus = "$MemberTitle";
}  else {
	$ThisStatus = "$JrMemberTitle";
}
}  else {
	$RegName = "unreg";
}
if ($RegName ne "unreg"){
$ProfileString = qq(<A HREF="$CGIURL/ubbmisc.cgi?action=getbio&UserName=$UserNameCoded" target=_new>
<IMG SRC="$NonCGIURL/$profilegif" BORDER=0 ALT="Click Here to See the Profile for $thisline[2]"></A>);


if (($EmailBlock eq "ON") || ($EmailView eq "no")) {
$EmailString = "&nbsp;";
}  else {

$EmailString = qq(&nbsp;&nbsp;<A HREF="$CGIURL/Ultimate.cgi?action=email&ToWhom=$UserNameCoded" target=_new><IMG SRC="$NonCGIURL/$mailgif" BORDER=0 ALT="Click Here to Email $thisline[2]"></A>&nbsp;&nbsp;);
} 	
}  else {
$EmailString = "&nbsp;";
$ThisStatus = "unregistered";
$ProfileString = "&nbsp;";
}

if ($DisplayRegistration eq "NO") {
$EmailString = "&nbsp;";
$ThisStatus = "";
$ProfileString = "&nbsp;";
$EditLink = "";
}

$ThisThread .= qq(<tr $AlternateColor>
	<TD width=18% valign=top>
	<FONT SIZE="$TextSize" face="$FontFace"><B>$thisline[2]</B></font><BR><FONT SIZE="1" face="$FontFace">$ThisStatus</FONT>
</td>
<TD>
<IMG SRC="$NonCGIURL/posticon.gif" BORDER=0>
<FONT SIZE="$TextSize" FACE="$FontFace">
<FONT SIZE="1" color="$TimeColor" face="$FontFace">posted $ThisDate $FormatTime &nbsp;&nbsp;&nbsp;
$ProfileString $EmailString &nbsp;&nbsp;
</FONT><HR>$ReplyText</FONT><BR><BR></td></tr>);

#rotate thru alt colors
if ($AlternateColor eq "$AltColumnColor1") {
	$AlternateColor = "$AltColumnColor2";
	}  else {
	$AlternateColor = "$AltColumnColor1";
	}
}  # end loop


$ThisThread .= qq(</table>$BorderBottom<table border=0 width="$TableWidth"><TR><TD valign=top align=left><FONT SIZE="1" FACE="$FontFace">$TopicPageTotal<P>All times are $TimeZone</FONT></td><td valign=top align=right><FONT SIZE="1" FACE="$FontFace">This is an ARCHIVED topic.  You may not reply to it!</font></td></tr>
<tr><td colspan=2></td></tr>
<TR><TD></TD>
<td align=right valign=top NOWRAP>
<FONT SIZE="$TextSize" FACE="$FontFace">
<FORM ACTION="$CGIURL/forumdisplay.cgi" METHOD="GET">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="topics">
<B>Hop to: </B><SELECT NAME="number">);

#add forum select list
&GetForumSelectList2;

$ThisThread .= qq(</SELECT>
<INPUT TYPE="SUBMIT" NAME="SUBMIT" VALUE="Go">
</FORM></FONT></TD></tr></TABLE>
<br><B><FONT SIZE="$TextSize" FACE="$FontFace">
<A HREF="mailto:$BBEmail">Contact Us</A> | <A HREF="$HomePageURL" target=_top>$MyHomePage</A>
</B></FONT>
<p><FONT COLOR="$CopyrightTextColor" size="1" FACE="$FontFace">$YourCopyrightNotice
<P>
Powered by: Ultimate Bulletin Board, Version $Version<BR>&copy; Madrona Park, Inc., 1998 - 1999.<br><br>
</FONT></CENTER>$Footer2</font></body></html>);

if ($PageNumber eq "1") {
	$HTMLPageName = "$ThisTopicNumber";
}  else {
	$HTMLPageName = "$ThisTopicNumber-$PageNumber";
}

unless (-w "$NonCGIPath/Archives/Archive-$ArchiveNumber/HTML/$HTMLPageName.html") {
unlink "$NonCGIPath/Archives/Archive-$ArchiveNumber/HTML/$HTMLPageName.html";
}

&Lock("lock.file");
open (THREADHTML, ">$NonCGIPath/Archives/Archive-$ArchiveNumber/HTML/$HTMLPageName.html");
print THREADHTML ("$ThisThread");
close (THREADHTML);
&Unlock("lock.file");

chmod (0777, "$NonCGIPath/Archives/Archive-$ArchiveNumber/HTML/$HTMLPageName.html");

if ($ContinueAt ne "") {
	&CreateArchiveHTML("$ArchiveNumber", "$ArchiveTopic", "$ContinueAt", "$NextPage");
}
}  #end CreateArchiveHTML

sub AppendArchiveSumm {
my $ArchiveNumber = shift;
my $ArchiveTopic = shift;

($ThisNum, $junk) = split(/\./, $ArchiveTopic);

@topicfile = &OpenFile("$NonCGIPath/Archives/Archive-$ArchiveNumber/$ArchiveTopic");

@stats = split(/\|\|/, $topicfile[0]);
$stats[3] =~ s/\|/&#0124;/sg;
$ThisSubject = $stats[4];
chomp($ThisSubject);
$ThisSubject =~ s/\|/&#0124;/sg;

$ThreadLine = "$ThisSubject|#|$ThisNum|#|$stats[3]";

&AppendFile("$NonCGIPath/Archives/Archive-$ArchiveNumber/archives.thread", "$ThreadLine");
chmod(0777, "$NonCGIPath/Archives/Archive-$ArchiveNumber/archives.thread");
}


sub AppendArchiveIndex {
my $ArchiveNumber = shift;
my $ArchiveTopic = shift;

($ThisNum, $junk) = split(/\./, $ArchiveTopic);

@topicfile = &OpenFile("$NonCGIPath/Archives/Archive-$ArchiveNumber/$ArchiveTopic");

$TopLine = $topicfile[0];
@stats = split(/\|\|/, $TopLine);
$TopicSubject = $stats[4];
chomp($TopicSubject);
$TopicSubject =~ s/\|/&#0124;/sg;

foreach $uno(@topicfile) {
if ($uno !~ /^A/) {
@thisline = split(/\|\|/, $uno);
$Mess = $thisline[6];
$Message = &Indexify($Mess);
$PostDate = $thisline[3];
$Author = $thisline[2];
$Author =~ s/\|/&#0124;/sg;

$IndexLine = "$ArchiveNumber|$ThisNum|$thisline[2]|$PostDate|$TopicSubject|$Message";
&AppendFile("$NonCGIPath/Archives/archiveindex-$ArchiveNumber.pl", "$IndexLine");
}
}
chmod(0777, "$NonCGIPath/Archives/archiveindex-$ArchiveNumber.pl");
}

sub MarkForumTopic {
my $Path = shift;
my $ArchDir = shift;
my $ArchTopic = shift;

@thistopic = &OpenFile("$Path");
$TopLine = $thistopic[0];

@statline = split(/\|\|/, $TopLine);
chomp($statline[4]);
$ArchiveNotes = $statline[5];
chomp($ArchiveNotes);
chomp($statline[6]);
$ThisNote = "$ArchDir:$ArchTopic,";
if ($ArchiveNotes eq "") {
	$ArchiveNotes = $ThisNote;
}  else {
$ArchiveNotes = ("$ArchiveNotes" . "$ThisNote");
}

$statline[5] = $ArchiveNotes;
$thistopic[0] = join("||", @statline);

&Lock("lock.file");
open (REVISED, ">$Path");
foreach $uno(@thistopic) {
chomp($uno);
print REVISED ("$uno\n");
}
close(REVISED);
&Unlock("lock.file");
}

sub ReArchiveIndex {
my $ArchRow = shift;
my $ArchTotal = shift;
my $StartWith = shift;

$ArchRow = $ArchRow + 0;
$ArchTotal = $ArchTotal + 0;
$StartWith = $StartWith + 0;

#is this the last archive?
if ($ArchRow == $ArchTotal) {
	$LastArchive = "true";
}  else {
	$LastArchive = "false";
}

my @archives = &OpenFile("$NonCGIPath/Archives/archives.pl");
my $uno = "";
my $Count = 0;

foreach $uno(@archives) {
$Count++;
	if ($Count == $ArchRow) {
		($ThisNumber, $junk, $junk2) = split(/\|\#\|/, $uno);
	}
}

#retrieve all topics 
opendir (GETTHREADS, "$NonCGIPath/Archives/Archive-$ThisNumber");
	@threads1 = readdir (GETTHREADS);
closedir (GETTHREADS);

@threads2 = grep(/\.cgi/, @threads1);
@threads = sort(@threads2);

$TotalThreads = @threads; #total topics in archive
$LastArrayNum = $TotalThreads - 1;

#limit processing to Cycle rate of 250 topics
$Cycle = 250;
$ThisCycle = $Cycle - 1;
$ArrayStart = $StartWith - 1;
$End = $StartWith + $ThisCycle;
$ArrayEnd = $End - 1;

if ($LastArrayNum <= $ArrayEnd) {
	$ArrayEnd = $LastArrayNum;
	$FinishedArchive = "true";
}  else {
	$FinishedArchive = "false";
}

@truncated = @threads[$ArrayStart... $ArrayEnd];
$StartPoint = $StartWith;
$LastOne = $ArrayEnd + 1;
$NextStart = $ArrayEnd + 1;
	@forumindex = @blank;
for $this(@truncated) {
	@stat = &OpenFile("$NonCGIPath/Archives/Archive-$ThisNumber/$this");
		@stats = split(/\|\|/, $stat[0]);
		$Subject = $stats[4];
		$Subject =~ s/\|/&#0124;/sg;
		chomp($Subject);
		
		($HTMLpage, $trash) = split(/\./, $this);
	
		foreach $review(@stat) {
			unless ($review =~ /^A/) {
			@parseit = split(/\|\|/, $review);
			my $Writer = $parseit[2];
			my $Date = $parseit[3];
			chomp($parseit[6]);
			my $Text = &Indexify($parseit[6]);
			$Writer =~ s/\|/&#0124;/sg;
			my $threadline .= ("$ThisNumber" . "|" . "$HTMLpage" . "|" . "$Writer" . "|" . "$Date" . "|" . "$Subject" . "|" . "$Text\n");
			push (@forumindex, $threadline);
			} #end unless
		}
} #end for threads loop


if ($ArrayStart == 0) {
unlink("$NonCGIPath/Archives/archiveindex-$ThisNumber.pl");
}

&Lock ("lock.file");
open (THISFILE, ">>$NonCGIPath/Archives/archiveindex-$ThisNumber.pl");
for $line(@forumindex) {
chomp($line);
print THISFILE ("$line\n");
}
close (THISFILE);
&Unlock ("lock.file");
chmod (0666, "$NonCGIPath/Archives/archiveindex-$ThisNumber.pl");

if ($FinishedArchive eq "true") {
	if ($LastArchive eq "true") {
		&EndUpdate("I N D E X &nbsp;&nbsp;&nbsp;&nbsp; U P D A T E D", "Thank you for your patience.  All forum and archive topics have been completely re-indexed.");
	} else {
		$ArchRow++;
		&ContinueArchIndex("$ArchRow", "$ArchTotal", "1");
	}
} else {
		&ContinueArchIndex("$ArchRow", "$ArchTotal" , "$NextStart");
}

} #end rearchiveindex


sub ContinueArchIndex {
my $ArchRow = shift;
my $TotalArchie = shift;
my $NextStart = shift;

$ActionWording = qq(We are indexing each of your archive topics now.<P>Archive <FONT FACE="Verdana" SIZE="2" COLOR="Navy">$ThisNumber</FONT> is currently being updated.  Please wait while we continue updating!</B><P>We just finished updating topics <FONT FACE="Verdana" SIZE="2" COLOR="Navy">$StartPoint</font> through<FONT FACE="Verdana" SIZE="2" COLOR="Navy"> $LastOne </font> in Archive <FONT FACE="Verdana" SIZE="2" COLOR="Navy">$ThisNumber</font>
</FONT>);
$ForwardURL = "$CGIURL/archive.cgi?action=ContinueArchiveIndex&ArchiveRow=$ArchRow&TotalArchives=$TotalArchie&StartWith=$NextStart";
&ContinueThis($ForwardURL, $ActionWording);

}


sub UpdateArchThreads {
my $ArchRow = shift;
my $ArchTotal = shift;
my $StartWith = shift;

$ArchRow = $ArchRow + 0;
$ArchTotal = $ArchTotal + 0;
$StartWith = $StartWith + 0;

#is this the last archive?
if ($ArchRow == $ArchTotal) {
	$LastArchive = "true";
}  else {
	$LastArchive = "false";
}

my @archives = &OpenFile("$NonCGIPath/Archives/archives.pl");
my $uno = "";
my $Count = 0;

foreach $uno(@archives) {
$Count++;
	if ($Count == $ArchRow) {
		($ThisNumber, $junk, $junk2) = split(/\|\#\|/, $uno);
	}
}

#retrieve all topics 
opendir (GETTHREADS, "$NonCGIPath/Archives/Archive-$ThisNumber");
	@threads1 = readdir (GETTHREADS);
closedir (GETTHREADS);

@threads2 = grep(/\.cgi/, @threads1);
@threads = sort(@threads2);

$TotalThreads = @threads; #total topics in archive
$LastArrayNum = $TotalThreads - 1;

#limit processing to Cycle rate of 250 topics
$Cycle = 250;
$ThisCycle = $Cycle - 1;
$ArrayStart = $StartWith - 1;
$End = $StartWith + $ThisCycle;
$ArrayEnd = $End - 1;

if ($LastArrayNum <= $ArrayEnd) {
	$ArrayEnd = $LastArrayNum;
	$FinishedArchive = "true";
}  else {
	$FinishedArchive = "false";
}

@truncated = @threads[$ArrayStart... $ArrayEnd];
$StartPoint = $StartWith;
$LastOne = $ArrayEnd + 1;
$NextStart = $ArrayEnd + 1;

for $this(@truncated) {
	@topicfile = &OpenFile("$NonCGIPath/Archives/Archive-$ThisNumber/$this");

($TopicNumber, $junk) = split(/\./, $this);
@stats = split(/\|\|/, $topicfile[0]);
$TopicSubject = $stats[4];
chomp($TopicSubject);
$Author = $stats[3];
$Author =~ s/\|/&#0124;/sg;
$TopicSubject =~ s/\|/&#0124;/sg;

$ThreadLine = "$TopicSubject|#|$TopicNumber|#|$Author";
	push(@threadfile, $ThreadLine);
} #end for threads loop


if ($ArrayStart == 0) {
unlink("$NonCGIPath/Archives/Archive-$ThisNumber/archives.thread");
}

&Lock ("lock.file");
open (THISFILE, ">>$NonCGIPath/Archives/Archive-$ThisNumber/archives.thread");
for $line2(@threadfile) {
chomp($line2);
print THISFILE ("$line2\n");
}
close (THISFILE);
&Unlock ("lock.file");
chmod (0666, "$NonCGIPath/Archives/Archive-$ThisNumber/archives.thread");

if ($FinishedArchive eq "true") {
	if ($LastArchive eq "true") {
		&EndUpdate("P R O C E S S &nbsp;&nbsp;&nbsp;&nbsp; C O M P L E T E", "Thank you for your patience.  All forums and archives have been recalibrated and your general variables have been updated.");
	} else {
		$ArchRow++;
		&ContinueUpdateThreads("$ArchRow", "$ArchTotal", "1");
	}
} else {
		&ContinueUpdateThreads("$ArchRow", "$ArchTotal" , "$NextStart");
}

} #end updateArchThreads

sub ContinueUpdateThreads {
my $ArchRow = shift;
my $TotalArchie = shift;
my $NextStart = shift;

$ActionWording = qq(Please wait while we continue updating!</B><P>We just finished updating topic threads <FONT FACE="Verdana" SIZE="2" COLOR="Navy">$StartPoint</font> through<FONT FACE="Verdana" SIZE="2" COLOR="Navy"> $LastOne </font> in Archive <FONT FACE="Verdana" SIZE="2" COLOR="Navy">$ThisNumber</font>
</FONT>);
$ForwardURL = "$CGIURL/archive.cgi?action=UpdateArchiveThreads&ArchiveRow=$ArchRow&TotalArchives=$TotalArchie&StartWith=$NextStart";
&ContinueThis($ForwardURL, $ActionWording);
}