VERSION 5.00
Begin VB.Form frmBitmap 
   Caption         =   "Bitmap Browser"
   ClientHeight    =   5055
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   8505
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   ScaleHeight     =   5055
   ScaleWidth      =   8505
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton Command1 
      Caption         =   "Cancel"
      Height          =   375
      Left            =   1440
      TabIndex        =   30
      Top             =   4440
      Width           =   1095
   End
   Begin VB.CommandButton cmdOK 
      Caption         =   "OK"
      Default         =   -1  'True
      Height          =   375
      Left            =   120
      TabIndex        =   29
      Top             =   4440
      Width           =   1095
   End
   Begin VB.CommandButton cmdBottomInc 
      Caption         =   ">"
      Height          =   255
      Left            =   2280
      TabIndex        =   27
      Top             =   4080
      Width           =   255
   End
   Begin VB.CommandButton cmdRightInc 
      Caption         =   ">"
      Height          =   255
      Left            =   2280
      TabIndex        =   25
      Top             =   3720
      Width           =   255
   End
   Begin VB.CommandButton cmdTopInc 
      Caption         =   ">"
      Height          =   255
      Left            =   2280
      TabIndex        =   23
      Top             =   3360
      Width           =   255
   End
   Begin VB.CommandButton cmdBottomDec 
      Caption         =   "<"
      Height          =   255
      Left            =   2040
      TabIndex        =   28
      Top             =   4080
      Width           =   255
   End
   Begin VB.CommandButton cmdRightDec 
      Caption         =   "<"
      Height          =   255
      Left            =   2040
      TabIndex        =   26
      Top             =   3720
      Width           =   255
   End
   Begin VB.CommandButton cmdTopDec 
      Caption         =   "<"
      Height          =   255
      Left            =   2040
      TabIndex        =   24
      Top             =   3360
      Width           =   255
   End
   Begin VB.CommandButton cmdLeftInc 
      Caption         =   ">"
      Height          =   255
      Left            =   2280
      TabIndex        =   22
      Top             =   3000
      Width           =   255
   End
   Begin VB.CommandButton cmdLeftDec 
      Caption         =   "<"
      Height          =   255
      Left            =   2040
      TabIndex        =   21
      Top             =   3000
      Width           =   255
   End
   Begin VB.CheckBox chkRect 
      Caption         =   "Use rectangle"
      Height          =   255
      Left            =   720
      TabIndex        =   19
      Top             =   2640
      Width           =   1335
   End
   Begin VB.TextBox txtBottom 
      Height          =   285
      Left            =   720
      TabIndex        =   9
      Top             =   4080
      Width           =   1215
   End
   Begin VB.TextBox txtRight 
      Height          =   285
      Left            =   720
      TabIndex        =   8
      Top             =   3720
      Width           =   1215
   End
   Begin VB.TextBox txtTop 
      Height          =   285
      Left            =   720
      TabIndex        =   7
      Top             =   3360
      Width           =   1215
   End
   Begin VB.TextBox txtLeft 
      Height          =   285
      Left            =   720
      TabIndex        =   4
      Top             =   3000
      Width           =   1215
   End
   Begin VB.VScrollBar VScroll 
      Height          =   4095
      Left            =   6000
      Max             =   1
      Min             =   -1
      TabIndex        =   3
      TabStop         =   0   'False
      Top             =   240
      Width           =   255
   End
   Begin VB.HScrollBar HScroll 
      Height          =   255
      LargeChange     =   2
      Left            =   2640
      Max             =   1
      Min             =   -1
      TabIndex        =   2
      TabStop         =   0   'False
      Top             =   4440
      Width           =   3255
   End
   Begin VB.PictureBox PictureBox 
      Height          =   4095
      Left            =   2640
      ScaleHeight     =   4035
      ScaleWidth      =   3195
      TabIndex        =   1
      Top             =   240
      Width           =   3255
      Begin VB.PictureBox boxMove 
         Appearance      =   0  'Flat
         BackColor       =   &H000000FF&
         BorderStyle     =   0  'None
         ForeColor       =   &H00FF0000&
         Height          =   75
         Left            =   1320
         MousePointer    =   15  'Size All
         ScaleHeight     =   75
         ScaleWidth      =   75
         TabIndex        =   31
         Top             =   3360
         Visible         =   0   'False
         Width           =   75
      End
      Begin VB.PictureBox boxLeft 
         BackColor       =   &H000000FF&
         Height          =   975
         Left            =   480
         MousePointer    =   9  'Size W E
         ScaleHeight     =   975
         ScaleWidth      =   15
         TabIndex        =   20
         Top             =   2760
         Visible         =   0   'False
         Width           =   15
      End
      Begin VB.PictureBox boxTop 
         BackColor       =   &H000000FF&
         Height          =   15
         Left            =   980
         MousePointer    =   7  'Size N S
         ScaleHeight     =   15
         ScaleWidth      =   2535
         TabIndex        =   18
         Top             =   1880
         Visible         =   0   'False
         Width           =   2535
      End
      Begin VB.PictureBox boxBottom 
         BackColor       =   &H000000FF&
         Height          =   15
         Left            =   980
         MousePointer    =   7  'Size N S
         ScaleHeight     =   15
         ScaleWidth      =   2535
         TabIndex        =   17
         Top             =   3200
         Visible         =   0   'False
         Width           =   2535
      End
      Begin VB.PictureBox boxRight 
         BackColor       =   &H000000FF&
         Height          =   975
         Left            =   2900
         MousePointer    =   9  'Size W E
         ScaleHeight     =   975
         ScaleWidth      =   15
         TabIndex        =   16
         Top             =   2960
         Visible         =   0   'False
         Width           =   15
      End
      Begin VB.PictureBox boxTopLeft 
         Appearance      =   0  'Flat
         BackColor       =   &H000000FF&
         BorderStyle     =   0  'None
         ForeColor       =   &H00FF0000&
         Height          =   75
         Left            =   740
         MousePointer    =   8  'Size NW SE
         ScaleHeight     =   75
         ScaleWidth      =   75
         TabIndex        =   15
         Top             =   3080
         Visible         =   0   'False
         Width           =   75
      End
      Begin VB.PictureBox boxTopRight 
         Appearance      =   0  'Flat
         BackColor       =   &H000000FF&
         BorderStyle     =   0  'None
         ForeColor       =   &H00FF0000&
         Height          =   75
         Left            =   1700
         MousePointer    =   6  'Size NE SW
         ScaleHeight     =   75
         ScaleWidth      =   75
         TabIndex        =   14
         Top             =   2960
         Visible         =   0   'False
         Width           =   75
      End
      Begin VB.PictureBox boxBottomLeft 
         Appearance      =   0  'Flat
         BackColor       =   &H000000FF&
         BorderStyle     =   0  'None
         ForeColor       =   &H00FF0000&
         Height          =   75
         Left            =   860
         MousePointer    =   6  'Size NE SW
         ScaleHeight     =   75
         ScaleWidth      =   75
         TabIndex        =   13
         Top             =   3680
         Visible         =   0   'False
         Width           =   75
      End
      Begin VB.PictureBox boxBottomRight 
         Appearance      =   0  'Flat
         BackColor       =   &H000000FF&
         BorderStyle     =   0  'None
         ForeColor       =   &H00FF0000&
         Height          =   75
         Left            =   1700
         MousePointer    =   8  'Size NW SE
         ScaleHeight     =   75
         ScaleWidth      =   75
         TabIndex        =   12
         Top             =   3560
         Visible         =   0   'False
         Width           =   75
      End
      Begin VB.Image ImageBMP 
         Height          =   480
         Left            =   1440
         Top             =   1920
         Width           =   480
      End
   End
   Begin VB.FileListBox Files 
      Height          =   2235
      Left            =   120
      Pattern         =   "*.bmp"
      TabIndex        =   0
      Top             =   240
      Width           =   2415
   End
   Begin VB.Label Label4 
      Caption         =   "Bottom"
      Height          =   255
      Left            =   120
      TabIndex        =   11
      Top             =   4080
      Width           =   495
   End
   Begin VB.Label Label3 
      Caption         =   "Right"
      Height          =   255
      Left            =   120
      TabIndex        =   10
      Top             =   3720
      Width           =   375
   End
   Begin VB.Label Label2 
      Caption         =   "Top"
      Height          =   255
      Left            =   120
      TabIndex        =   6
      Top             =   3360
      Width           =   375
   End
   Begin VB.Label Label1 
      Caption         =   "Left"
      Height          =   255
      Left            =   120
      TabIndex        =   5
      Top             =   3000
      Width           =   375
   End
End
Attribute VB_Name = "frmBitmap"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim rectX1 As Integer, rectY1 As Integer
Dim rectX2 As Integer, rectY2 As Integer
Dim MarkerX1 As Integer, MarkerY1 As Integer
Dim MarkerX2 As Integer, MarkerY2 As Integer
Dim dragX As Integer, dragY As Integer
Dim LoadedImage As String
Dim UsedRect As Boolean
Dim bOK As Boolean

Public Function BitmapDialog(UsedImage As String, bRect As Boolean, x1 As Integer, y1 As Integer, x2 As Integer, y2 As Integer) As Boolean
    bOK = False
    rectX1 = x1
    rectY1 = y1
    rectX2 = x2
    rectY2 = y2
    If rectX2 <= rectX1 Then rectX2 = rectX1 + 1
    If rectY2 <= rectY1 Then rectY2 = rectY1 + 1
    If bRect Then chkRect.Value = 1 Else chkRect.Value = 0
On Error GoTo err:
    Files.Path = frmMain.SkinForm.GetBasePath
    Set ImageBMP.Picture = LoadPicture(Files.Path + "\" + UsedImage)
    LoadedImage = UsedImage
    UsedRect = bRect
err:
    If rectY1 > ImageBMP.Height / Screen.TwipsPerPixelY Then rectY2 = rectY2 - rectY1: rectY1 = 0
    If rectX1 > ImageBMP.Width / Screen.TwipsPerPixelY Then rectX2 = rectX2 - rectX1: rectX1 = 0
    RetrieveMarker
    UpdateMarker
    Form_Resize
    Me.Show 1, frmMain
    If LoadedImage <> "" And bOK Then
        UsedImage = LoadedImage
        x1 = rectX1
        y1 = rectY1
        x2 = rectX2
        y2 = rectY2
        bRect = UsedRect
        BitmapDialog = True
    Else
        BitmapDialog = False
    End If
End Function

Private Sub boxBottom_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button And 1 And X <> 0 Then
        RetrieveMarker MarkerX1, MarkerY1, MarkerX2, MarkerY2 + Y
    End If
End Sub

Private Sub boxBottom_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    UpdateMarker
End Sub

Private Sub boxBottomLeft_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    dragX = X
    dragY = Y
End Sub

Private Sub boxBottomLeft_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button And 1 Then
        RetrieveMarker MarkerX1 + X - dragX, MarkerY1, MarkerX2, MarkerY2 + Y - dragY
    End If
End Sub

Private Sub boxBottomLeft_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    UpdateMarker
End Sub

Private Sub boxBottomRight_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    dragX = X
    dragY = Y
End Sub

Private Sub boxBottomRight_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button And 1 Then
        RetrieveMarker MarkerX1, MarkerY1, MarkerX2 + X - dragX, MarkerY2 + Y - dragY
    End If
End Sub

Private Sub boxBottomRight_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    UpdateMarker
End Sub

Private Sub boxLeft_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button And 1 And X <> 0 Then
        RetrieveMarker MarkerX1 + X, MarkerY1, MarkerX2, MarkerY2
    End If
End Sub

Private Sub boxLeft_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    UpdateMarker
End Sub


Private Sub boxMove_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    dragX = X
    dragY = Y
End Sub

Private Sub boxMove_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button And 1 And X <> 0 And Y <> 0 Then
        RetrieveMarker MarkerX1 + X - dragX, MarkerY1 + Y - dragY, MarkerX2 + X - dragX, MarkerY2 + Y - dragY
    End If
End Sub

Private Sub boxMove_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    UpdateMarker
End Sub

Private Sub boxRight_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button And 1 And X <> 0 Then
        RetrieveMarker MarkerX1, MarkerY1, MarkerX2 + X, MarkerY2
    End If
End Sub

Private Sub boxRight_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    UpdateMarker
End Sub

Private Sub boxTop_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button And 1 And X <> 0 Then
        RetrieveMarker MarkerX1, MarkerY1 + Y, MarkerX2, MarkerY2
    End If
End Sub

Private Sub boxTop_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    UpdateMarker
End Sub

Private Sub boxTopLeft_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    dragX = X
    dragY = Y
End Sub

Private Sub boxTopLeft_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button And 1 Then
        RetrieveMarker MarkerX1 + X - dragX, MarkerY1 + Y - dragY, MarkerX2, MarkerY2
    End If
End Sub

Private Sub boxTopLeft_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    UpdateMarker
End Sub


Private Sub boxTopRight_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    dragX = X
    dragY = Y
End Sub

Private Sub boxTopRight_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button And 1 Then
        RetrieveMarker MarkerX1, MarkerY1 + Y - dragY, MarkerX2 + X - dragX, MarkerY2
    End If
End Sub

Private Sub boxTopRight_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    UpdateMarker
End Sub


Private Sub chkRect_Click()
    If chkRect.Value = 1 Then
        UsedRect = True
        RetrieveMarker
    Else
        UsedRect = False
        RetrieveMarker
    End If
    
End Sub

Private Sub cmdBottomDec_Click()
    txtBottom = CStr(Val(txtBottom) - 1)
End Sub

Private Sub cmdBottomInc_Click()
    txtBottom = CStr(Val(txtBottom) + 1)
End Sub

Private Sub cmdLeftDec_Click()
    txtLeft = CStr(Val(txtLeft) - 1)
End Sub

Private Sub cmdLeftInc_Click()
    txtLeft = CStr(Val(txtLeft) + 1)
End Sub

Private Sub cmdOK_Click()
    bOK = True
    Me.Hide
End Sub

Private Sub cmdRightDec_Click()
    txtRight = CStr(Val(txtRight) - 1)
End Sub

Private Sub cmdRightInc_Click()
    txtRight = CStr(Val(txtRight) + 1)
End Sub

Private Sub cmdTopDec_Click()
    txtTop = CStr(Val(txtTop) - 1)
End Sub

Private Sub cmdTopInc_Click()
    txtTop = CStr(Val(txtTop) + 1)
End Sub

Private Sub Command1_Click()
    Hide
End Sub

Private Sub Files_Click()
On Error GoTo err
    LoadedImage = Files.filename
    Set ImageBMP.Picture = LoadPicture(Files.Path + "\" + Files.filename)
'    rectX1 = 0
'    rectY1 = 0
'    rectX2 = ImageBMP.Width / Screen.TwipsPerPixelX
'    rectY2 = ImageBMP.Height / Screen.TwipsPerPixelY
    Form_Resize
err:
End Sub

Private Sub Form_Activate()
    Files.Path = frmMain.SkinForm.GetBasePath
    Files.Refresh
End Sub

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
    If KeyCode = 27 Then Hide
End Sub

Private Sub Form_Resize()
On Error GoTo err
    PictureBox.Width = ScaleWidth - PictureBox.Left - 500
    VScroll.Left = PictureBox.Left + PictureBox.Width + 200
    VScroll.Top = PictureBox.Top
    VScroll.Height = PictureBox.Height
    HScroll.Left = PictureBox.Left
    HScroll.Width = PictureBox.Width
    HScroll.Top = PictureBox.Top + PictureBox.Height + 200
    
    ImageBMP.Left = PictureBox.ScaleWidth / 2 - ImageBMP.Width / 2
    ImageBMP.Top = PictureBox.ScaleHeight / 2 - ImageBMP.Height / 2
    If ImageBMP.Width <= PictureBox.ScaleWidth Then
        HScroll.Enabled = False
        HScroll.Value = 0
    Else
        HScroll.Min = -(PictureBox.ScaleWidth / 2 - ImageBMP.Width / 2)
        HScroll.Max = PictureBox.ScaleWidth / 2 - ImageBMP.Width / 2
        HScroll.LargeChange = PictureBox.Width
        HScroll.SmallChange = PictureBox.Width / 10
        HScroll.Value = 0
        HScroll.Enabled = True
    End If
    If ImageBMP.Height <= PictureBox.ScaleHeight Then
        VScroll.Enabled = False
        VScroll.Value = 0
    Else
        VScroll.Min = -(PictureBox.ScaleHeight / 2 - ImageBMP.Height / 2)
        VScroll.Max = PictureBox.ScaleHeight / 2 - ImageBMP.Height / 2
        VScroll.LargeChange = PictureBox.Height
        VScroll.SmallChange = PictureBox.Height / 10
        VScroll.Value = 0
        VScroll.Enabled = True
    End If
    RetrieveMarker
err:
End Sub

Private Sub HScroll_Change()
    ImageBMP.Left = PictureBox.ScaleWidth / 2 - ImageBMP.Width / 2 + HScroll.Value
    RetrieveMarker
End Sub

Private Sub Text1_Change()

End Sub

Public Sub RetrieveMarker(Optional x1 As Integer = -1000, Optional y1 As Integer = -1000, Optional x2 As Integer = -1000, Optional y2 As Integer = -1000)
On Error GoTo err
       
    If x1 = -1000 Then x1 = rectX1 * Screen.TwipsPerPixelY
    If y1 = -1000 Then y1 = rectY1 * Screen.TwipsPerPixelY
    If x2 = -1000 Then x2 = (rectX2 - 1) * Screen.TwipsPerPixelX
    If y2 = -1000 Then y2 = (rectY2 - 1) * Screen.TwipsPerPixelX
    
    If x1 >= x2 Then x2 = x1 + 1
    If y1 >= y2 Then y2 = y1 + 1
    
    MarkerX1 = x1: MarkerX2 = x2
    MarkerY1 = y1: MarkerY2 = y2
    
    boxTop.Top = y1 + ImageBMP.Top
    boxTop.Height = 1
    boxTop.Left = x1 + ImageBMP.Left
    boxTop.Width = x2 - x1 + 1
    
    boxBottom.Top = y2 + ImageBMP.Top
    boxBottom.Height = 1
    boxBottom.Left = x1 + ImageBMP.Left
    boxBottom.Width = x2 - x1 + 1
    
    boxLeft.Left = x1 + ImageBMP.Left
    boxLeft.Width = 1
    boxLeft.Top = y1 + ImageBMP.Top
    boxLeft.Height = y2 - y1 + 1
    
    boxRight.Left = x2 + ImageBMP.Left
    boxRight.Width = 1
    boxRight.Top = y1 + ImageBMP.Top
    boxRight.Height = y2 - y1 + 1
    
    boxTopLeft.Left = boxTop.Left - (boxTopLeft.Width) / 2 + Screen.TwipsPerPixelX
    boxTopLeft.Top = boxTop.Top - boxTopLeft.Height / 2 + Screen.TwipsPerPixelY
    
    boxTopRight.Left = boxRight.Left - (boxTopRight.Width) / 2 + Screen.TwipsPerPixelX
    boxTopRight.Top = boxTop.Top - boxTopRight.Height / 2 + Screen.TwipsPerPixelY
    
    boxBottomLeft.Left = boxTop.Left - (boxBottomLeft.Width) / 2 + Screen.TwipsPerPixelX
    boxBottomLeft.Top = boxBottom.Top - boxBottomLeft.Height / 2 + Screen.TwipsPerPixelY
    
    boxBottomRight.Left = boxRight.Left - (boxTopLeft.Width) / 2 + Screen.TwipsPerPixelX
    boxBottomRight.Top = boxBottom.Top - boxTopLeft.Height / 2 + Screen.TwipsPerPixelY
    
    boxMove.Left = boxTop.Left + boxTop.Width / 2 - boxMove.Width / 2
    boxMove.Top = boxLeft.Top + boxLeft.Height / 2 - boxMove.Height / 2
        
    boxTop.Visible = UsedRect
    boxLeft.Visible = UsedRect
    boxRight.Visible = UsedRect
    boxBottom.Visible = UsedRect
    
    Dim bCorners As Boolean
    bCorners = UsedRect And rectX2 - rectX1 > 16 And rectY2 - rectY1 > 16
    boxTopLeft.Visible = bCorners
    boxTopRight.Visible = bCorners
    boxBottomLeft.Visible = bCorners
    boxBottomRight.Visible = bCorners
    boxMove.Visible = bCorners
    
err:
End Sub

Public Sub UpdateMarker()
    Dim x1 As Integer, y1 As Integer
    Dim x2 As Integer, y2 As Integer
    rectX1 = (MarkerX1) / Screen.TwipsPerPixelX
    rectY1 = (MarkerY1) / Screen.TwipsPerPixelX
    rectX2 = (MarkerX2) / Screen.TwipsPerPixelX + 1
    rectY2 = (MarkerY2) / Screen.TwipsPerPixelX + 1
    txtLeft = CStr(rectX1)
    txtTop = CStr(rectY1)
    txtRight = CStr(rectX2)
    txtBottom = CStr(rectY2)
End Sub

Private Sub ImageBMP_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    dragX = X
    dragY = Y
End Sub

Private Sub ImageBMP_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If dragX <> X And dragY <> Y Then
        Dim lx As Integer
        Dim ly As Integer
        lx = X
        ly = Y
        If lx < dragX Then t = lx: lx = dragX: dragX = t
        If ly < dragY Then t = ly: ly = dragY: dragY = t
        chkRect.Value = 1
        RetrieveMarker dragX, dragY, lx, ly
        UpdateMarker
    End If
End Sub

Private Sub txtBottom_Change()
    rectY2 = Val(txtBottom)
    RetrieveMarker
End Sub

Private Sub txtLeft_Change()
    rectX1 = Val(txtLeft)
    RetrieveMarker
End Sub

Private Sub txtRight_Change()
    rectX2 = Val(txtRight)
    RetrieveMarker
End Sub

Private Sub txtTop_Change()
    rectY1 = Val(txtTop)
    RetrieveMarker
End Sub

Private Sub VScroll_Change()
    ImageBMP.Top = PictureBox.ScaleHeight / 2 - ImageBMP.Height / 2 + VScroll.Value
    RetrieveMarker
End Sub
