//---------------------------------------------------------------------------
#ifndef JoyDevH
#define JoyDevH
//---------------------------------------------------------------------------
#include <vcl\SysUtils.hpp>
#include <vcl\Controls.hpp>
#include <vcl\Classes.hpp>
#include <vcl\Forms.hpp>
#include <Mmsystem.h>
//---------------------------------------------------------------------------
enum TJoystickNumber {JoystickDev1, JoystickDev2};

typedef void __fastcall (__closure *TJoystickButtonEvent)(TObject* Sender,
								WORD xPos,
                        WORD yPos,
                        int ButtonChanged,
                        bool Button1Pressed,
                        bool Button2Pressed,
                        bool Button3Pressed,
                        bool Button4Pressed);

typedef void __fastcall (__closure *TJoystickMoveEvent)(TObject* Sender,
								WORD xPos,
                        WORD yPos,
                        bool Button1Pressed,
                        bool Button2Pressed,
                        bool Button3Pressed,
                        bool Button4Pressed);

typedef void __fastcall (__closure *TJoystickZMoveEvent)(TObject* Sender,
								WORD zPos,
                        bool Button1Pressed,
                        bool Button2Pressed,
                        bool Button3Pressed,
                        bool Button4Pressed);

class TJoystickDevice : public TComponent
{
private:
	JOYCAPS FJoyCaps;
   UINT FNumberOfJoys;
   bool FJoystick1;
   bool FJoystick2;

   bool FUseEvents;
   UINT FPollIntervall;
   UINT FThreshold;

   HWND FWindowHandle;

   TJoystickNumber FJoyStick;
	AnsiString FJoystickName;

	JOYINFOEX FJoyPos;

	MMRESULT FError;

   TJoystickNumber __fastcall JoystickNumberRead(void);
	void __fastcall JoystickNumberWrite(TJoystickNumber aNumber);

	UINT __fastcall GetPollIntervall(void);
	void __fastcall SetPollIntervall(UINT NewIntervall);
	UINT __fastcall GetThreshold(void);
	void __fastcall SetThreshold(UINT NewIntervall);
	void __fastcall SetUseEvents(bool Use);

   void __fastcall Capture(void);
	void __fastcall SetThreshold(void);

	void __fastcall GetCaps(void);
	void __fastcall WndProc(Messages::TMessage &Message);

   TJoystickButtonEvent FOnButtonDown;
   TJoystickButtonEvent FOnButtonUp;
   TJoystickMoveEvent   FOnMove;
	TJoystickZMoveEvent	FOnZMove;

protected:
public:
	__fastcall TJoystickDevice(TComponent* Owner);
	virtual __fastcall ~TJoystickDevice();

   const JOYINFOEX* __fastcall JoyInfo(DWORD dwFlags = JOY_RETURNALL);

	__property MMRESULT Error = {read=FError};

__published:
	__property TJoystickNumber Joystick = {read=JoystickNumberRead, write=JoystickNumberWrite};
	__property AnsiString DriverName = {read=FJoystickName, write=FJoystickName, nodefault};
	__property bool UseEvents = {read=FUseEvents, write=SetUseEvents, default=false};
	__property UINT PollIntervall = {read=GetPollIntervall, write=SetPollIntervall};
	__property UINT Threshold = {read=GetThreshold, write=SetThreshold};

   __property TJoystickButtonEvent OnButtonDown = {read=FOnButtonDown, write=FOnButtonDown};
   __property TJoystickButtonEvent OnButtonUp   = {read=FOnButtonUp, write=FOnButtonUp};
   __property TJoystickMoveEvent   OnMove       = {read=FOnMove, write=FOnMove};
   __property TJoystickZMoveEvent  OnZMove      = {read=FOnZMove, write=FOnZMove};
 };
//---------------------------------------------------------------------------
#endif
