//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "JoyDev.h"

//---------------------------------------------------------------------------
static inline TJoystickDevice *ValidCtrCheck()
{
	return new TJoystickDevice(NULL);
}
//---------------------------------------------------------------------------
__fastcall TJoystickDevice::TJoystickDevice(TComponent* Owner)
	: TComponent(Owner)
{
	FNumberOfJoys = joyGetNumDevs();

   JOYINFO Info;

  	FJoyStick = JoystickDev1;

   if(FNumberOfJoys > 0)
   	FError = FJoystick1 = joyGetPos(JOYSTICKID1, &Info) == JOYERR_NOERROR;

   if(FNumberOfJoys > 1)
   	FError = FJoystick2 = joyGetPos(JOYSTICKID2, &Info) == JOYERR_NOERROR;

   GetCaps();

   FWindowHandle = AllocateHWnd(WndProc);
	SetThreshold();
   Capture();
}
//---------------------------------------------------------------------------
__fastcall TJoystickDevice::~TJoystickDevice()
{
  	DeallocateHWnd(FWindowHandle);
	if(FUseEvents == true)
	{
		FUseEvents = false;
	   Capture();
   }
}
//---------------------------------------------------------------------------
void __fastcall TJoystickDevice::WndProc(Messages::TMessage &Message)
{
	if(FUseEvents == false)
		Message.Result = DefWindowProc(FWindowHandle, Message.Msg, Message.WParam, Message.LParam);
	else
   	switch(Message.Msg)
      {
         case MM_JOY1MOVE :                     // changed position
            if(FJoyStick == JoystickDev2)
               break;

         case MM_JOY2MOVE :                     // changed position
            if((FJoyStick == JoystickDev1) && (Message.Msg == MM_JOY2MOVE))
               break;

             if(OnMove)
             {
               WORD xPos = LOWORD(Message.LParam);
               WORD yPos = HIWORD(Message.LParam);
               bool Button1 = Message.WParam & JOY_BUTTON1;
               bool Button2 = Message.WParam & JOY_BUTTON2;
               bool Button3 = Message.WParam & JOY_BUTTON3;
               bool Button4 = Message.WParam & JOY_BUTTON4;

               try
               {
                  OnMove(this, xPos, yPos, Button1, Button2, Button3, Button4);
					}
               catch(...)
               {
                  Application->HandleException(this);
               }
             }
             break;

         case MM_JOY1BUTTONDOWN :               // button is down
            if(FJoyStick == JoystickDev2)
               break;

         case MM_JOY2BUTTONDOWN :               // button is down
            if((FJoyStick == JoystickDev1) && (Message.Msg == MM_JOY2BUTTONDOWN))
               break;

             if(OnButtonDown)
             {
               WORD xPos = LOWORD(Message.LParam);
               WORD yPos = HIWORD(Message.LParam);

               int ButtonChanged = 0;

               if(Message.WParam & JOY_BUTTON1CHG)
                  ButtonChanged = 1;
               else
               if(Message.WParam & JOY_BUTTON2CHG)
                  ButtonChanged = 2;
               else
               if(Message.WParam & JOY_BUTTON3CHG)
                  ButtonChanged = 3;
               else
               if(Message.WParam & JOY_BUTTON4CHG)
                  ButtonChanged = 4;

               bool Button1 = Message.WParam & JOY_BUTTON1;
               bool Button2 = Message.WParam & JOY_BUTTON2;
               bool Button3 = Message.WParam & JOY_BUTTON3;
               bool Button4 = Message.WParam & JOY_BUTTON4;

               try
					{
                  OnButtonDown(this, xPos, yPos, ButtonChanged, Button1, Button2, Button3, Button4);
               }

               catch(...)
               {
                  Application->HandleException(this);
               }
             }
             break;

         case MM_JOY1BUTTONUP :               // button is down
            if(FJoyStick == JoystickDev2)
               break;

         case MM_JOY2BUTTONUP :               // button is down
            if((FJoyStick == JoystickDev1) && (Message.Msg == MM_JOY2BUTTONDOWN))
               break;

             if(OnButtonUp)
             {
               WORD xPos = LOWORD(Message.LParam);
               WORD yPos = HIWORD(Message.LParam);

               int ButtonChanged = 0;

               if(Message.WParam & JOY_BUTTON1CHG)
                  ButtonChanged = 1;
               else
               if(Message.WParam & JOY_BUTTON2CHG)
                  ButtonChanged = 2;
               else
               if(Message.WParam & JOY_BUTTON3CHG)
                  ButtonChanged = 3;
               else
               if(Message.WParam & JOY_BUTTON4CHG)
                  ButtonChanged = 4;

               bool Button1 = Message.WParam & JOY_BUTTON1;
               bool Button2 = Message.WParam & JOY_BUTTON2;
               bool Button3 = Message.WParam & JOY_BUTTON3;
               bool Button4 = Message.WParam & JOY_BUTTON4;

               try
               {
                  OnButtonUp(this, xPos, yPos, ButtonChanged, Button1, Button2, Button3, Button4);
               }

               catch(...)
               {
                  Application->HandleException(this);
               }
             }
             break;

         case MM_JOY1ZMOVE :               // button is down
            if(FJoyStick == JoystickDev2)
               break;

         case MM_JOY2ZMOVE :               // button is down
            if((FJoyStick == JoystickDev1) && (Message.Msg == MM_JOY2ZMOVE))
               break;

             if(OnZMove)
             {
               WORD zPos = LOWORD(Message.LParam);

               bool Button1 = Message.WParam & JOY_BUTTON1;
               bool Button2 = Message.WParam & JOY_BUTTON2;
               bool Button3 = Message.WParam & JOY_BUTTON3;
               bool Button4 = Message.WParam & JOY_BUTTON4;

               try
               {
                  OnZMove(this, zPos, Button1, Button2, Button3, Button4);
               }

               catch(...)
               {
                  Application->HandleException(this);
               }
             }
             break;

         default:
            Message.Result = DefWindowProc(FWindowHandle, Message.Msg, Message.WParam, Message.LParam);
	   }
}
//---------------------------------------------------------------------------
TJoystickNumber __fastcall TJoystickDevice::JoystickNumberRead(void)
{
	return FJoyStick;
}
//---------------------------------------------------------------------------
void __fastcall TJoystickDevice::JoystickNumberWrite(TJoystickNumber aNumber)
{
//	if((aNumber == JoystickDev1) && (FJoystick1 == true))
   	FJoyStick = aNumber;
//	else
//	if((aNumber == JoystickDev2) && (FJoystick2 == true))
//   	FJoyStick = aNumber;

   GetCaps();
}
//---------------------------------------------------------------------------
void __fastcall TJoystickDevice::GetCaps(void)
{
	memset(&FJoyCaps, 0, sizeof(JOYCAPS));

	if(FJoyStick == JoystickDev1)
		FError = joyGetDevCaps(JOYSTICKID1, &FJoyCaps, sizeof(JOYCAPS));
   else
	if(FJoyStick == JoystickDev2)
		FError = joyGetDevCaps(JOYSTICKID2, &FJoyCaps, sizeof(JOYCAPS));

	if(FError == JOYERR_NOERROR)
   	FJoystickName = FJoyCaps.szPname;
   else
	if(FJoyStick == JoystickDev1)
   	FJoystickName = "Joystick1 not available";
   else
   	FJoystickName = "Joystick2 not available";
}
//---------------------------------------------------------------------------
const JOYINFOEX* __fastcall TJoystickDevice::JoyInfo(DWORD dwFlags)
{
	FJoyPos.dwFlags = dwFlags;
   FJoyPos.dwSize = sizeof(JOYINFOEX);

	if(FJoyStick == JoystickDev1)
		FError = joyGetPosEx(JOYSTICKID1, &FJoyPos);
   else
		FError = joyGetPosEx(JOYSTICKID2, &FJoyPos);

	if(FError != JOYERR_NOERROR)
	{
		if(FJoyStick == JoystickDev1)
   		FJoystickName = "Joystick1 not available";
	   else
   		FJoystickName = "Joystick2 not available";
   }

   return &FJoyPos;
}
//---------------------------------------------------------------------------
UINT __fastcall TJoystickDevice::GetPollIntervall(void)
{
	return FPollIntervall;
}
//---------------------------------------------------------------------------
void __fastcall TJoystickDevice::SetPollIntervall(UINT NewIntervall)
{
	if(NewIntervall != 0)
   {
	   if(NewIntervall > FJoyCaps.wPeriodMax)
   		NewIntervall = FJoyCaps.wPeriodMax;

	   if(NewIntervall < FJoyCaps.wPeriodMin)
   		NewIntervall = FJoyCaps.wPeriodMin;
   }
   FPollIntervall = NewIntervall;
	if(FPollIntervall > 0)
	{
   	FThreshold = 0;
	   SetThreshold();
   }
   
   Capture();
}
//---------------------------------------------------------------------------
UINT __fastcall TJoystickDevice::GetThreshold(void)
{
	return FThreshold;
}
//---------------------------------------------------------------------------
void __fastcall TJoystickDevice::SetThreshold(UINT NewThreshold)
{
	FThreshold = NewThreshold;

	if(FThreshold > 0)
	{
		FPollIntervall = 0;
	   Capture();
   }

   SetThreshold();
}
//---------------------------------------------------------------------------
void __fastcall TJoystickDevice::SetUseEvents(bool Use)
{
	FUseEvents = Use;
   Capture();
}
//---------------------------------------------------------------------------
void __fastcall TJoystickDevice::SetThreshold(void)
{
	UINT uJoyID = FJoyStick == JoystickDev1 ? JOYSTICKID1 : JOYSTICKID2;
	FError = joySetThreshold(uJoyID, FThreshold);
}
//---------------------------------------------------------------------------
void __fastcall TJoystickDevice::Capture(void)
{
	UINT uJoyID = FJoyStick == JoystickDev1 ? JOYSTICKID1 : JOYSTICKID2;

	FError = joyReleaseCapture(uJoyID);

	if(FUseEvents)
   {
		FError = joySetCapture(FWindowHandle,
   								 uJoyID,
						    		 FPollIntervall,
         	                FPollIntervall == 0);
	}
}
//---------------------------------------------------------------------------
namespace Joydev
{
	void __fastcall Register()
	{
		TComponentClass classes[1] = {__classid(TJoystickDevice)};
		RegisterComponents("Climax", classes, 0);
	}
}
//---------------------------------------------------------------------------
