

class CMyString
{
public:
	void Init( void )
	{
		m_nBufferSize = 0;
		m_pchData = NULL;
	}

public:
	CMyString()
	{
		Init();
	}
	// copy constructor
	//CMyString(const CMyString& stringSrc);
	// from a single character
	//CMyString(TCHAR ch, int nRepeat = 1);
	// from an ANSI string (converts to TCHAR)

	CMyString(LPCSTR lpsz)
	{
		Init();
		if( lpsz )
		{
			int nLen = strlen( lpsz );
			m_pchData = new char[nLen + 1];
			strcpy( m_pchData, lpsz );
			m_nBufferSize = nLen + 1;
		}
		else
		{
			m_pchData = new char[1];
			m_pchData[0] = NULL;
			m_nBufferSize = 1;
		}
	}

	void FreeBuffer( void )
	{
		if( m_pchData )
		{
			delete [] m_pchData;
			m_pchData = NULL;			
		}

		m_nBufferSize = 0;
	}
	
	// get data length
	int Length() const
	{
		if( !m_pchData )
			return 0;
		else
			return strlen( m_pchData );
	}

	// TRUE if zero length
	BOOL IsEmpty() const;
	// clear contents to empty
	void Empty();

	
	// ref-counted copy from another CString
	const CMyString& operator=(const CMyString& stringSrc);
	

	// copy string content from ANSI string (converts to TCHAR)
	const CMyString& operator=(LPCSTR lpsz)
	{
		FreeBuffer();
		
		int nLen = strlen( lpsz );
		
		m_pchData = new char[nLen + 1];
		strcpy( m_pchData, lpsz );
		m_nBufferSize = nLen + 1;

		return * this;
	};

	const CMyString& operator+=(LPCTSTR lpsz)
	{
		CMyString str( m_pchData );
		
		int nLen = strlen( lpsz );
		FreeBuffer();

		int nNewSize = nLen + str.Length() + 1;
		m_pchData = new char[ nNewSize ];
		strcpy( m_pchData, str.m_pchData );
		strcat( m_pchData, lpsz );
		m_nBufferSize = nNewSize;

		return * this;
	}




// Implementation
public:
	~CMyString()
	{
		FreeBuffer();
	}

public:
	LPTSTR m_pchData;   
	int m_nBufferSize;
};