// MailSender.h : Declaration of the CMailSender

#ifndef __MAILSENDER_H_
#define __MAILSENDER_H_

#include "resource.h"       // main symbols

#define DISP_ERROR(n) MAKE_HRESULT(1, FACILITY_WINDOWS | FACILITY_DISPATCH, (n) )

#define HANDLE_ERROR	\
			LPVOID lpMsgBuf;	\
			FormatMessage( FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,	\
				NULL, ::GetLastError(), MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),	\
				(LPTSTR) &lpMsgBuf, 0, NULL );	\
												\
			CComBSTR bstrError = (char*)lpMsgBuf;\
			LocalFree( lpMsgBuf );

#define		_ERROR_WINSOCK_INITFAILED	1
#define		_ERROR_GETHOSTBYNAME		2
#define		_ERROR_CREATESOCKETFAILED	3
#define		_ERROR_CONNECTFAILED		4
#define		_ERROR_SENDFAILED			5
#define		_ERROR_FROM_SMTPSERVER		6
#define		_ERROR_OPENFILE				7
#define		_ERROR_NOTENOUGH_MEMORY		8
#define		_ERROR_FILEREAD_FAILED		9
#define		_ERROR_HOST_NONSPECIFIED	10

typedef struct _BUFFER 
				{     
					PBYTE pBuf;
					DWORD cLen; 
				} BUFFER;  


/////////////////////////////////////////////////////////////////////////////
// CMailSender
class ATL_NO_VTABLE CMailSender : 
	public CComObjectRootEx<CComMultiThreadModel>,
	public CComCoClass<CMailSender, &CLSID_MailSender>,
	public ISupportErrorInfo,
	public IDispatchImpl<IMailSender, &IID_IMailSender, &LIBID_ASPEMAILLib>
{
public:
	CMailSender()
	{
		m_bIncludeErrorCode = FALSE;
		m_bHTML = FALSE;
	}

DECLARE_REGISTRY_RESOURCEID(IDR_MAILSENDER)
DECLARE_NOT_AGGREGATABLE(CMailSender)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CMailSender)
	COM_INTERFACE_ENTRY(IMailSender)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()

// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

	HRESULT VerbalError( int nErrorIndex );
	HRESULT VerbalErrorEx( DWORD dwLastError, int nErrorIndex );
	BOOL m_bIncludeErrorCode;

	std::vector<CComBSTR> m_arrTo, m_arrToName, m_arrReplyTo, m_arrReplyToName,
		m_arrFiles, m_arrCC, m_arrCCName, m_arrBCC, m_arrBCCName, m_arrAttachment;

	CComBSTR m_bstrFrom, m_bstrFromName, m_bstrHost, m_bstrBody, m_bstrSubject, m_bstrOrganization;
	int m_nPort;

	BOOL m_bHTML;

	static const int pr2six[];
	static char six2pr[];
	static PBYTE BufferQueryPtr( BUFFER * pB ) { return pB->pBuf; }   
	static BOOL BufferResize( BUFFER *pB, DWORD cNewL );
	static BOOL UUEncode( BYTE * bufin, DWORD nbytes, BUFFER * pbuffEncoded );

	HRESULT ReadAndEncodeFile( CComBSTR Path, CMyString * pRetVal );
	void ExtractFileName( CComBSTR Path, char * pFileName );
	void ExtractContentType( CComBSTR Path, char * pContentType );

// IMailSender
public:
	STDMETHOD(get_IsHTML)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_IsHTML)(/*[in]*/ BOOL newVal);
	STDMETHOD(Reset)();
	STDMETHOD(AddAttachment)(/*[in]*/BSTR Path);
	STDMETHOD(AddBcc)(/*[in]*/BSTR Address, /*[in, optional]*/VARIANT Name);
	STDMETHOD(AddCC)(/*[in]*/BSTR Address, /*[in, optional]*/VARIANT Name);
	STDMETHOD(AddReplyTo)(/*[in]*/BSTR Address, /*[in, optional]*/VARIANT Name);
	STDMETHOD(AddAddress)(/*[in]*/BSTR Address, /*[in, optional]*/VARIANT Name);
	STDMETHOD(get_Subject)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Subject)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_Body)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Body)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_FromName)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_FromName)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_From)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_From)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_Port)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Port)(/*[in]*/ long newVal);
	STDMETHOD(get_Host)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Host)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_IncludeErrorCode)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_IncludeErrorCode)(/*[in]*/ BOOL newVal);
	STDMETHOD(Send)(/* [out, retval] */VARIANT_BOOL * pVal);
};

#endif //__MAILSENDER_H_
