// MailSender.cpp : Implementation of CMailSender
#include "stdafx.h"
#include "AspEmail.h"
#include "MyString.h"
#include "MailSender.h"

// UUEncode arrays
const int CMailSender::pr2six[256]={ 
    64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64, 
    64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,62,64,64,64,63, 
    52,53,54,55,56,57,58,59,60,61,64,64,64,64,64,64,64,0,1,2,3,4,5,6,7,8,9, 
    10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,64,64,64,64,64,64,26,27, 
    28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51, 
    64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64, 
    64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64, 
    64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64, 
    64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64, 
    64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64, 
    64,64,64,64,64,64,64,64,64,64,64,64,64 };  
	
char CMailSender::six2pr[64] = { 
    'A','B','C','D','E','F','G','H','I','J','K','L','M', 
    'N','O','P','Q','R','S','T','U','V','W','X','Y','Z', 
    'a','b','c','d','e','f','g','h','i','j','k','l','m', 
    'n','o','p','q','r','s','t','u','v','w','x','y','z', 
    '0','1','2','3','4','5','6','7','8','9','+','/' }; 

/* Static */
BOOL CMailSender::BufferResize( BUFFER *pB, DWORD cNewL ) 
{     
	PBYTE pN; 
    if ( cNewL > pB->cLen )     
	{
		pN = (unsigned char *)malloc( cNewL ); 
        if ( pB->pBuf )         
		{
			memcpy( pN, pB->pBuf, pB->cLen ); 
            free( pB->pBuf );
		}         
		pB->pBuf = pN; 
        pB->cLen = cNewL;     
	}      
	return TRUE; 
}
 
/* Static */
BOOL CMailSender::UUEncode( BYTE * bufin, DWORD nbytes, BUFFER * pbuffEncoded ) 
{ 
   unsigned char *outptr; 
   unsigned int i; 
 
   //  Resize the buffer to 133% of the incoming data    
   if ( !BufferResize( pbuffEncoded, nbytes + ((nbytes + 3) / 3) + 4)) 
        return FALSE; 
 
   outptr = (unsigned char *) BufferQueryPtr(pbuffEncoded); 
 
   for (i=0; i<nbytes; i += 3) 
   { 
      *(outptr++) = six2pr[*bufin >> 2];            /* c1 */ 
      *(outptr++) = six2pr[((*bufin << 4) & 060) | ((bufin[1] >> 4) & 017)]; /*c2*/ 
      *(outptr++) = six2pr[((bufin[1] << 2) & 074) | ((bufin[2] >> 6) & 03)];/*c3*/ 
      *(outptr++) = six2pr[bufin[2] & 077];         /* c4 */ 
 
      bufin += 3; 
   } 
 
   /* If nbytes was not a multiple of 3, then we have encoded too 
    * many characters.  Adjust appropriately. 
    */ 
	if(i == nbytes+1) 
	{ 
	  /* There were only 2 bytes in that last group */ 
	  outptr[-1] = '='; 
	} 
	else 
	if(i == nbytes+2) 
	{ 
		/* There was only 1 byte in that last group */ 
		outptr[-1] = '='; 
		outptr[-2] = '='; 
	} 
 
   *outptr = '\0'; 
 
   return TRUE; 
}

HRESULT CMailSender::ReadAndEncodeFile( CComBSTR Path, CMyString * pRetVal )
{		
	USES_CONVERSION;
	
	HANDLE hFile = ::CreateFile( OLE2T(Path), GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL );
	if( hFile == INVALID_HANDLE_VALUE )
	{			
		HANDLE_ERROR;
		return Error( bstrError, GetObjectCLSID(), DISP_ERROR(_ERROR_OPENFILE) );
	}

	long nSize = ::GetFileSize( hFile, NULL );
	ULONG nBytesRead;
	
	BYTE * buf = new BYTE[nSize + 10];

	if( !buf )
		return Error( "Creating memory buffer failed. Not enough memory.", GetObjectCLSID(), DISP_ERROR(_ERROR_NOTENOUGH_MEMORY) );
	
	if( !::ReadFile( hFile, buf, nSize, &nBytesRead, NULL ) )
	{
		HANDLE_ERROR;
		::CloseHandle( hFile );
		return Error( bstrError, GetObjectCLSID(), DISP_ERROR(_ERROR_FILEREAD_FAILED) );
	}

	::CloseHandle( hFile );
	
	BUFFER resbuf;
	resbuf.pBuf = NULL;
	resbuf.cLen = 0;

	UUEncode( buf, nSize, &resbuf );

	char * szBuf76 = new char[resbuf.cLen + resbuf.cLen / 38 + 200];
		
	if( !szBuf76 )
	{
		delete [] buf;
		return Error( "Creating memory buffer 2 failed. Not enough memory.", GetObjectCLSID(), DISP_ERROR(_ERROR_NOTENOUGH_MEMORY) );
	}

	szBuf76[0] = 0;
	
	// Cut the string into pieces of 76 characters
	int nCount = 0, nBufCount = 0;
	int nLen = resbuf.cLen;
	while( nCount + 76 <= nLen )
	{
		lstrcpyn( szBuf76 + nBufCount, (const char *)resbuf.pBuf + nCount, 77 );	// incl. term. 0
		nBufCount += 76;
		lstrcpyn( szBuf76 + nBufCount, "\r\n", 3 );
		nBufCount += 2;
		nCount += 76;
	}

	if( nLen > nCount )
	{
		lstrcat( szBuf76, (const char *)resbuf.pBuf + nCount );	// incl. term. 0
		lstrcat( szBuf76, "\r\n" );
	}

	CMyString res( szBuf76);

	* pRetVal = res.m_pchData;

	delete [] szBuf76;
	free( resbuf.pBuf ); 
	delete [] buf;

	return S_OK;
}


/////////////////////////////////////////////////////////////////////////////
// CMailSender

STDMETHODIMP CMailSender::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_IMailSender
	};
	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}



HRESULT CMailSender::VerbalErrorEx( DWORD dwLastError, int nErrorIndex )
{
	HMODULE hModule = NULL;
	CComBSTR bstrError;
	CComBSTR bstrExtendedError;
	
	DWORD dwFormatFlags = FORMAT_MESSAGE_ALLOCATE_BUFFER |
        FORMAT_MESSAGE_IGNORE_INSERTS |
        FORMAT_MESSAGE_FROM_SYSTEM;

	if(dwLastError >= WSABASEERR )//&& dwLastError <= MAX_NERR) 
	{
		switch( dwLastError )
		{
		case WSAHOST_NOT_FOUND:
			bstrError = "Host not found.";
			break;

		case WSAENETUNREACH:
			bstrError = "Network is unreachable.";
			break;

		default:
			char szErr[256];
			sprintf( szErr, "Winsock error %d (0x%X) occurred.", dwLastError, dwLastError );
			bstrError = szErr;
			break;
		}
	}
	else
	{	
		LPVOID lpMsgBuf;
		FormatMessage( dwFormatFlags, hModule, dwLastError, MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), (LPTSTR) &lpMsgBuf, 0, NULL );

		bstrError = (char*)lpMsgBuf;
		LocalFree( lpMsgBuf );

		if(hModule != NULL)
			FreeLibrary(hModule);

		// Handle Extended error messages
		char szErrCode[20];
		sprintf( szErrCode, "%04X ", dwLastError );
		bstrExtendedError = szErrCode;
		bstrExtendedError += bstrError;
	}
	
	return Error( m_bIncludeErrorCode ? bstrExtendedError : bstrError, GetObjectCLSID(), DISP_ERROR( nErrorIndex ) );
}


STDMETHODIMP CMailSender::Send( VARIANT_BOOL * pVal )
{
	int m_nPort = 25;

	USES_CONVERSION;

	* pVal = VARIANT_FALSE;

	if( m_bstrHost.Length() == 0 )
	{
		return Error( "Host not specified.", GetObjectCLSID(), DISP_ERROR( _ERROR_HOST_NONSPECIFIED ) );
	}

	WORD wVersionRequested;
	WSADATA wsaData;
	int err; 
	wVersionRequested = MAKEWORD( 1, 1 );

	err = WSAStartup( wVersionRequested, &wsaData );
	if( err != 0 )
	{
		return Error( "Winsock initialization failed.", GetObjectCLSID(), DISP_ERROR( _ERROR_WINSOCK_INITFAILED ) );
	}


	sockaddr_in name;

	unsigned long addr = inet_addr( OLE2T( m_bstrHost ) );
    if (addr != INADDR_NONE) 
	{
        // It was a dotted quad number, so save result
        name.sin_addr.s_addr = addr;        
		name.sin_family = AF_INET;    
	}
    else 
	{
		HOSTENT * pHostEnt = gethostbyname( OLE2T( m_bstrHost ) );
		if( !pHostEnt )
		{
			err = ::WSAGetLastError();
			WSACleanup( );
			return VerbalErrorEx( err, _ERROR_GETHOSTBYNAME );
		}
		
		name.sin_family		= pHostEnt->h_addrtype;
		name.sin_addr.s_addr= *((u_long*)pHostEnt->h_addr_list[0]);
		//memcpy( &name.sin_addr, pHostEnt->h_addr, pHostEnt->h_length);
	}

	name.sin_port = htons(m_nPort);

	SOCKET hSocket = socket (AF_INET, SOCK_STREAM, 0);
	if (hSocket == INVALID_SOCKET) 
	{
		WSACleanup( );
		return VerbalErrorEx( err, _ERROR_CREATESOCKETFAILED );
	}

	// Connect
	if( connect( hSocket, (sockaddr *)&name, sizeof(name) ) == SOCKET_ERROR )
	{
		err = ::WSAGetLastError();
		WSACleanup( );
		return VerbalErrorEx( err, _ERROR_CONNECTFAILED );
	}

	// Send
	char szBuffer[512];
	int numRead = recv( hSocket, szBuffer, 500, 0 );

	CMyString s[400];
	int n = 0;

	int nSize = m_arrTo.size();
	int nCCSize = m_arrCC.size();
	int nBccSize = m_arrBCC.size();

	s[n++] = "HELO AspEmail\r\n";

	sprintf( szBuffer, "MAIL FROM: <%s>\r\n", OLE2T(m_bstrFrom) );
	s[n++] = szBuffer;
	
	// Add recipients
	std::vector<CComBSTR>::iterator it, it2;
	for( it = m_arrTo.begin(); it != m_arrTo.end(); it++ )
	{
		sprintf( szBuffer, "RCPT TO: <%s>\r\n", OLE2T(*it) );
		s[n++] = szBuffer;
	}

	for( it = m_arrCC.begin(); it != m_arrCC.end(); it++ )
	{
		sprintf( szBuffer, "RCPT TO: <%s>\r\n", OLE2T(*it) );
		s[n++] = szBuffer;
	}

	for( it = m_arrBCC.begin(); it != m_arrBCC.end(); it++ )
	{
		sprintf( szBuffer, "RCPT TO: <%s>\r\n", OLE2T(*it) );
		s[n++] = szBuffer;
	}

	s[n++] = "DATA\r\n";

	if( m_bstrFromName.Length() > 0 )
		sprintf( szBuffer, "FROM: \"%s\" <%s>\r\n", OLE2T( m_bstrFromName ), OLE2T( m_bstrFrom ) );
	else
		sprintf( szBuffer, "FROM: <%s>\r\n", OLE2T( m_bstrFrom ) );
	s[n++] = szBuffer;

	if( m_bstrOrganization.Length() > 0 )
	{
		sprintf( szBuffer, "ORGANIZATION: %s\r\n", OLE2T( m_bstrOrganization ) );
		s[n++] = szBuffer;
	}

	// Build the TO: list
	// Build the "TO:" list
	if( m_arrToName.size() > 0 )
	{
		CMyString strTo;
		for( it = m_arrToName.begin(), it2 = m_arrTo.begin(); it != m_arrToName.end(); it++, it2++ )
		{
			if( strTo.Length() > 0 )
				strTo += ",";

			if( it->Length() == 0 )
				sprintf( szBuffer, "%s", OLE2T( *it2 ) );
			else
				sprintf( szBuffer, "\"%s\" <%s>", OLE2T( *it ), OLE2T( *it2 ) );
			strTo += szBuffer;
		}

		s[n] = "TO: ";
		s[n] += strTo.m_pchData;
		s[n++] += "\r\n";
	}

	// Build CC List
	if( m_arrCCName.size() > 0 )
	{
		CMyString strTo;
		for( it = m_arrCCName.begin(), it2 = m_arrCC.begin(); it != m_arrCCName.end(); it++, it2++ )
		{
			if( strTo.Length() > 0 )
				strTo += ",";

			if( it->Length() == 0 )
				sprintf( szBuffer, "%s", OLE2T( *it2 ) );
			else
				sprintf( szBuffer, "\"%s\" <%s>", OLE2T( *it ), OLE2T( *it2 ) );
			strTo += szBuffer;
		}

		s[n] = "CC: ";
		s[n] += strTo.m_pchData;
		s[n++] += "\r\n";
	}

	// Build Reply-to List
	if( m_arrReplyToName.size() > 0 )
	{
		CMyString strTo;
		for( it = m_arrReplyToName.begin(), it2 = m_arrReplyTo.begin(); it != m_arrReplyToName.end(); it++, it2++ )
		{
			if( strTo.Length() > 0 )
				strTo += ",";

			if( it->Length() == 0 )
				sprintf( szBuffer, "%s", OLE2T( *it2 ) );
			else
				sprintf( szBuffer, "\"%s\" <%s>", OLE2T( *it ), OLE2T( *it2 ) );
			strTo += szBuffer;
		}

		s[n] = "REPLY-TO: ";
		s[n] += strTo.m_pchData;
		s[n++] += "\r\n";
	}

	sprintf( szBuffer, "SUBJECT: %s\r\n", OLE2T( m_bstrSubject ) );
	s[n++] = szBuffer;

	// DATE/TIME
	char szTimeZone[40];
	_tzset();
	BOOL bNegative = FALSE;
	int zone = _timezone;
	if( zone < 0 )
	{
		bNegative = TRUE;
		zone = -zone;
	}

	sprintf( szTimeZone, " %c%02d00\r\n", bNegative ? '+' : '-', zone / 3600 );
	
	time_t ltime;    
	struct tm *today;
	time( &ltime );
	today = localtime( &ltime );

	strftime( szBuffer, 128, "DATE: %a, %d %b %Y %H:%M:%S", today );

	s[n] = szBuffer;
	s[n++] += szTimeZone;


	if( m_arrAttachment.size() > 0 || m_bHTML )
	{
		// Generate separator
		GUID g;
		CoCreateGuid( &g );
		char szBoundary[200];
		sprintf( szBoundary, "%04X_%04X_%04X_%04X_%02X%02X_%02X%02X_%02X%02X_%02X%02X", HIWORD(g.Data1), LOWORD(g.Data1), g.Data2, g.Data3, g.Data4[0], g.Data4[1], g.Data4[2], g.Data4[3], g.Data4[4], g.Data4[5], g.Data4[6], g.Data4[7] );

		s[n++] = "MIME-Version: 1.0\r\n";

		sprintf( szBuffer, "Content-Type: multipart/mixed;boundary=\"%s\"\r\n\r\n", szBoundary );
		s[n++] = szBuffer;

		
		s[n++] = "This is a multi-part message in MIME format.\r\n\r\n";

		// Body in the MIME format
		sprintf( szBuffer, "--%s\r\n", szBoundary );
		s[n++] = szBuffer;
		
		
		s[n++] = m_bHTML ? "Content-Type: text/html; charset=ISO-8859-1\r\n"
			: "Content-Type: text/plain; charset=ISO-8859-1\r\n";
		s[n++] = "Content-Transfer-Encoding: 7bit\r\n\r\n";
		
		char * pBody = OLE2T(m_bstrBody);
		s[n] = pBody;
		s[n++] += "\r\n\r\n";

		for( it = m_arrAttachment.begin(); it != m_arrAttachment.end(); it++ )
		{
			sprintf( szBuffer, "--%s\r\n", szBoundary );
			s[n++] = szBuffer;

			char szContentType[200], szFileName[200];
			ExtractContentType( *it, szContentType );
			ExtractFileName( *it, szFileName );
			
			sprintf( szBuffer, "Content-Type: %s;name=\"%s\"\r\n", szContentType, szFileName );
			s[n++] = szBuffer;

						
			s[n++] = "Content-Transfer-Encoding: base64\r\n";
			
			sprintf( szBuffer, "Content-Disposition: attachment;filename=\"%s\"\r\n\r\n", szFileName );
			s[n++] = szBuffer;

			HRESULT hr = ReadAndEncodeFile( *it, &s[n] );
			if( FAILED( hr ) )
				return hr;			
			s[n++] += "\r\n\r\n";
		}

		sprintf( szBuffer, "--%s--\r\n.\r\n", szBoundary );
		s[n++] = szBuffer;
	}
	else
	{
		s[n++] = "\r\n";
		char * pBody = OLE2T(m_bstrBody);
		s[n] = pBody;
		s[n++] += "\r\n.\r\n";
	}

	s[n++] = "QUIT\r\n";

	int nQuitLine = n - 1;

	// Start sendind info
	for( int i = 0; i < n; i++ )
	{		
		err = send( hSocket, s[i].m_pchData, s[i].Length(), 0 );

		if( err == SOCKET_ERROR  )
		{
			return VerbalErrorEx( err, _ERROR_SENDFAILED );
		}
		
		if( i < 3 + nSize + nCCSize + nBccSize || i == nQuitLine - 1 || i == nQuitLine  )
		{			
			int nRes = recv( hSocket, szBuffer, 500, 0 );
			if( nRes > 0 )
				szBuffer[nRes] = '\0';

			// Error handling
			if( szBuffer[0] == '5' )
				return Error( szBuffer, GetObjectCLSID(), DISP_ERROR(_ERROR_FROM_SMTPSERVER) );

		}
	}
	
	WSACleanup();

	* pVal = VARIANT_TRUE;

	return S_OK;
}

void CMailSender::ExtractContentType( CComBSTR Path, char * pContentType )
{
	char ext[_MAX_EXT];

	USES_CONVERSION;

	_splitpath( OLE2T(Path), NULL, NULL, NULL, ext );
	if( *ext )
	{
		UCHAR szVal[250];
		ULONG nSize = 240;
		ULONG nType = REG_SZ;
		HKEY hKey;

		::RegOpenKey( HKEY_CLASSES_ROOT, ext, &hKey );
		LONG res = ::RegQueryValueEx( hKey, "Content Type", NULL, &nType, szVal, &nSize );
		::RegCloseKey( hKey );

		if( res != ERROR_SUCCESS )
			strcpy( pContentType,  "application/octet-stream" );
		else
			strcpy( pContentType,  (char *)szVal );
	}
	else
		strcpy( pContentType, "application/octet-stream" );
}

void CMailSender::ExtractFileName( CComBSTR Path, char * pFileName )
{
	USES_CONVERSION;

	char fname[_MAX_FNAME];   
	char ext[_MAX_EXT];
   
	_splitpath( OLE2T(Path), NULL, NULL, fname, ext );

	strcpy( pFileName, fname );
	strcat( pFileName, ext );
}

STDMETHODIMP CMailSender::get_IncludeErrorCode(BOOL *pVal)
{
	* pVal = m_bIncludeErrorCode;
	return S_OK;
}

STDMETHODIMP CMailSender::put_IncludeErrorCode(BOOL newVal)
{
	m_bIncludeErrorCode = newVal;
	return S_OK;
}

STDMETHODIMP CMailSender::get_Host(BSTR *pVal)
{
	* pVal = m_bstrHost.Copy();
	return S_OK;
}

STDMETHODIMP CMailSender::put_Host(BSTR newVal)
{
	m_bstrHost = newVal;
	return S_OK;
}

STDMETHODIMP CMailSender::get_Port(long *pVal)
{
	* pVal = m_nPort;
	return S_OK;
}

STDMETHODIMP CMailSender::put_Port(long newVal)
{
	m_nPort = newVal;
	return S_OK;
}

STDMETHODIMP CMailSender::get_From(BSTR *pVal)
{
	* pVal = m_bstrFrom.Copy();
	return S_OK;
}

STDMETHODIMP CMailSender::put_From(BSTR newVal)
{
	m_bstrFrom = newVal;
	return S_OK;
}

STDMETHODIMP CMailSender::get_FromName(BSTR *pVal)
{
	* pVal = m_bstrFromName.Copy();
	return S_OK;
}

STDMETHODIMP CMailSender::put_FromName(BSTR newVal)
{
	m_bstrFromName = newVal;
	return S_OK;
}

STDMETHODIMP CMailSender::get_Body(BSTR *pVal)
{
	* pVal = m_bstrBody.Copy();
	return S_OK;
}

STDMETHODIMP CMailSender::put_Body(BSTR newVal)
{
	m_bstrBody = newVal;
	return S_OK;
}

STDMETHODIMP CMailSender::get_Subject(BSTR *pVal)
{
	* pVal = m_bstrSubject.Copy();
	return S_OK;
}

STDMETHODIMP CMailSender::put_Subject(BSTR newVal)
{
	m_bstrSubject = newVal;
	return S_OK;
}

STDMETHODIMP CMailSender::AddAddress(BSTR Address, VARIANT Name)
{
	m_arrTo.push_back( Address );
	if( Name.vt != VT_ERROR )
	{
		CComVariant var( Name );
		var.ChangeType( VT_BSTR, NULL );
		m_arrToName.push_back( var.bstrVal );
	}
	else
		m_arrToName.push_back( L"" );

	return S_OK;
}

STDMETHODIMP CMailSender::AddReplyTo(BSTR Address, VARIANT Name)
{
	m_arrReplyTo.push_back( Address );
	if( Name.vt != VT_ERROR )
	{
		CComVariant var( Name );
		var.ChangeType( VT_BSTR, NULL );
		m_arrReplyToName.push_back( var.bstrVal );
	}
	else
		m_arrReplyToName.push_back( L"" );

	return S_OK;
}

STDMETHODIMP CMailSender::AddCC(BSTR Address, VARIANT Name)
{
	m_arrCC.push_back( Address );
	if( Name.vt != VT_ERROR )
	{
		CComVariant var( Name );
		var.ChangeType( VT_BSTR, NULL );
		m_arrCCName.push_back( var.bstrVal );
	}
	else
		m_arrCCName.push_back( L"" );

	return S_OK;
}

STDMETHODIMP CMailSender::AddBcc(BSTR Address, VARIANT Name)
{
	m_arrBCC.push_back( Address );
	if( Name.vt != VT_ERROR )
	{
		CComVariant var( Name );
		var.ChangeType( VT_BSTR, NULL );
		m_arrBCCName.push_back( var.bstrVal );
	}
	else
		m_arrBCCName.push_back( L"" );
	
	return S_OK;
}

STDMETHODIMP CMailSender::AddAttachment(BSTR Path)
{
	m_arrAttachment.push_back( Path );
	return S_OK;
}

STDMETHODIMP CMailSender::Reset()
{
	m_arrTo.clear();
	m_arrToName.clear();

	m_arrReplyTo.clear();
	m_arrReplyToName.clear();

	m_arrCC.clear();
	m_arrCCName.clear();

	m_arrBCC.clear();
	m_arrBCCName.clear();

	m_arrAttachment.clear();

	return S_OK;
}

STDMETHODIMP CMailSender::get_IsHTML(BOOL *pVal)
{
	* pVal = m_bHTML;
	return S_OK;
}

STDMETHODIMP CMailSender::put_IsHTML(BOOL newVal)
{
	m_bHTML = newVal;
	return S_OK;
}
