//----------------------------------------------------------------------------
// EnhWave.hpp - bcbdcc32 generated hdr (DO NOT EDIT) rev: 0
// From: EnhWave.pas
//----------------------------------------------------------------------------
#ifndef EnhWaveHPP
#define EnhWaveHPP
//----------------------------------------------------------------------------
#include <MMSystem.hpp>
#include <Windows.hpp>
#include <Dialogs.hpp>
#include <Forms.hpp>
#include <Controls.hpp>
#include <Graphics.hpp>
#include <Classes.hpp>
#include <SysUtils.hpp>
#include <Messages.hpp>
#include <System.hpp>
namespace Enhwave
{
//-- type declarations -------------------------------------------------------
struct TEWWAVEHeader
{
	char RIFF[4];
	long FileLen;
	char WAVE[4];
	char FMT[4];
	long FmtSize;
	Word FormatTag;
	Word channels;
	long SampleRate;
	long BytesSec;
	Word BlockAlign;
	Word BitsSample;
	char DATA[4];
	long DataLen;
} ;

class __declspec(delphiclass) EWaveError;
class __declspec(pascalimplementation) EWaveError : public Sysutils::Exception
{
	typedef Sysutils::Exception inherited;
	
public:
	/* Exception.Create */ __fastcall EWaveError(const System::AnsiString Msg) : Sysutils::Exception(Msg
		) { }
	/* Exception.CreateFmt */ __fastcall EWaveError(const System::AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	/* Exception.CreateRes */ __fastcall EWaveError(int Ident) : Sysutils::Exception(Ident) { }
	/* Exception.CreateResFmt */ __fastcall EWaveError(int Ident, const System::TVarRec * Args, const int 
		Args_Size) : Sysutils::Exception(Ident, Args, Args_Size) { }
	/* Exception.CreateHelp */ __fastcall EWaveError(const System::AnsiString Msg, int AHelpContext) : 
		Sysutils::Exception(Msg, AHelpContext) { }
	/* Exception.CreateFmtHelp */ __fastcall EWaveError(const System::AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	/* Exception.CreateResHelp */ __fastcall EWaveError(int Ident, int AHelpContext) : Sysutils::Exception(
		Ident, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ __fastcall EWaveError(int Ident, const System::TVarRec * Args, const 
		int Args_Size, int AHelpContext) : Sysutils::Exception(Ident, Args, Args_Size, AHelpContext) { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~EWaveError(void) { }
	
};

typedef void __fastcall (__closure *TEWDataEvent)(System::TObject* sender, char * data, int size);

enum TEWInCap { icStereo };

typedef Set<TEWInCap, icStereo, icStereo>  TEWInCaps;

enum TEWOutCap { ocStereo, ocLRVolume, ocPitch, ocPlaybackRate, ocSync, ocVolume, ocSampleAccurate }
	;

typedef Set<TEWOutCap, ocStereo, ocSampleAccurate>  TEWOutCaps;

enum TEWDev { wvMapper, wvDevice0, wvDevice1, wvDevice2, wvDevice3, wvDevice4, wvDevice5, wvDevice6, 
	wvDevice7, wvDevice8, wvDevice9 };

typedef Shortint TEWIBuffers;

typedef int TEWIBufferSize;

class __declspec(delphiclass) TEnhWaveIn;
class __declspec(pascalimplementation) TEnhWaveIn : public Classes::TComponent
{
	typedef Classes::TComponent inherited;
	
private:
	HWND FWindowHandle;
	int FChannels;
	long FSamples;
	int FBits;
	TEWIBuffers FMaxBuffers;
	TEWIBufferSize FInBuffSize;
	TEWDev FWantedDev;
	bool FOpened;
	bool FCapturing;
	int FWaveInID;
	Classes::TNotifyEvent FOnOpen;
	TEWDataEvent FOnData;
	Classes::TNotifyEvent FOnClose;
	System::AnsiString FFileName;
	int NumInBuffs;
	wavehdr_tag InBuffs[9];
	System::file TheFile;
	bool FileOpen;
	long FileDataSize;
	void __fastcall WndProc(Messages::TMessage &Msg);
	void __fastcall SetMaxBuffers(TEWIBuffers b);
	void __fastcall SetChannels(int c);
	void __fastcall SetSamples(long s);
	void __fastcall SetBits(int b);
	void __fastcall SetInBuffSize(TEWIBufferSize s);
	void __fastcall SetWantedDev(TEWDev d);
	void __fastcall SetOnOpen(Classes::TNotifyEvent value);
	void __fastcall SetOnData(TEWDataEvent value);
	void __fastcall SetOnClose(Classes::TNotifyEvent value);
	void __fastcall SetFileName( System::AnsiString value);
	TEWInCaps __fastcall GetCaps(void);
	void __fastcall SetCaps(TEWInCaps value);
	void __fastcall CloseWAVFile(void);
	
public:
	__fastcall virtual TEnhWaveIn(Classes::TComponent* AOwner);
	__fastcall virtual ~TEnhWaveIn(void);
	bool __fastcall IsOpen(void);
	bool __fastcall IsCapturing(void);
	void __fastcall open(void);
	void __fastcall close(void);
	
__published:
	__property TEWInCaps capabilities = {read=GetCaps, write=SetCaps, stored=false, nodefault};
	__property System::AnsiString FileName = {read=FFileName, write=SetFileName, nodefault};
	__property int channels = {read=FChannels, write=SetChannels, default=1};
	__property long samples = {read=FSamples, write=SetSamples, default=8000};
	__property int SampleBits = {read=FBits, write=SetBits, default=8};
	__property TEWIBuffers MaxBuffers = {read=FMaxBuffers, write=SetMaxBuffers, default=2};
	__property TEWIBufferSize BufferSize = {read=FInBuffSize, write=SetInBuffSize, default=2048};
	__property TEWDev device = {read=FWantedDev, write=SetWantedDev, default=0};
	__property int DeviceID = {read=FWaveInID, nodefault};
	__property Classes::TNotifyEvent OnOpen = {read=FOnOpen, write=FOnOpen};
	__property TEWDataEvent OnData = {read=FOnData, write=FOnData};
	__property Classes::TNotifyEvent OnClose = {read=FOnClose, write=FOnClose};
};

class __declspec(delphiclass) TEnhWaveOut;
class __declspec(pascalimplementation) TEnhWaveOut : public Classes::TComponent
{
	typedef Classes::TComponent inherited;
	
private:
	HWND FWindowHandle;
	int FChannels;
	long FSamples;
	int FBits;
	TEWDev FWantedDev;
	bool FOpened;
	bool FPlaying;
	int FWaveOutID;
	Classes::TNotifyEvent FOnOpen;
	Classes::TNotifyEvent FOnDone;
	Classes::TNotifyEvent FOnClose;
	wavehdr_tag *OutList;
	void __fastcall WndProc(Messages::TMessage &Msg);
	void __fastcall SetChannels(int c);
	void __fastcall SetSamples(long s);
	void __fastcall SetBits(int b);
	void __fastcall SetWantedDev(TEWDev d);
	void __fastcall SetOnOpen(Classes::TNotifyEvent value);
	void __fastcall SetOnDone(Classes::TNotifyEvent value);
	void __fastcall SetOnClose(Classes::TNotifyEvent value);
	void __fastcall RemoveBuffer(Mmsystem::PWaveHdr buffer);
	Word __fastcall GetVolume(void);
	void __fastcall SetVolume(Word value);
	TEWOutCaps __fastcall GetCaps(void);
	void __fastcall SetCaps(TEWOutCaps value);
	
public:
	__fastcall virtual TEnhWaveOut(Classes::TComponent* AOwner);
	__fastcall virtual ~TEnhWaveOut(void);
	bool __fastcall IsOpen(void);
	bool __fastcall IsPlaying(void);
	void __fastcall open(void);
	void __fastcall close(void);
	void __fastcall playback(char * data, int size);
	void __fastcall reset(void);
	
__published:
	__property TEWOutCaps capabilities = {read=GetCaps, write=SetCaps, stored=false, nodefault};
	__property Word volume = {read=GetVolume, write=SetVolume, stored=false, nodefault};
	__property int channels = {read=FChannels, write=SetChannels, default=1};
	__property long samples = {read=FSamples, write=SetSamples, default=8000};
	__property int SampleBits = {read=FBits, write=SetBits, default=8};
	__property TEWDev device = {read=FWantedDev, write=SetWantedDev, default=0};
	__property int DeviceID = {read=FWaveOutID, nodefault};
	__property Classes::TNotifyEvent OnOpen = {read=FOnOpen, write=FOnOpen};
	__property Classes::TNotifyEvent OnDone = {read=FOnDone, write=FOnDone};
	__property Classes::TNotifyEvent OnClose = {read=FOnClose, write=FOnClose};
};

//-- var, const, procedure ---------------------------------------------------
extern void __fastcall Register(void);
//-- template instantiations -------------------------------------------------
template class TEWOutCaps ;
template class TEWInCaps ;

}	/* namespace Enhwave */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Enhwave;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// EnhWave
