unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Jstick, ExtCtrls;

type
  TfrmMain = class(TForm)
    CheckBox1: TCheckBox;
    Jstick1: TJstick;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Memo1: TMemo;
    Label13: TLabel;
    Label14: TLabel;
    chkNormalize: TCheckBox;
    chkRange: TCheckBox;
    chkAxis: TCheckBox;
    chkButtons: TCheckBox;
    chkPov: TCheckBox;
    sbRange: TScrollBar;
    lblRange: TLabel;
    chkNullZone: TCheckBox;
    lblNullZone: TLabel;
    sbNullZone: TScrollBar;
    btnInfo: TButton;
    btnExit: TButton;
    btnCalibrate: TButton;
    btnButtonValue: TButton;
    btnPovValue: TButton;
    btnAxisOrdinal: TButton;
    procedure CheckBox1Click(Sender: TObject);
    procedure Jstick1Axis(Sender: TObject; X, Y, Z, R, U, V: Integer; pcX,
      pcY, pcZ, pcR, pcU, pcV: Single);
    procedure Jstick1Button(Sender: TObject; ButtonID: Integer;
      ButtonDown: Boolean);
    procedure Jstick1Pov(Sender: TObject; PovValue: Integer);
    procedure chkNormalizeClick(Sender: TObject);
    procedure chkRangeClick(Sender: TObject);
    procedure UpdateValueDisplay;
    procedure FormCreate(Sender: TObject);
    procedure chkAxisClick(Sender: TObject);
    procedure chkButtonsClick(Sender: TObject);
    procedure chkPovClick(Sender: TObject);
    procedure sbRangeChange(Sender: TObject);
    procedure chkNullZoneClick(Sender: TObject);
    procedure sbNullZoneChange(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure btnInfoClick(Sender: TObject);
    procedure btnCalibrateClick(Sender: TObject);
    procedure btnButtonValueClick(Sender: TObject);
    procedure btnPovValueClick(Sender: TObject);
    procedure btnAxisOrdinalClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

uses Unit2;

{$R *.DFM}


procedure TfrmMain.UpdateValueDisplay;
var
  x, y, z, r, u, v: Integer;
  pcX, pcY, pcZ, pcR, pcU, pcV: Single;
begin
  //read the current values
  jstick1.QueryAxisValues(x, y, z, r, u, v, pcX, pcY, pcZ, pcR, pcU, pcV);

  //fake an axis event to update the display
  Jstick1Axis(Self, x, y, z, r, u, v, pcX, pcY, pcZ, pcR, pcU, pcV);
end;

procedure TfrmMain.CheckBox1Click(Sender: TObject);
begin
  jstick1.EnablePolling := checkbox1.Checked;
end;

procedure TfrmMain.Jstick1Axis(Sender: TObject; X, Y, Z, R, U, V: Integer;
  pcX, pcY, pcZ, pcR, pcU, pcV: Single);
begin
  label1.Caption := 'X = ' + IntToStr(X);
  label2.Caption := 'Y = ' + IntToStr(Y);
  label3.Caption := 'Z = ' + IntToStr(Z);
  label4.Caption := 'R = ' + IntToStr(R);
  label5.Caption := 'U = ' + IntToStr(U);
  label6.Caption := 'V = ' + IntToStr(V);

  label7.Caption := Format('%3.3f %%', [pcX]);
  label8.Caption := Format('%3.3f %%', [pcY]);
  label9.Caption := Format('%3.3f %%', [pcZ]);
  label10.Caption := Format('%3.3f %%', [pcR]);
  label11.Caption := Format('%3.3f %%', [pcU]);
  label12.Caption := Format('%3.3f %%', [pcV]);
end;

procedure TfrmMain.Jstick1Button(Sender: TObject; ButtonID: Integer;
  ButtonDown: Boolean);
begin
  if ButtonDown then
    memo1.Lines.Add('  Button ' + IntToStr(ButtonID) + ' Down')
  else
    memo1.Lines.Add('  Button ' + IntToStr(ButtonID) + ' Up');
end;

procedure TfrmMain.Jstick1Pov(Sender: TObject; PovValue: Integer);
var
  s: string;
begin
  case PovValue of
    0: s := '  POV Up ';
    9000: s := '  POV Right ';
    18000: s := '  POV Down ';
    27000: s := '  POV Left ';
    65535, -1: s := '  POV Centered ';
  else
    s := '  POV ' + IntToStr(PovValue);
  end;

  memo1.Lines.Add(s);
end;

procedure TfrmMain.chkNormalizeClick(Sender: TObject);
begin
  jstick1.NormalizeAxis := chkNormalize.Checked;
  UpdateValueDisplay;
end;

procedure TfrmMain.chkRangeClick(Sender: TObject);
begin
  jstick1.UseRange := chkRange.Checked;
  UpdateValueDisplay;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  chkAxis.Checked := jstick1.MonitorAxis;
  chkButtons.Checked := jstick1.MonitorButtons;
  chkPov.Checked := jstick1.MonitorPov;
  chkNormalize.Checked := jstick1.NormalizeAxis;
  chkRange.Checked := jstick1.UseRange;
  chkNullZone.Checked := jstick1.UseNullZone;
  sbRange.Position := jstick1.RangeX div 1000;
  sbNullZone.Position := jstick1.NullZoneX;

  UpdateValueDisplay;
end;

procedure TfrmMain.chkAxisClick(Sender: TObject);
begin
  jstick1.MonitorAxis := chkAxis.Checked;
end;

procedure TfrmMain.chkButtonsClick(Sender: TObject);
begin
  jstick1.MonitorButtons := chkButtons.Checked;
end;

procedure TfrmMain.chkPovClick(Sender: TObject);
begin
  jstick1.MonitorPov := chkPov.Checked;
end;

procedure TfrmMain.chkNullZoneClick(Sender: TObject);
begin
  jstick1.UseNullZone := chkNullZone.Checked;
end;

procedure TfrmMain.sbRangeChange(Sender: TObject);
var
  r: Integer;
begin
  r := sbRange.Position * 1000;

  jstick1.RangeX := r;
  jstick1.RangeY := r;
  jstick1.RangeZ := r;
  jstick1.RangeR := r;
  jstick1.RangeU := r;
  jstick1.RangeV := r;

  lblRange.Caption := 'Range = ' + IntToStr(r);
  UpdateValueDisplay;
end;


procedure TfrmMain.sbNullZoneChange(Sender: TObject);
var
  r: Integer;
begin
  r := sbNullZone.Position;

  jstick1.NullZoneX := r;
  jstick1.NullZoneY := r;
  jstick1.NullZoneZ := r;
  jstick1.NullZoneR := r;
  jstick1.NullZoneU := r;
  jstick1.NullZoneV := r;

  lblNullZone.Caption := 'NullZone = ' + IntToStr(r) + ' %';
  UpdateValueDisplay;
end;

procedure TfrmMain.btnExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmMain.btnInfoClick(Sender: TObject);
begin
  frmInfo.ShowModal;
end;

procedure TfrmMain.btnCalibrateClick(Sender: TObject);
begin
  jstick1.Calibrate;
end;

procedure TfrmMain.btnButtonValueClick(Sender: TObject);
begin
  if jstick1.QueryButtonValue(1) then
    ShowMessage('Button1 is Down')
  else
    ShowMessage('Button1 is Up')
end;

procedure TfrmMain.btnPovValueClick(Sender: TObject);
begin
  ShowMessage('POV Value is ' + IntToStr(jstick1.QueryPovValue));
end;

procedure TfrmMain.btnAxisOrdinalClick(Sender: TObject);
begin
  if jstick1.QueryIsAxisLeft(1) then
    ShowMessage('Axis X is LEFT')
  else
  if jstick1.QueryIsAxisRight(1) then
    ShowMessage('Axis X is RIGHT')
  else
  if jstick1.QueryIsAxisCentered(1) then
    ShowMessage('Axis X is CENTERED');

//you don't really need the last "else if" because if the
//joystick is not left and the joystick is not right it
//must be centered, I just wanted to show you how to use
//some of the TJstick methods
end;

end.
