<script language="vbscript" runat="server">

Public Sub SaveConfig

	Session("SAVECONFIG") = false

	Set CFG = FS.CreateTextFile( Session( "BINPATH" ) + "\NICKI.CFG", true )
  	If Err.Number > 0 Then
		Exit Sub
	End If


	REM **************************************
	REM *** Write basic setup to NICKI.CFG ***
	REM **************************************

	If MASTER("STARTIMC") = "ON" Then
		CFG.WriteLine "/STARTIMC"
	End If

	If MASTER("STOPIMC") = "ON" Then
		CFG.WriteLine "/STOPIMC"
	End If

	CFG.WriteLine ""

	If MASTER("SMTPTIMEOUT") <> "" Then
		CFG.WriteLine "SMTPTIMEOUT = " + MASTER("SMTPTIMEOUT")
	End If

	If MASTER("POPTIMEOUT") <> "" Then
		CFG.WriteLine "POPTIMEOUT = " + MASTER("POPTIMEOUT")
	End If

	If MASTER("SMTPHOST") <> "" Then
		CFG.WriteLine "SMTPHOST = " + MASTER("SMTPHOST")
	End If

	If MASTER("SMTPDOMAIN") <> "" Then
		CFG.WriteLine "SMTPDOMAIN = " + MASTER("SMTPDOMAIN")
	End If

	If MASTER("DATADIR") <> "" Then
		CFG.WriteLine "DATADIR = " + MASTER("DATADIR")
	End If

	CFG.WriteLine ""

	For x = 1 To MASTER("CFGCNT")
		CFG.WriteLine CFGARY( Trim(CStr( x )) + ".FILENAME" )
	Next

	CFG.Close

	REM *******************************************
	REM *** Now save all account configurations ***
	REM *******************************************

	For x = 1 To MASTER("CFGCNT")
		chX = Trim(CStr(x))
		cfgName = CFGARY( chX + ".FILENAME" )

		If cfgName <> "" Then
			Set CFG = FS.CreateTextFile( Session( "BINPATH" ) + "\" + cfgName, true )
			If Err.Number > 0 Then
				Exit Sub
			End If
			
			If CFGARY(chX + ".LEAVEMAIL") = "ON" Then
				CFG.WriteLine "/LEAVEMAIL"
			End If

			If CFGARY(chX + ".MULTIPLE") = "ON" Then
				CFG.WriteLine "/MULTIPLE"
			End If

			If CFGARY(chX + ".POPHOST") <> "" Then
				CFG.WriteLine "POPHOST = " + CFGARY(chX + ".POPHOST")
			End If

			If CFGARY(chX + ".DATADIR") <> "" Then
				CFG.WriteLine "DATADIR = " + CFGARY(chX + ".DATADIR")
			End If

			If CFGARY(chX + ".PWD") <> "" Then
				CFG.WriteLine "PWD = " + CFGARY(chX + ".PWD")
			End If

			If CFGARY(chX + ".UID") <> "" Then
				CFG.WriteLine "UID = " + CFGARY(chX + ".UID")
			End If

			If CFGARY(chX + ".DEST") <> "" Then
				CFG.WriteLine "DEST = " + CFGARY(chX + ".DEST")
			End If

			CFG.Close
		End If
	next

	Session("SAVECONFIG") = true 

End Sub







Public Sub ReadConfig()
	Dim CFG
	Dim cnt

	On Error Resume Next
	Set CFG = FS.OpenTextFile( Session( "BINPATH" ) + "\NICKI.CFG", 1, FALSE )
	If err.number > 0 Then
		Exit Sub
	End If

	MASTER.RemoveAll
	CFGARY.RemoveAll
	cnt = 0

	While Not CFG.AtEndOfStream
		line = trim(CFG.ReadLine)

		If line <> "" Then
			If InStr( line, "=" ) > 0 Then
				PARM = UCase(Trim(Left( line, InStr( line, "=" )-1 )))
				ARG = Trim(Mid( line, InStr( line, "=" )+1 ))

				MASTER( PARM ) = ARG
			Else
				PARM = UCase(Trim(line))
				ARG = ""

				If InStr( PARM, "/" ) > 0 Then
					MASTER( Mid( PARM, 2 ) ) = "ON"
				Else
					cnt = cnt + 1
					CFGARY( Trim(CStr(cnt)) + ".FILENAME" ) = PARM
				End If
			End If
		End If
	Wend

	MASTER( "CFGCNT" ) = cnt
	CFG.Close

	For cnt = 1 to MASTER("CFGCNT")
		Set CFG = FS.OpenTextFile( Session("BINPATH" ) + "\" + CFGARY( Trim(CStr(cnt)) + ".FILENAME" ), 1, FALSE )
		If Err.Number = 0 Then	
			While Not CFG.AtEndOfStream
				line = trim(CFG.ReadLine)

				If InStr( line, "=" ) > 0 Then
					PARM = UCase(Trim(Left( line, InStr( line, "=" )-1 )))
					ARG = Trim(Mid( line, InStr( line, "=" )+1 ))

					CFGARY( Trim(CStr(cnt)) + "." + PARM ) = ARG
				Else
					PARM = UCase(Trim(line))
					ARG = ""

					If InStr( PARM, "/" ) <> -1 Then
						CFGARY( Trim(CStr(cnt)) + "." + Mid( PARM, 2 ) ) = "ON"
					End If
				End If
			Wend

			CFG.Close
		End If
	Next
End Sub

</script>
