#!/usr/local/bin/perl

# ==========================================================================
# If the first line doesn't match your path to perl please modify.
# Run this script from command line.
#	(ie: for c-shell "./install.cgi" or bash "install.cgi")
# NOTE: It should be run from the directory AdCafe will store its data
#
# Copyright (c) 1998 Infohiway
#
# Install AdCafe - this script installs adcafe on a server
#
# install.cgi
#
#
# ==========================================================================

MAIN:
{
# IMPORTANT! This really, really, has to be your PATH TO PERL. Modify if incorrect.
	$newPathToPerl = '/usr/local/bin/perl';

# IMPORTANT! AdCafe CGI URL - should be URL
	$adcafeUrlCgi = 'http://www.yourserver.com/cgi-bin/';	# cgi file URL
# CGI directory using file system - should be same location as $adcafeUrlCgi above
#     (just with a different method of referring to it)
	$serverDirCgi = '/www/cgi-bin/';
# IMPORTANT! AdCafe Data URL - should be URL
	$adcafeUrlData = 'http://www.yourserver.com/data/';	# data file URL
# IMPORTANT! AdCafe data file directory - should be absolute reference.
	$adcafeDirData = '/www/data/';	#data location - should match data URL above
	$adcafeDirTotals = '/www/totals/';	#total files location
	$adcafeDirLogs = '/www/logs/';	# ad logs location

#	mkdir("$adcafeDirData", 0777);	# uncomment to create directories
#	mkdir("$adcafeDirTotals", 0777);	# uncomment to create directories
#	mkdir("$adcafeDirLogs", 0777);	# uncomment to create directories
#	mkdir("$serverDirCgi", 0777);	# uncomment to create directories

# IMPORTANT! company name and email
	$adCafeServer = 'YourName, Inc.';	# name of your company
	$adCafeMailAddr = 'email@yourServer.com';	# email address displayed on admin pages

# IMPORTANT! Default ad banner and href
	$adDefGif = 'http://www.yourserver.com/default.gif';	# gif to use when error in ad delivery
	$adDefUrl = 'http://www.yourserver.com/default.htm';	# Url to use when error in ad delivery
	$adDefGifUrl = 'http://www.yourserver.com/adcafe/';	# default location for ad gifs

	$adcafeAdminId = 'AdCafe';		# login to AdCafe admin functions and totals
	$adcafeAdminPswd = 'admin';		# password to AdCafe admin functions
	$adcafeAdminTots = 'tots';		# password to AdCafe admin totals
	$adcafeAdminStats = 'stats';		# password to AdCafe admin stats

# ------------------------------------------------------------------------------------

# Nothing below here should need to be changed

# ------------------------------------------------------------------------------------

	$orgPathToPerl = '/usr/local/bin/perl';		# what is currently in cgi files
	my $cmask = umask(000);
	$| = 1;		# directly to screen without buffering.

	print STDOUT "\nAdCafe Installation\nFilter cgi files to setup for local server\n";

	my @cgiList = (	# files to be filtered
		'adcafe.cgi',
		'adcafe_admin.cgi',
		'adcafe_ads.cgi',
		'adcafe_all.cgi',
		'adcafe_allads.cgi',
		'adcafe_allgrp.cgi',
		'adcafe_batch.cgi',
		'adcafe_clean.cgi',
		'adcafe_click.cgi',
		'adcafe_dates.cgi',
		'adcafe_daily.cgi',
		'adcafe_env.cgi',
		'adcafe_frame.cgi',
		'adcafe_getad.cgi',
		'adcafe_getsubs.cgi',
		'adcafe_gif.cgi',
		'adcafe_grps.cgi',
		'adcafe_gui.cgi',
		'adcafe_htm.cgi',
		'adcafe_inactive.cgi',
		'adcafe_lock.cgi',
		'adcafe_login.cgi',
		'adcafe_security.cgi',
		'adcafe_setup.cgi',
		'adcafe_sites.cgi',
		'adcafe_ssi.cgi',
		'adcafe_stats.cgi',
		'adcafe_statads.cgi',
		'adcafe_statsubs.cgi',
		'adcafe_sum.cgi',
		'adcafe_test.cgi',
		'adcafe_totals.cgi',
		'adcafe_tots.cgi',
		'adcafe_totdata.cgi',
		'adcafe_totform.cgi',
		'adcafe_totmsg.cgi',
		'adcafe_totsub.cgi',
		'adcafe_update.cgi',
	);
	my ($file);
	my $errCode = 0;
	while ($file = shift @cgiList) {
		$errCode += &filterCGI($file);
	}

	my @modList = (	# files to be id properly
		'adcafe.htm',
		'frame.htm',
		'gif.htm',
		'htm.htm',
		'htmlad.htm',
		'ssi.shtml',
		'readme.htm',
		'adcafe.gif',
		'adcafe_bg.gif'
	);
	while ($file = shift @modList) {
		$errCode += &fileMod($file);
	}

	my @varCfg =	(
		"adcafeUrlCgi","adcafeUrlData","adcafeDirData","adCafeServer","adcafeDirTotals",
		"adcafeDirLogs","adCafeMailAddr","adDefGif", "adDefUrl", "adDefGifUrl",
		"adcafeAdminId", "adcafeAdminPswd", "adcafeAdminTots", "adcafeAdminStats"
	);
	$errCode += &filterCGI('adcafe_cfg.cgi', \@varCfg);

	if ($errCode > 0) {
		print STDOUT "\nInstallation complete - ERRORS were detected!\nNot all files could be updated for your server!\n";
		print STDOUT "Please note which files had a problem!\nYou can contact Infohiway at ad adcafe\@infohiway.com\n";
	} else {
		print STDOUT "\nInstallation complete - no errors were detected!\n";
	}
	umask($cmask);

	exit;
}

sub filterCGI
{
	my $file = shift;
	my $changes = shift;
	print STDOUT "Reading $file ...";
	unless (-e $file) {
		print STDOUT " Can not open\n";
		return 2;
	}

	open(FILE, $file);
	my @lines = <FILE>;
	close(FILE);
	my $dirCgi = ($serverDirCgi ne $adcafeDirData) ? $serverDirCgi : '';
	unless (open(FILE, ">$dirCgi$file")) {
		print STDOUT " Could not update\n";
		return 1;
	}

	print STDOUT " Updating\n";
	my $line = shift @lines;
	chop($line);
	$line =~ s/\n|\cM|\cJ//g;
	$line =~ s/$orgPathToPerl/$newPathToPerl/i;
	
	print FILE "$line\n";
	while (@lines) {
		$line = shift @lines;
		chop($line);
		$line =~ s/\n|\cM|\cJ//g;
		foreach $var (@$changes) {
			if ($line =~ /^\t\$$var =/i) {
				$line = "\t\$$var = \'$$var\';";
				last;
			}
		}
		print FILE "$line\n";
	}
	close(FILE);
	chmod 0755, "$dirCgi$file";
	return 0;
}

sub fileMod
{
	my $file = shift;
	print STDOUT "Set permission: $file ...";
	unless (-e $file) {
		print STDOUT " Can not find\n";
		return 2;
	}

	print STDOUT " Updating\n";
	chmod 0664, $file;
	return 0;
}
