#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - extract totals from adcafe log file
# Copyright (c) 1998 Infohiway
#
# Ad log file parse
#
# adcafe_update.cgi
#
# ==========================================================================

sub updateTotals
{ 
	$yearLog = shift;
	$monLog = shift;
	$dayLog = shift;
	my $errMsg = &validDates;

	umask(000);
	&logEvent(8, "msg=Update Details in adcafe$dayLog\.upd");
	&openMsg($dayLog);
	&wrtMsg("Adcafe Batch Update: $monLog\/$dayLog\/$yearLog");
	if (length($errMsg) > 0) {
		&wrtMsg("FatalError: $errMsg");
		&logEvent(8, "msg=Update FatalError: $errMsg");
	} else {
		$keyDay = sprintf("%04d%02d%02d", $yearLog, $monLog, $dayLog);
		my $logFile = "${adcafeDirLogs}adcafe$keyDay\.log";
		if (-e $logFile) {
			open (LOG, "$logFile");
			&wrtMsg("Process $logFile");
			&processLog;
			close LOG;
			if ($adcafeChkIfExp eq 'b') {
				&wrtMsg("Update finished - check ad expirations");
				&cleanSiteSchedule;
				&wrtMsg("Ad expirations check finished - start cleanup");
			} else {
				&wrtMsg("Update finished - start cleanup");
			}
			&logEvent(8, "msg=Update finished: Start daily cleanup");
			require 'adcafe_clean.cgi';
#			system 'perl', 'adcafe_clean.cgi';
			&cleanFiles;
			&wrtMsg("Cleanup finished");
		} else {
			&wrtMsg("Couldn't find $logFile");
		}
	}

	&closeMsg;
}

sub processLog
{
	my ($time, $agent, $idAd, $action, $addr, $page, $idSite, $typeBrowser, $typeOS);
	my (%hits, %clicks, $totHit, $totClk, %ad);
	while (<LOG>) {
		chop;
		($action, $idAd, $idSite, $time, $agent, $addr, $page) = split(/\|/, $_);
		next if length($idAd) < 1;

		($typeBrowser, $typeOS) = &parseBrowser($agent);
		if ($action eq 'C') {	# clickthru
			$clicks{$typeBrowser}++;
			$clicks{$typeOS}++;
			$clicks{$idAd}++;
			$clicks{$idSite}++;
			$totClk++;
			$ad{$idAd}++;
		} else {
			$ad{$idAd}++;
			$hits{$idAd}++;
			$hits{$idSite}++;
			$hits{$typeOS}++;
			$hits{$typeBrowser}++;
			$totHit++;
		}
	}

	$keyMon = sprintf("%04d%02d", $yearLog,$monLog);
	&wrtMsg("Total: $totHit  $totClk");
	&updtTot($adcafeTotId, $totHit, $totClk);

	my ($key, $hits, $clks, $flag);
	while(($key, $hits)=each(%hits)) {
		&wrtMsg("$key: $hits  $clicks{$key}");
		$flag = ($ad{$key}) ? 1 : '';
		&updtTot($key, $hits, $clicks{$key}, $flag);
	}
	while(($key, $clks)=each(%clicks)) {
		unless ($hits{$key} > 0) {
			&wrtMsg("$key: 0  $clks");
			$flag = ($ad{$key}) ? 1 : '';
			&updtTot($key, 0, $clks, $flag);
		}
	}
	$hits = $hits{'win'}; $hits += $hits{'win95'}; $hits += $hits{'winNT'};
	$clks = $clicks{'win'}; $clks += $clicks{'win95'}; $clks += $clicks{'winNT'};
	&wrtMsg("win: $hits  $clks");
	&updtTot('win', $hits, $clks);
	$hits = $hits{'msie'}; $hits += $hits{'msie4'};
	$clks = $clicks{'msie'}; $clks += $clicks{'msie4'};
	&wrtMsg("msie: $hits  $clks");
	&updtTot('msie', $hits, $clks);
	$hits = $hits{'nav'}; $hits += $hits{'nav4'};
	$clks = $clicks{'nav'}; $clks += $clicks{'nav4'};
	&wrtMsg("nav: $hits  $clks");
	&updtTot('nav', $hits, $clicks);

	my @allAds = keys %ad;
	my $allRec = join("\n",@allAds);
	&wrtMsg("Build adcafe$keyDay\.key");
	open(AD, ">${adcafeDirTotals}adcafe$keyDay\.key");
	print AD "$allRec\n";
	close(AD);
}

sub updtTot
{
	my $id = shift;
	my $hits = shift;
	my $clks = shift;
	my $flagAd = shift;
	unless($id) { return; }

	my ($hitsTot,$clksTot,$totCtr);
	my %tot;
	dbmopen(%tot,"${adcafeDirTotals}$id",0666);
	my $hitsOld = 0; my $clksOld =  0;
	if ($tot{$keyDay}) {
		($hitsOld,$clksOld) = split(/\|/, $tot{$keyDay});
	}
	$tot{$keyDay} = "$hits\|$clks";
	if ($tot{$keyMon}) {
		($hitsTot,$clksTot,$totCtr) = split(/\|/, $tot{$keyMon});
		$hitsTot += $hits; $clksTot += $clks; $totCtr++;
		if ($hitsOld > 0) {
			$hitsTot -= $hitsOld; $clksTot -= $clksOld; $totCtr--;
		}
	} else {
		$hitsTot = $hits; $clksTot = $clks; $totCtr = 1;
	}
	$tot{$keyMon} = "$hitsTot\|$clksTot\|$totCtr";
	if ($tot{$yearLog}) {
		($hitsTot,$clksTot,$totCtr) = split(/\|/, $tot{$yearLog});
		$hitsTot += $hits; $clksTot += $clks; $totCtr++;
		if ($hitsOld > 0) {
			$hitsTot -= $hitsOld; $clksTot -= $clksOld; $totCtr--;
		}
	} else {
		$hitsTot = $hits; $clksTot = $clks; $totCtr = 1;
	}
	$tot{$yearLog} = "$hitsTot\|$clksTot\|$totCtr";
	if ($tot{'tot'}) {
		($hitsTot,$clksTot,$totCtr) = split(/\|/, $tot{'tot'});
		$hitsTot += $hits; $clksTot += $clks; $totCtr++;
		if ($hitsOld > 0) {
			$hitsTot -= $hitsOld; $clksTot -= $clksOld; $totCtr--;
		}
	} else {
		$hitsTot = $hits; $clksTot = $clks; $totCtr = 1;
	}
	$tot{'tot'} = "$hitsTot\|$clksTot\|$totCtr";
	my $dateBeg = $keyDay;
	my $dateEnd = $keyDay;
	if ($tot{'date'}) {
		($dateBeg,$dateEnd) = split(/\|/, $tot{'date'});
		if ($dateBeg gt $keyDay) { $dateBeg = $keyDay; }
		if ($dateEnd lt $keyDay) { $dateEnd = $keyDay; }
	}
	$tot{'date'} = "$dateBeg\|$dateEnd\|$totCtr";
	dbmclose(%tot);
	
	if ($flagAd > 0 && $adcafeChkIfExp eq 'b') {
		&updateAdCtr($id, $hits, $clks, $hitsTot, $clksTot);
	}
}

sub updateAdCtr
{
	my $id = shift;
	my $updHits = shift;  my $updClks = shift;
	my $totHits = shift;  my $totClks = shift;
	my ($hit, $clk, $opts, $rec, $exp, $cd, $rest);
	my $lock = &lockAdCtr($id);
	($rec, $opts) = &loadAdCtr($id);
	($hit, $clk) = split(/\|/, $rec);
	($exp, $cd, $rest) = split(/\|/, $opts, 3);
	$hit += $updHits;  $clk += $updClks;

	if ($totHits != $hit) {
		$hit = $totHits;
	}
	if ($totClks != $clk) {
		$clk = $totClks;
	}
	if (&okToStart($cd, $id)) {
		$cd = 'R';
		&logEvent(1, "Id=$id");	# ad starting
	}
	if ($cd eq 'R') {
		$cd = &isExpired($exp, $hit, $clk);
	}
	if ($cd eq 'E') {
		&logEvent(2, "Id=$id");	# ad stopping
		$opts =~ s/\|R\|/\|E\|/;
	}

	&saveAdCtr($id, "$hit\|$clk", "$exp\|$cd\|$rest");
	&unlockAdCtr($id) if $lock > 0;
}

sub cleanSiteSchedule
{
	my $file = "${adcafeDirData}adcafe\.cfg";
	if (-e $file) {
		open(CFG, $file);
		my ($id);
		while (<CFG>) {
			chop($_) if $_ =~ /\n$/;
			($id) = split(/\=/, $_);
			&checkSite($id);
		}
		close(CFG);
	}
}

sub checkSite
{
	my $site = shift;
	my $file = "${adcafeDirData}adsite$site\.cfg";
	if (&fileLock($file, \*LSITE)) {
		my @ads = ();
		if (-e $file) {
			open(SITE, $file);
			<SITE>;	# cycle ctr
			@ads = <SITE>;	#load ads
			close(SITE);
		}

		open(SITE, ">$file");
		print SITE "0\|0\n";
		my ($id, $exp, $cd, $rest, $rec);
		while ($rec = shift @ads) {
			chop($rec);
			($id, $exp, $cd, $rest) = &syncAdCtr($rec);
			if ($cd eq 'R' || $cd =~ /^S/) {
				print SITE "$id\|$exp\|$cd\|$rest\n";
			}
		}
		close(SITE);
		&fileUnlock($file, \*LSITE);
	} else {
		&logEvent(6, "Rtn=update\|File=adsite.cfg\|Site=$site");
	}
}

sub syncAdCtr
{
	my $rec = shift;
	my ($id, $exp, $cd, $rest, $expC, $cdC, $restC);
	($id, $exp, $cd, $rest) = split(/\|/, $rec);
	unless ($id) { return 'X'; }

	my $file = "$adcafeDirTotals$id\.ctr";
	my $flagOK = '';
	unless ($exp) {$exp = 'A';}
	unless ($rest) { $rest = "0\|0\|\|\|0\|0"; }
	unless ($cd) { $cd = 'R'; }
	if (-e $file) {
		$flagOK = 't';
		open(CTR, $file);
		<CTR>;
		$_ = <CTR>;  chop;
		($expC, $cdC, $restC) = split(/\|/, $_, 3);
		close(CTR);
		unless ($expC) {
			$expC = $exp;  $flagOK = '';
		}
		unless ($cdC) {
			$cdC = $cd;  $flagOK = '';
		}
		unless ($restC) {
			$restC = $rest;  $flagOK = '';
		}
		$exp = $expC;
		$rest = $restC;
		$cd = $cdC;
	}

	unless ($flagOK eq 't') {
		open(CTR, ">$file");
		print CTR "0\|0\n$exp\|$cd\|$rest\n";
		close(CTR);
	}

	return ($id, $exp, $cd, $rest);
}

sub validDates
{
	my ($dayEnd, $monEnd, $yearEnd);
	($dayEnd, $monEnd, $yearEnd) = (localtime(time))[3,4,5];
	$monEnd++; $yearEnd += 1900;

	if ($yearLog < 1997) {
		return "Invalid year: $yearLog";
	}

	if ($monLog < 1 || $monLog > 12) {
		return "Invalid month: $monLog";
	}
	
	my $endMonth = &daysInMonth($monLog, $yearLog);
	if ($dayLog < 1 || $dayLog > $endMonth) {
		return "Invalid day: $dayLog";
	}
	if ($yearLog > $yearEnd || ($yearLog == $yearEnd && $monLog > $monEnd) ||
			($yearLog == $yearEnd && $monLog == $monEnd && $dayLog > $dayEnd)) {
		return "Date entered ($monLog/$dayLog/$yearLog) exceeds yesterdays date";
	}

	return '';
}

sub wrtMsg
{
	my $msg = shift;
	print TRC "$msg\n";
}

sub closeMsg
{
	close(TRC);
}

sub openMsg
{
	my $day = shift;
	my $stdName = sprintf("adcafe%02d\.upd", $day);
	if (-e $stdName) {
    	open(TRC, ">>$adcafeDirLogs$stdName");
	} else {
    	open(TRC, ">$adcafeDirLogs$stdName");
	}
	select TRC;
	$| = 1;
}

	return 1;	# force true