#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - Advertiser management system
# Copyright (c) 1998 Infohiway
#
# Admin statistics - Professional only
#
# adcafe_tots.cgi
#
# ==========================================================================

require 'adcafe_cfg.cgi';
require 'adcafe_dates.cgi';
require 'adcafe_gui.cgi';
require 'adcafe_security.cgi';
require 'adcafe_totsub.cgi';
require 'adcafe_totdata.cgi';
require 'adcafe_totform.cgi';
require 'adcafe_totmsg.cgi';

MAIN:
{ 
	&getInput;
	unless (&okToRun($adcafeLoginAdminTotCd, $adcafeAdminId)) {
		print STDOUT "Location: ${adcafeUrlCgi}adcafe_login.cgi?rt=t\n\n";	# sponsor login
		exit;
	}
	$cgiTotals = 'adcafe_tots.cgi';
	&setupForTotals;

	my $errMsg = &setupDates;
	&htmlHeader('AdCafe Totals');
	unless (length($errMsg) > 0) {
		&dspHeading;
		if ($input{'ts'} eq 't' || $input{'ta'} eq 't') {
			&dspSiteTotals if $input{'ts'} eq 't';
			&dspAdTotals if $input{'ta'} eq 't';
		}
		&dspMsgs if $input{'tm'} eq 't';
	}

	&totEnd($errMsg);

	exit;
}

sub dspSiteTotals
{
	my $totHit = 0;
	&loadSites;
	&dspTotHeading(' Server / Site Totals ');
	my @sites = sort {$siteInfo{$a} cmp $siteInfo{$b}} keys %siteInfo;
	my ($id, $name);
	if (@sites) {
		$totHit = &dspSite($adcafeTotId, $siteInfo{$adcafeTotId});
		my $color = $adcafeTblAltColor;
		while ($id = shift @sites) {
			unless ($id eq $adcafeTotId) {
				($name) = split(/\|/, $siteInfo{$id});
				if (&dspSite($id, $name, $color)) {
					$color = ($color) ? '' : $adcafeTblAltColor;
				}
			}
		}
	}
	print STDOUT "</TABLE>";

	if ($totHit > 0) {
		&dspTotHeading(' Totals by Browser ');
		my $color = '';
		while ($id = shift @brIds) {
			if (&dspSite($id, $brName{$id}, $color)) {
				$color = ($color) ? '' : $adcafeTblAltColor;
			}
		}
		print STDOUT "</TABLE>";

		&dspTotHeading(' Totals by System ');
		$color = '';
		while ($id = shift @sysIds) {
			if (&dspSite($id, $sysName{$id}, $color)) {
				$color = ($color) ? '' : $adcafeTblAltColor;
			}
		}
		print STDOUT "</TABLE>";
	}
}

sub dspSite
{
	my $id = shift;
	my $desc = shift;
	my $color = shift;

	unless ($color) { $color = ''; }
	my ($hitC,$hitY, $hitM, $hitCA, $hitYA, $hitMA);
	my ($clkC, $clkY, $clkM, $clkCA, $clkYA, $clkMA);
	my ($yldC, $yldY, $yldM, $yldCA, $yldYA, $yldMA);
	my ($ctrC, $ctrY, $ctrM, $href);
	($hitC,$clkC,$ctrC, $hitM,$clkM,$ctrM,$hitY,$clkY,$ctrY) = &loadTotals($id);
	if ($id eq $adcafeTotId || $hitC > 0) {
		if ($siteInfo{$id}) {
			$href = "<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_statads.cgi\?id=$id&lgn=$adcafeLoginSiteCd\" onMouseOver=\"window.status=\'$desc Totals\'; return true\"><B>$desc</B></A>";
		} else {
			$href = $desc;
		}
		$yldC = ($hitC > 0) ? sprintf("%0.2f%%",($clkC / $hitC * 100)) : '0.00%';
		$yldY = ($hitY > 0) ? sprintf("%0.2f%%",($clkY / $hitY * 100)) : '0.00%';
		$yldM = ($hitM > 0) ? sprintf("%0.2f%%",($clkM / $hitM * 100)) : '0.00%';
		$hitCA = ($ctrC > 0) ? int($hitC / $ctrC) : 0;
		$clkCA = ($ctrC > 0) ? int($clkC / $ctrC) : 0;
		$hitMA = ($ctrM > 0) ? int($hitM / $ctrM) : 0;
		$clkMA = ($ctrM > 0) ? int($clkM / $ctrM) : 0;
		$hitYA = ($ctrY > 0) ? int($hitY / $ctrY) : 0;
		$clkYA = ($ctrY > 0) ? int($clkY / $ctrY) : 0;
		$yldCA = ($hitCA > 0) ? sprintf("%0.2f%%",($clkCA / $hitCA * 100)) : '0.00%';
		$yldYA = ($hitYA > 0) ? sprintf("%0.2f%%",($clkYA / $hitYA * 100)) : '0.00%';
		$yldMA = ($hitMA > 0) ? sprintf("%0.2f%%",($clkMA / $hitMA * 100)) : '0.00%';
		$hitC = fmtNumber($hitC);
		$clkC = fmtNumber($clkC);
		$hitM = fmtNumber($hitM);
		$clkM = fmtNumber($clkM);
		$hitCA = fmtNumber($hitCA);
		$clkCA = fmtNumber($clkCA);
		$hitMA = fmtNumber($hitMA);
		$clkMA = fmtNumber($clkMA);
		$hitY = fmtNumber($hitY);
		$clkY = fmtNumber($clkY);
		$hitYA = fmtNumber($hitYA);
		$clkYA = fmtNumber($clkYA);
		print STDOUT "<TR VALIGN=TOP$color><TD WIDTH=25%>$href</TD><TD>Impressions<BR>Clickthrus<BR>Yield</TD>";
		print STDOUT "<TD ALIGN=RIGHT>$hitC<BR>$clkC<BR>$yldC</TD>";
		if ($isDateRange eq 't') {
			print STDOUT "<TD ALIGN=RIGHT>$hitCA<BR>$clkCA<BR>$yldCA</TD>";
		}
		print STDOUT "<TD ALIGN=RIGHT>$hitM<BR>$clkM<BR>$yldM</TD>";
		print STDOUT "<TD ALIGN=RIGHT>$hitMA<BR>$clkMA<BR>$yldMA</TD>";
		unless ($isDateRange eq 't') {
			print STDOUT "<TD ALIGN=RIGHT>$hitY<BR>$clkY<BR>$yldY</TD>";
		}
		print STDOUT "<TD ALIGN=RIGHT>$hitYA<BR>$clkYA<BR>$yldYA</TD></TR>\n";
		return $hitC;
	}

	return '';
}

sub dspAdTotals
{
	&loadGroups;
	&loadAdIds;
	my @ads = sort {$adName{$a} cmp $adName{$b}} keys %adName;
	unless (@ads) { return ''; }

	my @grps = sort {$groupName{$a} cmp $groupName{$b}} keys %groupName;
	my $color = '';  my ($id, @ids);
	&dspAdHeading('Group Totals');
	while ($id = shift @grps) {
		if (&dspAdGroup($id, $color)) {
			$color = ($color) ? '' : $adcafeTblAltColor;
		}
	}
	print STDOUT "</TABLE>";

	&dspAdHeading('Individual Ad Totals');
	$color = '';
	while (@ads) {
		$id = shift @ads;
		unless ($input{'ti'} ne 't' && $adGroup{$id}) {
			&dspAd($id, $color);
			$color = ($color) ? '' : $adcafeTblAltColor;
		}
	}
	print STDOUT "</TABLE>";

	return 1;
}

sub dspAd
{
	my $id = shift;
	my $color = shift;

	my %cdDesc = ('R'=>'Running', 'E'=>'Expired', 'A'=>'Err:Ad', 'C'=>'Err:Ctr', 'S'=>'Scheduled');
	my $cd = (loadAdStatus($id))[0];
	my $status = ($cdDesc{$cd}) ? $cdDesc{$cd} : $cd;

	my $href = "<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_statads.cgi\?id=$id&lgn=$adcafeLoginAdCd\" onMouseOver=\"window.status=\'$adName{$id} Totals\'; return true\"><B>$adName{$id}</B></A>";
	print STDOUT "<TR$color VALIGN=TOP><TD WIDTH=30%>$href<BR>$id: <B>$status</B></TD>";
	&dspAdTot(&loadTotals($id));
}

sub dspAdGroup
{
	my $group = shift;
	my $color = shift;
	my @ids = split(/\,/, $groupAds{$group});
	my ($totHC,$totHT, $totHM, $totCC, $totCT, $totCM, $totNC, $totNT, $totNM, $totCd);
	my %cdDesc = ('R'=>'Running', 'E'=>'Expired', 'P'=>'Part Expired',	'A'=>'Err:Ad', 'C'=>'Err:Ctr', 'S'=>'Scheduled');
	my ($hitC,$hitT, $hitM, $clkC, $clkT, $clkM, $ctrC, $ctrT, $ctrM, $cd, $id);

	while ($id = shift @ids) {
		$cd = (loadAdStatus($id))[0];
		unless ($totCd) {
			$totCd = $cd;
		} else {
			if ($cd eq 'R') {
				$totCd = ($totCd eq 'R') ? 'R' : 'P';
			} elsif ($cd eq 'E') {
				$totCd = ($totCd eq 'E') ? 'E' : 'P';
			}
		}
		($hitC,$clkC,$ctrC, $hitM,$clkM,$ctrM,$hitT,$clkT,$ctrT) = &loadTotals($id);
		$totHC += $hitC; $totCC += $clkC; $totNC = ($ctrC > $totNC) ? $ctrC : $totNC;
		$totHM += $hitM;  $totCM += $clkM; $totNM = ($ctrM > $totNM) ? $ctrM : $totNM;
		$totHT += $hitT; $totCT += $clkT; $totNT = ($ctrT > $totNT) ? $ctrT : $totNT;
	}
	unless ($totHC > 0 || $totCC > 0) { return ''; }

	my $status = ($cdDesc{$totCd}) ? $cdDesc{$totCd} : $totCd;

	my $href = "<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_statads.cgi\?id=$group&lgn=$adcafeLoginGroupCd\" onMouseOver=\"window.status=\'$groupName{$group} Totals\'; return true\"><B>$groupName{$group}</B></A>";
	print STDOUT "<TR$color VALIGN=TOP><TD WIDTH=30%>$href<BR>$group: <B>$status</B></TD>";
	&dspAdTot($totHC,$totCC,$totNC, $totHM,$totCM,$totNM,$totHT,$totCT,$totNT);
	return 1;
}

sub dspAdTot
{
	my $hitC = shift; my $clkC = shift; my $ctrC = shift;
	my $hitM = shift; my $clkM = shift; my $ctrM = shift;
	my $hitT = shift; my $clkT = shift; my $ctrT = shift;

	my ($hitCA, $hitTA, $hitMA, $clkCA, $clkTA, $clkMA, $yldC, $yldT, $yldCA, $yldTA, $yldMA);
	$yldC = ($hitC > 0) ? sprintf("%0.2f%%",($clkC / $hitC * 100)) : '0.00%';
	$yldT = ($hitT > 0) ? sprintf("%0.2f%%",($clkT / $hitT * 100)) : '0.00%';
	$hitCA = ($ctrC > 0) ? int($hitC / $ctrC) : 0;
	$clkCA = ($ctrC > 0) ? int($clkC / $ctrC) : 0;
	$hitMA = ($ctrM > 0) ? int($hitM / $ctrM) : 0;
	$clkMA = ($ctrM > 0) ? int($clkM / $ctrM) : 0;
	$hitTA = ($ctrT > 0) ? int($hitT / $ctrT) : 0;
	$clkTA = ($ctrT > 0) ? int($clkT / $ctrT) : 0;
	$yldCA = ($hitCA > 0) ? sprintf("%0.2f%%",($clkCA / $hitCA * 100)) : '0.00%';
	$yldTA = ($hitTA > 0) ? sprintf("%0.2f%%",($clkTA / $hitTA * 100)) : '0.00%';
	$yldMA = ($hitMA > 0) ? sprintf("%0.2f%%",($clkMA / $hitMA * 100)) : '0.00%';
	$hitC = fmtNumber($hitC);
	$clkC = fmtNumber($clkC);
	$hitCA = fmtNumber($hitCA);
	$clkCA = fmtNumber($clkCA);
	$hitMA = fmtNumber($hitMA);
	$clkMA = fmtNumber($clkMA);
	$hitT = fmtNumber($hitT);
	$clkT = fmtNumber($clkT);
	$hitTA = fmtNumber($hitTA);
	$clkTA = fmtNumber($clkTA);

	print STDOUT '<TD WIDTH=10%>Impressions<BR>Clickthrus<BR>Yield</TD>';
	print STDOUT "<TD ALIGN=RIGHT WIDTH=12%>$hitC<BR>$clkC<BR>$yldC</TD>";
	if ($isDateRange eq 't') {
		print STDOUT "<TD ALIGN=RIGHT WIDTH=12%>$hitCA<BR>$clkCA<BR>$yldCA</TD>";
	}
	print STDOUT "<TD ALIGN=RIGHT WIDTH=12%>$hitMA<BR>$clkMA<BR>$yldMA</TD>";
	print STDOUT "<TD ALIGN=RIGHT WIDTH=12%>$hitTA<BR>$clkTA<BR>$yldTA</TD>";
	print STDOUT "<TD ALIGN=RIGHT WIDTH=12%>$hitT<BR>$clkT<BR>$yldT</TD></TR>\n";
}

sub dspAdHeading
{
	my $title = shift;
	my $maxCol = ($isDateRange eq 't') ? 7 : 6;
	print STDOUT "<P><TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>\n";
	print STDOUT "<TR$adcafeHdrTblColor><TD COLSPAN=$maxCol ALIGN=CENTER><B>$title</B></TD></TR>\n";
	print STDOUT "<TR$adcafeHdrTblColor><TD><B>Name / Id: Status</B></TD><TD>&nbsp;</TD>";
	if ($isDateRange eq 't') {
		print STDOUT "<TD ALIGN=RIGHT><B>Range<BR>Total</B></TD>";
		print STDOUT "<TD ALIGN=RIGHT><B>Range<BR>Average</B></TD>";
	} else {
		print STDOUT "<TD ALIGN=RIGHT><B><BR>Today</B></TD>";
	}
	print STDOUT "<TD ALIGN=RIGHT><B>MTD<BR>Avg</B></TD><TD ALIGN=RIGHT><B>Total<BR>Avg</B></TD>";
	print STDOUT "<TD ALIGN=RIGHT><B><BR>Total</B></TD></TR>\n";
}

sub loadTotals
{
	my $id = shift;
	my $mon = $input{'smon'}; my $day = $input{'sday'}; my $year = $input{'syear'};
	my $monEnd = $input{'emon'}; my $dayEnd = $input{'eday'}; my $yearEnd = $input{'eyear'};
	my $endMonth = &daysInMonth($mon, $year);
	my $totHits = 0;  my $totClks = 0;  my $ctr = 0;
	my ($hits, $clks, $key);
	my %tots = ();
	dbmopen(%tots,"${adcafeDirTotals}$id",0666);
	while ($year < $yearEnd || ($year == $yearEnd && $mon < $monEnd) || ($year == $yearEnd && $mon == $monEnd && $day <= $dayEnd)) {
		$key = sprintf("%04d%02d%02d", $year, $mon, $day);
		($hits,$clks) = split(/\|/, $tots{$key});
		if ($hits > 0 || $clks > 0) {
			$totHits += $hits;  $totClks += $clks;  $ctr++;
		}
		$day++;
		if ($day > $endMonth) {
			$day = 1; $mon++;
			if ($mon > 12) {
				$mon = 1; $year++;
			}
			$endMonth = &daysInMonth($mon, $year);
		}
	}

	$key = sprintf("%04d%02d", $year, $mon);
	my ($hitsMon,$clksMon,$ctrMon,$hitsYr,$clksYr,$ctrYr);
	($hitsMon,$clksMon,$ctrMon) = split(/\|/, $tots{$key});
	$key = ($adName{$id}) ? 't' : $year;
	($hitsYr,$clksYr,$ctrYr) = split(/\|/, $tots{$year});
	dbmclose(%tots);

	return ($totHits, $totClks, $ctr, $hitsMon,$clksMon,$ctrMon,$hitsYr,$clksYr,$ctrYr);
}

sub loadAdIds
{
	my $mon = $input{'smon'}; my $day = $input{'sday'}; my $year = $input{'syear'};
	my $monEnd = $input{'emon'}; my $dayEnd = $input{'eday'}; my $yearEnd = $input{'eyear'};
	my $endMonth = &daysInMonth($mon, $year);
	my $totHits = 0;  my $totClks = 0;  my $ctr = 0;
	my ($file, $key);
	%adName = ();
	while ($year < $yearEnd || ($year == $yearEnd && $mon < $monEnd) || ($year == $yearEnd && $mon == $monEnd && $day <= $dayEnd)) {
		$file = sprintf("adcafe%04d%02d%02d\.key", $year, $mon, $day);
		if (-e "$adcafeDirTotals$file") {
			open(ID, "$adcafeDirTotals$file");
			while(<ID>) {
				chop;
				unless ($adName{$_}) {
					$adName{$_} = &loadAdName($_);
				}
			}
			close(ID);
		}
		$day++;
		if ($day > $endMonth) {
			$day = 1; $mon++;
			if ($mon > 12) {
				$mon = 1; $year++;
			}
			$endMonth = &daysInMonth($mon, $year);
		}
	}
}
