#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - Advertiser management system
# Copyright (c) 1998 Infohiway
#
# Admin statistics subroutines - Professional only
#
# adcafe_totmsg.cgi
#
# ==========================================================================

sub dspMsgs
{
	my $mon = $input{'smon'};
	my $day = $input{'sday'};
	my $year = $input{'syear'};
	my $monEnd = $input{'emon'};
	my $dayEnd = $input{'eday'};
	my $yearEnd = $input{'eyear'};
	my $endMonth = &daysInMonth($mon, $year);
	my %cdDesc = (	1=>'Ad Started', 2=>'Ad Expired', 3=>'Clickthru Error',
					4=>'File Load Error', 5=>'Log Error', 6=>'Lock Error',
					7=>'Invalid GIF format', 8=>'FYI'
				 );
	my ($name, $color, $flag, $key);
	print STDOUT "<P><TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>\n";
	print STDOUT "<TR$adcafeHdrTblColor><TD COLSPAN=3 ALIGN=CENTER><B> Information / Error Messages </B></TD></TR>\n";
	print STDOUT "<TR$adcafeHdrTblColor><TD><B>Date / Time</B></TD><TD><B>Event</B></TD><TD><B>Message</B></TD></TR>\n";
	while ($year < $yearEnd || ($year == $yearEnd && $mon < $monEnd) || ($year == $yearEnd && $mon == $monEnd && $day <= $dayEnd)) {
		$key = sprintf("%04d%02d%02d", $year, $mon, $day);
		$name = "${adcafeDirLogs}adcafe$key\.msg";
		if (-e $name) {
			open(MSG,$name);
			while(<MSG>) {
				chop;
				$flag = 1;
				/\[([^\]].+)\] (.) (.*)/;
				print STDOUT "<TR$color><TD WIDTH=20%>$1</TD><TD WIDTH=20%>$cdDesc{$2}</TD><TD WIDTH=50%>";
				&parseMsg($3, $2);
				print STDOUT "</TD></TR>\n";
				$color = ($color) ? '' : $adcafeTblAltColor;
			}
			close (MSG);
		}
		$day++;
		if ($day > $endMonth) {
			$day = 1; $mon++;
			if ($mon > 12) {
				$mon = 1; $year++;
			}
			$endMonth = &daysInMonth($mon, $year);
		}
	}
	if ($flag < 1) {
		print STDOUT "<TR><TD COLSPAN=3 ALIGN=CENTER>No messages found for display.</TD></TR>\n";
	}
	print STDOUT '</TABLE>';
}

sub parseMsg
{
	my $msg = shift;
	my $msgCd = shift;
	my @allCds = split(/\|/,$msg);
	my($pair, $code, $value);
	my %msgLog = ('L'=>'Log Imp', 'C'=>'Log Click');
	while (@allCds) {
		$pair = shift @allCds;
		($code, $value) = split(/=/, $pair);
		$value =~ tr/+/ /;
		$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
		if ($msgCd == 1 || $msgCd == 2) {
			if ($code eq 'Id') {
				if ($adName{$value}) {
					$msg = "$adName{$value}";
				} else {
					my $file = "$adcafeDirData$value\.ad";
					if (-e $file) {
						open(AD, $file);
						<AD>; <AD>; <AD>; <AD>;
						$msg = <AD>;
						chop($msg);
						close(AD);
					} else {
						$msg = "$code=$value";
					}
				}
			} else {
				$msg = '';
			}
		} elsif ($code eq 'msg') {
			$msg = "$value";
		} elsif ($code eq 'Log') {
			$msg = "$msgLog{$value}";
		} else {
			$msg = "$code: $value";
		}
		print STDOUT "$msg ";
	}
	
}

	return 1;	# force true return
