#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - Advertiser management system
# Copyright (c) 1998 Infohiway
#
# Admin statistics subroutines - Professional only
#
# adcafe_totform.cgi
#
# ==========================================================================

sub totEnd
{
	my $errMsg = shift;
	my $hdgMsg = '';
	if (length($errMsg) > 0) {
		$errMsg = "<FONT $adcafeFontErrColor><B>$errMsg</B></FONT>";
	} else {
		$hdgMsg = "<B>More Totals</B>";
		$errMsg = '<HR>';
	}
	my ($day, $mon, $year);
	($day, $mon, $year) = (localtime(time))[3,4,5];
	$mon++;  $year += 1900;
	my $maxYear = $year + 1;
	my ($ix, $sel, $begMons, $endMons, $begYrs, $endYrs);
	my @monthsName = ('', 'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');	# make 1 relative
	if ($input{'smon'} > 0 && 	$input{'smon'} < 13) {
		$mon = $input{'smon'};
	} else {
		$input{'smon'} = $mon;  $input{'sday'} = $day;  $input{'syear'} = $year;
	}
	for ($ix = 1; $ix < 13; $ix++) {
		$sel = ($mon == $ix) ? ' SELECTED' : '';
		$begMons .= "<OPTION VALUE=\"$ix\"$sel>$monthsName[$ix]\n";
	}

	if ($input{'emon'} > 0 && 	$input{'emon'} < 13) {
		$mon = $input{'emon'};
		for ($ix = 1; $ix < 13; $ix++) {
			$sel = ($mon == $ix) ? ' SELECTED' : '';
			$endMons .= "<OPTION VALUE=\"$ix\"$sel>$monthsName[$ix]\n";
		}
	} else {
		$endMons = $begMons;
		$input{'emon'} = $mon;  $input{'eday'} = $day;  $input{'eyear'} = $year;
	}

	$year = $input{'syear'};
	for ($ix = 1997; $ix < $maxYear; $ix++) {
		$sel = ($year == $ix) ? ' SELECTED' : '';
		$begYrs .= "<OPTION VALUE=\"$ix\"$sel>$ix\n";
	}
	$year = $input{'eyear'};
	for ($ix = 1997; $ix < $maxYear; $ix++) {
		$sel = ($year == $ix) ? ' SELECTED' : '';
		$endYrs .= "<OPTION VALUE=\"$ix\"$sel>$ix\n";
	}

	my $tsChk = ($input{'ts'} eq 't') ? ' CHECKED' : '';
	my $taChk = ($input{'ta'} eq 't') ? ' CHECKED' : '';
	my $tmChk = ($input{'tm'} eq 't') ? ' CHECKED' : '';
	my $tiChk = ($input{'ti'} eq 't') ? ' CHECKED' : '';

	print STDOUT <<EOT;
$errMsg
<CENTER><FORM ACTION="$cgiTotals" METHOD=POST>
$hdgMsg
<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=5 WIDTH=90%>
<TR><TD>Starting Date</TD>
<TD><INPUT TYPE=TEXT NAME=sday SIZE=4 VALUE="$input{'sday'}">
&nbsp;&nbsp;<SELECT NAME=smon SIZE=1>
$begMons
</SELECT>
&nbsp;&nbsp;<SELECT NAME=syear SIZE=1>
$begYrs
</SELECT>
</TD></TR>
<TR><TD>Ending Date</TD>
<TD><INPUT TYPE=TEXT NAME=eday SIZE=4 VALUE="$input{'eday'}">
&nbsp;&nbsp;<SELECT NAME=emon SIZE=1>
$endMons
</SELECT>
&nbsp;&nbsp;<SELECT NAME=eyear SIZE=1>
$endYrs
</SELECT>
EOT

	unless ($optSkipMsg eq 't') {
		print STDOUT <<EOT;
</TD></TR>
<TR><TD COLSPAN=2><HR></TD></TR>
<TR VALIGN=TOP><TD>Totals to Display</TD>
<TD><INPUT TYPE="CHECKBOX" NAME="ts" VALUE="t"$tsChk>Site Totals
<BR><INPUT TYPE="CHECKBOX" NAME="ta" VALUE="t"$taChk>Ad Totals (including groups)
<BR><INPUT TYPE="CHECKBOX" NAME="ti" VALUE="t"$tiChk>Totals of Individual Ads in a group
<BR><INPUT TYPE="CHECKBOX" NAME="tm" VALUE="t"$tmChk>Messages
EOT
	}

	print STDOUT <<EOT;
</TD></TR></TABLE>
<P><INPUT TYPE="submit" VALUE=" Submit ">
</FORM></CENTER>
<P>
EOT

	if ($optSkipMsg eq 't') {
		if ($adcafeTotalCd ne 'a') {	# live totals
			my $dsc = ($adcafeTotalCd eq 'b') ? 'Live Totals' : 'Totals';
		print STDOUT "<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_totals.cgi\" style=\"$adcafeLinkColor\"><B>&nbsp; $dsc &nbsp;</B></a>&#0124;";
		}
		if ($adcafeTotalCd ne 'd') {	# batch totals
			my $dsc = ($adcafeTotalCd eq 'b') ? 'Batch Totals' : 'Totals';
			print STDOUT "<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_tots.cgi\" style=\"$adcafeLinkColor\"><B>&nbsp; $dsc &nbsp;</B></a>&#0124;";
		}
	} else {
		print STDOUT "<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_daily.cgi\" style=\"$adcafeLinkColor\"><B>&nbsp; Daily Snapshot &nbsp;</B></a>&#0124;";
	}


	print STDOUT <<EOT;
<A STYLE="text-decoration: none" HREF="${adcafeUrlCgi}adcafe_admin.cgi" style=\"$adcafeLinkColor\"><B>&nbsp; Admin &nbsp;</B></a>&#0124;
<A STYLE="text-decoration: none" HREF="${adcafeUrlCgi}adcafe_login.cgi" style=\"$adcafeLinkColor\"><B>&nbsp; Sponsor Login &nbsp;</B></a>
</CENTER>
EOT

	&htmlFooter;
}

sub setupDates
{
	my $errMsg = '';
  	$isDateRange = 'f';	# date range?
	if ($input{'sday'}) {
		$errMsg = &invDate($input{'sday'}, $input{'smon'}, $input{'syear'});
		if (length($errMsg) < 1) {
			if ($input{'eday'}) {
				$errMsg = &invDate($input{'eday'}, $input{'emon'}, $input{'eyear'});
				if (length($errMsg) < 1) {
					if (&cmpDate($input{'smon'}, $input{'sday'}, $input{'syear'},
								 $input{'emon'}, $input{'eday'}, $input{'eyear'}) > 0) {
						$errMsg = "Starting Date $input{'smon'}/$input{'sday'}/$input{'syear'}";
						$errMsg .= " exceeds Ending Date $input{'emon'}/$input{'eday'}/$input{'eyear'}";
					}
				}
			} else {
				$errMsg = "No ending day entered";
			}
		}
		if ($input{'smon'} != $input{'emon'} || $input{'sday'} != $input{'eday'}
		  || $input{'syear'} != $input{'eyear'}) {
		  	$isDateRange = 't';
		}
	} else {
		my ($day, $mon, $year);
		($day, $mon, $year) = (localtime(time))[3,4,5];
		$year += 1900; $mon++;
		unless ($adcafeTotalCd eq 'd') {	# batch so start with yesterday
			$day--;
			if ($day < 1) {
				$mon--;
				if ($mon == 0) {
					$mon = 12; $year--;
				}
				$day = &daysInMonth($mon, $year);
			}
		}
		$input{'smon'} = $mon;  $input{'sday'} = $day;  $input{'syear'} = $year;
		$input{'emon'} = $mon;  $input{'eday'} = $day;  $input{'eyear'} = $year;
		$input{'ts'} = 't';  $input{'ta'} = 't';  $input{'tm'} = 'f';  $input{'ti'} = 't';
	}

	if ($input{'ti'} eq 't') {
		$input{'ta'} = 't';
	}

	if ($input{'ts'} ne 't' && $input{'ta'} ne 't' && $input{'tm'} ne 't' && $input{'ti'} ne 'f') {
		$input{'ts'} = 't';
	}

	return $errMsg;
}

sub invDate
{
	my $inDay = shift;
	my $inMon = shift;
	my $inYr = shift;
	my ($day, $mon, $year);
	($day, $mon, $year) = (localtime(time))[3,4,5];
	$year += 1900; $mon++;
	if ($inYr > $year) {
		return "Year exceeds current year: $inYr";
	} elsif ($inYr == $year && $inMon > $mon) {
		return "Month exceeds current date: $inMon";
	} elsif ($inYr == $year && $inMon == $mon && $inDay > $day) {
		return "Date exceeds current date: $inMon/$inDay/$inYr";
	} else {
		if ($mon < 1 || $mon > 12) {
			return "Invalid month: $inMon";
		}
		my $end = &daysInMonth($inMon, $inYr);
		if ($inDay < 1 || $inDay > $end) {
			return "Invalid day: $inDay";
		}
	}
	return '';
}

	return 1;	# force true return
