#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - Advertiser management system
# Copyright (c) 1998 Infohiway
#
# Admin statistics subroutines - Professional only
#
# adcafe_totdata.cgi
#
# ==========================================================================

sub loadAdName
{
	my $id = shift;
	my $name = ($id eq $adDefId) ? 'Default Ad' : $id;
	my $file = "$adcafeDirData$id\.ad";
	if (-e $file) {
		open(AD, $file);
		<AD>; <AD>; <AD>; <AD>;
		$name = <AD>;
		chop($name);
		close(AD);
	}
	return $name;
}

sub loadSites
{
	&loadAllSites;
	$siteInfo{$adcafeTotId} = 'Grand Totals';
}

sub loadGroups
{
	%groupName = ();  %groupAds = ();  %adGroup = ();
	my $fileGrps = "${adcafeDirData}adgroup\.cfg";
	if (-e $fileGrps) {
		open(GRPCFG,"$fileGrps");
		my ($group, $name, $tmp, $ads);
		while (<GRPCFG>) {
			chop($_);
			($group, $name, $tmp, $ads) = split(/\|/,$_);
			$groupName{$group} = $name;
			$groupAds{$group} = $ads;
			@ads = split(/\,/, $ads);
			while (@ads) {
				$tmp = shift @ads;
				unless ($adGroup{$tmp}) {
					$adGroup{$tmp} = 1;
				}
			}
		}
		close(GRPCFG);
	}
}

	return 1;	# force true return
