#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - Advertiser management system
# Copyright (c) 1998 Infohiway
#
# Admin statistics
#
# adcafe_totals.cgi
#
# ==========================================================================

require 'adcafe_cfg.cgi';
require 'adcafe_dates.cgi';
require 'adcafe_gui.cgi';
require 'adcafe_security.cgi';
require 'adcafe_totsub.cgi';
require 'adcafe_totdata.cgi';
require 'adcafe_totform.cgi';
require 'adcafe_totmsg.cgi';

MAIN:
{ 
	&getInput;
	unless (&okToRun($adcafeLoginAdminTotCd, $adcafeAdminId)) {
		print STDOUT "Location: ${adcafeUrlCgi}adcafe_login.cgi?rt=t\n\n";	# sponsor login
		exit;
	}
	$| = 1;
	$cgiTotals = 'adcafe_totals.cgi';
	&setupForTotals;

	my $errMsg = &setupDates;
	&htmlHeader('AdCafe Totals');
	unless (length($errMsg) > 0) {
		&dspHeading;
		if ($input{'ts'} eq 't' || $input{'ta'} eq 't') {
			&loadSites;
			&loadTotals;
			&dspSiteTotals if $input{'ts'} eq 't';
			&dspAdTotals if $input{'ta'} eq 't';
		}
		&dspMsgs if $input{'tm'} eq 't';
	}

	&totEnd($errMsg);

	exit;
}

sub dspSiteTotals
{
	my $totHit = 0;
	&dspTotHeading(' Server / Site Totals ');
	my @sites = sort {$siteInfo{$a} cmp $siteInfo{$b}} keys %siteInfo;
	my ($id, $name);
	if (@sites) {
		$totHit = &dspSite($adcafeTotId, $siteInfo{$adcafeTotId});
		my $color = $adcafeTblAltColor;
		while ($id = shift @sites) {
			unless ($id eq $adcafeTotId) {
				($name) = split(/\|/, $siteInfo{$id});
				if (&dspSite($id, $name, $color)) {
					$color = ($color) ? '' : $adcafeTblAltColor;
				}
			}
		}
	}
	print STDOUT "</TABLE>";
	if ($totHit > 0) {
		&dspTotHeading(' Totals by Browser ');
		my $color = '';
		while ($id = shift @brIds) {
			if (&dspSite($id, $brName{$id}, $color)) {
				$color = ($color) ? '' : $adcafeTblAltColor;
			}
		}
		print STDOUT "</TABLE>";

		&dspTotHeading(' Totals by System ');
		$color = '';
		while ($id = shift @sysIds) {
			if (&dspSite($id, $sysName{$id}, $color)) {
				$color = ($color) ? '' : $adcafeTblAltColor;
			}
		}
		print STDOUT "</TABLE>";
	}
}

sub dspSite
{
	my $id = shift;
	my $desc = shift;
	my $color = shift;
	my ($hitC,$hitY, $hitM, $hitCA, $hitYA, $hitMA);
	my ($clkC, $clkY, $clkM, $clkCA, $clkYA, $clkMA);
	my ($yldC, $yldY, $yldM, $yldCA, $yldYA, $yldMA);
	my ($ctrC, $ctrY, $ctrM, $href);
	
	($hitC,$clkC,$ctrC, $hitY,$clkY,$ctrY,$hitM,$clkM,$ctrM) = split(/,/, $siteTotal{$id});
	if ($id eq $adcafeTotId || $hitC > 0) {
		$yldC = ($hitC > 0) ? sprintf("%0.2f%%",($clkC / $hitC * 100)) : '0.00%';
		$yldY = ($hitY > 0) ? sprintf("%0.2f%%",($clkY / $hitY * 100)) : '0.00%';
		$yldM = ($hitM > 0) ? sprintf("%0.2f%%",($clkM / $hitM * 100)) : '0.00%';
		$hitCA = ($ctrC > 0) ? int($hitC / $ctrC) : 0;
		$clkCA = ($ctrC > 0) ? int($clkC / $ctrC) : 0;
		$hitMA = ($ctrM > 0) ? int($hitM / $ctrM) : 0;
		$clkMA = ($ctrM > 0) ? int($clkM / $ctrM) : 0;
		$hitYA = ($ctrY > 0) ? int($hitY / $ctrY) : 0;
		$clkYA = ($ctrY > 0) ? int($clkY / $ctrY) : 0;
		$yldCA = ($hitCA > 0) ? sprintf("%0.2f%%",($clkCA / $hitCA * 100)) : '0.00%';
		$yldYA = ($hitYA > 0) ? sprintf("%0.2f%%",($clkYA / $hitYA * 100)) : '0.00%';
		$yldMA = ($hitMA > 0) ? sprintf("%0.2f%%",($clkMA / $hitMA * 100)) : '0.00%';
		$hitC = fmtNumber($hitC);
		$clkC = fmtNumber($clkC);
		$hitM = fmtNumber($hitM);
		$clkM = fmtNumber($clkM);
		$hitCA = fmtNumber($hitCA);
		$clkCA = fmtNumber($clkCA);
		$hitMA = fmtNumber($hitMA);
		$clkMA = fmtNumber($clkMA);
		$hitY = fmtNumber($hitY);
		$clkY = fmtNumber($clkY);
		$hitYA = fmtNumber($hitYA);
		$clkYA = fmtNumber($clkYA);
		if ($siteInfo{$id}) {
			$href = "<A HREF=\"${adcafeUrlCgi}adcafe_stats.cgi\?id=$id&lgn=$adcafeLoginSiteCd\" onMouseOver=\"window.status=\'$desc Totals\'; return true\"><B>$desc</B></A>";
		} else {
			$href = $desc;
		}
		print STDOUT "<TR$color VALIGN=TOP><TD>$href</TD><TD>Impressions<BR>Clickthrus<BR>Yield</TD>";
		print STDOUT "<TD ALIGN=RIGHT>$hitC<BR>$clkC<BR>$yldC</TD>";
		if ($isDateRange eq 't') {
			print STDOUT "<TD ALIGN=RIGHT>$hitCA<BR>$clkCA<BR>$yldCA</TD>";
		}
		print STDOUT "<TD ALIGN=RIGHT>$hitM<BR>$clkM<BR>$yldM</TD>";
		print STDOUT "<TD ALIGN=RIGHT>$hitMA<BR>$clkMA<BR>$yldMA</TD>";
		unless ($isDateRange eq 't') {
			print STDOUT "<TD ALIGN=RIGHT>$hitY<BR>$clkY<BR>$yldY</TD>";
		}
		print STDOUT "<TD ALIGN=RIGHT>$hitYA<BR>$clkYA<BR>$yldYA</TD></TR>\n";
		return $hitC;
	}

	return '';
}

sub dspAdTotals
{
	&loadGroups;
	my @ads = sort {$adName{$a} cmp $adName{$b}} keys %adName;
	unless (@ads) { return ''; }

	my @grps = sort {$groupName{$a} cmp $groupName{$b}} keys %groupName;
	my $color = '';
	&dspAdHeading('Group Totals');
	while ($id = shift @grps) {
		if (&dspAdGroup($id, $color)) {
			$color = ($color) ? '' : $adcafeTblAltColor;
		}
	}
	print STDOUT "</TABLE>";

	&dspAdHeading('Individual Ad Totals');
	$color = '';
	while (@ads) {
		$id = shift @ads;
		unless ($input{'ti'} ne 't' && $adGroup{$id}) {
			&dspAd($id, $color);
			$color = ($color) ? '' : $adcafeTblAltColor;
		}
	}
	print STDOUT "</TABLE>";

}

sub dspAd
{
	my $id = shift;
	my $color = shift;
	my $href = "<A HREF=\"${adcafeUrlCgi}adcafe_stats.cgi\?id=$id&lgn=$adcafeLoginAdCd\" onMouseOver=\"window.status=\'$adName{$id} Totals\'; return true\"><B>$adName{$id}</B></A>";
	print STDOUT "<TR VALIGN=TOP$color><TD WIDTH=40%>$href<BR>$id</TD>";
	&dspAdTot($adTotal{$id});
}


sub dspAdGroup
{
	my $group = shift;
	my $color = shift;
	my @ids = split(/\,/, $groupAds{$group});
	my ($totHC,$totHT, $totCC, $totCT, $totNC, $totCd);
	my ($hitC,$hitT, $clkC, $clkT, $ctrC, $cd, $id);

	while ($id = shift @ids) {
		($hitC, $clkC, $ctrC, $hitT, $clkT, $cd) = split(/,/, $adTotal{$id});
		unless ($totCd) {
			$totCd = $cd;
		} else {
			if ($cd eq 'R') {
				$totCd = ($totCd eq 'R') ? 'R' : 'P';
			} elsif ($cd eq 'E') {
				$totCd = ($totCd eq 'E') ? 'E' : 'P';
			}
		}
		$totHC += $hitC; $totCC += $clkC; $totNC = ($ctrC > $totNC) ? $ctrC : $totNC;
		$totHT += $hitT; $totCT += $clkT;
	}
	unless ($totHC > 0 || $totCC > 0) { return ''; }

	my $href = "<A HREF=\"${adcafeUrlCgi}adcafe_stats.cgi\?id=$group&lgn=$adcafeLoginGroupCd\" onMouseOver=\"window.status=\'$groupName{$group} Totals\'; return true\"><B>$groupName{$group}</B></A>";
	print STDOUT "<TR VALIGN=TOP$color><TD WIDTH=40%>$href<BR>$group</TD>";
	&dspAdTot("$totHC,$totCC,$totNC,$totHT,$totCT,$totCd");
	return 1;
}

sub dspAdTot
{
	my $adTotal = shift;
	my ($hitC, $clkC, $ctrC, $hitA, $clkA, $hitT, $clkT, $cd, $yldC, $yldT);

	($hitC, $clkC, $ctrC, $hitT, $clkT, $cd) = split(/,/, $adTotal);
	my %cdDesc = ('R'=>'Running', 'E'=>'Expired', 'P'=>'Part Expired',	'A'=>'Err:Ad', 'C'=>'Err:Ctr');
	my $status = ($cdDesc{$cd}) ? $cdDesc{$cd} : $cd;
	$yldC = ($hitC > 0) ? sprintf("%0.2f%%",($clkC / $hitC * 100)) : '0.00%';
	$yldT = ($hitT > 0) ? sprintf("%0.2f%%",($clkT / $hitT * 100)) : '0.00%';
	$hitA = ($ctrC > 0) ? int($hitC / $ctrC) : 0;
	$clkA = ($ctrC > 0) ? int($clkC / $ctrC) : 0;
	$yldA = ($hitA > 0) ? sprintf("%0.2f%%",($clkA / $hitA * 100)) : '0.00%';
	$hitC = fmtNumber($hitC);
	$hitT = fmtNumber($hitT);
	$hitA = fmtNumber($hitA);
	$clkA = fmtNumber($clkA);
	$clkC = fmtNumber($clkC);
	$clkT = fmtNumber($clkT);
	print STDOUT "<TD WIDTH=10%>$status</TD><TD WIDTH=10%>";
	if ($isDateRange eq 't') {
		print STDOUT "Range:<BR>Average:";
	} else {
		print STDOUT "Today:";
	}
	print STDOUT "<BR>Total:</TD><TD ALIGN=RIGHT WIDTH=10%>$hitC";
	if ($isDateRange eq 't') {
		print STDOUT "<BR>$hitA";
	}
	print STDOUT "<BR>$hitT</TD><TD ALIGN=RIGHT WIDTH=10%>$clkC";
	if ($isDateRange eq 't') {
		print STDOUT "<BR>$clkA";
	}
	print STDOUT "<BR>$clkT</TD><TD ALIGN=RIGHT WIDTH=10%>$yldC";
	if ($isDateRange eq 't') {
		print STDOUT "<BR>$yldA";
	}
	print STDOUT "<BR>$yldT</TD></TR>\n";
}

sub dspAdHeading
{
	my $title = shift;
	print STDOUT "<P><TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>\n";
	print STDOUT "<TR><TD COLSPAN=6><BR></TD></TR>\n";
	print STDOUT "<TR$adcafeHdrTblColor><TD COLSPAN=6 ALIGN=CENTER><B>$title</B></TD></TR>\n";
	print STDOUT "<TR$adcafeHdrTblColor><TD><B>Name / Id</B></TD><TD><B>Status</B></TD><TD COLSPAN=2 ALIGN=RIGHT><B>Impressions</B></TD><TD ALIGN=RIGHT><B>Clicks</B></TD><TD ALIGN=RIGHT><B>Yield</B></TD></TR>\n";
}

sub loadTotals
{
	my $mon = $input{'smon'};
	my $day = $input{'sday'};
	my $year = $input{'syear'};
	my $monEnd = $input{'emon'};
	my $dayEnd = $input{'eday'};
	my $yearEnd = $input{'eyear'};
	my $endMonth = &daysInMonth($mon, $year);
	my ($name, $id, $data, $key);
	while ($year < $yearEnd || ($year == $yearEnd && $mon < $monEnd) || ($year == $yearEnd && $mon == $monEnd && $day <= $dayEnd)) {
		$key = sprintf("%04d%02d%02d", $year, $mon, $day);
		$name = "${adcafeDirTotals}adcafe$key\.ctr";
		if (-e $name) {
			open(CTR,$name);
			$_ = <CTR>;	# grand totals
			chop($_) if $_ =~ /\n$/;
			&updtSiteTot($adcafeTotId, $_);
			while(<CTR>) {
				chop if $_ =~ /\n$/;
				($id, $data) = split(/,/, $_, 2);
				if ($siteInfo{$id}) {
					&updtSiteTot($id, $data);
				} elsif ($brName{$id}) {
					&updtSiteTot($id, $data);
				} elsif ($sysName{$id}) {
					&updtSiteTot($id, $data);
				} else {
					&updtAdTot($id, $data);
				}
			}
			close(CTR);
		}
		$day++;
		if ($day > $endMonth) {
			$day = 1; $mon++;
			if ($mon > 12) {
				$mon = 1; $year++;
			}
			$endMonth = &daysInMonth($mon, $year);
		}
	}
	unless ($siteTotal{$adcafeTotId}) {
		$siteTotal{$adcafeTotId} = "0,0,1";
	}
	$name = "${adcafeDirTotals}adcafe\.ctr";
	if (-e $name) {
		open(CTR,$name);
		<CTR>;
		$_ = <CTR>;	# grand totals
		chop($_) if $_ =~ /\n$/;
		$siteTotal{$adcafeTotId} .= ",$_";
		while(<CTR>) {
			chop if $_ =~ /\n$/;
			($id, $data) = split(/,/, $_, 2);
			if ($siteInfo{$id}) {
				$siteTotal{$id} .= ",$data";
			} elsif ($brName{$id}) {
				$siteTotal{$id} .= ",$data";
			} elsif ($sysName{$id}) {
				$siteTotal{$id} .= ",$data";
			}
		}
		close(CTR);
	}
}

sub updtSiteTot
{
	my $id = shift;
	my $data = shift;
	($hit, $clk) = split(/,/, $data, 2);
	if ($siteTotal{$id}) {
		my ($h, $c, $ctr);
		($h, $c, $ctr) = split(/,/, $siteTotal{$id});
		$hit += $h; $clk += $c; $ctr++;
		$siteTotal{$id} = "$hit,$clk,$ctr";
	} else {
		$siteTotal{$id} = "$hit,$clk,1";
	}
}

sub updtAdTot
{
	my $id = shift;
	my $data = shift;
	my ($hit, $clk);
	($hit, $clk) = split(/,/, $data, 2);
	if ($adTotal{$id}) {
		my ($h, $c, $ctr);
		($h, $c, $ctr, $data) = split(/,/, $adTotal{$id},4);
		$hit += $h; $clk += $c; $ctr++;
		$adTotal{$id} = "$hit,$clk,$ctr,$data";
	} else {
		$data = &loadAdInfo($id);
		$adTotal{$id} = "$hit,$clk,1,$data";
	}
}

sub loadAdInfo
{
	my $id = shift;
	$adName{$id} = &loadAdName($id);

	my ($cd, $curHit, $curClk);
	($cd, $curHit, $curClk) = &loadAdStatus($id);

	return "$curHit,$curClk,$cd";
}
