#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - extract totals from adcafe log file
# Copyright (c) 1998 Infohiway
#
# Ad log file parse
#
# adcafe_sum.cgi
#
# ==========================================================================

require 'adcafe_cfg.cgi';
require 'adcafe_dates.cgi';
require 'adcafe_gui.cgi';
require 'adcafe_security.cgi';
require 'adcafe_lock.cgi';
require 'adcafe_getsubs.cgi';
require 'adcafe_update.cgi';


MAIN:
{
	&getInput;
	unless (&okToRun($adcafeLoginAdminTotCd, $adcafeAdminId)) {
		print STDOUT "Location: ${adcafeUrlCgi}adcafe_login.cgi?rt=u\n\n";	# sponsor login
		exit;
	}
	if ($input{'d'}) {
		my $errMsg = &checkInput;
		if (length($errMsg) < 1) {
#			system 'perl', 'adcafe_update.cgi', "$input{'y'}", "$input{'m'}", "$input{'d'}";
			&updateTotals($input{'y'}, $input{'m'}, $input{'d'});
			&htmlHeader("AdCafe Totals Update");
			print STDOUT "<HR><FONT SIZE=+2><B>Totals update has been completed!</B></FONT><HR>";
			&htmlEnd;
		} else {
			&htmlForm($errMsg);
		}
	} else {
		&htmlForm;
	}

	exit;
}

sub htmlForm
{
	my $errMsg = shift;
	&htmlHeader("AdCafe Totals Update");
	if (length($errMsg) > 0) {
		$errMsg = "<FONT $adcafeFontErrColor><B>$errMsg</B></FONT><HR>";
	}

	my ($day, $mon, $year);
	($day, $mon, $year) = (localtime(time))[3,4,5];
	$mon++;  $year += 1900;
	$day--;
	if ($day < 1) {
		$mon--;
		if ($mon == 0) {
			$mon = 12; $year--;
		}
		$day = &daysInMonth($mon, $year);
	}
	my $maxYear = $year + 1;
	my ($ix, $sel, $begMons, $endMons, $begYrs, $endYrs);
	my @monthsName = ('', 'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');	# make 1 relative
	for ($ix = 1; $ix < 13; $ix++) {
		$sel = ($mon == $ix) ? ' SELECTED' : '';
		$begMons .= "<OPTION VALUE=\"$ix\"$sel>$monthsName[$ix]\n";
	}
	for ($ix = 1997; $ix < $maxYear; $ix++) {
		$sel = ($year == $ix) ? ' SELECTED' : '';
		$begYrs .= "<OPTION VALUE=\"$ix\"$sel>$ix\n";
	}

	print STDOUT <<EOT;
$errMsg
<CENTER><FORM ACTION="adcafe_sum.cgi" METHOD=POST>
<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=5 WIDTH=90%>
<TR><TD>Date of totals to update</TD>
<TD><INPUT TYPE=TEXT NAME=d SIZE=4 VALUE="$day">
&nbsp;&nbsp;<SELECT NAME=m SIZE=1>
$begMons
</SELECT>
&nbsp;&nbsp;<SELECT NAME=y SIZE=1>
$begYrs
</SELECT>
</TD></TR></TABLE>
<P><INPUT TYPE="submit" VALUE=" Submit ">
</FORM></CENTER>
<P>
EOT
	&htmlEnd;
}

sub htmlEnd
{
	print STDOUT '<CENTER>';
	if ($adcafeTotalCd ne 'a') {	# live totals
		my $dsc = ($adcafeTotalCd eq 'b') ? 'Live Totals' : 'Totals';
		print STDOUT "<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_totals.cgi\" style=\"$adcafeLinkColor\"><B>&nbsp; $dsc &nbsp;</B></a>&#0124;";
	}
	if ($adcafeTotalCd ne 'd') {	# batch totals
		my $dsc = ($adcafeTotalCd eq 'b') ? 'Batch Totals' : 'Totals';
		print STDOUT "<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_tots.cgi\" style=\"$adcafeLinkColor\"><B>&nbsp; $dsc &nbsp;</B></a>&#0124;";
	}


	print STDOUT <<EOT;
<A STYLE="text-decoration: none" HREF="${adcafeUrlCgi}adcafe_daily.cgi" style="$adcafeLinkColor"><B>&nbsp; Daily Snapshot &nbsp;</B></a>&#0124;
<A STYLE="text-decoration: none" HREF="${adcafeUrlCgi}adcafe_admin.cgi" style=\"$adcafeLinkColor\"><B>&nbsp; Admin &nbsp;</B></a>&#0124;
<A STYLE="text-decoration: none" HREF="${adcafeUrlCgi}adcafe_login.cgi" style=\"$adcafeLinkColor\"><B>&nbsp; Sponsor Login &nbsp;</B></a>
</CENTER>
EOT

	&htmlFooter;
}

sub checkInput
{
	unless($input{'d'}) { return ''; }

	my $inDay = $input{'d'};
	my $inMon = $input{'m'};
	my $inYr = $input{'y'};
	my ($day, $mon, $year);
	($day, $mon, $year) = (localtime(time))[3,4,5];
	$year += 1900; $mon++;
	if ($inYr > $year) {
		return "Year exceeds current year: $inYr";
	} elsif ($inYr == $year && $inMon > $mon) {
		return "Month exceeds current date: $inMon";
	} elsif ($inYr == $year && $inMon == $mon && $inDay > $day) {
		return "Date exceeds current date: $inMon/$inDay/$inYr";
	} else {
		if ($mon < 1 || $mon > 12) {
			return "Invalid month: $inMon";
		}
		my $end = &daysInMonth($inMon, $inYr);
		if ($inDay < 1 || $inDay > $end) {
			return "Invalid day: $inDay";
		}
	}

	return '';
}
