#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - Advertiser management system
# Copyright (c) 1998 Infohiway
#
# Stats for individual account
#
# adcafe_statsubs.cgi
#
# ==========================================================================

	$adcafeStatDays = 15;

sub dspAdTotals
{
	my $errMsg = &loadTotals;
	if (length($errMsg > 0)) {
		return $errMsg;
	}

	print STDOUT '<CENTER><P>';
	print STDOUT "<FONT SIZE=+1$adcafeFontHdrColor><B>$adInfo{'name'}</B></FONT></CENTER>\n";
	print STDOUT "<P><TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>\n";
	print STDOUT "<TR$adcafeHdrTblColor><TD><B>Date</B></TD><TD ALIGN=RIGHT><B>Impressions</B></TD><TD ALIGN=RIGHT><B>ClickThrus</B></TD><TD ALIGN=RIGHT><B>Yield</B></TD></TR>\n";

	my $mon = $input{'smon'};  my $day = $input{'sday'};  my $year = $input{'syear'};
	my $monEnd = $input{'emon'};  my $dayEnd = $input{'eday'};  my $yearEnd = $input{'eyear'};
	my $endMonth = &daysInMonth($mon, $year);
	my ($key, $hit, $clk, $yld);
	my $sumHit = 0;  my $sumClk = 0;  my $ctr = 0;
	my $color = $adcafeTblAltColor;
	while ($year < $yearEnd || ($year == $yearEnd && $mon < $monEnd) || ($year == $yearEnd && $mon == $monEnd && $day <= $dayEnd)) {
		$key = sprintf("%04d%02d%02d", $year, $mon, $day);
		($hit,$clk) = split(/\|/, $tots{$key});
		if ($hit > 0 || $clk > 0) {
			$sumHit += $hit;	$sumClk += $clk;  $ctr++;
			$yld = ($hit > 0) ? sprintf("%0.2f%%",($clk / $hit * 100)) : '0.0%';
			$color = ($color) ? '' : $adcafeTblAltColor;
			$clk = fmtNumber($clk);
			$hit = fmtNumber($hit);
			print STDOUT "<TR VALIGN=TOP$color><TD>$mon/$day/$year</TD><TD ALIGN=RIGHT>$hit</TD><TD ALIGN=RIGHT>$clk</TD><TD ALIGN=RIGHT>$yld</TD></TR>\n";
		}
		$day++;
		if ($day > $endMonth) {
			$day = 1; $mon++;
			if ($mon > 12) {
				$mon = 1; $year++;
			}
			$endMonth = &daysInMonth($mon, $year);
		}
	}

	if ($ctr > 1) {
		$yld = ($sumHit > 0) ? sprintf("%0.2f%%",($sumClk / $sumHit * 100)) : '0.0%';
		$clk = fmtNumber($sumClk);
		$hit = fmtNumber($sumHit);
		$color = ($color) ? '' : $adcafeTblAltColor;
		print STDOUT "<TR VALIGN=TOP$color><TD><B>Total</B></TD><TD ALIGN=RIGHT>$hit</TD><TD ALIGN=RIGHT>$clk</TD><TD ALIGN=RIGHT>$yld</TD></TR>\n";
		$sumClk = $sumClk / $ctr;  $sumHit = $sumHit / $ctr;
		$yld = ($sumHit > 0) ? sprintf("%0.2f%%",($sumClk / $sumHit * 100)) : '0.0%';
		$clk = fmtNumber(int($sumClk + 0.5));
		$hit = fmtNumber(int($sumHit + 0.5));
		$color = ($color) ? '' : $adcafeTblAltColor;
		print STDOUT "<TR VALIGN=TOP$color><TD>Average</TD><TD ALIGN=RIGHT>$hit</TD><TD ALIGN=RIGHT>$clk</TD><TD ALIGN=RIGHT>$yld</TD></TR>\n";
	}

	unless ($input{'lgn'} eq $adcafeLoginSiteCd || $input{'lgn'} eq $adcafeLoginAdminStatCd) {
		if ($ctr > 1) {
			print STDOUT "<TR VALIGN=TOP><TD COLSPAN=4><HR></TD></TR>\n";
		}
		my $totHit = $adInfo{'tothit'};  my $totClk = $adInfo{'totclk'};
		$yld = ($totHit > 0) ? sprintf("%0.2f%%",($totClk / $totHit * 100)) : '0.0%';
		$clk = fmtNumber($totClk);
		$hit = fmtNumber($totHit);
		print STDOUT "<TR VALIGN=TOP><TD><B>Ad Total</B></TD><TD ALIGN=RIGHT>$hit</TD><TD ALIGN=RIGHT>$clk</TD><TD ALIGN=RIGHT>$yld</TD></TR></TABLE>\n";

		if ($input{'lgn'} eq $adcafeLoginGroupCd) {
			&dspAdGrpStatus;
		} else {
			&dspAdStatus($sumHit, $sumClk);
		}
	} else {
		print STDOUT "</TABLE>\n";
	}

	return '';
}

sub dspAdStatus
{
	my $sumHit = shift;  my $sumClk = shift;
	my %cdDesc = ('R'=>'Running', 'E'=>'Expired', 'P'=>'Part Expired', 'S'=>'Scheduled');
	my $adCd = $adInfo{'cd'};
	my $status = ($cdDesc{$adCd}) ? $cdDesc{$adCd} : "Invalid: $adCd";
	print STDOUT "<TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>\n";
	print STDOUT "<TR><TD>Ad Start Date: $adInfo{'begin'}</TD><TD>Status: $status</TD></TR>\n";
	my ($adExp, $adLeft) = &whenToStop($sumHit, $sumClk);
	if ($adCd eq 'E') {
		$adLeft = 'Completed';
	}
	print STDOUT "<TR><TD>Stop When: $adExp</TD><TD>$adLeft</TD></TR></TABLE>\n";

}

sub dspAdGrpStatus
{
	my @ids = split(/\,/, $adInfo{'__ads'});

	my $dateFlds = "&smon=$input{'smon'}&sday=$input{'sday'}&syear=$input{'syear'}&emon=$input{'emon'}&eday=$input{'eday'}&eyear=$input{'eyear'}";

	print STDOUT "<P><CENTER><B>Individual Ads in Group</B></FONT></CENTER>\n";
	print STDOUT "<P><TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>\n";
	print STDOUT "<TR$adcafeHdrTblColor><TD><BR><B>Ad Status</B></TD><TD COLSPAN=2 ALIGN=RIGHT><BR><B>Impressions</B></TD><TD ALIGN=RIGHT><B>Click<BR>Thrus</B></TD><TD ALIGN=RIGHT><BR><B>Yield</B></TD><TD>&nbsp;</TD></TR>\n";
	my ($errMsg, $hit, $clk, $yld, $color, $adExp, $adLeft, $adCd, $status);
	my %cdDesc = ('R'=>'Running', 'E'=>'Expired', 'P'=>'Part Expired', 'S'=>'Scheduled');
	while ($id = shift @ids) {
		$errMsg .= &loadAdInfo($id);
		$adCd = $adInfo{'cd'};
		$status = ($cdDesc{$adCd}) ? $cdDesc{$adCd} : "Invalid: $adCd";
		($hit,$clk) = split(/\|/, $tots{$id});
		$yld = ($hit > 0) ? sprintf("%0.2f%%",($clk / $hit * 100)) : '0.0%';
		$clk = fmtNumber(int($clk + 0.5));
		$hit = fmtNumber(int($hit + 0.5));
		print STDOUT "<TR VALIGN=TOP$color><TD>$adInfo{'name'}</TD><TD>Average</TD><TD ALIGN=RIGHT>$hit</TD><TD ALIGN=RIGHT>$clk</TD><TD ALIGN=RIGHT>$yld</TD>\n";
		print STDOUT "<TD ALIGN=RIGHT><A HREF=\"$adcafeUrlCgi$cgiStats\?id=$id&lgn=y$dateFlds\" onMouseOver=\"window.status=\'$adcafeUrlCgi$cgiStats\'; return true\"><B>Show</B></A></TD></TR>\n";
		if ($adInfo{$id}) {
			($adInfo{'tothit'}, $adInfo{'totclk'}) = split(/\|/, $adInfo{$id});
		}
		my ($adExp, $adLeft) = &whenToStop($hit, $clk);
		if ($adInfo{'cd'} eq 'E') {
			$adLeft = 'Completed';
		}
		$yld = ($adInfo{'tothit'} > 0) ? sprintf("%0.2f%%",($adInfo{'totclk'} / $adInfo{'tothit'} * 100)) : '0.0%';
		$clk = fmtNumber($adInfo{'totclk'});
		$hit = fmtNumber($adInfo{'tothit'});
		print STDOUT "<TR VALIGN=TOP$color><TD>$id: $status - Begin $adInfo{'begin'}<BR>$adExp: $adLeft</TD><TD>Total</TD><TD ALIGN=RIGHT>$hit</TD><TD ALIGN=RIGHT>$clk</TD><TD ALIGN=RIGHT>$yld</TD><TD>&nbsp;</TD></TR>\n";
		$color = ($color) ? '' : $adcafeTblAltColor;
	}
	print STDOUT "</TABLE>\n";
}

sub loadAdInfo
{
	my $id = shift;
	my $file = "$adcafeDirData$id\.ad";
	unless (-e $file) {
		return "<FONT $adcafeFontErrColor><B>Could not open $file</B></FONT><BR>";
	}

	open(AD, $file);
	<AD>; <AD>; <AD>; <AD>;
	my $data = <AD>; chop($data);
	$adInfo{'name'} = $data;
	<AD>; <AD>;
	$data = <AD>; chop($data);
	$adInfo{'begin'} = $data;
	close(AD);

	$file = "$adcafeDirTotals$id\.ctr";
	unless (-e $file) {
		return "<FONT $adcafeFontErrColor><B>Could not open $file</B></FONT><BR>";
	}

	my ($adCd, $adExp, $totHit, $totClk);
	open(ADCTR, $file);
	$_ = <ADCTR>;  chop($_);
	($totHit, $totClk) = split(/\|/, $_);
	$adInfo{'tothit'} = $totHit;
	$adInfo{'totclk'} = $totClk;
	$_ = <ADCTR>;  chop($_);
	close(ADCTR);
	($adExp, $adCd) = split(/\|/, $_);
	$adInfo{'exp'} = $adExp;
	if ($adCd =~ /^S/) { $adCd = 'S'; }
	$adInfo{'cd'} = $adCd;

	return '';
}

sub loadGroup
{
	my $id = $input{'id'};
	my $fileGrps = "${adcafeDirData}adgroup\.cfg";
	my $name = "$fileGrps not found";  my $ads = '';
	if (-e $fileGrps) {
		open(GRPCFG,"$fileGrps");
		my ($group, $tmp);
		while (<GRPCFG>) {
			chop($_);
			($group, $name, $tmp, $ads) = split(/\|/,$_);
			last if $group eq $id;
		}
		unless ($group eq $id) {
			$name = "Group $id not found";
			$ads = '';
		}
		close(GRPCFG);
	}

	return ($name, $ads);
}

sub loadSite
{
	my $id = $input{'id'};
	my ($name, $site, $tmp);
	my $file = "${adcafeDirData}adcafe\.cfg";
	if (-e $file) {
		open(SITE, $file);
		while (<SITE>) {
			chop;
			($site, $tmp) = split(/\=/, $_);
			if ($site eq $id) {
				($name) = split(/\|/, $tmp);
				last;
			}
		}
		close(SITE);
	}

	return $name;
}

sub whenToStop
{
	my $avgHit = shift;
	my $avgClk = shift;
	my $adExp = $adInfo{'exp'};
	my $totHit = $adInfo{'tothit'};
	my $totClk = $adInfo{'totclk'};
	my ($msg, $num, $left);
	if ($adExp =~ /^A/) {
		$msg = 'Never Expires';
		$left = 'Perpetually Runs';
	} elsif ($adExp =~ /^H(\d+)/) {
		$num = fmtNumber($1);
		$msg = "$num Hits";
		$left = &pctComplete($totHit, $1, $avgHit);
	} elsif ($adExp =~ /^C(\d+)/) {
		$num = fmtNumber($1);
		$msg = "$num ClickThrus";
		$left = &pctComplete($totClk, $1, $avgClk);
	} elsif ($adExp =~ /^D(\d\d\d\d)(\d\d)(\d\d)/) {
		$msg = "$2/$3/$1";
		$num = &dayDiff($2, $3, $1);
		if ($num < 0) { 
			$left = 'Exp: ???';
		} else {
			$left = "Expires: ";
			if ($num > 0) {
				$num = fmtNumber($num);
				$left .= "in $num Days";
			} else {
				$left .= "Today";
			}
		}
	}

	return ($msg, $left);
}

sub pctComplete
{
	my $cur = shift;
	my $max = shift;
	my $day = shift;

	my $msg = '100% Complete';
	my $num = $max - $cur;
	if ($num > 0) {
		my $pct = int(($cur / $max * 100) + 0.5);
		$msg = "$pct\% Complete";
		if ($day > 0) {
			$num = (int($num / $day)) + 1;
			$msg .= ' (Exp: ';
			if ($num > 0) {
				$num = fmtNumber($num);
				$msg .= "$num Days)";
			} else {
				$msg .= 'Today)';
			}
		}
	}
}

sub setupDates
{
	my $errMsg = '';
	if ($input{'sday'}) {
		$errMsg = &invDate($input{'sday'}, $input{'smon'}, $input{'syear'});
		if (length($errMsg) < 1) {
			if ($input{'eday'}) {
				$errMsg = &invDate($input{'eday'}, $input{'emon'}, $input{'eyear'});
				if (length($errMsg) < 1) {
					if (&cmpDate($input{'smon'}, $input{'sday'}, $input{'syear'},
								 $input{'emon'}, $input{'eday'}, $input{'eyear'}) > 0) {
						$errMsg = "Starting Date $input{'smon'}/$input{'sday'}/$input{'syear'}";
						$errMsg .= " exceeds Ending Date $input{'emon'}/$input{'eday'}/$input{'eyear'}";
					}
				}
			} else {
				$errMsg = "No ending day entered";
			}
		}
	} else {
		my ($day, $mon, $year);
		($day, $mon, $year) = (localtime(time))[3,4,5];
		$year += 1900; $mon++;
		if ($cgiStats eq 'adcafe_statads.cgi') {	# batch so start with yesterday
			$day--;
			if ($day < 1) {
				$mon--;
				if ($mon == 0) {
					$mon = 12; $year--;
				}
				$day = &daysInMonth($mon, $year);
			}
		}
		$input{'emon'} = $mon;  $input{'eday'} = $day;  $input{'eyear'} = $year;
		if ($adcafeStatDays > 1) {
			$day -= $adcafeStatDays;  $day++;
			while ($day < 1) {
				$mon--;
				if ($mon == 0) {
					$mon = 12; $year--;
				}
				$day += &daysInMonth($mon, $year);
			}
		}
		$input{'smon'} = $mon;  $input{'sday'} = $day;  $input{'syear'} = $year;
	}

	return $errMsg;
}

sub invDate
{
	my $inDay = shift;
	my $inMon = shift;
	my $inYr = shift;
	my ($day, $mon, $year);
	($day, $mon, $year) = (localtime(time))[3,4,5];
	$year += 1900; $mon++;
	if ($inYr > $year) {
		return "Year exceeds current year: $inYr";
	} elsif ($inYr == $year && $inMon > $mon) {
		return "Month exceeds current date: $inMon";
	} elsif ($inYr == $year && $inMon == $mon && $inDay > $day) {
		return "Date exceeds current date: $inMon/$inDay/$inYr";
	} else {
		if ($mon < 1 || $mon > 12) {
			return "Invalid month: $inMon";
		}
		my $end = &daysInMonth($inMon, $inYr);
		if ($inDay < 1 || $inDay > $end) {
			return "Invalid day: $inDay";
		}
	}
	return '';
}

sub htmlStart
{
	my $title = "AdCafe Totals";
	&htmlHeader($title);
}

sub htmlEnd
{
	my $errMsg = shift;
	my $hdgMsg = '';
	if (length($errMsg) > 0) {
		$errMsg = "<FONT $adcafeFontErrColor><B>$errMsg</B></FONT>";
	} else {
		$hdgMsg = "<B>More Ad Totals</B>";
		$errMsg = '<HR>';
	}
	my ($day, $mon, $year);
	($day, $mon, $year) = (localtime(time))[3,4,5];
	$mon++;  $year += 1900;
	$maxYear = $year + 1;
	my ($ix, $sel, $begMons, $endMons, $begYrs, $endYrs);
	my @monthsName = ('', 'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');	# make 1 relative
	if ($input{'smon'} > 0 && 	$input{'smon'} < 13) {
		$mon = $input{'smon'};
	} else {
		$input{'smon'} = $mon;  $input{'sday'} = $day;  $input{'syear'} = $year;
	}
	for ($ix = 1; $ix < 13; $ix++) {
		$sel = ($mon == $ix) ? ' SELECTED' : '';
		$begMons .= "<OPTION VALUE=\"$ix\"$sel>$monthsName[$ix]\n";
	}

	if ($input{'emon'} > 0 && 	$input{'emon'} < 13) {
		$mon = $input{'emon'};
		for ($ix = 1; $ix < 13; $ix++) {
			$sel = ($mon == $ix) ? ' SELECTED' : '';
			$endMons .= "<OPTION VALUE=\"$ix\"$sel>$monthsName[$ix]\n";
		}
	} else {
		$endMons = $begMons;
		$input{'emon'} = $mon;  $input{'eday'} = $day;  $input{'eyear'} = $year;
	}

	$year = $input{'syear'};
	for ($ix = 1997; $ix < $maxYear; $ix++) {
		$sel = ($year == $ix) ? ' SELECTED' : '';
		$begYrs .= "<OPTION VALUE=\"$ix\"$sel>$ix\n";
	}
	$year = $input{'eyear'};
	for ($ix = 1997; $ix < $maxYear; $ix++) {
		$sel = ($year == $ix) ? ' SELECTED' : '';
		$endYrs .= "<OPTION VALUE=\"$ix\"$sel>$ix\n";
	}

	print STDOUT <<EOT;
$errMsg
<CENTER><FORM ACTION="$cgiStats" METHOD=POST>
$hdgMsg
<INPUT TYPE=HIDDEN NAME=id VALUE="$input{'id'}">
<INPUT TYPE=HIDDEN NAME=lgn VALUE="$input{'lgn'}">
<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=5 WIDTH=90%>
<TR><TD>Starting Date</TD>
<TD><INPUT TYPE=TEXT NAME=sday SIZE=4 VALUE="$input{'sday'}">
&nbsp;&nbsp;<SELECT NAME=smon SIZE=1>
$begMons
</SELECT>
&nbsp;&nbsp;<SELECT NAME=syear SIZE=1>
$begYrs
</SELECT>
</TD></TR>
<TR><TD>Ending Date</TD>
<TD><INPUT TYPE=TEXT NAME=eday SIZE=4 VALUE="$input{'eday'}">
&nbsp;&nbsp;<SELECT NAME=emon SIZE=1>
$endMons
</SELECT>
&nbsp;&nbsp;<SELECT NAME=eyear SIZE=1>
$endYrs
</SELECT>
</TD></TR></TABLE>
<P><INPUT TYPE="submit" VALUE=" Submit ">
</FORM></CENTER>
<P><CENTER>
<A STYLE="text-decoration: none" HREF="${adcafeUrlCgi}adcafe_login.cgi" style=\"$adcafeLinkColor\"><B>&nbsp; Sponsor Login &nbsp;</B></a>
</CENTER>
EOT

	&htmlFooter;
}

	return 1;	# force true return
