#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - Advertiser management system
# Copyright (c) 1998 Infohiway
#
# Stats for individual account
#
# adcafe_stats.cgi
#
# ==========================================================================

require 'adcafe_cfg.cgi';
require 'adcafe_dates.cgi';
require 'adcafe_gui.cgi';
require 'adcafe_statsubs.cgi';

MAIN:
{ 
	&getInput;
	$| = 1;
	unless ($input{'id'}) {
		print STDOUT "Location: ${adcafeUrlCgi}adcafe_login.cgi?rt=s\n\n";	# sponsor login
		exit;
	}
	unless (&okToRun($input{'lgn'}, $input{'id'})) {
		print STDOUT "Location: ${adcafeUrlCgi}adcafe_login.cgi?rt=s\n\n";	# sponsor login
		exit;
	}
	$cgiStats = 'adcafe_stats.cgi';
	my $errMsg = &setupDates;
	&htmlStart;
	unless (length($errMsg) > 0) {
		$errMsg = &dspAdTotals;
	}

	&htmlEnd($errMsg);
	exit;
}

sub loadTotals
{
	my $mon = $input{'smon'};  my $day = $input{'sday'};  my $year = $input{'syear'};
	my $monEnd = $input{'emon'};  my $dayEnd = $input{'eday'};  my $yearEnd = $input{'eyear'};
	my $endMonth = &daysInMonth($mon, $year);
	my ($key, $file, $hit, $clk, $id, @ids, $totHit, $totClk, $totCd);

	%tots = ();    my %adId = ();
	my $errMsg = '';
	if ($input{'lgn'} eq $adcafeLoginGroupCd) {
		my ($name, $ads) = &loadGroup;
		$adInfo{'name'} = $name;
		$adInfo{'__ads'} = $ads;
		$adInfo{'tothit'} = 0;  $adInfo{'totclk'} = 0;
		my @ids = split(/\,/, $ads);
		grep($adId{$_}++, @ids);
	} elsif ($input{'lgn'} eq $adcafeLoginSiteCd) {
		$adInfo{'name'} = &loadSite;
		$adId{$input{'id'}}++;
	} elsif ($input{'lgn'} eq $adcafeLoginAdminStatCd) {
		$adInfo{'name'} = $adCafeServer;
		$adId{$adcafeTotId}++;
	} else {
		$errMsg = &loadAdInfo($input{'id'});
		$adId{$input{'id'}}++;
	}

	my (%hits, %clks);
	while ($year < $yearEnd || ($year == $yearEnd && $mon < $monEnd) || ($year == $yearEnd && $mon == $monEnd && $day <= $dayEnd)) {
		$key = sprintf("%04d%02d%02d", $year, $mon, $day);
		$file = "${adcafeDirTotals}adcafe$key\.ctr";
		$totHit = 0;  $totClk = 0;
		if (-e $file) {
			open(CTR,$file);
			$_ = <CTR>;	# grand totals
			chop if $_ =~ /\n$/;
			if ($adId{$adcafeTotId}) {
				($hit, $clk) = split(/,/, $_, 2);
				if ($hit > 0 || $clk > 0) {
					$totHit += $hit;  $totClk += $clk;
					$hits{$adcafeTotId} += $hit;  $clks{$adcafeTotId} = $clk;
					$adId{$adcafeTotId}++;
				}
			}
			while(<CTR>) {
				chop if $_ =~ /\n$/;

				($id, $hit, $clk) = split(/,/, $_, 3);
				if ($adId{$id}) {
					if ($hit > 0) {
						$totHit += $hit;  $totClk += $clk;
						$hits{$id} += $hit;  $clks{$id} = $clk;
						$adId{$id}++;
					}
				}
			}
			close(CTR);
		}
		$tots{$key} = "$totHit\|$totClk";
		$day++;
		if ($day > $endMonth) {
			$day = 1; $mon++;
			if ($mon > 12) {
				$mon = 1; $year++;
			}
			$endMonth = &daysInMonth($mon, $year);
		}
	}
	while(($key, $hit)=each(%hits)) {
		if ($input{'lgn'} eq $adcafeLoginGroupCd) {
			&loadAdTot($key);
		}
		if ($adId{$key} > 1) {
			$day = $adId{$key} - 1;
			$clk = $clks{$key} / $day;  $hit = $hits{$key} / $day;
			$tots{$key} = "$hit\|$clk";
		}
	}
}

sub loadAdTot
{
	my $id = shift;
	my $file = "$adcafeDirTotals$id\.ctr";
	if (-e $file) {
		open(ADCTR, $file);
		$_ = <ADCTR>;  chop($_);
		my ($totHit, $totClk) = split(/\|/, $_);
		$adInfo{'tothit'} += $totHit;
		$adInfo{'totclk'} += $totClk;
		close(ADCTR);
	}
}
