#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - Advertiser management system
# Copyright (c) 1998 Infohiway
#
# Stats for individual account
#
# adcafe_statads.cgi
#
# ==========================================================================

require 'adcafe_cfg.cgi';
require 'adcafe_dates.cgi';
require 'adcafe_gui.cgi';
require 'adcafe_security.cgi';
require 'adcafe_statsubs.cgi';

MAIN:
{ 
	&getInput;
	$| = 1;
	unless ($input{'id'}) {
		print STDOUT "Location: ${adcafeUrlCgi}adcafe_login.cgi?rt=s\n\n";	# sponsor login
		exit;
	}
	my $id = ($input{'id'} eq $adcafeTotId) ? $adcafeAdminId : $input{'id'};

	unless (&okToRun($input{'lgn'}, $id)) {
		print STDOUT "Location: ${adcafeUrlCgi}adcafe_login.cgi?rt=s\n\n";	# sponsor login
		exit;
	}
	$cgiStats = 'adcafe_statads.cgi';
	my $errMsg = &setupDates;
	&htmlStart;
	unless (length($errMsg) > 0) {
		$errMsg = &dspAdTotals;
	}

	&htmlEnd($errMsg);
	if ($flagOpen eq 't') {
		dbmclose(%tots);
	}
	exit;

}

sub loadTotals
{
	my $errMsg = '';
	if ($input{'lgn'} eq $adcafeLoginGroupCd) {
		$errMsg = &loadGrpTotals;
	} elsif ($input{'lgn'} eq $adcafeLoginSiteCd) {
		$adInfo{'name'} = &loadSite;
		dbmopen(%tots,"${adcafeDirTotals}$input{'id'}",0666);
		my ($totHit, $totClk) = split(/\|/, $tots{'tot'});
		$adInfo{'tothit'} = $totHit;
		$adInfo{'totclk'} = $totClk;
		$flagOpen = 't';
	} elsif ($input{'lgn'} eq $adcafeLoginAdminStatCd) {
		$adInfo{'name'} = $adCafeServer;
		dbmopen(%tots,"${adcafeDirTotals}$adcafeTotId",0666);
		my ($totHit, $totClk) = split(/\|/, $tots{'tot'});
		$adInfo{'tothit'} = $totHit;
		$adInfo{'totclk'} = $totClk;
		$flagOpen = 't';
	} else {
		$errMsg = &loadAdInfo($input{'id'});
		dbmopen(%tots,"${adcafeDirTotals}$input{'id'}",0666);
		my ($totHit, $totClk) = split(/\|/, $tots{'tot'});
		$adInfo{'tothit'} = $totHit;
		$adInfo{'totclk'} = $totClk;
		$flagOpen = 't';
	}

	return $errMsg;
}

sub loadGrpTotals
{
	my ($name, $ads) = &loadGroup;

	my $monEnd = $input{'emon'};  my $dayEnd = $input{'eday'};  my $yearEnd = $input{'eyear'};
	my ($key, $hit, $clk, $ctr, $id, $mon, $day, $year, $endMonth);
	my $totHit = 0; my $totClk = 0;  my $totCtr = 0;
	my $errMsg = '';  my $totCd = '';
	my @ids = split(/\,/, $ads);
	$adInfo{'__ads'} = $ads;
	$adInfo{'name'} = $name;

	my (%hits, %clks);
	while ($id = shift @ids) {
		my %adtots = ();
		dbmopen(%adtots,"${adcafeDirTotals}$id",0666);
		($hit, $clk, $ctr) = split(/\|/, $adtots{'tot'}, 3);
		$adInfo{$id} = "$hit\|$clk";
		$totHit += $hit;  $totClk += $clk;  $totCtr = ($ctr > $totCtr) ? $ctr : $totCtr;
		$mon = $input{'smon'};  $day = $input{'sday'};  $year = $input{'syear'};
		$endMonth = &daysInMonth($mon, $year);

		my $adHit = 0; my $adClk = 0;  my $adCtr = 0;
		while ($year < $yearEnd || ($year == $yearEnd && $mon < $monEnd) || ($year == $yearEnd && $mon == $monEnd && $day <= $dayEnd)) {
			$key = sprintf("%04d%02d%02d", $year, $mon, $day);
			($hit,$clk) = split(/\|/, $adtots{$key});
			if ($hit > 0 || $clk > 0) {
				$hits{$key} += $hit;  $clks{$key} += $clk;
				$adHit += $hit;  $adClk += $clk;  $adCtr++;
			}
			$day++;
			if ($day > $endMonth) {
				$day = 1; $mon++;
				if ($mon > 12) {
					$mon = 1; $year++;
				}
				$endMonth = &daysInMonth($mon, $year);
			}
		}
		dbmclose(%adtots);
		if ($adCtr > 0) {
			$adClk = $adClk / $adCtr;  $adHit = $adHit / $adCtr;
			$hits{$id} = $adHit;  $clks{$id} = $adClk;
		}
	}
	$tots{'tot'} = "$totHit\|$totClk\|$totCtr";
	$adInfo{'tothit'} = $totHit;
	$adInfo{'totclk'} = $totClk;
	while(($key, $hit)=each(%hits)) {
		$tots{$key} = "$hit\|$clks{$key}";
	}
}
