#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - Advertiser management system
# Copyright (c) 1998 Infohiway
#
# Maintenance for ad sites
#
# adcafe_sites.cgi
#
# ==========================================================================

require 'adcafe_cfg.cgi';
require 'adcafe_gui.cgi';
require 'adcafe_lock.cgi';
require 'adcafe_security.cgi';

MAIN:
{ 
	&getInput;
	$| = 1;
	unless (&okToRun($adcafeLoginAdminCd, $adcafeAdminId)) {
		print STDOUT "Location: ${adcafeUrlCgi}adcafe_login.cgi?rt=sm&a=$input{'a'}\n\n";	# sponsor login
		exit;
	}
	my $siteId = $input{'id'};
	my $action = $input{'a'};
	if ($input{'doit'}) {	# update 
		my $errFlag = &updateSites;
		&htmlNext($errFlag);
	} elsif ($input{'can'}) {	# cancel update
		&htmlNext();
	} else {
		&htmlStart($action);
		if ($action eq 'd') {	# delete
			&htmlDelete($siteId);
		} elsif ($action eq 'e') {	# edit
			&htmlEdit($siteId);
		} else {
			&htmlAdd;
		}
		&htmlEnd;
	}

	exit;
}

sub htmlEdit
{
	my $siteId = shift;
	&htmlData($siteId);
}

sub htmlAdd
{
	my $siteId = shift;
	&htmlData($siteId);
}

sub htmlData
{
	my $siteId = shift;
	my ($siteName, $sitePswd) = &loadSite($siteId);
	my ($butSubmit, $butCancel, $action, $siteIdData);
	if ($input{'a'} eq 'e') {
		$butSubmit = 'Update Site';
		$butCancel = ' Cancel Update ';
		$action = 'e';
		$siteIdData = "<B>$siteId</B><INPUT TYPE=HIDDEN NAME=id VALUE=\"$siteId\">";
	} else {
		$butCancel = ' Cancel Add ';
		$butSubmit = 'Add New Site';
		$action = 'a';
		$siteIdData = "<INPUT TYPE=TEXT NAME=id VALUE=\"$siteId\">";
	}

	print STDOUT <<EOT;
<P><CENTER><FORM METHOD=POST ACTION="${adcafeUrlCgi}adcafe_sites.cgi">
<TABLE CELLPADDING=3 BORDER=0 WIDTH=100%><TR><TD>
<INPUT TYPE=HIDDEN NAME=a VALUE="$action">
<INPUT TYPE=HIDDEN NAME=db VALUE="s">
Site ID:</TD><TD>$siteIdData</TD></TR>
<TR><TD>Site Name</TD><TD><INPUT TYPE=TEXT SIZE=35 NAME=name VALUE="$siteName"></TD></TR>
<TR><TD>Site Password</TD><TD><INPUT TYPE=TEXT SIZE=25 NAME=pswd VALUE="$sitePswd"></TD></TR>
<TR><TD COLSPAN=2 ALIGN=CENTER><P><HR SIZE=1>
<INPUT TYPE=SUBMIT NAME=doit VALUE="$butSubmit">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
<INPUT TYPE=SUBMIT NAME=can VALUE="$butCancel">
</TD></TR></TABLE></FORM></CENTER>
EOT

}

sub htmlDelete
{
	my $siteId = shift;
	my ($siteName, $sitePswd) = &loadSite($siteId);
	my $siteAds = &loadSiteAds($siteId);

	print STDOUT <<EOT;
<CENTER><B>Are you sure you want to delete this site:</B>
<P><TABLE CELLPADDING=3>
<TR><TD ALIGN=CENTER COLSPAN=2><B>$siteId</B>&nbsp;=&nbsp;<B>$siteName</B></TD></TR>
</TABLE><HR SIZE=1>
<P><FORM METHOD=POST ACTION=\"${adcafeUrlCgi}adcafe_sites.cgi\">
<TABLE CELLPADDING=3><TR><TD ALIGN=CENTER>
<INPUT TYPE=HIDDEN NAME=a VALUE="d">
<INPUT TYPE=HIDDEN NAME=db VALUE="s">
<INPUT TYPE=HIDDEN NAME=id VALUE=\"$siteId\">
<INPUT TYPE=HIDDEN NAME=name VALUE=\"$siteName\">
<INPUT TYPE=HIDDEN NAME=pswd VALUE=\"$sitePswd\">
<INPUT TYPE=SUBMIT NAME=doit VALUE="Delete Site">
</TD><TD ALIGN=CENTER><INPUT TYPE=SUBMIT NAME=can VALUE=" Cancel Delete ">
</TD></TR></TABLE></FORM></CENTER>
EOT

}

sub loadSite
{
	my $siteId = shift;
	my ($siteName, $sitePswd);
	if ($input{'doit'}) {
		$siteName = $input{'name'};
		$sitePswd = $input{'pswd'};
	} else {
		my $fileSite = "${adcafeDirData}adcafe\.cfg";
		if (-e $fileSite) {
			open(SITE, $fileSite);
			my @sites = <SITE>;
			close(SITE);
			my ($site, $id, $name);
			while ($site = shift @sites) {
				chop($site) if $site =~ /\n$/;
				($id, $name) = split(/\=/, $site);
				if ($siteId eq $id) {
					($siteName, $sitePswd) = split(/\|/, $name);
					last;
				}
			}
		}
	}

	return ($siteName, $sitePswd);
}

sub loadSiteAds
{
	my $siteId = shift;
	my $fileSite = "${adcafeDirData}adsite$siteId\.cfg";
	my $adList;
	if (-e $fileSite) {
		open(SITE, $fileSite);
		<SITE>;	#eat ctr rec
		$adList = "<TR><TD ALIGN=CENTER COLSPAN=2>The following ads are running on this site</TD></TR>\n";
		while (<SITE>) {
			chop if $_ =~ /\n$/;

			$adList .= "<TR><TD ALIGN=CENTER COLSPAN=2><B>$_</B></TD></TR>\n";
		}
		close(SITE);
	} else {
		$adList = "<TR><TD ALIGN=CENTER COLSPAN=2><B>No ads are currently running on this site!</B><P></TD></TR>\n";
	}

	return $adList;
}

sub validateInput
{
	my $site = $input{'id'};
	my $action = $input{'a'};
	my ($tmp, $errMsg);
	unless (&validId($site)) {
		return "Id <B>\($site\)</B> must contain only letters and digits<BR>";
	}

	if ($action eq 'e') {	# edit
		unless ($siteInfo{$site}) {
			$errMsg = "Could not find $site - choose an existing site to edit<BR>";
		}
	} elsif ($action eq 'd') {	# delete
		unless ($siteInfo{$site}) {
			$errMsg = "Could not find $site - choose an existing site to delete<BR>";
		}
	} else {	# add
		$errMsg = &uniqueId($site);
	}

	if ($action ne 'd') {
		my %flds = ('id'=>'Site id', 'name'=>'Site name', 'pswd'=>'Site Password');
		my @flds = keys %flds;
		while ($tmp = shift @flds) {
			unless (length($input{$tmp}) > 0) {
				$errMsg .= "$flds{$tmp} not entered<BR>";
			}
			if ($input{$tmp} =~ /[=;><&\*'\|]/) {
				$errMsg .= "$flds{$tmp} can not include these characters: \"=;><&*'|\"<BR>";
			}
		}
	}

	return $errMsg;
}

sub updateSites
{
	my $errFlag = '';
	my $fileCfg = "${adcafeDirData}adcafe\.cfg";
	if (&fileLock($fileCfg, \*LCFG)) {
		&loadAllSites;
		my $errMsg = &validateInput;
		if (length($errMsg) > 0) {
			&htmlError($errMsg);
			$errFlag = 1;
		} else {
			my $fileSite = "${adcafeDirData}adsite$siteId\.cfg";
			if (-e $fileCfg) {
				open(CFG,">$fileCfg");
				my @site = keys %siteInfo;
				my ($site, $name);
				my $id = $input{'id'};
				my $action = $input{'a'};
				while ($site = shift @site) {
					if ($site eq $id) {
						if ($action ne 'd') {	# edit
							print CFG "$id\=$input{'name'}\|$input{'pswd'}\n";
						} else {	# delete
							unlink $fileSite;				
						}
					} else {
						print CFG "$site\=$siteInfo{$site}\n";
					}
				}
				# add or edit with new id
				if ($action eq 'a') {
					print CFG "$id\=$input{'name'}\|$input{'pswd'}\n";
				}
				close(CFG);
			} else {
				&htmlError("Fatal Error: Could not find $fileCfg");
				$errFlag = 1;
			}
		}
		&fileUnlock($fileCfg, \*LCFG);
	} else {
		&logEvent(6, "Rtn=sites\|File=adcafe.cfg\|Site=$siteId");
		&htmlError("Fatal Error: Could not update $fileCfg");
		$errFlag = 1;
	}

	return $errFlag;
}

sub htmlNext
{
	my $err = shift;
	if ($err) {
		my $site = $input{'id'};
		my $action = $input{'a'};
		if ($action eq 'd') {	# delete
			&htmlDelete($site);
		} elsif ($action eq 'e') {	# edit
			&htmlEdit($site);
		} else {
			&htmlAdd($site);
		}
		&htmlEnd;
	} else {
		print STDOUT "Location: ${adcafeUrlCgi}adcafe_admin.cgi\n\n";	# admin stats
	}
}

sub htmlError
{
	my $msg = shift;
	&htmlStart($input{'a'});
	$msg = "<FONT SIZE=+1 $adcafeFontErrColor>Input Errors</FONT><BR><FONT $adcafeFontErrColor>$msg</FONT><HR SIZE=1>";
	print STDOUT $msg;
}


sub htmlStart
{
	my $action = shift;
	my %descAction = ('d'=>'Deletion',	'e'=>'Edit', 'a'=>'Add', ''=>'Add');
	my $title = "AdCafe Site $descAction{$action}";
	&htmlHeader($title);
}

sub htmlEnd
{
	print STDOUT '<P><CENTER>';
	if ($adcafeTotalCd ne 'a') {	# live totals
		my $dsc = ($adcafeTotalCd eq 'b') ? 'Live Totals' : 'Totals';
		print STDOUT "<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_totals.cgi\" style=\"$adcafeLinkColor\"><B>&nbsp; $dsc &nbsp;</B></a>&#0124;";
	}
	if ($adcafeTotalCd ne 'd') {	# batch totals
		my $dsc = ($adcafeTotalCd eq 'b') ? 'Batch Totals' : 'Totals';
		print STDOUT "<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_tots.cgi\" style=\"$adcafeLinkColor\"><B>&nbsp; $dsc &nbsp;</B></a>&#0124;";
	}

	print STDOUT <<EOT; 
<A STYLE="text-decoration: none" HREF="${adcafeUrlCgi}adcafe_daily.cgi" style="$adcafeLinkColor"><B>&nbsp; Daily Snapshot &nbsp;</B></a>&#0124;
<A STYLE="text-decoration: none" HREF="${adcafeUrlCgi}adcafe_all.cgi?site=$input{'id'}" style=\"$adcafeLinkColor\" onMouseOver=\"window.status=\'${adcafeUrlCgi}adcafe_all.cgi\'; return true\"><B>&nbsp; View Ads on Site &nbsp;</B></a>&#0124;
<A STYLE="text-decoration: none" HREF="${adcafeUrlCgi}adcafe_admin.cgi" style=\"$adcafeLinkColor\"><B>&nbsp; Admin &nbsp;</B></a>&#0124;
<A STYLE="text-decoration: none" HREF="${adcafeUrlCgi}adcafe_login.cgi" style=\"$adcafeLinkColor\"><B>&nbsp; Sponsor Login &nbsp;</B></a>
</CENTER>
EOT

	&htmlFooter;
}
