#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - Advertiser management system
# Copyright (c) 1998 Infohiway
#
# Setup and test installation of adcafe
#
# adcafe_setup.cgi
#
# ==========================================================================

require 'adcafe_cfg.cgi';
require 'adcafe_gui.cgi';

MAIN:
{ 
	&getInput;
	$| = 1;
	if (length($input{'site'}) > 0) {
		&setupAdCafe;
	} else {
		&dspForm;
	}
	exit;
}

sub setupAdCafe
{
	my $file = "${adcafeDirData}adcafe\.cfg";
	&htmlHeader('AdCafe Setup Test');

	print STDOUT "<CENTER><P><B>Test the setup of AdCafe on server</B><P></CENTER>";
	my $errCreate;
	if (-e $file) {
		print STDOUT "<BR>$file already has been created";
	} else {
		if (open(CFG, ">$file")) {
			print STDOUT "<BR>$file created";
			print CFG "1=$input{'site'}\|$input{'pswd'}\n";
			close(CFG);
		} else {
			print STDOUT "<BR>$file could not be created";
			$errCreate = 1;
		}
	}
	$file = "${adcafeDirData}adsite1\.cfg";
	if (-e $file) {
		print STDOUT "<BR>$file already has been created";
	} else {
		if (open(CFG, ">$file")) {
			print STDOUT "<BR>$file created";
			print CFG "0\|0\n";
			close(CFG);
		} else {
			print STDOUT "<BR>$file could not be created";
			$errCreate = 1;
		}
	}

	if ($errCreate > 0) {
		&errMsg;
	} else {
		&okMsg;
	}

	&htmlFooter;

}

sub okMsg
{
	print STDOUT <<EOT;
<CENTER><P><B>Data files successfully created</B>
<P><A HREF="${adcafeUrlCgi}adcafe_test.cgi"><B>Test Ad Delivery and Display AdCafe Info</B></A>
<P><A HREF="${adcafeUrlData}adcafe.htm"><B>Only Display AdCafe Info</B></A>
</CENTER>
EOT

}

sub errMsg
{
	print STDOUT <<EOT;
<P><B>Data files could not be created in: $adcafeDirData</B><BR>
This probably means that permissions on the directory or the cgi
script are not setup correctly.  The permissions need to allow
a browser client to create and update a data file.  Contact your
webmaster on what you need to do.
EOT

}

sub dspForm
{
	&htmlHeader('AdCafe Setup Test');

	print STDOUT <<EOT;
<P>
This page tests to see whether AdCafe has been installed correctly.  Enter
the name of your main advertising site.  If you do not have multiple sites,
enter the name of your server or company.  AdCafe forces you to have at least
one site.  It will automatically give it a site Id of 1.
<P><CENTER>
<FORM ACTION="${adcafeUrlCgi}adcafe_setup.cgi" METHOD=POST>
<TABLE BORDER=0 CELLSPACING=2 COLSPAN=3 WIDTH=500>
<TR><TD><B>Main Site Name</B></TD>
<TD WIDTH=50%><INPUT TYPE="text" NAME="site" SIZE=30 MAX=30 VALUE="$adCafeServer"</TD></TR>
<TR><TD><B>Site Password</B></TD>
<TD WIDTH=50%><INPUT TYPE="text" NAME="pswd" SIZE=25 MAX=25</TD></TR>
<TR><TD></TD><TD><INPUT TYPE="submit" VALUE=" Submit "></TD>
</TR></TABLE></FORM></CENTER>
EOT

	&htmlFooter;
}

