#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - Advertiser management system
# Copyright (c) 1998 Infohiway
#
# adcafe_security.cgi
#
# ==========================================================================

# The following variables are for AdCafe logins and passwords

	$adcafeLoginAdminCd = 'a';
	$adcafeLoginAdminTotCd = 't';
	$adcafeLoginAdminStatCd = 's';
	$adcafeLoginSiteCd = 'b';
	$adcafeLoginGroupCd = 'g';
	$adcafeLoginAdCd = 'y';
	$adcafeRelogTime = 36000;	# in seconds

sub okToRun
{
	my $code = shift;
	my $id = shift;
	my $user = $ENV{'REMOTE_ADDR'};
	$user =~ s/\./_/g;

	my $usrName = "${adcafeDirData}usr$user\.pwd";
	unless (-e $usrName) { return ''; }

	open(USR, $usrName);
	my $loginTime = <USR>;  chop($loginTime);
	my ($fCd, $fId);
	my $flag = '';
	my $skipCodes = "$adcafeLoginSiteCd$adcafeLoginGroupCd$adcafeLoginAdCd";
	my %okIf = (
		"$adcafeLoginAdminCd"=>"$skipCodes",
		"$adcafeLoginAdminTotCd"=>"$skipCodes",
		"$adcafeLoginAdminStatCd"=>"$skipCodes"
	);
	unless ((time - $loginTime) > $adcafeRelogTime) {
		while(<USR>) {
			chop;
			($fCd, $fId) = split(/\|/,$_);
			if ($fCd eq $code && $fId eq $id) {
				$flag = 't';  last;
			}
			if ($okIf{$fCd} =~ /$code/) {
				$flag = 't';  last;
			}
		}
	}
	close(USR);

	return $flag;
}
