#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - Advertiser management system
# Copyright (c) 1998 Infohiway
#
# Login to admin functions
#
# adcafe_login.cgi
#
# ==========================================================================

require 'adcafe_cfg.cgi';
require 'adcafe_gui.cgi';
require 'adcafe_security.cgi';

MAIN:
{ 
	&getInput;
	$| = 1;
	if ($input{'pswd'}) {
		my $isOk = &verifyLogin;
		if ($isOk eq $adcafeLoginAdminCd) {
			if ($input{'rt'} eq 'u') {
				print STDOUT "Location: ${adcafeUrlCgi}adcafe_sum.cgi\n\n";
			} elsif ($input{'rt'} eq 't') {
				&gotoTotals;
			} elsif ($input{'rt'} eq 's') {
				$input{'id'} = $adcafeTotId;
				&gotoStats($isOk);
			} elsif ($input{'rt'} eq 'd') {
				print STDOUT "Location: ${adcafeUrlCgi}adcafe_daily.cgi\n\n";	# daily totals
			} elsif ($input{'rt'} eq 'im') {
				print STDOUT "Location: ${adcafeUrlCgi}adcafe_inactive.cgi\n\n";	# admin functions
			} elsif ($input{'rt'} eq 'am') {
				print STDOUT "Location: ${adcafeUrlCgi}adcafe_ads.cgi?a=$input{'a'}&id=$input{'id'}\n\n";
			} elsif ($input{'rt'} eq 'gm') {
				print STDOUT "Location: ${adcafeUrlCgi}adcafe_grps.cgi?a=$input{'a'}&id=$input{'id'}\n\n";
			} elsif ($input{'rt'} eq 'sm') {
				print STDOUT "Location: ${adcafeUrlCgi}adcafe_sites.cgi?a=$input{'a'}&id=$input{'id'}\n\n";
			} else {
				print STDOUT "Location: ${adcafeUrlCgi}adcafe_admin.cgi\n\n";	# admin functions
			}
		} elsif ($isOk eq $adcafeLoginAdminTotCd) {  # admin, tots, stats
			if ($input{'rt'} eq 's') {
				$input{'id'} = $adcafeTotId;
				&gotoStats($isOk);
			} elsif ($input{'rt'} eq 'd') {
				print STDOUT "Location: ${adcafeUrlCgi}adcafe_daily.cgi\n\n";	# daily totals
			} else {
				&gotoTotals;
			}
		} elsif ($isOk eq $adcafeLoginAdminStatCd) {  # admin, tots, stats
			$input{'id'} = $adcafeTotId;
			&gotoStats($isOk);
		} elsif ($isOk eq $adcafeLoginAdCd) {	# individual ads
			&gotoStats($isOk);
		} elsif ($isOk eq $adcafeLoginGroupCd) {	# group ads
			&gotoStats($isOk);
		} elsif ($isOk eq $adcafeLoginSiteCd) {	# sites stats
			&gotoStats($isOk);
		} else {
			my $msg = "<FONT $adcafeFontErrColor><B>You did not enter a correct login / password combination.<BR></FONT>Please re-enter your login and password.</B>";
			&dspLogin($msg);
		}
	} else {
		my $msg = '<B>Enter your login and password.</B>';
		&dspLogin($msg);
	}

	exit;
}

sub gotoTotals
{
	if ($adcafeTotalCd eq 'd') {	# By day
		print STDOUT "Location: ${adcafeUrlCgi}adcafe_totals.cgi\n\n";	# admin totals
	} else {						# By ad and site
		print STDOUT "Location: ${adcafeUrlCgi}adcafe_tots.cgi\n\n";	# admin totals
	}
}

sub gotoStats
{
	my $code = shift;
	if ($adcafeTotalCd eq 'd') {	# By day
		print STDOUT "Location: ${adcafeUrlCgi}adcafe_stats.cgi?id=$input{'id'}&lgn=$code\n\n";
	} else {
		print STDOUT "Location: ${adcafeUrlCgi}adcafe_statads.cgi?id=$input{'id'}&lgn=$code\n\n";
	}
}

sub verifyLogin
{
	my $userId = $input{'id'};
	my $userPswd =  $input{'pswd'};
	my $isVerified = 'n';
	my ($pswd, $id, $tmp, $name, $file);
	if ($userId eq $adcafeAdminId) {
		if ($adcafeAdminPswd eq $userPswd) {
			$isVerified = $adcafeLoginAdminCd;
		} elsif ($adcafeAdminTots eq $userPswd) {
			$isVerified = $adcafeLoginAdminTotCd;
		} elsif ($adcafeAdminStats eq $userPswd) {
			$isVerified = $adcafeLoginAdminStatCd;
		}
	} else {
		$file = "$adcafeDirData$userId\.ad";
		if (-e $file) {
			open(CFG, $file);
			<CFG>; <CFG>; <CFG>; <CFG>;	<CFG>;
			$pswd = <CFG>; chop($pswd);
			if ($pswd eq $userPswd) {
				$isVerified = $adcafeLoginAdCd;
			}
			close(CFG);
		} else {
			$file = "${adcafeDirData}adgroup\.cfg";
			if (-e $file) {
				open(GRPCFG, $file);
				while (<GRPCFG>) {
					chop;
					($id, $name, $pswd, $tmp) = split(/\|/,$_);
					if ($id eq $userId) {
						if ($pswd eq $userPswd) {
							$isVerified = $adcafeLoginGroupCd;
						}
						last;
					}
				}
				close(GRPCFG);
			}
			if ($isVerified eq 'n') {
				$file = "${adcafeDirData}adcafe\.cfg";
				if (-e $file) {
					open(SITE, $file);
					while (<SITE>) {
						chop($_) if $_ =~ /\n$/;
						($id, $tmp) = split(/\=/, $_);
						if ($id eq $userId) {
							($name, $pswd) = split(/\|/, $tmp);
							if ($pswd eq $userPswd) {
								$isVerified = $adcafeLoginSiteCd;
							}
							last;
						}
					}
					close(SITE);
				}
			}
		}
	}

	unless ($isVerified eq 'n') { &svLogin($isVerified); }
		
	return $isVerified;
}

sub svLogin
{
	my $code = shift;

	my $user = $ENV{'REMOTE_ADDR'};
	$user =~ s/\./_/g;

	my $usrName = "${adcafeDirData}usr$user\.pwd";
	my (@logins, $line, $fCd, $fId);
	my $curTime = time;
	if (-e $usrName) {
		open(USR, $usrName);
		my $time = <USR>;  chop($time);
		if (($curTime - $time) < $adcafeRelogTime) {
			@logins = <USR>;
		}
		close(USR);
	}

	my %admin;
	if ($code eq $adcafeLoginAdminCd) {
		$admin{$adcafeLoginAdminTotCd}++;
		$admin{$adcafeLoginAdminStatCd}++;
	}
	open(USR,">$usrName");
	print USR "$curTime\n";
	while (@logins) {
		$line = shift @logins;
		($fCd, $fId) = split(/\|/,$line);
		unless ($fCd eq $code) {
			unless ($admin{$fCd}) {
				print USR $line;
			}
		}
	}
	print USR "$code\|$input{'id'}\n";
	if ($code eq $adcafeLoginAdminCd) {
		print USR "$adcafeLoginAdminTotCd\|$adcafeAdminId\n";
		print USR "$adcafeLoginAdminStatCd\|$adcafeAdminId\n";
	}
	close(USR);
}

sub dspLogin
{
	my $msg = shift;
	&htmlHeader('AdCafe Sponsor Login');

	my ($rt, $rh);
	if ($input{'rt'}) {
		$rt = "<INPUT TYPE=HIDDEN NAME=rt VALUE=\"$input{'rt'}\">";
	}
	if ($input{'rh'}) {
		$rh = "<INPUT TYPE=HIDDEN NAME=rh VALUE=\"$input{'rh'}\">";
	}

	print STDOUT <<EOT;
<CENTER>
$msg
<P>
<FORM ACTION="${adcafeUrlCgi}adcafe_login.cgi" METHOD=POST>
<INPUT TYPE=HIDDEN NAME=a VALUE="$input{'a'}">
$rt$rh
<TABLE BORDER=0 CELLSPACING= 2 COLSPAN=2 WIDTH=450>
<TR>
<TD><B>Ad ID</B></TD>
<TD WIDTH=30%><INPUT TYPE="text" NAME="id" SIZE=10 MAX=10 VALUE="$input{'id'}"></TD>
<TR>
<TD><B>Password</B></TD>
<TD WIDTH=30%><INPUT TYPE="password" NAME="pswd" SIZE=25 MAX=25></TD>
<TR>
<TD COLSPAN=2 ALIGN=CENTER><INPUT TYPE="submit" VALUE=" Submit "></TD>
</TR></TABLE></FORM></CENTER>
EOT

	&htmlFooter;
}
