#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - Advertiser management system
# Copyright (c) 1998 Infohiway
#
# adcafe_lock.cgi
#
# ==========================================================================

sub logEvent
{
	my $msgCd = shift;
	my $msg = shift;
	my ($day, $mon, $year, $hr, $min, $tmp);
	($tmp, $min, $hr, $day, $mon, $year) = localtime(time);
	$mon++;  $year += 1900;
	my $ext = sprintf("%04d%02d%02d", $year, $mon, $day);
	my $name = "${adcafeDirLogs}adcafe$ext\.msg";

	if (&fileLock($name, \*LMSGLOG)) {
		if (-e $name) {
			open(MSGLOG,">>$name");
		} else {
			open(MSGLOG,">$name");
		}
		binmode MSGLOG;
		$tmp = sprintf("%02d\/%02d\/%04d %02d:%02d", $mon, $day, $year, $hr, $min);
		my $msgRec = "\[$tmp\] $msgCd $msg";
		print MSGLOG "$msgRec\n";
		close(MSGLOG);
		&fileUnlock($name, \*LMSGLOG);
	}
}

sub fileLock
{
	my $fileName = shift;
	my $fH = shift;
	my $numTrys = 10;
	if ((-M "$fileName.lok") > .001) {
		unlink ("$fileName.lok");
	}
	while ($numTrys--) {
		if (-f "$fileName.lok") {
#			open(TRC,">>lock.txt");
#			print TRC "$fileName\|$numTrys\n";
#			close(TRC);
			select(undef,undef,undef,0.1);
		} else {
			open ($fH,">$fileName.lok");
			last;
		}
	}

	return ($numTrys > 0);
}

sub fileUnlock
{
	my $fileName = shift;
	my $fH = shift;
	close($fH);
	unlink("$fileName.lok");
}

	return 1;	# force true
