#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - Advertiser management system
# Copyright (c) 1998 Infohiway
#
# Admin functions - inactive ads
#
# adcafe_inactive.cgi
#
# ==========================================================================

require 'adcafe_cfg.cgi';
require 'adcafe_gui.cgi';
require 'adcafe_security.cgi';

MAIN:
{ 
	&getInput;
	$| = 1;
	unless (&okToRun($adcafeLoginAdminCd, $adcafeAdminId)) {
		print STDOUT "Location: ${adcafeUrlCgi}adcafe_login.cgi?rt=im&rh=i&a=$input{'a'}\n\n";	# sponsor login
		exit;
	}

	$cgiStats = ($adcafeTotalCd eq 'd') ? 'adcafe_stats.cgi' : 'adcafe_statads.cgi';
	&htmlStart;
	&dspAds;
	&dspGroups;
	&htmlEnd;

	exit;
}

sub dspAds
{
	my @ads = &loadInactiveAds();
	if (@ads) {
		&htmlAdStart;
		my ($ix, $id, $color);
		while ($id = shift @ads) {
			&htmlAd($id, $color);
			$color = ($color) ? '' : $adcafeTblAltColor;
		}
		print STDOUT '</TABLE>';
	} else {
		print STDOUT '<CENTER><B>No Ads Are Currently Inactive:</B><P>';
	}
	print STDOUT '</CENTER><HR SIZE=1>';
}

sub htmlAd
{
	my $id = shift;
	my $color = shift;
	my $fileAd = "$adcafeDirData$id\.ad";
	print STDOUT "\n<TR VALIGN=TOP$color><TD><B>$id</B></TD>";
	if (-e $fileAd) {
		open(AD, $fileAd);
		&dspAd($id);
		close(AD);
	} else {
		print STDOUT "<TD COLSPAN=3>File missing: $fileAd</TD>";
	}
	print STDOUT '</TR>';
}

sub dspAd
{
	my $id = shift;
	<AD>; <AD>; <AD>; <AD>;
	my $name = <AD>;  chop($name);
	my $href = "<A STYLE=\"text-decoration: none\" HREF=\"$adcafeUrlCgi$cgiStats\?id=$id&lgn=$adcafeLoginAdCd\" onMouseOver=\"window.status=\'$name Totals\'; return true\"><B>$name</B></A>";
	my $pswd = <AD>;  chop($pswd);
	print STDOUT "<TD>$href<BR>$pswd</TD>";

	<AD>; <AD>; <AD>; <AD>;	# type, date, sites, restrictions
	<AD>; <AD>; <AD>; <AD>;		# raw, refresh, email, amt

	my $notes = '';  my $br = '';
	while (<AD>) {
		chop if /\n$/;
		$notes .= "$br$_";
		$br = '<BR>';
	}
	print STDOUT "<TD>$notes&nbsp;</TD>";

	print STDOUT "<TD><A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_ads.cgi\?a=e&id=$id&rh=i\" onMouseOver=\"window.status=\'${adcafeUrlCgi}adcafe_ads.cgi\'; return true\"><B>Edit</B></A>";
	print STDOUT "<BR><A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_ads.cgi\?a=d&id=$id&rh=i\" onMouseOver=\"window.status=\'${adcafeUrlCgi}adcafe_ads.cgi\'; return true\"><B>Delete</B></A></TD>\n";
}

sub htmlAdStart
{
	print STDOUT <<EOT; 
<CENTER><B>The Following Ads Are Inactive:</B>
<P>
<TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR$adcafeHdrTblColor>
<TD><B>Id</B></TD>
<TD><B>Name</B></TD>
<TD><B>Notes</B></TD>
<TD ALIGN=CENTER><B>Action</B></TD>
</TR>
EOT

}

sub loadInactiveAds
{
	my ($file, $id, $tmp);
	%adActive = ();
	%siteInfo = ();
	&loadAllSites;
	while(($id) = each(%siteInfo)) {
		$file = "${adcafeDirData}adsite$id\.cfg";
		if (-e $file) {
			open(SITE, $file);
			<SITE>;	# skip
			while (<SITE>) {
				chop if $_ =~ /\n$/;
				($id, $tmp) = split(/\|/, $_, 2);
				$adActive{$id}++;
			}
			close(SITE);
		}
	}
	$file = "${adcafeDirData}ads\.cfg";
	my @ads;
	if (-e $file) {
		open(ADS, $file);
		while (<ADS>) {
			chop if $_ =~ /\n$/;
			unless ($adActive{$_}) {
				push(@ads, $_);
			}
		}
		close(ADS);
	}

	return sort { lc($a) cmp lc($b) } @ads;
}

sub htmlStart
{
	my $title = "AdCafe Inactive Ads";
	&htmlHeader($title);
}

sub htmlEnd
{
	print STDOUT '<P><CENTER>';
	if ($adcafeTotalCd ne 'a') {	# live totals
		my $dsc = ($adcafeTotalCd eq 'b') ? 'Live Totals' : 'Totals';
		print STDOUT "<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_totals.cgi\" style=\"$adcafeLinkColor\"><B>&nbsp; $dsc &nbsp;</B></a>&#0124;";
	}
	if ($adcafeTotalCd ne 'd') {	# batch totals
		my $dsc = ($adcafeTotalCd eq 'b') ? 'Batch Totals' : 'Totals';
		print STDOUT "<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_tots.cgi\" style=\"$adcafeLinkColor\"><B>&nbsp; $dsc &nbsp;</B></a>&#0124;";
	}

	print STDOUT <<EOT;
<A STYLE="text-decoration: none" HREF="${adcafeUrlCgi}adcafe_daily.cgi" style="$adcafeLinkColor"><B>&nbsp; Daily Snapshot &nbsp;</B></a>&#0124;
<A STYLE="text-decoration: none" HREF="${adcafeUrlCgi}adcafe_admin.cgi" style=\"$adcafeLinkColor\"><B>&nbsp; Admin &nbsp;</B></a>&#0124;
<A STYLE="text-decoration: none" HREF="${adcafeUrlCgi}adcafe_login.cgi" style=\"$adcafeLinkColor\"><B>&nbsp; Sponsor Login &nbsp;</B></a>
</CENTER>
EOT

	&htmlFooter;
}

sub dspGroups
{
	&loadAllGroups;
	my @grps = sort { lc($a) cmp lc($b) } keys %groupInfo;
	print STDOUT '<CENTER><P>';
	if (@grps) {
		print STDOUT '<B>The Following Groups Are Inactive:</B><P><TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>';
		my ($group, $name, $pswd, $ads, $color, $href);
		print STDOUT "\n<TR$adcafeHdrTblColor><TD><B>Id</B></TD><TD><B>Name / Password</B></TD><TD><B>Ads in Group</B></TD><TD ALIGN=CENTER><B>--Action--</B></TD></TR>\n";
		while ($group = shift @grps) {
			($name, $pswd, $ads) = split(/\|/,$groupInfo{$group});
			unless (&isGroupActive($ads)) {
				$ads =~ s/\,/ /g;
				$href = "<A STYLE=\"text-decoration: none\" HREF=\"$adcafeUrlCgi$cgiStats\?id=$group&lgn=$adcafeLoginGroupCd\" onMouseOver=\"window.status=\'$name Totals\'; return true\"><B>$name</B></A>";
				print STDOUT "<TR$color VALIGN=TOP><TD>$group</TD><TD>$href<BR>$pswd</TD><TD>$ads</TD>";
				print STDOUT "<TD><A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_grps.cgi\?a=e&id=$group\" style=\"$adcafeLinkColor\" onMouseOver=\"window.status=\'${adcafeUrlCgi}adcafe_grps.cgi\'; return true\"><B>Edit</B></A>";
				print STDOUT "<BR><A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_grps.cgi\?a=d&id=$group\" style=\"$adcafeLinkColor\" onMouseOver=\"window.status=\'${adcafeUrlCgi}adcafe_grps.cgi\'; return true\"><B>Delete</B></A>";
				print STDOUT "</TD></TR>\n";
				$color = ($color) ? '' : $adcafeTblAltColor;
			} else {
				$flagInactiveGroups = 't';
			}
		}
		print STDOUT '</TABLE>';
	} else {
		print STDOUT '<B>No Groups Are Currently Inactive:</B><P>';
	}

	print STDOUT '</CENTER><HR SIZE=1>';
}

sub isGroupActive
{
	my @ads = split(/\,/, (shift));
	my ($id, $flag);
	while ($id = shift @ads) {
		if ($adActive{$id}) {
			return 't';
		}
	}

	return '';
}
