#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - put ad into html page for delivery
# Copyright (c) 1998 Infohiway
#
# Ad insertion into html page begin delivered
#
# adcafe_htm.cgi
#
# The template looked for in the html file for an ad insertion is as follows:
# (all entries are assumed to be on seperate lines)
# 	<!-- AdCafe SITE=(valid site id) ID=(optional hard code of ad id) -->
# 
# ==========================================================================

require 'adcafe_cfg.cgi';
require 'adcafe_getad.cgi';

MAIN:
{ 
	&getInput;
	$| = 1;

	print STDOUT $adcafeHdrResponse;
	if (length($input{'htm'}) > 4) {
		&processHtml($input{'htm'});
	} else {
		&htmlError;
		&logEvent(4, "Page=$input{'htm'}");
	}

	&exitCheck;
}

sub processHtml
{
	my $file = shift;
	if (-e $file) {
		&seedRandomNum;
		open(HTML, $file);
		while (<HTML>) {
			chop($_) if $_ eq "\n";
			if ($_ =~ /^\<!-- AdCafe.+ --\>$/i) {	# insert ad
				my $site = ($_ =~ /SITE\s*=\s*(\S+)/i) ? $1 : '';
				my $id = ($_ =~ /ID\s*=\s*(\S+)/i) ? $1 : '';
				&insertAd($site, $id);
			} else {
				print STDOUT $_;
			}
		}
		close(HTML);
	} else {
		&htmlError;
	}
}

sub insertAd
{
	%adInfo = ();
	$adInfo{'site'} = shift;
	$adInfo{'id'} = shift;
	&loadAdBanner();
	&htmlAd();
	logAd('L');
}

sub htmlError
{

	print STDOUT <<EOT; 
<HTML><HEAD><TITLE>"AdCafe HTML delivery error</TITLE></HEAD>
<BODY $adcafeBodyColor>
<FONT SIZE=+1 $adcafeFontErrColor>Could not find HTML file: $input{'htm'}</FONT>
<BR><HR>
Please check your setup of this script.  You should be passing a the html file
name after the cgi name.
<BR>For example, 'adcafe_htm.cgi?htm=index.html'
<BR>This html file should have a comment in it to define the placement of any ads
desired.
</BODY></HTML>
EOT

}
