#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - Advertiser management system
# Copyright (c) 1998 Infohiway
#
# System wide variables for browser data entry
#
# adcafe_gui.cgi
# ==========================================================================

{
	$adcafeScreenWidth = 600;
	$adcafeFontErrColor = ' COLOR="#ee0000"';	# inside FONT cmd
	$adcafeFontHdrColor = ' COLOR="#336633"';	# inside FONT cmd
	$adcafeHdrTblColor = ' BGCOLOR="#d0ffd0"';	# inside TR cmd
	$adcafeTblAltColor = ' BGCOLOR="#ffffdd"';	# inside TR cmd
	$adcafeFontFace = ' FACE="Times New Roman"';
	$adcafeLinkColor = 'color: #336633';
	$adcafeFooter = "<P><CENTER><FONT SIZE=+1 $adcafeFontFace$adcafeFontHdrColor><B>$adCafeServer</B></FONT>
<BR><B> Email: </B><A HREF=\"mailto:$adCafeMailAddr\">$adCafeMailAddr</A></CENTER>";

}

sub htmlHeader
{
	my $title = shift;
	my $titleOnly = shift;
	print STDOUT $adcafeHdrResponse;
	print STDOUT <<EOT; 
<HTML>
<HEAD><TITLE>$title</TITLE></HEAD>
<BODY  $adcafeBodyColor$adcafeBodyBG>
<TABLE BORDER=0 WIDTH=$adcafeScreenWidth cellpadding=0 cellspacing=0>
<TR><TD>
EOT

	if (!$titleOnly) {
		print STDOUT <<EOT; 
<CENTER>
<H1 ALIGN=CENTER><FONT $adcafeFontHdrColor$adcafeFontFace>
<B>$title</B></FONT>
</H1>
</CENTER>
EOT

	}

}

sub htmlFooter
{
	print STDOUT <<EOT; 
$adcafeFooter
<P><FONT COLOR="#007f00"><B>AdCafe</B></FONT>
<FONT SIZE=-1> is a product from <B>Infohiway, Inc.</B></FONT>
</TD></TR></TABLE>
</BODY></HTML>
EOT
}

sub fmtNumber
{
	my $numIn = shift;
	my $lenIn = length($numIn) - 1;
	my $numComma = int ($lenIn / 3);

	my $ix = 0;
	my $ch = '';
	while ($ix != $numComma) {
		$lenIn -= 3;
		$ch = substr($numIn, $lenIn, 1);
		$ch .= ',';
		substr($numIn,  $lenIn, 1) = $ch;
		$ix++;
	}

	if (length($numIn) == 0) {
		$numIn = '0';
	}

	return $numIn
}

sub loadAllGroups
{
	%groupInfo = ();
	my $fileGrps = "${adcafeDirData}adgroup\.cfg";
	if (-e $fileGrps) {
		open(GRPCFG,"$fileGrps");
		my ($group, $name, $pswd, $ads);
		while (<GRPCFG>) {
			chop($_);
			($group, $name, $pswd, $ads) = split(/\|/,$_);
			$groupInfo{$group} = "$name\|$pswd\|$ads";
		}
		close(GRPCFG);
	}
}

sub loadAllSites
{
	%siteInfo = ();
	my $fileSite = "${adcafeDirData}adcafe\.cfg";
	if (-e $fileSite) {
		open(SITE,"$fileSite");
		my ($id, $name);
		while (<SITE>) {
			chop($_) if $_ =~ /\n$/;
			($id, $name) = split(/\=/, $_);
			$siteInfo{$id} = $name;
		}
		close(SITE);
	}
}

sub validId
{
	my $id = shift;
	if (length($id) < 1) { return ''; }

	my $ctr = $id =~ tr/a-zA-z_0-9//c;
	if ($ctr > 0) { return ''; }

	return 't';
}

sub uniqueId
{
	my $id = shift;
	if ($id eq $adcafeTotId) {
		return "$id can not be used as an ID - enter another id<BR>";
	}
	unless (defined %groupInfo) { &loadAllGroups; }
	if ($groupInfo{$id}) {
		return "$id already in use as a group - enter a unique id<BR>";
	}
	unless (defined %siteInfo) { &loadAllSites; }
	if ($siteInfo{$id}) {
		return "$id already in use as a site - enter a unique id<BR>";
	}
	my $file = "${adcafeDirData}$id\.ad";
	if (-e $file) {
		return "$id already in use as an ad - enter a unique id<BR>";
	}

	return '';
}

