#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - Advertiser management system
# Copyright (c) 1998 Infohiway
#
# Maintenance for ad groups
#
# adcafe_grps.cgi
#
# ==========================================================================

require 'adcafe_cfg.cgi';
require 'adcafe_gui.cgi';
require 'adcafe_lock.cgi';
require 'adcafe_security.cgi';

MAIN:
{ 
	&getInput;
	$| = 1;
	unless (&okToRun($adcafeLoginAdminCd, $adcafeAdminId)) {
		print STDOUT "Location: ${adcafeUrlCgi}adcafe_login.cgi?rt=gm&a=$input{'a'}\n\n";	# sponsor login
		exit;
	}
	my $group = $input{'id'};
	my $action = $input{'a'};
	if ($input{'doit'}) {	# update group file
		my $errFlag = &updateGroups;
		&htmlNext($errFlag);
	} elsif ($input{'can'}) {	# cancel update
		&htmlNext();
	} else {
		&htmlStart($action);
		if ($action eq 'd') {	# delete
			&htmlDelete($group);
		} elsif ($action eq 'e') {	# edit
			&htmlEdit($group);
		} else {
			&htmlAdd;
		}
		&htmlEnd;
	}

	exit;
}

sub htmlEdit
{
	my $group = shift;
	&htmlData($group);
}

sub htmlAdd
{
	my $group = shift;
	&htmlData($group);
}

sub htmlData
{
	my $group = shift;
	my ($groupName, $groupPswd, $groupAds);
	($groupName, $groupPswd, $groupAds) = &loadGroup($group);

	if ($input{'a'} eq 'e') {
		$butSubmit = 'Update Group';
		$butCancel = ' Cancel Update ';
		$action = 'e';
	} else {
		$butCancel = ' Cancel Add ';
		$butSubmit = 'Add New Group';
		$action = 'a';
	}
	my $adList = &fmtAds($groupAds);

	print STDOUT <<EOT;
<P><CENTER><FORM METHOD=POST ACTION="${adcafeUrlCgi}adcafe_grps.cgi">
<TABLE BORDER=0 CELLSPACING=2 WIDTH=100%>
<INPUT TYPE=HIDDEN NAME=a VALUE=$action>
<INPUT TYPE=HIDDEN NAME=db VALUE="g">
<INPUT TYPE=HIDDEN NAME=old VALUE="$group">
<TR><TD>Id:</TD><TD><INPUT TYPE=TEXT NAME=id SIZE=5 VALUE="$group"></TD></TR>
<TR><TD>Name:</TD><TD><INPUT TYPE=TEXT NAME=name SIZE=35 VALUE="$groupName"></TD></TR>
<TR><TD>Password</TD><TD><INPUT TYPE=TEXT NAME=pswd VALUE="$groupPswd"></TD></TR>
<TR VALIGN=TOP><TD>Ads in Group</TD><TD>
$adList
</TD></TR><TR><TD COLSPAN=2 ALIGN=CENTER><P><HR SIZE=1>
<INPUT TYPE=SUBMIT NAME=doit VALUE="$butSubmit">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
<INPUT TYPE=SUBMIT NAME=can VALUE="$butCancel">
</TD></TR></TABLE></FORM></CENTER>
EOT

}

sub htmlDelete
{
	my $group = shift;
	my ($groupName, $groupPswd, $groupAds);
	($groupName, $groupPswd, $groupAds) = &loadGroup($group);
	my $adList = &fmtAds($groupAds, 'd');

	print STDOUT <<EOT;
<CENTER><B>Are you sure you want to delete this group:</B><P><TABLE BORDER=0 CELLSPACING=2>
<TR><TD>Id:</TD><TD><B>$group</B></TD></TR>
<TR><TD>Name:</TD><TD><B>$groupName</B></TD></TR>
<TR><TD>Password:</TD><TD><B>$groupPswd</B></TD></TR>
$adList
</TABLE><HR SIZE=1>
<P><FORM METHOD=POST ACTION="${adcafeUrlCgi}adcafe_grps.cgi">
<TABLE BORDER=0 CELLSPACING=2><TR><TD ALIGN=CENTER>
<INPUT TYPE=HIDDEN NAME=a VALUE="d">
<INPUT TYPE=HIDDEN NAME=db VALUE="g">
<INPUT TYPE=HIDDEN NAME=id VALUE=$group>
<INPUT TYPE=HIDDEN NAME=name VALUE="$groupName">
<INPUT TYPE=HIDDEN NAME=pswd VALUE="$groupPswd">
<INPUT TYPE=HIDDEN NAME=ads VALUE="$groupAds">
<INPUT TYPE=SUBMIT NAME=doit VALUE="Delete Group">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
<INPUT TYPE=SUBMIT NAME=can VALUE=" Cancel Delete ">
</TD></TR></TABLE></FORM></CENTER>
EOT

}

sub fmtAds
{
	my $tmp = shift;
	my $delOpt = shift;

	my @ads = split(/\,/, $tmp);
	my $adList = '';

	if ($delOpt) {
		if (@ads) {
			$adList = "\n<TR><TD COLSPAN=2 ALIGN=CENTER><HR>Ads in this group</TD></TR>\n";
			my ($ix, $id, $name);
			while ($id = shift @ads) {
				$name = &loadAdName($id);
				$adList .= "<TR><TD COLSPAN=2><B>$id: $name</B></TD></TR>\n";
			}
		} else {
			$adList = "<TR><TD COLSPAN=2 ALIGN=CENTER><B>No ads are in this group!</B><P></TD></TR>\n";
		}
	} else {
		my %groupAds = ();
		grep($groupAds{$_}++, @ads);
		@ads = &loadAllAds;
		my $selected;
		$tmp = @ads;
		if ($tmp > 0) {
			$tmp++;
			$tmp = 7 if $tmp > 7;
			$adList = "<SELECT NAME=ads MULTIPLE SIZE=$tmp>\n";
			while(@ads) {
				$tmp = shift @ads;
				$selected = ($groupAds{$tmp}) ? ' SELECTED' : '';
				$adList .= "<OPTION VALUE=\"$tmp\"$selected\>$tmp: $adInfo{$tmp}\n";
			}
			$adList .= "</SELECT>";
		} else {
			$adList = "<FONT $adcafeFontErrColor>No Ads Defined</FONT>";
		}
	}

	return $adList;
}

sub validateInput
{
	my $group = $input{'id'};
	unless (&validId($group)) {
		return "Id <B>\($group\)</B> must contain only letters and digits<BR>";
	}
	my $action = $input{'a'};
	my ($tmp, $errMsg);

	if ($action eq 'a') {	# add
		$errMsg = &uniqueId($group);
	} elsif ($action eq 'd') {	# add
		unless ($groupInfo{$group}) {
			$errMsg = "Could not find $group - choose an existing group to delete<BR>";
		}
	} else {
		if ($input{'old'} eq $group) {	# no change in id
			unless ($groupInfo{$group}) {
				$errMsg = "Could not find $group - choose an existing group to edit<BR>";
			}
		} else {
			$errMsg = &uniqueId($group);
		}
	}

	if ($action ne 'd') {
		my %flds = ('id'=>'Id',	'name'=>'Group Name',	'pswd'=>'Password', 'ads'=>'Advertisements');
		my @flds = keys %flds;
		while ($tmp = shift @flds) {
			unless (length($input{$tmp}) > 0) {
				$errMsg .= "$flds{$tmp} not entered<BR>";
			}
			if ($input{$tmp} =~ /[;><&\*']/) {
				$errMsg .= "$flds{$tmp} can not include these characters: \";><&*'\"<BR>";
			}
		}
	}

	return $errMsg;
}

sub updateGroups
{
	my $errFlag = '';
	my $fileGrps = "${adcafeDirData}adgroup\.cfg";
	if (&fileLock($fileGrps, \*LGRPCFG)) {
		&loadAllGroups;
		my $errMsg = &validateInput;
		if (length($errMsg) > 0) {
			&htmlError($errMsg);
			$errFlag = 1;
		} else {
			open(GRPCFG,">$fileGrps");
			my @grps = keys %groupInfo;
			my ($group, $name, $pswd, $ads);
			my $id = $input{'id'};
			$input{'ads'} =~ tr/\|/,/;
			my $action = $input{'a'};
			while ($group = shift @grps) {
				($name, $pswd, $ads) = split(/\|/,$groupInfo{$group});
				if ($group eq $id) {
					if ($action ne 'd') {	# edit
						if ($input{'old'} eq $id) {	#didn't change id
							print GRPCFG "$id\|$input{'name'}\|$input{'pswd'}\|$input{'ads'}\n";
						}
					}
				} else {
					print GRPCFG "$group\|$groupInfo{$group}\n";
				}
			}
			# add or edit with new id
			if ($action eq 'a' || ($action eq 'e' && $input{'old'} ne $id)) {
				print GRPCFG "$id\|$input{'name'}\|$input{'pswd'}\|$input{'ads'}\n";
			}
			close(GRPCFG);
		}
		&fileUnlock($fileGrps, \*LGRPCFG);
	} else {
		&logEvent(6, "Rtn=grps\|File=adgroup.cfg\|Id=$id");
		&htmlError("Fatal Error: Could not update $fileGrps");
		$errFlag = 1;
	}

	return $errFlag;
}

sub loadAllAds
{
	%adInfo = ();
	my $file = "${adcafeDirData}adcafe\.cfg";
	if (-e $file) {
		open(CFG, $file);
		my ($id, $tmp);
		while (<CFG>) {
			chop($_) if $_ =~ /\n$/;
			($id, $tmp) = split(/\=/, $_);
			$file = "${adcafeDirData}adsite$id\.cfg";
			if (-e $file) {
				open(SITE, $file);
				<SITE>;	# skip 1st record
				while (<SITE>) {
					chop if $_ =~ /\n$/;
					($id, $tmp) = split(/\|/, $_);
					unless ($adInfo{$id}) {
						$adInfo{$id} = &loadAdName($id);
					}
				}
				close(SITE);
			}
		}
		close(CFG);
	}
	$file = "${adcafeDirData}ads\.cfg";
	if (-e $file) {
		open(ADS, $file);
		while (<ADS>) {
			chop if $_ =~ /\n$/;
			unless ($adInfo{$_}) {
				my $id = $_;
				$adInfo{$id} = &loadAdName($_);
			}
		}
		close(ADS);
	}

	sort keys %adInfo;
}

sub loadGroup
{
	my $groupId = shift;
	my ($groupAds, $groupPswd, $groupName);

	if ($input{'doit'}) {
		$groupName = $input{'name'};
		$groupPswd = $input{'pswd'};
		$input{'ads'} =~ tr/\|/,/;
		$groupAds = $input{'ads'};
		unless ($groupPswd) { $groupPswd = ''; }
		unless ($groupName) { $groupName = ''; }
	} else {
		my $file = "${adcafeDirData}adgroup\.cfg";
		if (-e $file) {
			open(GRP, $file);
			my ($group, $name, $pswd, $ads);
			while (<GRP>) {
				chop($_) if $_ =~ /\n$/;
				($group, $name, $pswd, $ads) = split(/\|/,$_);
				if ($groupId eq $group) {
					$groupName = $name;
					$groupAds = $ads;
					$groupPswd = $pswd;
					last;
				}
			}
			close(GRP);
		}
	}

	return ($groupName, $groupPswd, $groupAds);
}

sub loadAdName
{
	my $ad = shift;
	my $file = "${adcafeDirData}$ad\.ad";
	my $name = $ad;
	if (-e $file) {
		open(AD, $file);
		my $ctr;
		while (<AD>) {
			$ctr++;
			last if $ctr == 4;
		}
		$name = <AD>;
		chop($name) if $name =~ /\n$/;
		close(AD);
	}

	return $name;
}

sub htmlNext
{
	my $err = shift;
	if ($err) {
		my $group = $input{'id'};
		my $action = $input{'a'};
		if ($action eq 'd') {	# delete
			&htmlDelete($group);
		} elsif ($action eq 'e') {	# edit
			&htmlEdit($group);
		} else {
			&htmlAdd($group);
		}
		&htmlEnd;
	} else {
		print STDOUT "Location: ${adcafeUrlCgi}adcafe_admin.cgi\n\n";	# admin stats
	}
}

sub htmlError
{
	my $msg = shift;
	&htmlStart($input{'a'});
	$msg = "<FONT SIZE=+1 $adcafeFontErrColor>Input Errors</FONT><BR><FONT $adcafeFontErrColor>$msg</FONT><HR SIZE=1>";
	print STDOUT $msg;
}

sub htmlStart
{
	my $action = shift;
	my %descAction = ('d'=>'Deletion',	'e'=>'Edit', 'a'=>'Add', ''=>'Add');
	my $title = "AdCafe Groups $descAction{$action}";
	&htmlHeader($title);
}

sub htmlEnd
{
	print STDOUT '<P><CENTER>';
	if ($adcafeTotalCd ne 'a') {	# live totals
		my $dsc = ($adcafeTotalCd eq 'b') ? 'Live Totals' : 'Totals';
		print STDOUT "<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_totals.cgi\" style=\"$adcafeLinkColor\"><B>&nbsp; $dsc &nbsp;</B></a>&#0124;";
	}
	if ($adcafeTotalCd ne 'd') {	# batch totals
		my $dsc = ($adcafeTotalCd eq 'b') ? 'Batch Totals' : 'Totals';
		print STDOUT "<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_tots.cgi\" style=\"$adcafeLinkColor\"><B>&nbsp; $dsc &nbsp;</B></a>&#0124;";
	}

	print STDOUT <<EOT; 
<A STYLE="text-decoration: none" HREF="${adcafeUrlCgi}adcafe_daily.cgi" style="$adcafeLinkColor"><B>&nbsp; Daily Snapshot &nbsp;</B></a>&#0124;
<A STYLE="text-decoration: none" HREF="${adcafeUrlCgi}adcafe_admin.cgi" style=\"$adcafeLinkColor\"><B>&nbsp; Admin &nbsp;</B></a>&#0124;
<A STYLE="text-decoration: none" HREF="${adcafeUrlCgi}adcafe_login.cgi" style=\"$adcafeLinkColor\"><B>&nbsp; Sponsor Login &nbsp;</B></a>
</CENTER>
EOT

	&htmlFooter;
}
