#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - deliver gif file for display
# Copyright (c) 1998 Infohiway
#
# Ad gif delivery
#
# adcafe_gif.cgi
#
# ==========================================================================

require 'adcafe_cfg.cgi';
require 'adcafe_getad.cgi';

MAIN:
{ 
	&getInput;
	$| = 1;
	$adInfo{'site'} = $input{'site'};	# global with ad info to run
	my ($gif, $id, $href, $ctr);
	&seedRandomNum;
	while (length($adInfo{'gif'}) < 8 && $ctr < 3) {	# try up to 3 times to get a gif
		&loadAdBanner();
		$ctr++;
	}
	if (length($adInfo{'gif'}) < 8) {
		&loadError(7, "msg=Could not find gif to use\|Site=$adInfo{'site'}");
	}
	logAd('L');
	logUser();
	print STDOUT "Location: $adInfo{'gif'}\nExpires: 0\n\n";

	&exitCheck;
}

sub logUser
{
	my $adTime = time;
	my $user = $ENV{'REMOTE_ADDR'};
	$user =~ s/\./_/g;

	my $tag = ($input{'tag'}) ? $input{'tag'} : 0;

	my $usrName = "${adcafeDirData}usr$user\.tmp";
	my @ads;
	my $usrTime = $adTime;
	if (-e $usrName) {
		open(USR,"$usrName");
		
		my $lastTime = <USR>;
		chop($lastTime);
		unless (($adTime - $lastTime) > 30) {
			$usrTime = $lastTime;
			@ads = <USR>;
		}
		close(USR);
	}
	open(USR,">$usrName");
	print USR "$usrTime\n";
	my ($fId, $fSite, $fUrl, $fTag, $fT);
	while(@ads) {
		$line = shift @ads;
		($fId, $fSite, $fUrl, $fTag, $fT) = split(/\|/,$line);
		unless ($fSite eq $adInfo{'site'} && $fTag eq $tag) {
			print USR $line;
		}
	}
	print USR "$adInfo{'id'}\|$adInfo{'site'}\|$adInfo{'url'}\|$tag\|$adTime\n";
	close(USR);

	return 1;
}
