#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - Advertiser management system
# Copyright (c) 1998 Infohiway
#
# adcafe_getsubs.cgi
#
# ==========================================================================

sub isExpired
{
	my $exp = shift;  my $hit = shift;  my $clk = shift;
	my $cd = 'R';
	if ($exp !~ /^A/) {
		if ($exp =~ /^H(\d+)/) {
			unless ($hit < $1)  { $cd = 'E'; }
		} elsif ($exp =~ /^C(\d+)/) {
			unless ($clk < $1) { $cd = 'E'; }
		} elsif ($exp =~ /^D(\d\d\d\d)(\d\d)(\d\d)/) {
			if (&cmpToday($2, $3, $1) < 0) { $cd = 'E'; }
		}
	}

	return $cd;
}

sub okToStart
{
	my $adCd = shift;
	my $cd;
	if ($adCd =~ /S(\d\d\d\d)(\d\d)(\d\d)/) {
		my ($day, $mon, $year);
		($day, $mon, $year) = (localtime(time))[3,4,5];
		$mon++;	$year += 1900;
		if ($year == $1) {
			if ($mon == $2) {
				if ($day >= $3) {
					$cd = 'R';	# now active
				}
			} elsif ($mon > $2) {
				$cd = 'R';	# now active
			}
		} elsif ($year > $1) {
			$cd = 'R';	# now active
		}
	}

	return $cd;
}

sub loadAdCtr
{
	my $id = shift;
	my $file = "$adcafeDirTotals$id\.ctr";
	my $ctr = "0\|0";
	my $opt = "H1\|R";
	if (-e $file) {
		open(CTR, $file);
		$ctr = <CTR>;
		chop($ctr) if $ctr =~ /\n$/;
		$opt = <CTR>;
		chop($opt) if $opt =~ /\n$/;
		close(CTR);
	}

	return ($ctr, $opt);
}

sub lockAdCtr
{
	my $id = shift;
	my $file = "$adcafeDirTotals$id\.ctr";
	if (&fileLock($file, \*LCTR)) { return 1; }

	&logEvent(6, "Rtn=get\|File=$id\.ctr\|Site=$adInfo{'site'}");
	return 0;
}

sub unlockAdCtr
{
	my $id = shift;
	my $file = "$adcafeDirTotals$id\.ctr";
	&fileUnlock($file, \*LCTR);
}

sub saveAdCtr
{
	my $id = shift;
	my $ctrs = shift;
	my $opts = shift;
	my $file = "$adcafeDirTotals$id\.ctr";
	open(CTR, ">$file");
	print CTR "$ctrs\n";
	print CTR "$opts\n";
	close(CTR);
}

sub parseBrowser
{
	my $agent = shift;
	my $browser = 'o-br';
	if ($agent =~ /msie4/i) {
		$browser = 'msie4';
	} elsif ($agent =~ /msie/i) {
		$browser = 'msie';
	} elsif ($agent =~ /opera/i) {
		$browser = 'o-br';
	} elsif ($agent =~ /^mozilla4/i) {
		$browser = 'nav4';
	} elsif ($agent =~ /mozilla/i) {
		$browser = 'nav';
	}

	my $os = 'o-os';
	if ($agent =~ /macintosh|mac_/i) {
		$os = 'mac';
	} elsif ($agent =~ /sun/i) {
		$os = 'sun';
	} elsif ($agent =~ /os\/2/i) {
		$os = 'os2';
	} elsif ($agent =~ /win/i) {
		if ($agent =~ /95/) {
			$os = 'win95';
		} elsif ($agent =~ /NT|32/) {
			$os = 'winNT';
		} else {
			$os = 'win';
		}
	}

	return ($browser, $os);
}

	return 1;	# force true
