#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - ad delivery routines
# Copyright (c) 1998 Infohiway
#
# Ad delivery routines
#
# adcafe_getad.cgi
#
# ==========================================================================

require 'adcafe_dates.cgi';
require 'adcafe_lock.cgi';
require 'adcafe_getsubs.cgi';

sub htmlAd
{
	if (length($adInfo{'raw'}) > 4) {
		print STDOUT $adInfo{'raw'};
	} else {
		if (length($adInfo{'url'}) > 4) {
			print STDOUT "<A HREF=$adInfo{'href'}>\n";
		}
		print STDOUT "<IMG SRC=$adInfo{'imgsrc'}>\n";
		if (length($adInfo{'url'}) > 4) {
			print STDOUT '</A>';
		}
	}
}

sub seedRandomNum
{
#	open(TMP, ">>srand.txt");
#	my $tm = time;
#	my $t = $tm ^ ($$ + ($$ << 15));
#	print TMP "$tm\t$$\t$t\n";   close(TMP);
#	srand( $tm ^ ($$ + ($$ << 15)));
	srand( time ^ ($$ + ($$ << 15)));
}

sub loadAdBanner
{
	my $site = $adInfo{'site'};
	my $adId = $adInfo{'id'};
	my $adOk;
	if (length($adId) == 0) {
		my $file = "${adcafeDirData}adsite$site\.cfg";
		if (-e $file) {
			$adOk = &findAd($file)
		} else {
			&loadError(4, "msg=Could not find site\|Site=$site");
		}
	} else {
		$adOk = &loadAd($adId);
	}

	return $adOk;
}

sub findAd
{
	my $file = shift;
	my (@ads, $ix, $cycle, $adRec, $id, $ctr, $lk);
	if ($adcafeChkIfExp eq 'c') {
		if (&fileLock($file, \*LSITE)) {
			$lk = 't';
		} else {
			&loadError(6, "File=adsite.cfg\|Site=$adInfo{'site'}");
			return;
		}
	}

	open(SITE, $file);
	$_ = <SITE>;

	if ($adcafeChkIfExp eq 'c') {
		chop($_) if $_ =~ /\n$/;
		($ix, $cycle) = split(/\|/, $_);
	}
	@ads = <SITE>;
	close(SITE);
	my $max = @ads;
	if (length($adInfo{'num'}) > 0 && $adcafeCycleCd eq 's') {
		$ix = $adInfo{'num'};
	} elsif ($adcafeChkIfExp eq 'b') {
		$ix = int(rand($max));
	}
	while (length($id) < 1 && $ctr < $max) {
		($adRec, $id) = &okToShow($ads[$ix]);
		$ads[$ix] = $adRec;
		$ctr++;
		$ix++;
		if ($ix >= $max) {
			$ix = 0; $cycle++;
		}
	}

	$adInfo{'num'} = $ix;
	if ($lk eq 't') {
		open(SITE, ">$file");
		print SITE "$ix\|$cycle\n";
		print SITE @ads;
		close(SITE);
		&fileUnlock($file, \*LSITE);
	}
	if (length($id) > 0) {
		$id = &loadGif($id);
		&updtTotal(1, 0) if $adcafeTotalCd ne 'a';
	} else {
		&loadError(4, "msg=Could not find ad for site\|Site=$adInfo{'site'}");
	}

}

sub loadAd
{
	my $id = shift;
	my $ok = 't';
	unless ($adcafeChkIfExp eq 'c') {
		my ($ctrs, $opts, $optOut);
		($ctrs, $opts) = &loadAdCtr($id);
		my $optIn = "$id\|$opts";
		($optOut, $ok) = &okToShow($optIn);
	}

	if ($ok) {
		$ok = &loadGif($id);
		&updtTotal(1, 0) if $adcafeTotalCd ne 'a';
		if (length($ok) < 1) {
			&loadError(4, "msg=Could not find ad\|Id=$adId");
		}
	}

	return $ok;
}

sub loadGif
{
	my $id = shift;
	my $file = "$adcafeDirData$id\.ad";
	unless (-e $file) {
		return '';
	}

	my ($href, $tmp, $gif, $alt, $raw, $h, $w, $border, $type, $max);
	$adInfo{'id'} = $id;
	open(AD, $file);
	$href = <AD>; chop($href);
	&fmtHref($href);
	$gif = <AD>; chop($gif); unless($gif) { $gif = ''; };
	$alt = <AD>; chop($alt); unless($alt) { $alt = ''; };
	$h = <AD>; chop($h); unless($h) { $h = ''; };
	&fmtImg($gif, $alt, $h);
	<AD>; <AD>;
	$tmp = <AD>; chop($tmp);
	($type, $max) = split(/\|/, $tmp);
	$adInfo{'type'} = $type;
	$adInfo{'max'} = $max;
	$tmp = <AD>; chop($tmp);
	$adInfo{'start'} = $tmp;
	<AD>; <AD>;
	$raw = <AD>; chop($raw);
	&fmtRawHtml($raw);

	my $rf = <AD>; chop($rf);
	$adInfo{'rf'} = ($rf) ? $rf : $adcafeRotate;

	close(AD);

	return 1;
}

sub okToShow
{
	my $adRec = shift;
	my ($adId, $adCd, $adExp);

	chop($adRec) if $adRec =~ /\n$/;
	($adId, $adExp, $adCd, $adDay, $adTime, $adBegHr, $adEndHr, $adBr, $adOs) = split(/\|/, $adRec);
	unless ($adDay) {$adDay = 0;}
	unless ($adTime) {$adTime = 0;}
	unless ($adBr) {$adBr = 0;}
	unless ($adOs) {$adOs = 0;}
	unless ($adExp) {$adExp = 'R';}
	unless ($adCd) {$adCd = 'R';}

	my $ok = $adId;
	if (&okToStart($adCd)) {
		$adCd = 'R';	# now active
		&logEvent(1, "Id=$id\|Site=$adInfo{'site'}") if $adcafeChkIfExp eq 'c';
	}
	if ($adCd eq 'R') {
		if ($adDay > 0 || $adTime > 0) {	# hours check
			unless (&isTimeOK($adDay, $adTime, $adBegHr, $adEndHr)) { $ok = '';	}	# failed
		}
		if ($ok && ($adBr > 0 || $adOs > 0)) {	# browser and os check
			unless (&isEnvOk($adBr, $adOs)) { $ok = '';	}	# failed
		}

		if ($ok && $adcafeChkIfExp eq 'c') {
			unless (&isAdCurrent($adId, $adExp) eq 'R') {
				$ok = '';
				$adCd = 'E';	# turn it off
			}	# failed
		}
	} else {
		$ok = '';
	}

	$adRec = "$adId\|$adExp\|$adCd\|$adDay\|$adTime\|$adBegHr\|$adEndHr\|$adBr\|$adOs\n";

	return ($adRec, $ok);
}

sub isAdCurrent
{
	my $id = shift;
	my $type = shift;
	my ($hit, $clk, $opts, $rec);
	my $lock = &lockAdCtr($id);
	($rec, $opts) = &loadAdCtr($id);
	($hit, $clk) = split(/\|/, $rec);
	my $cd = &isExpired($type, $hit, $clk);
	if ($cd eq 'E') {
		&logEvent(2, "Id=$id\|Site=$adInfo{'site'}");	# ad stopping
		$opts =~ s/\|R\|/\|E\|/;
	} else {
		$hit++;
		$opts =~ s/\|S\d+\|/\|R\|/;
	}

	&saveAdCtr($id, "$hit\|$clk", $opts);
	&unlockAdCtr($id) if $lock > 0;

	return $cd;
}

sub loadError
{
	my $err = shift;
	my $msg = shift;
	$adInfo{'alt'} = $msg;
	$adInfo{'id'} = $adDefId;
	&fmtHref("$adDefUrl\|T\|");
	&fmtImg($adDefGif, $msg, "$adDefHeight\|$adDefWidth\|$adDefBorder");
	&logEvent($err, $msg);
}

sub updtTotal
{
	my $ctrH = shift;
	my $ctrC = shift;
	my $site = $adInfo{'site'};
	my $ad = $adInfo{'id'};
	my ($day, $mon, $year, $num, $tmp, $hit, $clk, $id);
	($day, $mon, $year) = (localtime(time))[3,4,5];
	$mon++;  $year += 1900;
	my $today = sprintf("%04d%02d%02d", $year, $mon, $day);
	my @recs;
	my $name = "${adcafeDirTotals}adcafe$today\.ctr";
	my ($flgS, $flgA, $flgB, $flgO, $flgBt, $flgOt, $typeBr, $typeSys);
	($typeBr, $typeSys) = &parseBrowser(&getAgent);
	my %sysTot = ( 'win95'=>'win', 'winNT'=>'win' );
	my %brTot = ( 'msie4'=>'msie', 'nav4'=>'nav' );
	if (&fileLock($name, \*LCTR)) {
		if (-e $name) {
			open(CTR,$name);
			@recs = <CTR>;
			close(CTR);
		}
		open(CTR,">$name");
		$tmp = shift @recs;
		chop($tmp) if $tmp =~ /\n$/;
		($hit, $clk) = split(/,/, $tmp);
		$hit += $ctrH;  $clk += $ctrC;
		print CTR "$hit\,$clk\n";
		while (@recs) {
			$tmp = shift @recs;
			chop($tmp) if $tmp =~ /\n$/;
			($id, $hit, $clk) = split(/,/, $tmp);
			if ($id eq $site) {
				$hit += $ctrH;  $clk += $ctrC;  $flgS = 't';
			} elsif ($id eq $ad) {
				$hit += $ctrH;  $clk += $ctrC;  $flgA = 't';
			} elsif ($id eq $typeBr) {
				$hit += $ctrH;  $clk += $ctrC;  $flgB = 't';
			} elsif ($id eq $brTot{$typeBr}) {
				$hit += $ctrH;  $clk += $ctrC;  $flgBt = 't';
			} elsif ($id eq $typeSys) {
				$hit += $ctrH;  $clk += $ctrC;  $flgO = 't';
			} elsif ($id eq $sysTot{$typeSys}) {
				$hit += $ctrH;  $clk += $ctrC;  $flgOt = 't';
			}
			print CTR "$id\,$hit\,$clk\n";
		}
		if (length($site) > 0 && $flgS ne 't') {
			print CTR "$site\,$ctrH\,$ctrC\n";
		}
		if ($flgA ne 't') {
			print CTR "$ad\,$ctrH\,$ctrC\n";
		}
		if (length($typeBr) > 0 && $flgB ne 't') {
			print CTR "$typeBr\,$ctrH\,$ctrC\n";
			if ($brTot{$typeBr} && $flgBt ne 't') {
				print CTR "$brTot{$typeBr}\,$ctrH\,$ctrC\n";
			}
		}
		if (length($typeSys) > 0 && $flgO ne 't') {
			print CTR "$typeSys\,$ctrH\,$ctrC\n";
			if ($sysTot{$typeSys} && $flgOt ne 't') {
				print CTR "$sysTot{$typeSys}\,$ctrH\,$ctrC\n";
			}
		}
		close(CTR);
		&fileUnlock($name, \*LCTR);
	} else {
		&logEvent(6, "Rtn=get\|File=adcafe$today\.ctr\|Site=$adInfo{'site'}\|Id=$ad");
	}
	$name = "${adcafeDirTotals}adcafe\.ctr";
	my $flgMon = 'f';
	my $flgYear = 'f';
	if (&fileLock($name, \*LCTR)) {
		if (-e $name) {
			open(CTR,$name);
			$tmp = <CTR>;
			chop($tmp);
			$tmp =~ /^(\d\d\d\d)(\d\d)(\d\d)/;
			$flgMon = 't' if $mon != $2;
			$flgYear = 't' if $year != $1;
			@recs = <CTR>;
			close(CTR);
		}
		open(CTR,">$name");
		print CTR "$today\n";
		$tmp = shift @recs;
		chop($tmp) if $tmp =~ /\n$/;
		$tmp = &siteTotal($tmp, $ctrH, $ctrC, $flgYear, $flgMon);
		print CTR "$tmp\n";
		$flgS = ''; $flgB = ''; $flgO = ''; $flgBt = ''; $flgOt = '';
		while (@recs) {
			$_ = shift @recs;
			chop($_) if $_ =~ /\n$/;
			($id, $tmp) = split(/,/, $_, 2);
			if ($id eq $site) {
				$tmp = &siteTotal($tmp, $ctrH, $ctrC, $flgYear, $flgMon);
				print CTR "$id\,$tmp\n";
				$flgS = 't';
			} elsif ($id eq $typeBr) {
				$tmp = &siteTotal($tmp, $ctrH, $ctrC, $flgYear, $flgMon);
				print CTR "$id\,$tmp\n";
				$flgB = 't';
			} elsif ($id eq $brTot{$typeBr}) {
				$tmp = &siteTotal($tmp, $ctrH, $ctrC, $flgYear, $flgMon);
				print CTR "$id\,$tmp\n";
				$flgBt = 't';
			} elsif ($id eq $typeSys) {
				$tmp = &siteTotal($tmp, $ctrH, $ctrC, $flgYear, $flgMon);
				print CTR "$id\,$tmp\n";
				$flgO = 't';
			} elsif ($id eq $sysTot{$typeSys}) {
				$tmp = &siteTotal($tmp, $ctrH, $ctrC, $flgYear, $flgMon);
				print CTR "$id\,$tmp\n";
				$flgOt = 't';
			} elsif ($flgYear eq 't' || $flgMon eq 't') {
				$tmp = &siteTotal($tmp, 0, 0, $flgYear, $flgMon);
				print CTR "$id\,$tmp\n";
			} else {
				print CTR "$_\n";
			}
		}
		if (length($site) > 0 && $flgS ne 't') {
			print CTR "$site\,$ctrH\,$ctrC\,1\,$ctrH\,$ctrC\,1\,0\,0\,0\,0\,0\,0\n";
		}
		if (length($typeBr) > 0 && $flgB ne 't') {
			print CTR "$typeBr\,$ctrH\,$ctrC\,1\,$ctrH\,$ctrC\,1\,0\,0\,0\,0\,0\,0\n";
			if ($brTot{$typeBr} && $flgBt ne 't') {
				print CTR "$brTot{$typeBr}\,$ctrH\,$ctrC\,1\,$ctrH\,$ctrC\,1\,0\,0\,0\,0\,0\,0\n";
			}
		}
		if (length($typeSys) > 0 && $flgO ne 't') {
			print CTR "$typeSys\,$ctrH\,$ctrC\,1\,$ctrH\,$ctrC\,1\,0\,0\,0\,0\,0\,0\n";
			if ($sysTot{$typeSys} && $flgOt ne 't') {
				print CTR "$sysTot{$typeSys}\,$ctrH\,$ctrC\,1\,$ctrH\,$ctrC\,1\,0\,0\,0\,0\,0\,0\n";
			}
		}
		close(CTR);
		&fileUnlock($name, \*LCTR);
	} else {
		&logEvent(6, "Rtn=get\|File=adcafe.ctr\|Site=$adInfo{'site'}\|Id=$ad");
	}
}

sub siteTotal
{
	my $totLine = shift;
	my $ctrH = shift;
	my $ctrC = shift;
	my $flgYear = shift;
	my $flgMon = shift;

	my ($hitY, $clkY, $ctrY, $hitM, $clkM, $ctrM, $prev, $tmp);
	($hitY,$clkY,$ctrY,$hitM,$clkM,$ctrM,$prev) = split(/,/, $totLine, 7);
	if ($flgYear eq 't') {
		my ($hitLm,$clkLm,$ctrLm,$hitLy,$clkLy,$ctrLy);
		$hitLy = $hitY; $clkLy = $clkY; $ctrLy = $ctrY;
		$hitY = 0; $clkY = 0; $ctrY = 0;
		$hitLm = $hitM; $clkLm = $clkM; $ctrLm = $ctrM;
		$hitM = 0; $clkM = 0; $ctrM = 0;
		$prev = "$hitLm\,$clkLm\,$ctrLm\,$hitLy\,$clkLy\,$ctrLy";
	} elsif ($flgMon eq 't') {
		my ($hitLm,$clkLm,$ctrLm);
		($hitLm,$clkLm,$ctrLm,$tmp) = split(/,/, $prev, 4);
		$hitLm = $hitM; $clkLm = $clkM; $ctrLm = $ctrM;
		$hitM = 0; $clkM = 0; $ctrM = 0;
		$prev = "$hitLm\,$clkLm\,$ctrLm\,$tmp";
	}

	if ($ctrH > 0 || $ctrC > 0) {
		if ($ctrM < 1) {
			$ctrM++; $ctrY++;
		}
	}
	$hitM += $ctrH;
	$clkM += $ctrC;
	$hitY += $ctrH;
	$clkY += $ctrC;
	$totLine = "$hitY\,$clkY\,$ctrY\,$hitM\,$clkM\,$ctrM\,$prev";
	return $totLine;
}

sub logAd
{
	my $adAction = shift;
	my $adId = $adInfo{'id'};
	my $adSite = $adInfo{'site'};
	my ($adDay, $adMon, $adYear);
	my $adTime = time;
	($adDay, $adMon, $adYear) = (localtime($adTime))[3,4,5];
	$adMon++;  $adYear += 1900;
	my $logExt = sprintf("%04d%02d%02d", $adYear, $adMon, $adDay);
	my $agent = &getAgent;

	my $logName = "${adcafeDirLogs}adcafe$logExt\.log";
#	if (&fileLock($logName, \*LLOG)) {
		if (-e $logName) {
			open(LOG,">>$logName");
		} else {
			unless ($adcafeTotalCd eq 'd') {
				$runBatchUpdt = ($adcafeUpdateCd eq 'b') ? 't' : '';
				my $updLog = "${adcafeDirLogs}adcafe.log";
				if (-e $updLog) {
					open(UPD,">>$updLog");
				} else {
					open(UPD,">$updLog");
				}
				print UPD "$logExt\n";
				close(UPD);
			} else {
				$runBatchUpdt = 't';
			}
			open(LOG,">$logName");
		}
#		binmode LOG;
		my $logLine = "$adAction\|$adId\|$adSite\|$adTime\|$agent\|$ENV{'REMOTE_ADDR'}\|$ENV{'HTTP_REFERER'}";
		print LOG "$logLine\n";
		close(LOG);
#		return 1;
#		&fileUnlock($logName, \*LLOG);
#	} else {
#		my %act = ('L'=>'Banner', 'C'=>'ClickThru');
#		&logEvent(5, "Log=$act{$adAction}\|Site=$adSite\|Id=$adId");
#	}
}

sub getAgent
{
	my $agent = $ENV{'HTTP_USER_AGENT'};
	$agent =~ s/[^\w_-]//g;
	$agent =~ s/compatible//g;
	return $agent;
}

sub fmtRawHtml
{
	my $raw = shift;
	my @html = split(/\|/, $raw);
	$adInfo{'raw'} = '';
#	open(TRC,">>raw.txt");
#	print TRC "---> RawHTML\n$raw\n";
	&loadDynamicTag;
	while(@html) {
		$raw = shift @html;
		$raw =~ s/\[HREF\]/$adInfo{'href'}/g;
		$raw =~ s/\[IMG\]/$adInfo{'imgsrc'}/g;
		$raw =~ s/\[GIF\]/$adInfo{'gif'}/g;
		$raw =~ s/\[URL\]/$adInfo{'url'}/g;
		$raw =~ s/\[CLICK\]/$adInfo{'click'}/g;
		$raw =~ s/\[ALT\]/$adInfo{'alt'}/g;
		$raw =~ s/\[DT\]/$adInfo{'dynTag'}/g;
		$adInfo{'raw'} .= "$raw\n";
	}
#	print TRC "---> Fmt\n$adInfo{'raw'}\n";
#	close(TRC);
}

sub fmtImg
{
	my $gif = shift;  my $alt = shift;  my $h = shift;
	$gif =~ s/\xfc/\|/g;
	my @gifs = split(/\|/, $gif);
	my $num = @gifs;
	if ($num > 1) {	# choose one of ads at random
		$gif = $gifs[int(rand($num))];
	}

	&loadDynamicTag;
	$gif =~ s/\[DT\]/$adInfo{'dynTag'}/;
	$adInfo{'gif'} = $gif;
	$adInfo{'alt'} = $alt;
	($h, $w, $b) = split(/\|/, $h);
	$adInfo{'width'} = ($w > 0) ? $w : $adDefWidth;
	$adInfo{'height'} = ($h > 0) ? $h : $adDefHeight;
	$adInfo{'border'} = ($b) ? $b : $adDefBorder;
	$adInfo{'imgsrc'} = "\"$gif\" WIDTH=$adInfo{'width'} HEIGHT=$adInfo{'height'} border=$adInfo{'border'} ALT=\"$alt\"";
}

sub fmtHref
{
	my $url = shift;
	my ($opt, $target, $urlV);
	unless ($url) {
		$url = "\|T\|";
	}
	($url, $opt, $target) = split(/\|/,$url);
	unless ($opt) {$opt = 'T';}
	unless ($opt eq 'F') {
		$target = ($opt eq 'T') ? '_top' : '_new';
	}

	&loadDynamicTag;
	$url =~ s/\[DT\]/$adInfo{'dynTag'}/;
	$adInfo{'url'} = $url;
	$adInfo{'tgt'} = $target;
	($urlV = $url) =~ s/([\x00-\x20\"#%\/;:<>?&=\x7F-\xFF])/sprintf("%%%02lx",unpack('C',$1))/ge;
	$adInfo{'click'} = "${adcafeUrlCgi}adcafe_click\.cgi?site=$adInfo{'site'}&id=$adInfo{'id'}&url=$urlV";
	$adInfo{'href'} = "\"$adInfo{'click'}\" TARGET=\"$adInfo{'tgt'}\"  onMouseOver=\"window.status=\'$url\'; return true\"";
}

sub loadDynamicTag
{
	unless ($adInfo{'dynTag'}) {
		my $dynCd = substr(time, -6);
		$adInfo{'dynTag'} = $dynCd;
	}
}

sub	isEnvOk
{
	my $adBr = shift;
	my $adOs = shift;
	my ($typeBr, $typeSys);
	($typeBr, $typeSys) = &parseBrowser(&getAgent);
	if ($adBr == 1) {	# check Netscape
		unless ($typeBr =~ /^nav/) {
			return '';
		}
	} elsif ($adBr == 2) {	# check MSIE
		unless ($typeBr =~ /^msie/) {
			return '';
		}
	} elsif ($adBr == 3) {	# check other
		unless ($typeBr !~ /^(nav|msie)/) {
			return '';
		}
	}
	if ($adOs == 1) {	# check Windows
		unless ($typeSys =~ /win/) {
			return '';
		}
	} elsif ($adOs == 2) {	# check mac
		unless ($typeSys =~ /mac/) {
			return '';
		}
	} elsif ($adOs == 3) {	# check other
		unless ($typeSys !~ /^(win|mac)/) {
			return '';
		}
	}

	return 1;
}

sub isTimeOK
{
	my $adDay = shift;
	my $adTime = shift;
	my $adBegHr = shift;
	my $adEndHr = shift;
	my ($hour, $wkDay);
	($hour, $wkDay) = (localtime(time))[2,6];
	$wkDay = ($wkDay > 0 && $wkDay < 6) ? 't' : 'f';
	if ($adDay == 1 && $wkDay ne 't') {	# daily check?
		return '';	# failed
	} elsif ($adDay == 2 && $wkDay ne 'f') {	# weekend check?
		return '';	# failed
	}
		
	$hour = ($hour >= $adBegHr && $hour <= $adEndHr) ? 't' : 'f';
	if ($adTime == 1 && $hour ne 't') {	# within hour range
		return '';	# failed
	} elsif ($adTime == 2 && $hour ne 'f') {	# outside hour range
		return '';	# failed
	}
	return 1;
}

sub exitCheck
{
	unless ($runBatchUpdt eq 't') { exit; }

	unless ($adcafeTotalCd eq 'd') {
		&logEvent(8, "msg=Start batch update");
		require 'adcafe_batch.cgi';
#			system 'perl', 'adcafe_batch.cgi';
		&batchUpdate;
	} else {
		&logEvent(8, "msg=Start daily cleanup");
		require 'adcafe_clean.cgi';
#			system 'perl', 'adcafe_clean.cgi';
		&cleanFiles;
	}

	exit;
}

	return 1;	# force true return
