#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - Advertiser management system
# Copyright (c) 1998 Infohiway
#
# Maintenance for ads
#
# adcafe_env.cgi
#
# ==========================================================================

require 'adcafe_cfg.cgi';
require 'adcafe_gui.cgi';

MAIN:
{ 
	&getInput;
	$| = 1;

	&htmlHeader("AdCafe environment display");

	my $var;
	print <<EOT;
<TABLE CELLPADDING=5 CELLSPACING=3 BORDER=5 WIDTH=500>
<TR$adcafeHdrTblColor><td><b>Input Variable</b></td>
<td><b>Contents</b></td></tr>
EOT

	my $color = '';
	foreach $var (sort keys(%input)) {
		print "<tr valign=top$color><td>$var</td><td>$input{$var}</td></tr>";
		$color = ($color) ? '' : $adcafeTblAltColor;
	}

	print <<EOT;
<tr$adcafeHdrTblColor><td><b>Environment Variable</b></td>
<td><b>Contents</b></td></tr>
EOT

	if ($ENV{'HTTP_REFERER'}) {
		$ENV{'HTTP_REFERER'} =~ s/http:\/\///i;
		$ENV{'HTTP_REFERER'} =~ s/\?/<BR>/;
	}

	$color = '';
	foreach $var (sort keys(%ENV)) {
		print "<tr valign=top$color><td width=50%>$var</td><td width=50%>$ENV{$var}</td></tr>";
		$color = ($color) ? '' : $adcafeTblAltColor;
	}

	print <<EOT;
</td></tr></table>
<P>
<CENTER>
EOT

	if ($adcafeTotalCd ne 'a') {	# live totals
		my $dsc = ($adcafeTotalCd eq 'b') ? 'Live Totals' : 'Totals';
		print STDOUT "<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_totals.cgi\" style=\"$adcafeLinkColor\"><B>&nbsp; $dsc &nbsp;</B></a>&#0124;";
	}
	if ($adcafeTotalCd ne 'd') {	# batch totals
		my $dsc = ($adcafeTotalCd eq 'b') ? 'Batch Totals' : 'Totals';
		print STDOUT "<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_tots.cgi\" style=\"$adcafeLinkColor\"><B>&nbsp; $dsc &nbsp;</B></a>&#0124;";
	}

	print STDOUT <<EOT; 
<A STYLE="text-decoration: none" HREF="${adcafeUrlCgi}adcafe_daily.cgi" style="$adcafeLinkColor"><B>&nbsp; Daily Snapshot &nbsp;</B></a>&#0124;
<A STYLE="text-decoration: none" HREF="${adcafeUrlCgi}adcafe_admin.cgi" style=\"$adcafeLinkColor\"><B>&nbsp; Admin &nbsp;</B></a>&#0124;
<A STYLE="text-decoration: none" HREF="${adcafeUrlCgi}adcafe_login.cgi" style=\"$adcafeLinkColor\"><B>&nbsp; Sponsor Login &nbsp;</B></a>
</CENTER>
EOT

	&htmlFooter;

	exit;
}
