#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - Advertiser management system
# Copyright (c) 1998 Infohiway
#
# Date routines
#
# adcafe_dates.cgi
#
# ==========================================================================

# 1 - exceeds today
# 0 - equal today
# -1 - less than today
sub cmpToday
{
	my $mon = shift;
	my $day = shift;
	my $year = shift;

	my ($curDay, $curMon, $curYear);
	($curDay, $curMon, $curYear) = (localtime(time))[3,4,5];
	$curMon++;
	$curYear += 1900;

	my $cmp = 0;	# assume equal
	if ($year == $curYear) {
		if ($mon == $curMon) {
			if ($day > $curDay) {
				$cmp = 1;
			} elsif ($day < $curDay) {
				$cmp = -1;
			}
		} elsif ($mon > $curMon) {
			$cmp = 1;
		} else {
			$cmp = -1;
		}
	} elsif ($year > $curYear) {
		$cmp = 1;
	} else {
		$cmp = -1;
	}

	return $cmp;
}

sub addDays
{
	my $mon = shift;
	my $day = shift;
	my $year = shift;
	my $days2add = shift;

	if ($days2add > 1) {
		$days2add--;
		my @daysJulian = (0, 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366);	# make 1 relative
		my $julDate = $daysJulian[$mon] + $day + $days2add;
		if ($julDate > 366) {
			$julDate -= 366;
			$year++;
		}
		$mon = 2;
		while ($julDate > $daysJulian[$mon]) {
			$mon++;
		}
		$mon--;
		$day = $julDate - $daysJulian[$mon];
	}

	return ($mon, $day, $year);
}

# 1 - Date 1 exceeds Date 2
# 0 - Dates equal
# -1 - Date 1 less than Date 2
sub cmpDate
{
	my $mon1 = shift;
	my $day1 = shift;
	my $year1 = shift;
	my $mon2 = shift;
	my $day2 = shift;
	my $year2 = shift;

	my $cmp = 0;	# assume equal
	if ($year1 == $year2) {
		if ($mon1 == $mon2) {
			if ($day1 > $day2) {
				$cmp = 1;
			} elsif ($day1 < $day2) {
				$cmp = -1;
			}
		} elsif ($mon1 > $mon2) {
			$cmp = 1;
		} else {
			$cmp = -1;
		}
	} elsif ($year1 > $year2) {
		$cmp = 1;
	} else {
		$cmp = -1;
	}

	return $cmp;
}

sub dayDiff
{
	my $mon = shift;
	my $day = shift;
	my $year = shift;

	my @daysJulian = (0, 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366);	# make 1 relative
	my $julDate = ($year * 1000) + $daysJulian[$mon] + $day;

	($day, $mon, $year) = (localtime(time))[3,4,5];
	$year += 1900; $mon++;
	my $julToday = ($year * 1000) + $daysJulian[$mon] + $day;
	$day = $julDate - $julToday;

	return $day;
}

sub daysInMonth
{
	my $mon = shift;
	my $year = shift;
	my @days = (0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
	my $max = $days[$mon];
	if ($mon == 2) {
		if ((($year%4 == 0) && ($year%100 != 0)) || ($year%400 == 0)) {
			$max++;
		}
	}
	return $max;
}

	return 1;	# force true
