#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - Advertiser management system
# Copyright (c) 1998 Infohiway
#
# Admin daily summary - Professional only
#
# adcafe_daily.cgi
#
# ==========================================================================

require 'adcafe_cfg.cgi';
require 'adcafe_dates.cgi';
require 'adcafe_gui.cgi';
require 'adcafe_security.cgi';
require 'adcafe_totdata.cgi';
require 'adcafe_totform.cgi';

MAIN:
{ 
	&getInput;
	unless (&okToRun($adcafeLoginAdminTotCd, $adcafeAdminId)) {
		print STDOUT "Location: ${adcafeUrlCgi}adcafe_login.cgi?rt=d\n\n";	# sponsor login
		exit;
	}

	$optSkipMsg = 't';
	$cgiTotals = 'adcafe_daily.cgi';
	my $errMsg = &setupDates;
	&htmlHeader('AdCafe Quick Totals');
	print STDOUT '<CENTER>';
	unless (length($errMsg) > 0) {
		&dspSiteTotals;
		&dspAdTotals;
	}

	&totEnd($errMsg);

	exit;
}

sub dspSectionHdg
{
	my $title = shift;
	print STDOUT "<P><TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>\n";
	print STDOUT "<TR$adcafeHdrTblColor><TD COLSPAN=4 ALIGN=CENTER><B>$title</B></TD></TR>\n";
	print STDOUT "<TR$adcafeHdrTblColor><TD><B>Description</B></TD><TD ALIGN=RIGHT><B>Impressions</B></TD><TD ALIGN=RIGHT><B>ClickThrus</B></TD><TD ALIGN=RIGHT><B>Yield</B></TD></TR>\n";
}

sub dspSiteTotals
{
	my $totHit = 0;
	&loadSites;
	&dspSectionHdg(' Server / Site Totals ');
	my @sites = sort {$siteInfo{$a} cmp $siteInfo{$b}} keys %siteInfo;
	my ($id, $name);
	if (@sites) {
		$totHit = &dspSite($adcafeTotId, $siteInfo{$adcafeTotId});
		my $color = $adcafeTblAltColor;
		while ($id = shift @sites) {
			unless ($id eq $adcafeTotId) {
				($name) = split(/\|/, $siteInfo{$id});
				if (&dspSite($id, $name, $color)) {
					$color = ($color) ? '' : $adcafeTblAltColor;
				}
			}
		}
	}
	print STDOUT "</TABLE>";
}

sub dspSite
{
	my $id = shift;
	my $desc = shift;
	my $color = shift;

	unless ($color) { $color = ''; }
	my ($hitC, $hitCA, $clkC, $clkCA, $yldC, $yldCA, $ctrC, $href);
	($hitC,$clkC,$ctrC) = &loadTotals($id);
	if ($id eq $adcafeTotId || $hitC > 0) {
		if ($siteInfo{$id}) {
			$href = "<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_statads.cgi\?id=$id&lgn=$adcafeLoginSiteCd\" onMouseOver=\"window.status=\'$desc Totals\'; return true\"><B>$desc</B></A>";
		} else {
			$href = $desc;
		}
		$yldC = ($hitC > 0) ? sprintf("%0.2f%%",($clkC / $hitC * 100)) : '0.00%';
		$hitC = fmtNumber($hitC);  $clkC = fmtNumber($clkC);
		print STDOUT "<TR VALIGN=TOP$color><TD WIDTH=50%>$href</TD><TD ALIGN=RIGHT>$hitC</TD><TD ALIGN=RIGHT>$clkC</TD><TD ALIGN=RIGHT>$yldC</TD></TR>\n";
		return $hitC;
	}

	return '';
}

sub dspAdTotals
{
	&loadGroups;
	&loadAdIds;
	my @ads = sort {$adName{$a} cmp $adName{$b}} keys %adName;
	unless (@ads) { return ''; }

	my @grps = sort {$groupName{$a} cmp $groupName{$b}} keys %groupName;
	my $color = '';  my ($id, @ids);
	&dspSectionHdg('Ad Totals');
	while ($id = shift @grps) {
		if (&dspAdGroup($id, $color)) {
			$color = ($color) ? '' : $adcafeTblAltColor;
		}
	}
	while (@ads) {
		$id = shift @ads;
		unless ($adGroup{$id}) {
			&dspAd($id, $color);
			$color = ($color) ? '' : $adcafeTblAltColor;
		}
	}
	print STDOUT "</TABLE>";

	return 1;
}

sub dspAd
{
	my $id = shift;
	my $color = shift;

	my $href = "<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_statads.cgi\?id=$id&lgn=$adcafeLoginAdCd\" onMouseOver=\"window.status=\'$adName{$id} Totals\'; return true\"><B>$adName{$id}</B></A>";
	print STDOUT "<TR$color VALIGN=TOP><TD WIDTH=50%>$href</B></TD>";
	&dspAdTot(&loadTotals($id));
}

sub dspAdGroup
{
	my $group = shift;
	my $color = shift;
	my @ids = sort(split(/\,/, $groupAds{$group}));
	my ($totHC, $totCC, $hitC, $clkC, $yldC, $id, $ads);
	while ($id = shift @ids) {
		($hitC,$clkC) = &loadTotals($id);
		$totHC += $hitC; $totCC += $clkC;
		if ($hitC > 0 || $clkC > 0) {
			$yldC = ($hitC > 0) ? sprintf("%0.2f%%",($clkC / $hitC * 100)) : '0.00%';
			$hitC = fmtNumber($hitC);  $clkC = fmtNumber($clkC);
			$ads .= "<TR$color VALIGN=TOP><TD WIDTH=50%><A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_statads.cgi\?id=$id&lgn=$adcafeLoginAdCd\" onMouseOver=\"window.status=\'$adName{$id} Totals\'; return true\">&nbsp;&nbsp;&nbsp;<B>$adName{$id}</B></A></TD><TD ALIGN=RIGHT>$hitC</TD><TD ALIGN=RIGHT>$clkC</TD><TD ALIGN=RIGHT>$yldC</TD></TR>\n";
		}
	}
	unless ($totHC > 0 || $totCC > 0) { return ''; }

	my $href = "<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_statads.cgi\?id=$group&lgn=$adcafeLoginGroupCd\" onMouseOver=\"window.status=\'$groupName{$group} Totals\'; return true\"><B>$groupName{$group}</B></A>";
	print STDOUT "<TR$color VALIGN=TOP><TD WIDTH=50%>$href</B></TD>";
	&dspAdTot($totHC,$totCC);
	print STDOUT $ads;
	return 1;
}


sub dspAdTot
{
	my $hitC = shift; my $clkC = shift;

	$yldC = ($hitC > 0) ? sprintf("%0.2f%%",($clkC / $hitC * 100)) : '0.00%';
	$hitC = fmtNumber($hitC);  $clkC = fmtNumber($clkC);

	print STDOUT "<TD ALIGN=RIGHT>$hitC</TD><TD ALIGN=RIGHT>$clkC</TD><TD ALIGN=RIGHT>$yldC</TD></TR>\n";
}

sub loadTotals
{
	my $id = shift;
	my $totHits = 0;  my $totClks = 0;
	if ($adcafeTotalCd eq 'd') {
		unless(defined(%dayTots)) {
			&loadDayTotals;
		}
		($totHits,$totClks) = split(/\|/, $dayTots{$id});
	} else {
		my $mon = $input{'smon'}; my $day = $input{'sday'}; my $year = $input{'syear'};
		my $monEnd = $input{'emon'}; my $dayEnd = $input{'eday'}; my $yearEnd = $input{'eyear'};
		my $endMonth = &daysInMonth($mon, $year);
		my ($hits, $clks, $key);
		my %tots = ();
		dbmopen(%tots,"${adcafeDirTotals}$id",0666);
		while ($year < $yearEnd || ($year == $yearEnd && $mon < $monEnd) || ($year == $yearEnd && $mon == $monEnd && $day <= $dayEnd)) {
			$key = sprintf("%04d%02d%02d", $year, $mon, $day);
			($hits,$clks) = split(/\|/, $tots{$key});
			if ($hits > 0 || $clks > 0) {
				$totHits += $hits;  $totClks += $clks;
			}
			$day++;
			if ($day > $endMonth) {
				$day = 1; $mon++;
				if ($mon > 12) {
					$mon = 1; $year++;
				}
				$endMonth = &daysInMonth($mon, $year);
			}
		}
		dbmclose(%tots);
	}

	return ($totHits, $totClks);
}

sub loadAdIds
{
	my $mon = $input{'smon'}; my $day = $input{'sday'}; my $year = $input{'syear'};
	my $monEnd = $input{'emon'}; my $dayEnd = $input{'eday'}; my $yearEnd = $input{'eyear'};
	my $endMonth = &daysInMonth($mon, $year);
	my $totHits = 0;  my $totClks = 0;  my $ctr = 0;
	my ($file, $key);
	%adName = ();
	while ($year < $yearEnd || ($year == $yearEnd && $mon < $monEnd) || ($year == $yearEnd && $mon == $monEnd && $day <= $dayEnd)) {
		$file = sprintf("adcafe%04d%02d%02d\.key", $year, $mon, $day);
		if (-e "$adcafeDirTotals$file") {
			open(ID, "$adcafeDirTotals$file");
			while(<ID>) {
				chop;
				unless ($adName{$_}) {
					$adName{$_} = &loadAdName($_);
				}
			}
			close(ID);
		}
		$day++;
		if ($day > $endMonth) {
			$day = 1; $mon++;
			if ($mon > 12) {
				$mon = 1; $year++;
			}
			$endMonth = &daysInMonth($mon, $year);
		}
	}
}

sub loadDayTotals
{
	my $mon = $input{'smon'}; my $day = $input{'sday'}; my $year = $input{'syear'};
	my $monEnd = $input{'emon'}; my $dayEnd = $input{'eday'}; my $yearEnd = $input{'eyear'};
	my $endMonth = &daysInMonth($mon, $year);
	my ($name, $id, $data, $key);
	while ($year < $yearEnd || ($year == $yearEnd && $mon < $monEnd) || ($year == $yearEnd && $mon == $monEnd && $day <= $dayEnd)) {
		$key = sprintf("%04d%02d%02d", $year, $mon, $day);
		$name = "${adcafeDirTotals}adcafe$key\.ctr";
		if (-e $name) {
			open(CTR,$name);
			$_ = <CTR>;	# grand totals
			chop($_) if $_ =~ /\n$/;
			&updtTot($adcafeTotId, $_);
			while(<CTR>) {
				chop if $_ =~ /\n$/;
				($id, $data) = split(/,/, $_, 2);
				&updtTot($id, $data);
			}
			close(CTR);
		}
		$day++;
		if ($day > $endMonth) {
			$day = 1; $mon++;
			if ($mon > 12) {
				$mon = 1; $year++;
			}
			$endMonth = &daysInMonth($mon, $year);
		}
	}
	unless ($siteTotal{$adcafeTotId}) {
		$dayTots{$adcafeTotId} = "0,0";
	}
}

sub updtTot
{
	my $id = shift;
	my $data = shift;
	($hit, $clk) = split(/,/, $data, 2);
	if ($siteTotal{$id}) {
		my ($h, $c);
		($h, $c) = split(/,/, $dayTots{$id});
		$hit += $h; $clk += $c;
		$dayTots{$id} = "$hit,$clk";
	} else {
		$dayTots{$id} = "$hit,$clk";
	}
}
