#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - ad clickthru routines
# Copyright (c) 1998 Infohiway
#
# Ad clickthru routines
#
# adcafe_click.cgi
#
# ==========================================================================

require 'adcafe_cfg.cgi';
require 'adcafe_getad.cgi';

MAIN:
{
	&getInput;
	$| = 1;

	my ($adId, $adSite);
	my $adUrl = $input{'url'};
	if (length($adUrl) < 1) {
		($adId, $adSite, $adUrl) = &getUser();
	} else {
		$adId = $input{'id'};
		$adSite = $input{'site'};
	}
	if (length($adUrl) < 1) {
		&htmlError();
		&logEvent(3, "Rtn=click\|User=$ENV{'REMOTE_ADDR'}");
	} else {
		if ($adId eq $adDefId) {
			$adUrl = $adDefUrl;
		}
		$adInfo{'id'} = $adId;
		$adInfo{'site'} = $adSite;
		&updateAdCtr($adId) if $adcafeChkIfExp eq 'c';
		&updtTotal(0, 1) if $adcafeTotalCd ne 'a';
		&logAd('C');
		print STDOUT "Location: $adUrl\n\n";		# give it to the server.
	}

	&exitCheck;
}

sub updateAdCtr
{
	my $id = shift;
	my ($cd, $hit, $clk, $opts, $rec);
	my $lock = &lockAdCtr($id);
	($rec, $opts) = &loadAdCtr($id);
	($hit, $clk) = split(/\|/, $rec);
	$clk++;
	&saveAdCtr($id, "$hit\|$clk", $opts);
	&unlockAdCtr($id) if $lock > 0;
}

sub getUser
{
	my $user = $ENV{'REMOTE_ADDR'};
	$user =~ s/\./_/g;

	my @adId;
	my $usrName = "${adcafeDirData}usr$user\.tmp";
	if (-e $usrName) {
		my $tag = ($input{'tag'}) ? $input{'tag'} : 0;
		open(USR,"$usrName");
		<USR>;	# time stamp
		while (<USR>) {
			chop;
			@adId = split(/\|/,$_);
			last if ($adId[1] eq $input{'site'} && $adId[3] eq $tag);
		}
		close(USR);
	}

	return @adId;
}

sub htmlError
{
	print STDOUT $adcafeHdrResponse;
	print STDOUT <<EOT;
<HTML><HEAD><TITLE>AdCafe Clickthru Error</TITLE></HEAD>
<BODY $adcafeBodyColor>
<FONT SIZE=+1 $adcafeFontErrColor>Invalid destination for $ENV{'REMOTE_ADDR'}</FONT>
<P>Sorry, but the server encountered an error
while trying to redirect you to the destination of the banner on which you clicked!
This probably occurred by an attempt to click on a banner before the graphic image
has loaded.  
<P>
Another possibility is that you attempted to click on an old banner which was reloaded
from your browser's cache.
</BODY></HTML>
EOT

}
