#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - cleanup files on disk
# Copyright (c) 1998 Infohiway
#
# Remove temporary files from data directory
#
# adcafe_clean.cgi
#
# ==========================================================================

sub cleanFiles
{ 
	my ($file, @files, $lastTime);
	my $curTime = time;
#	print STDOUT "Clean up $adcafeDirData\n";
	if (opendir(DIR, "$adcafeDirData")) {
		@files = readdir(DIR);
		closedir(DIR);
		@files = grep(!/^(\.|\.\.)$/,@files);
		@files = grep(/^usr\w*\.(tmp|pwd)$/,@files);
	}
	while ($file = shift @files) {
		$file = "$adcafeDirData$file";
		if (-f $file) {	# not directory
			open(USR, $file);
			$lastTime = <USR>;  chop($lastTime);
			close(USR);
			if (($curTime - $lastTime) > 750) {
				unlink $file;
#				print STDOUT "Delete $file\n";
			}
		}
	}

	$file = "${adcafeDirData}adcafe\.cfg";
	if (-e $file) {
		open(CFG,"$file");
		my ($id, $name);
		while (<CFG>) {
			chop($_) if $_ =~ /\n$/;
			($id, $name) = split(/\=/, $_);
			&update1Site($id);
		}
		close(CFG);
	}
#	print STDOUT "Clean up Completed\n";
}

sub update1Site
{
	my $site = shift;
	my $file = "${adcafeDirData}adsite$site\.cfg";
	if (&fileLock($file, \*LSITE)) {
		my ($id, $opt, $cd, @ads);
		my $tmp = "0\|0\n";
		if (-e $file) {
			open(SITE, $file);
			$tmp = <SITE>;	# cycle ctr
			@ads = <SITE>;	#load ads
			close(SITE);
		}

		open(SITE, ">$file");
		print SITE $tmp;
		while ($_ = shift @ads) {
			chop if $_ =~ /\n$/;
			($id, $opt, $cd, $tmp) = split(/\|/, $_, 4);
			if ($cd eq 'E') {
				&updateAd($id);
			} else {
				print SITE "$_\n";
			}
		}
		close(SITE);
		&fileUnlock($file, \*LSITE);
	} else {
		&logEvent(6, "Rtn=clean\|File=adsite.cfg\|Site=$site\|Msg=Cleanup expired");
	}
}

sub updateAd
{
	my $id = shift;
	my $file = "$adcafeDirData$id\.ad";
	unless (-e $file) {
		return '';
	}

	my ($day,$mon,$year);
	($day,$mon,$year) = (localtime(time))[3,4,5];
	$mon++;  $year += 1900;
	if (&fileLock($file, \*LAD)) {
		open(AD, $file);
		my @ads = <AD>;
		close(AD);
		$ads[8] = $adcafeInactiveSiteCd;
		my $num = $#ads;
		while ($num < 14) {
			$ads[$num] = '';
			$num++;
		}
		$ads[$num] = "Dates: $ads[7] - $mon/$day/$year\n";

		open(AD, ">$file");
		my $adRec = join("\n",@ads);
		print AD @ads;
		close(AD);
		&fileUnlock($file, \*LAD);
	} else {
		&logEvent(6, "Rtn=clean\|File=$id\.ad|Id=$id");
	}

	return 1;
}

	return 1;	# force true

