#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - manage batch totals update
# Copyright (c) 1998 Infohiway
#
# Ad Batch total update
#
# adcafe_batch.cgi
#
# ==========================================================================

require 'adcafe_cfg.cgi';
require 'adcafe_dates.cgi';
require 'adcafe_lock.cgi';
require 'adcafe_update.cgi';

sub batchUpdate
{
	my $updLog = "${adcafeDirLogs}adcafe.log";
	if (-e $updLog) {
		if (&fileLock($updLog, \*LUPD)) {
			my (@recs, @year, @mon, @day);
			open(UPD,$updLog);
			while (<UPD>) {
				chop;
				if (/(\d\d\d\d)(\d\d)(\d\d)/) {
					if (&cmpToday($2, $3, $1) < 0) {
						push(@year, $1); push(@mon, $2); push(@day, $3); 
					} else {
						push(@recs, $_);
					}
				}
			}
			close(UPD);
			open(UPD, ">$updLog");
			print UPD join("\n", @recs);  print UPD "\n";
			close(UPD);
			&fileUnlock($updLog, \*LUPD);
			my ($y, $m, $d);
			while ($y = shift @year) {
				$m = shift @mon;  $d = shift @day;
				&logEvent(8, "msg=Update $m/$d/$y");
#				system 'perl', 'adcafe_update.cgi', "$y", "$m", "$d";
				&updateTotals($y, $m, $d);
			}
		} else {
			&logEvent(6, "Rtn=batch\|File=$updLog");
		}
	} else {
		&logEvent(8, "msg=Update previous day");
		my ($d, $m, $y) = (localtime(time))[3,4,5];
		$m++; $y += 1900;  $d--;	# log yesterday's stuff
		if ($d < 1) {
			$m--;
			if ($m == 0) {
				$m = 12; $y--;
			}
			$d = &daysInMonth($m, $y);
		}
		&updateTotals($y, $m, $d);
#		system 'perl', 'adcafe_update.cgi';
	}
}

	return 1;	# force true
