#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - Advertiser management system
# Copyright (c) 1998 Infohiway
#
# Show all adds for group
#
# adcafe_allgrp.cgi
#
# ==========================================================================

require 'adcafe_cfg.cgi';
require 'adcafe_gui.cgi';
require 'adcafe_allads.cgi';

MAIN:
{ 
	&getInput;
	$| = 1;

	&loadGroupInfo;
	&htmlStart;
	&htmlAds;
	&htmlFooter;

	exit;
}


sub htmlStart
{
	my $title = "AdCafe Ads for $input{'name'}";
	&htmlHeader($title);
}

sub loadGroupInfo
{
	$idView = $input{'grp'};
	%adActive = ();
	my $file = "${adcafeDirData}adgroup\.cfg";
	if (-e $file) {
		open(GRPCFG, $file);
		my ($id, $name, $tmp, $ads);
		while (<GRPCFG>) {
			chop($_);
			($id, $name, $tmp, $ads) = split(/\|/,$_);
			if ($id eq $idView) {
				$input{'name'} = $name;
				my @ads = split(/\,/, $ads);
				while (@ads) {
					$tmp = shift @ads;
					$adActive{$tmp} = 1;
				}
				last;
			}
		}
		close(GRPCFG);
	}
	unless ($input{'name'}) {
		$input{'name'} = "Error: $file";
	}
}
