#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - Advertiser management system
# Copyright (c) 1997 Infohiway
#
# Show all adds for site
#
# adcafe_all.cgi
#
# ==========================================================================

require 'adcafe_cfg.cgi';
require 'adcafe_gui.cgi';
require 'adcafe_allads.cgi';

MAIN:
{ 
	&getInput;
	$| = 1;

	&loadSiteName;
	&htmlStart;
	&htmlAds;
	&htmlFooter;

	exit;
}


sub htmlStart
{
	my $title = "AdCafe Ads for $input{'name'}";
	&htmlHeader($title);
}

sub loadSiteName
{
	$idView = $input{'site'};
	my $file = "${adcafeDirData}adcafe\.cfg";
	%adActive = ();
	unless ($idView) {
		$input{'name'} = $adCafeServer;
	}
	if (-e $file) {
		open(CFG, $file);
		my ($id, $name);
		while (<CFG>) {
			chop;
			($id, $name) = split(/\=/, $_);
			unless ($idView) {
				&loadSiteAds($id);
			} elsif ($id eq $idView) {
				($input{'name'}) = split(/\|/, $name);
				&loadSiteAds($id);
				last;
			}
		}
		close(CFG);
	}
	unless ($input{'name'}) {
		$input{'name'} = "Error: $file";
	}
}

sub loadSiteAds
{
	my $site = shift;
	my $file = "${adcafeDirData}adsite$site\.cfg";
	if (-e $file) {
		open(SITE, $file);
		<SITE>;	# skip
		my ($rec, $id);
		while (<SITE>) {
			chop if $_ =~ /\n$/;
			($id, $rec) = split(/\|/, $_, 2);
			unless ($adActive{$id}) {
				$adActive{$id} = "$site\|$rec";
			}
		}
		close(SITE);
	}
}
