#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - Advertiser management system
# Copyright (c) 1998 Infohiway
#
# Maintenance for ads
#
# adcafe_ads.cgi
#
# ==========================================================================

require 'adcafe_cfg.cgi';
require 'adcafe_gui.cgi';
require 'adcafe_dates.cgi';
require 'adcafe_lock.cgi';
require 'adcafe_security.cgi';

MAIN:
{
	&getInput;
	$| = 1;
	unless (&okToRun($adcafeLoginAdminCd, $adcafeAdminId)) {
		print STDOUT "Location: ${adcafeUrlCgi}adcafe_login.cgi?rt=am&a=$input{'a'}&rh=$input{'rh'}\n\n";	# sponsor login
		exit;
	}
	my $ad = $input{'id'};
	my $action = $input{'a'};
	if ($input{'doit'}) {	# update
		my $errFlag = &updateAd;
		&htmlNext($errFlag);
	} elsif ($input{'can'}) {	# cancel update
		&htmlNext();
	} else {
		&htmlStart($action);
		if ($action eq 'd') {	# delete
			&htmlDelete($ad);
		} elsif ($action eq 'e') {	# edit
			&htmlEdit($ad);
		} else {
			&htmlAdd($ad);
		}
		&htmlEnd;
	}

	exit;
}

sub htmlEdit
{
	my $ad = shift;
	&htmlData($ad);
}

sub htmlAdd
{
	my $ad = shift;
	&htmlData($ad);
}

sub htmlData
{
	my $adId = shift;
	my ($adHref, $adGifs, $adAlt, $adPswd, $adType, $adFreq, $adMax, $adStartDate,
		$adSites, $adWhen, $adTgtList, $adTgtName, $adBegTime, $adEndTime, 
		$adBrowsers, $adSystems, $adDays, $adNotes, $adHeight, $adWidth, $adBorder,
		$adRawHtml, $adExchg, $adAmt, $adCo, $adRefresh, $adEmail);

	($adHref,$adGifs,$adAlt,$adHeight,$adCo,$adPswd,$adType,$adStartDate,
		$adSites,$adWhen,$adRawHtml,$adRefresh,$adEmail,$adAmt,$adNotes) = &loadAdData($adId);

	my ($butSubmit, $butCancel, $action, $adIdData);
	if ($input{'a'} eq 'e') {
		$butSubmit = 'Update Ad';
		$butCancel = ' Cancel Update ';
		$action = 'e';
		$adIdData = "<B>$adId</B><INPUT TYPE=HIDDEN NAME=id VALUE=$adId>";
	} else {
		$butCancel = ' Cancel Add ';
		$butSubmit = 'Add New Ad';
		$action = 'a';
		unless ($input{'doit'}) {
			$adId = '';		# in case copy of another ad
		}
		$adIdData = "<INPUT TYPE=TEXT NAME=id SIZE=10 VALUE=\"$adId\">";
	}

	($adStartDate) = &fmtDate($adStartDate);
	($adSites) = &loadSites($adSites);
	($adHref, $adTgtList, $adTgtName) = &fmtHref($adHref);
	($adMax, $adType, $adFreq, $adExchg) = &fmtType($adType);
	($adWhen, $adDays, $adBegTime, $adEndTime, $adBrowsers, $adSystems) = &fmtCond($adWhen);
	if (length($adGifs) > 0) {
		$adGifs =~ s/\|/\n/g;
		$adGifs =~ s/\xfc/\|/g;
	} else {
		$adGifs = $adDefGifUrl;
	}
	$adRawHtml =~ s/\|/\n/g;
	my $rawHtml = &fmtRawHtml($adRawHtml);
	($adHeight, $adWidth, $adBorder) = &fmtImg($adHeight);
	unless ($adRefresh) { $adRefresh = $adcafeRotate; }
	$adAmt = fmtAmt($adAmt);

	my $curTime = &fmtTime(time);

	print STDOUT <<EOT;
<P><CENTER><FORM METHOD=POST ACTION="${adcafeUrlCgi}adcafe_ads.cgi">
<TABLE CELLPADDING=3><TR><TD>
<INPUT TYPE=HIDDEN NAME=a VALUE="$action">
<INPUT TYPE=HIDDEN NAME=rh VALUE="$input{'rh'}">
<INPUT TYPE=HIDDEN NAME=db VALUE="a">
Ad ID:</TD><TD>$adIdData</TD></TR>
<TR><TD>Company:</TD><TD><INPUT TYPE=TEXT NAME=co SIZE=45 VALUE="$adCo"></TD></TR>
<TR><TD>HREF (where click goes):</TD><TD><INPUT TYPE=TEXT NAME=href SIZE=45 VALUE="$adHref"></TD></TR>    
<TR><TD>Target (Where HREF displayed):</TD><TD>
$adTgtList
<BR>Frame Name&nbsp;<INPUT TYPE=TEXT NAME=frm SIZE=10 VALUE="$adTgtName"></TD></TR>    
<TR><TD>Ad Banners:</TD><TD><TEXTAREA COLS=35 ROWS=3 NAME=gif WRAP=off>$adGifs</TEXTAREA></TD></TR>
<TR><TD>Alternate Banner Desc:</TD><TD><INPUT TYPE=TEXT NAME=alt SIZE=35 VALUE="$adAlt"></TD></TR>
<TR><TD>Banner size:</TD><TD>Height&nbsp;<INPUT TYPE=TEXT NAME=height SIZE=5 VALUE="$adHeight">
&nbsp;&nbsp;Width&nbsp;<INPUT TYPE=TEXT NAME=width SIZE=5 VALUE="$adWidth">
&nbsp;&nbsp;Border&nbsp;<INPUT TYPE=TEXT NAME=border SIZE=3 VALUE="$adBorder"></TD></TR>
<TR><TD>Sites displayed on:</TD><TD>$adSites</TD></TR>
<TR><TD>Date Start (mm/dd/yy):</TD><TD><INPUT TYPE=TEXT NAME=dt SIZE=15 VALUE="$adStartDate"></TD></TR>
<TR><TD>Run for:</TD><TD><INPUT TYPE=TEXT NAME=max SIZE=10 VALUE="$adMax">
$adType
</TD></TR>
<TR><TD>Frequency of Rotation:</TD><TD>
$adFreq
</TD></TR>
<TR><TD>Password:</TD><TD><INPUT TYPE=TEXT NAME=pswd SIZE=25 VALUE="$adPswd"></TD></TR>
<TR><TD>Times(on Server) Ad is active (current $curTime)</TD><TD>
$adDays $adWhen
<BR>Hour(0-23): Start&nbsp;<INPUT TYPE=TEXT NAME=tms SIZE=2 VALUE="$adBegTime">
&nbsp;End&nbsp;<INPUT TYPE=TEXT NAME=tme SIZE=2 VALUE="$adEndTime">
</TD></TR>
<TR><TD>Browsers Ad is active for:</TD><TD>
$adBrowsers
</TD></TR>
<TR><TD>Systems Ad is active for:</TD><TD>
$adSystems
</TD></TR>
<TR><TD>Raw HTML:</TD><TD><TEXTAREA COLS=35 ROWS=5 NAME=raw WRAP=off>$rawHtml</TEXTAREA></TD></TR>
<TR><TD>Email:</TD><TD><INPUT TYPE=TEXT NAME=email SIZE=30 VALUE="$adEmail"></TD></TR>
<TR><TD>Frame Refresh rate:</TD><TD><INPUT TYPE=TEXT NAME=rfrate SIZE=5 VALUE="$adRefresh"></TD></TR>
<TR><TD>Total Ad Amount:</TD><TD><INPUT TYPE=TEXT NAME=amt SIZE=15 VALUE="$adAmt"></TD></TR>
<TR><TD>Notes:</TD><TD><TEXTAREA COLS=35 ROWS=5 NAME=notes WRAP=off>$adNotes</TEXTAREA></TD></TR>
<TR><TD COLSPAN=2><HR SIZE=1></TD></TR>
<TR><TD ALIGN=CENTER>
<P><INPUT TYPE=SUBMIT NAME=doit VALUE="$butSubmit">
</TD><TD ALIGN=CENTER><P><INPUT TYPE=SUBMIT NAME=can VALUE="$butCancel">
</TD></TR></TABLE></FORM></CENTER>
<HR SIZE=2 NOSHADE>
EOT
# <TR><TD>Exchange Ratio:</TD><TD><INPUT TYPE=TEXT NAME=ratio SIZE=3 VALUE="$adExchg"></TD></TR>

	if (length($adRawHtml) > 0) {
		&htmlRaw($adRawHtml, $adGifs, $adHref, $adAlt, $adHeight, $adWidth, $adBorder);
	}
	&htmlDspAd($adGifs, $adHref, $adAlt, $adHeight, $adWidth, $adBorder);
}

sub htmlDelete
{
	my $adId = shift;
	my ($adHref,$adGifs,$adAlt,$adPswd,$adType,$adFreq,$adMax,$adStartDate,
		$adSites,$adWhen,$adBrowsers,$adSystems,$adTgtList,$adTgtName,
		$adBegTime,$adEndTime,$adDays,$adNotes, $adHeight, $adWidth, $adBorder,
		$adRawHtml, $adExchg, $adAmt, $adCo, $adRefresh, $adEmail);

	($adHref,$adGifs,$adAlt,$adHeight,$adCo,$adPswd,$adType,$adStartDate,
		$adSites,$adWhen,$adRawHtml,$adRefresh,$adEmail,$adAmt,$adNotes) = &loadAdData($adId);

	($adStartDate) = &fmtDate($adStartDate);
	($adSites) = &loadSites($adSites, 'd');
	($adHref, $adTgtList, $adTgtName) = &fmtHref($adHref, 'd');
	($adMax, $adType, $adFreq, $adExchg) = &fmtType($adType, 'd');
	($adWhen, $adDays, $adBegTime, $adEndTime, $adBrowsers, $adSystems) = &fmtCond($adWhen, 'd');
	$adGifs =~ s/\|/&lt;BR&gt;/g;
	$adGifs =~ s/\xfc/\|/g;
	$adNotes =~ s/\n/&lt;BR&gt;/g;
	$adRawHtml =~ s/\|/\n/g;
	my $rawHtml = &fmtRawHtml($adRawHtml);
	($adHeight, $adWidth, $adBorder) = &fmtImg($adHeight);
	$adAmt = fmtAmt($adAmt);

	print STDOUT <<EOT; 
<CENTER><B>Are you sure you want to delete this advertisement:</B>
<P><TABLE CELLPADDING=3>
<TR><TD>Ad ID:</TD><TD><B>$adId</B></TD></TR>
<TR><TD>Company:</TD><TD><B>$adCo</B></TD></TR>
<TR><TD>HREF:</TD><TD><B>$adHref</B></TD></TR>
<TR><TD>Target:</TD><TD><B>$adTgtList $adTgtName</B></TD></TR>
<TR><TD VALIGN=TOP>Ad Banners:</TD><TD><B>$adGifs</B></TD></TR>
<TR><TD>Alternate banner desc:</TD><TD><B>$adAlt</B></TD></TR>
<TR><TD>Banner size:</TD><TD>Height&nbsp;<B>$adHeight</B>
&nbsp;&nbsp;Width&nbsp;<B>$adWidth</B>&nbsp;&nbsp;Border&nbsp;<B>$adBorder</B></TD></TR>
<TR><TD VALIGN=TOP>Sites displayed on:</TD><TD><B>$adSites</B></TD></TR>
<TR><TD>Date Start:</TD><TD><B>$adStartDate</B></TD></TR>
<TR><TD>Run for:</TD><TD><B>$adMax $adType</B></TD></TR>
<TR><TD>Frequency of rotation:</TD><TD><B>$adFreq</B></TD></TR>
<TR><TD>Password:</TD><TD><B>$adPswd</B></TD></TR>
<TR><TD VALIGN=TOP>Time Active:</TD><TD><B>$adDays $adWhen<BR>$adBegTime $adEndTime</B></TD></TR>
<TR><TD>Browser:</TD><TD><B>$adBrowsers</B></TD></TR>
<TR><TD>System:</TD><TD><B>$adSystems</B></TD></TR>
<TR><TD>Raw HTML:</TD><TD><B>$rawHtml</B></TD></TR>
<TR><TD>Email:</TD><TD><B>$adEmail</B></TD></TR>
<TR><TD>Frame refresh rate:</TD><TD><B>$adRefresh</B></TD></TR>
<TR><TD>Total Ad Amount:</TD><TD><B>$adAmt</B></TD></TR>
<TR><TD VALIGN=TOP>Notes:</TD><TD><B>$adNotes</B></TD></TR>
</TABLE><HR SIZE=1>
<P><FORM METHOD=POST ACTION="${adcafeUrlCgi}adcafe_ads.cgi">
<TABLE CELLPADDING=3><TR><TD ALIGN=CENTER>
<INPUT TYPE=HIDDEN NAME=a VALUE="d">
<INPUT TYPE=HIDDEN NAME=db VALUE="a">
<INPUT TYPE=HIDDEN NAME=id VALUE=$adId>
<INPUT TYPE=HIDDEN NAME=rh VALUE="$input{'rh'}">
<INPUT TYPE=SUBMIT NAME=doit VALUE="Delete Ad">
</TD><TD ALIGN=CENTER><INPUT TYPE=SUBMIT NAME=can VALUE=" Cancel Delete ">
</TD></TR></TABLE></FORM></CENTER>
<HR SIZE=2 NOSHADE>
EOT

	if (length($adRawHtml) > 0) {
		&htmlRaw($adRawHtml, $adGifs, $adHref, $adAlt, $adHeight, $adWidth, $adBorder);
	}

	$adGifs =~ s/&lt;BR&gt;/\n/g;
	&htmlDspAd($adGifs, $adHref, $adAlt, $adHeight, $adWidth, $adBorder);
}

sub htmlDspAd
{
	my $adGif = shift;	my $adHref = shift;	my $adAlt = shift;
	my $adH = shift;	my $adW = shift;	my $adB = shift;
	if (length($adGif) == 0) { return; }
	if ($adGif eq $adDefGifUrl) { return; }

	unless ($adH > 0) { $adH = $adDefHeight; }
	unless ($adW > 0) { $adW = $adDefWidth; }
	unless ($adB) { $adB = $adDefBorder; }

	my @ads = split(/\n/, $adGif);
	my ($num, $len, $tmp, $gifUrl);
	my $maxLen = 80;
	my $dynTag = substr(time, -6);
	$adHref =~ s/\[DT\]/$dynTag/;
	while ($adGif = shift @ads) {
		$adGif =~ s/\[DT\]/$dynTag/;
		$len = length($adGif);
		if ($len > $maxLen) {
			$ix = int($len / $maxLen);
			$num = int ($maxLen / $ix) + 1;
			$gifUrl = substr($adGif, 0, $num);
			for ($ix = $num, $len = $num; $ix < $maxLen; $ix += $num) {
				$gifUrl .= '<BR>';
				if ($ix + $len > $maxLen) { $len = $maxLen - $ix; }
				$gifUrl .= substr($adGif, $ix, $len);
			}
		} else {
			$gifUrl = $adGif;
		}
		print STDOUT <<EOT;
</TD></TR><TR><TD ALIGN=CENTER>
<A HREF="$adHref" TARGET="new">
<IMG SRC="$adGif" WIDTH=$adW HEIGHT=$adH border=$adB ALT="$adAlt"></A>
<BR>$gifUrl<BR>
<HR SIZE=1 NOSHADE>
EOT
	}

}

sub htmlRaw
{
	my $adHtml = shift;  my $adGifs = shift;
	my $adHref = shift;	my $adAlt = shift;
	my $adH = shift;	my $adW = shift;	my $adB = shift;

	unless ($adH > 0) { $adH = $adDefHeight; }
	unless ($adW > 0) { $adW = $adDefWidth; }
	unless ($adB > 0) { $adB = $adDefBorder; }

	my @ads = split(/\n/, $adGifs);

	my $dynTag = substr(time, -6);

	my $gif = $ads[0];
	$gif =~ s/\[DT\]/$dynTag/;
	$adHref =~ s/\[DT\]/$dynTag/;
	my @lines = split(/\|/, $adHtml);
	while(@lines) {
		$adHtml = shift @lines;
		$adHtml =~ s/\[HREF\]/\"$adHref\" TARGET=\"_new\"/g;
		$adHtml =~ s/\[IMG\]/\"$gif\" WIDTH=$adW HEIGHT=$adH border=$adB ALT=\"$adAlt\"/g;
		$adHtml =~ s/\[CLICK\]/$adHref/g;
		$adHtml =~ s/\[GIF\]/$gif/g;
		$adHtml =~ s/\[URL\]/$adHref/g;
		$adHtml =~ s/\[ALT\]/$adAlt/g;
		$adHtml =~ s/\[DT\]/$dynTag/g;
		print STDOUT "$adHtml\n";
	}

	if (length($adGifs) == 0) { return; }

	print STDOUT <<EOT;
<HR SIZE=1 NOSHADE>
<CENTER>Default Ad Gifs</CENTER><BR>
EOT

}

sub updateAd
{
	my $errMsg = &validateInput;
	my $errFlag = '';
	if (length($errMsg) > 0) {
		&htmlError($errMsg);
		$errFlag = 1;
	} else {
		my $action = $input{'a'};
		if ($action eq 'd') {
			$errFlag = &adDelete;
		} else {
			$errFlag = &adUpdate;
		}
	}

	return $errFlag;
}

sub adDelete
{
	my $ad = $input{'id'};
	my $errFlag = '';
	my $file = "$adcafeDirData$ad\.ad";
	if (-e $file) {
		unlink $file;
		&updateAdMaster($ad);
		&updateSites($ad, '');
		&updateGroups($ad);
		$file = "$adcafeDirTotals$ad\.ctr";
		if (-e $file) { unlink $file; }
	} else {
		&htmlError("Fatal Error: Could not find $file");
		$errFlag = 1;
	}

	return $errFlag;
}

sub adUpdate
{
	my $errFlag = '';
	my $ad = $input{'id'};
	my $file = "$adcafeDirData$ad\.ad";
	if ($input{'a'} ne 'a') {	# add
		unless (-e $file) {
			$errFlag = 1;
		}
	}
	if ($errFlag == 1) {
		&htmlError("Fatal Error: Could not find $file");
	} else {
		if (&fileLock($file, \*LAD)) {
			open(AD,">$file");
			my (@adRecs);
			@adRecs = &bldAdRec;
			my $adRec = join("\n",@adRecs);
			print AD "$adRec\n";
			close(AD);
			&fileUnlock($file, \*LAD);
			if ($input{'a'} ne 'e') {
				updateAdMaster($ad);
			}
			my $adOpt = &bldAdOpt($adRecs[9]);
			&updateSites($ad, $adRecs[8], $adOpt);
		} else {
			&logEvent(6, "Rtn=ads\|File=$ad\.ad|Id=$ad");
		}
	}

	return $errFlag;
}

sub updateAdMaster
{
	my $id = shift;
	my $file = "${adcafeDirData}ads\.cfg";
	my @ads;
	if (&fileLock($file, \*LADS)) {
		if (-e $file) {
			open(ADS, $file);
			while (<ADS>) {
				chop if $_ =~ /\n$/;
				push(@ads, $_);
			}
			close(ADS);
		}
		open(ADS, ">$file");
		while ($_ = shift @ads) {
			unless ($_ eq $id) {
				print ADS "$_\n";
			}
		}
		if ($input{'a'} eq 'a') {	# add
			print ADS "$id\n";
		}
		close(ADS);
		&fileUnlock($file, \*LADS);
	} else {
		&logEvent(6, "Rtn=ads\|File=ads.cfg\|Id=$id");
	}
}

sub updateGroups
{
	my $ad = shift;
	my ($group, $name, $pswd, $adIds, @ads, $data, $flagUpd);
	while(($group, $data)=each(%groupInfo)) {
		($name, $pswd, $adIds) = split(/\|/,$data);
		@ads = split(/\,/, $adIds);
		$adIds = '';
		while ($id = shift @ads) {
			unless ($id eq $ad) {
				$adIds .= "$id,";
			} else {
				$flagUpd = 't';
			}
		}
		chop($adIds) if $adIds =~ /\,$/;
		if (length($adIds) > 0) {
			$groupInfo{$group} = "$name\|$pswd\|$adIds";
		} else {
			delete $groupInfo{$group};
		}
	}
	if ($flagUpd eq 't') {
		my $fileGrps = "${adcafeDirData}adgroup\.cfg";
		if (&fileLock($fileGrps, \*LGRPCFG)) {
			open(GRPCFG,">$fileGrps");
			while(($group, $data)=each(%groupInfo)) {
				print GRPCFG "$group\|$data\n";
			}
			close(GRPCFG);
			&fileUnlock($fileGrps, \*LGRPCFG);
		} else {
			&logEvent(6, "Rtn=ads\|File=adgroup.cfg\|Id=$ad");
		}
	}
}


sub updateSites
{
	my $ad = shift;
	my $siteList = shift;
	my $adOpt = shift;
	%adSites = ();
	if ($curSites ne $adcafeInactiveSiteCd) {
		my @sites = split(/\|/, $siteList);
		grep($adSites{$_}++, @sites);
	}

	my ($id, $name);
	while(($id, $name)=each(%siteInfo)) {
		&update1Site($id, $ad, $adOpt);
	}

	return '';
}

sub update1Site
{
	my $site = shift;
	my $ad = shift;
	my $adOpt = shift;
	my $file = "${adcafeDirData}adsite$site\.cfg";
	if (&fileLock($file, \*LSITE)) {
		my @ads = ();
		if (-e $file) {
			open(SITE, $file);
			<SITE>;	# cycle ctr
			@ads = <SITE>;	#load ads
			close(SITE);
		}

		open(SITE, ">$file");
		print SITE "0\|0\n";
		my ($id, $opt);
		while ($_ = shift @ads) {
			chop if $_ =~ /\n$/;
			($id, $opt) = split(/\|/, $_, 2);
			unless ($ad eq $id) {
				print SITE "$id\|$opt\n";
			}
		}
		if ($adSites{$site}) {
			unless ($adType eq 'E') {	#unless expired
				my $freq = $input{'freq'};
				while ($freq > 0) {
					print SITE "$ad\|$adOpt\n";
					$freq--;
				}
			}
		}
		close(SITE);
		&fileUnlock($file, \*LSITE);
	} else {
		&logEvent(6, "Rtn=ads\|File=adsite.cfg\|Site=$site\|Id=$ad");
	}
}

sub bldAdOpt
{
	my $opt = shift;

	my $ad = $input{'id'};
	my $file = "$adcafeDirTotals$ad\.ctr";
	my $adOpt = "H1\|R\|0\|0\|\|\|0\|0";
	if (&fileLock($file, \*LCTR)) {
		my $rec = "0\|0";
		if (-e $file) {
			open(CTR, $file);
			$rec = <CTR>;
			chop($rec) if $rec =~ /\n$/;
			close(CTR);
		}
		my $hit = 0; my $clk = 0;
		if ($rec =~ /^\d+\|\d+$/) {
			($hit, $clk) = split(/\|/, $rec);
		}

		my $exp = "$input{'type'}$input{'max'}";
		my $code = 'R';
		my ($mon, $day, $year);
		($mon, $day, $year) = &getDate($input{'dt'});
		if (&cmpToday($mon, $day, $year) >= 0) {	# greater than today
			unless ($hit > 0 || $clk > 0) {
				$code = sprintf("S%04d%02d%02d", $year, $mon, $day);
			}
		}
		if ($input{'type'} eq 'D') {
			($mon, $day, $year) = &addDays($mon, $day, $year, $input{'max'});
			$exp = sprintf("D%04d%02d%02d", $year, $mon, $day);
			if (&cmpToday($mon, $day, $year) < 0) {	# expired
			$code = 'E';
			}
		} elsif ($input{'type'} eq 'H') {
			if ($hit > $input{'max'}) {
				$code = 'E';
			}
		} elsif ($input{'type'} eq 'C') {
			if ($clk > $input{'max'}) {
				$code = 'E';
			}
		}

		$adOpt = "$exp\|$code\|$opt";
		open(CTR, ">$file");
		print CTR "$hit\|$clk\n";
		print CTR "$adOpt\n";
		close(CTR);
		&fileUnlock($file, \*LCTR);
	} else {
		&logEvent(6, "Rtn=ads\|File=$ad\.ctr\|Id=$ad");
	}
	return $adOpt;
}

sub loadAdData
{
	my $ad = shift;
	my @adRecs = ();
	if ($input{'doit'}) {
		@adRecs = &bldAdRec;
	} else {
		my $file = "${adcafeDirData}$ad\.ad";
		if (-e $file) {
			open(AD, $file);
			my $ctr;
			while (<AD>) {
				chop($_) if $_ =~ /\n$/;
				push(@adRecs, $_);
				$ctr++;
				last if $ctr > 13;
			}
			my $notes;
			while (<AD>) {
				$notes .= $_;
			}
			chop($notes) if $notes =~ /\n$/;
			push(@adRecs, $notes);
			close(AD);
		}
	}

	return @adRecs;
}

sub validateInput
{
	my $ad = $input{'id'};
	unless (&validId($ad)) {
		return "Id <B>\($ad\)</B> must contain only letters and digits<BR>";
	}

	&loadAllSites;
	&loadAllGroups;
	my $action = $input{'a'};
	my ($fld, $name, $errMsg);
	my $file = "${adcafeDirData}$ad\.ad";
	if ($action eq 'a') {	# add
		$errMsg = &uniqueId($ad);
	} elsif ($action eq 'd') {	# delete
		unless (-e $file) {
			$errMsg = "Could not find $ad - choose an existing ad to delete<BR>";
		}
	} else {	# edit
		unless (-e $file) {
			$errMsg = "Could not find $ad - choose an existing ad to edit<BR>";
		}
	}

	if ($action ne 'd') {
		my %fldName = (
			'tgt'=>'Target','pswd'=>'Password',
			'sites'=>'Sites for Ad',,'co'=>'Company name',
			'type'=>'When to stop','freq'=>'Frequency of rotation',
			'tmd'=>'Days Ad displayed','tmo'=>'Times ad displayed',
			'br'=>'Browser restriction','os'=>'Type of system restriction',
			'rfrate'=>'Refresh rate'
		);
		while (($fld, $def) = each %fldName) {
			unless (length($input{$fld})) {
				$errMsg .= "$def not entered<BR>";
			}
		}
		if ($input{'sites'} =~ /$adcafeInactiveSiteCd/) {
			if (length($input{'sites'}) > length($adcafeInactiveSiteCd)) {
				$errMsg .= "Ad can NOT be running on a site and INACTIVE!<BR>";
			}
		}
		if (length($input{'gif'}) > 0) {
			my @gifs = split (/\cM\cJ|\n/,$input{'gif'});
			while ($fld = shift @gifs) {
				if (&isUrlBad($fld)) {
					$errMsg .= 'Banner Gif is an invalid URL<BR>';
					last;
				}
			}
			$input{'href'} =~ s/\s//g;
			if (length($input{'href'}) > 0) {
				if (&isUrlBad($input{'href'})) {
					$errMsg .= 'HREF is an invalid URL<BR>';
				}
			}
		} elsif (length($input{'raw'}) < 1) {
			$errMsg .= 'Either a Banner GIF must be entered or the raw HTML<BR>';
		}
		if (length($input{'email'}) > 0) {
			$input{'email'} =~ s/ .*//;
			if ($input{'email'} !~ /([\w-.]+\@[\w-.]+)/) {
				$errMsg .= 'Email address entered is invalid<BR>';
			}
		}
		unless ($input{'type'} eq 'A') {
			if (length($input{'max'}) < 1) {
				$errMsg .= 'When to stop must be entered<BR>';
#			if (length($input{'max'}) < 1 && length($input{'ratio'}) < 1) {
#				$errMsg .= 'Either When to stop or the Exchange ratio must be entered<BR>';
			}
		}

		if (length($input{'dt'})) {
			$errMsg .= &validDate($input{'dt'});
		} else {
			$errMsg .= 'Starting date not entered<BR>';
		}
		if ($input{'tgt'} eq 'F') {
			unless (length($input{'tgt'})) {
				$errMsg .= 'Frame target name not entered<BR>';
			}
		}
		if ($input{'tmo'} > 0) {
			unless (length($input{'tms'})) {
				$errMsg .= 'Starting hour of ad not entered<BR>';
			}
			unless (length($input{'tme'})) {
				$errMsg .= 'Ending hour of ad not entered<BR>';
			}
		}

	}
	return $errMsg;
}

sub isUrlBad
{
	my $url = shift;
	my ($host, $service, $file, $data);

	if (($host, $service, $file, $data) = ($url =~ m|http://([^/:]+):{0,1}(\d*)([^?]+)\?{0,1}(\S*)$|)) {
		unless ($file) { $file = '/'; }
		if ($host =~ /;|>|<|&|\||\*|@|(\.\.)|(^\.)|(\/\/\.)/) { return 1; }
		if ($file =~ /;|>|<|&|\||\*|@|(\.\.)|(^\.)|(\/\/\.)/) { return 1; }

		return '';
	}

	return 1;
}

sub bldAdRec
{
	my %fldDefaults = (
			'href'=>'http://','tgt'=>'T','frm'=>'','gif'=>"$adDefGifUrl",'alt'=>'','co'=>'',
			'height'=>"$adDefHeight",'width'=>"$adDefWidth",'border'=>"$adDefBorder",'pswd'=>'',
			'sites'=>'','dt'=>'','max'=>'0','type'=>'H','freq'=>'0',
			'tmd'=>'0','tmo'=>'0','tms'=>'','tme'=>'','ratio'=>'',
			'br'=>'0','os'=>'0','raw'=>'','amt'=>'','notes'=>'',
			'rfrate'=>"$adcafeRotate", 'email'=>''
		);
	my ($fld, $def);
	while (($fld, $def) = each %fldDefaults) {
		unless (length($input{$fld})) {
			$input{$fld} = $def;
		}
	}
	$input{'amt'} =~ s/\D//g;
	$input{'notes'} =~ s/\cJ//g;
	$input{'notes'} =~ s/\cM/\n/g;
	$input{'raw'} =~ s/\n|\cM\cJ/\|/g;
	$input{'raw'} =~ s/^\s+//;
	$input{'raw'} =~ s/\s+$//;
	$input{'raw'} =~ s/\s+/ /g;
	$input{'gif'} =~ s/\|/\xfc/g;
	$input{'gif'} =~ s/\n|\cM\cJ/\|/g;
	$input{'gif'} =~ s/\s//g;
	chop($input{'gif'}) if $input{'gif'} =~ /\|$/;
	$input{'href'} =~ s/\|/\xfc/g;

	my @adRecs = ();
	$adRecs[0] = "$input{'href'}\|$input{'tgt'}\|$input{'frm'}";
	$adRecs[1] = $input{'gif'};
	$adRecs[2] = $input{'alt'};
	$adRecs[3] = "$input{'height'}\|$input{'width'}\|$input{'border'}";
	$adRecs[4] = $input{'co'};
	$adRecs[5] = $input{'pswd'};
	$adRecs[6] = "$input{'type'}\|$input{'max'}\|$input{'freq'}\|1";	# $input{'ratio'}";
	$adRecs[7] = &fmtDate($input{'dt'});
	$adRecs[8] = $input{'sites'};
	$adRecs[9] = "$input{'tmd'}\|$input{'tmo'}\|$input{'tms'}\|$input{'tme'}\|$input{'br'}\|$input{'os'}";
	$adRecs[10] = $input{'raw'};
	$adRecs[11] = $input{'rfrate'};
	$adRecs[12] = $input{'email'};
	$adRecs[13] = $input{'amt'};
	if ($input{'doit'}) {	# update
		$adRecs[14] = $input{'notes'};
	} else {
		my $ctr = 14;
		my @notes = split(/\n/, $input{'notes'});
		while ($fld = shift @notes) {
			$adRecs[$ctr] = $fld;
			$ctr++;
		}
	}

	return @adRecs;
}

sub loadSites
{
	my $curSites = shift;
	my $delOpt = shift;
	my (@sites, %adSites);
	if ($curSites ne $adcafeInactiveSiteCd) {
		@sites = split(/\|/, $curSites);
		grep($adSites{$_}++, @sites);
	}

	my $adcafeInactiveSite = '--- Ad Not Running ---';
	my $fileSite = "${adcafeDirData}adcafe\.cfg";
	my $siteList = '';
	if (-e $fileSite) {
		open(SITE, $fileSite);
		@sites = <SITE>;
		close(SITE);
		my ($site, $id, $name);
		if ($delOpt) {
			my $br = '';
			while ($site = shift @sites) {
				chop($site) if $site =~ /\n$/;
				($id, $name) = split(/\=/, $site);
				if ($adSites{$id}) {
					($name) = split(/\|/, $name);
					$siteList .= "$br$name";
					$br = '<BR>';
				}
			}
			if (length($siteList) == 0) {
				$siteList = $adcafeInactiveSite;
			}
		} else {
			$site = @sites;
			$site = 7 if $site > 7;
			$siteList = "<SELECT NAME=sites MULTIPLE SIZE=$site>\n";
			my $flag = '';
			while ($site = shift @sites) {
				chop($site) if $site =~ /\n$/;
				($id, $name) = split(/\=/, $site);
				($name) = split(/\|/, $name);
				$selected = '';
				if ($adSites{$id}) {
					$selected = ' SELECTED';
					$flag = 't';
				}
				$siteList .= "<OPTION VALUE=\"$id\"$selected\>$name\n";
			}
			$selected = ($flag eq 't') ? '' : ' SELECTED';
			$siteList .= "<OPTION VALUE=\"$adcafeInactiveSiteCd\"$selected\>$adcafeInactiveSite\n";
		}
	} else {
		if ($delOpt) {
			$siteList = $adcafeInactiveSite;
		} else {
			$siteList = "<SELECT NAME=sites SIZE=1>\n<OPTION VALUE=\"$adcafeInactiveSiteCd\" SELECTED\>$adcafeInactiveSite\n";
		}
	}
	$siteList .= "</SELECT>" if !$delOpt;

	return ($siteList);
}

sub fmtImg
{
	my $img = shift;
	my ($adH, $adW, $adB);
	
	($adH, $adW, $adB) = split(/\|/, $img);
	unless ($adH) { $adH = $adDefHeight; }
	unless ($adW) { $adW = $adDefWidth; }
	unless ($adB) { $adB = $adDefBorder; }

	return ($adH, $adW, $adB);
}
	
sub fmtType
{
	my $adType = shift;
	my $delOpt = shift;
	my ($adMax,$adFreq, $tmp, $sel,$adExchg);
	my %typeDesc = ('H'=>'Impressions', 'C'=>'ClickThrus', 'D'=>'Days', 'A'=>'Always');
	($adType,$adMax,$adFreq,$adExchg) = split(/\|/, $adType);
	unless ($adType) { $adType = 'H'; }
	unless ($adFreq) { $adFreq = 1; }
	unless ($adExchg) { $adExchg = 1; }
	my $typeList = ($delOpt) ? '' : "<SELECT NAME=type SIZE=1>\n";
	if ($delOpt) {
		$typeList = $typeDesc{$adType};
	} else {
		my @types = ('H', 'C', 'D', 'A');
		while ($tmp = shift @types) {
			$sel = ($tmp eq $adType) ? ' SELECTED' : '';
			$typeList .= "<OPTION VALUE=\"$tmp\"$sel>$typeDesc{$tmp}\n";
		}
		$typeList .= "</SELECT>";
	}

	my %freqDesc = ('0'=>'Never', '1'=>'Normal', '2'=>'Double', '3'=>'Triple', '4'=>'Quadruple');
	my $freqList = ($delOpt) ? '' : "<SELECT NAME=freq SIZE=1>\n";
	if ($delOpt) {
		$freqList = $freqDesc{$adFreq};
	} else {
		for ($tmp = 0; $tmp < 5; $tmp++) {
			$sel = ($tmp eq $adFreq) ? ' SELECTED' : '';
			$freqList .= "<OPTION VALUE=\"$tmp\"$sel>$freqDesc{$tmp}\n";
		}
		$freqList .= "</SELECT>";
	}

	return ($adMax, $typeList, $freqList, $adExchg);
}

sub validDate
{
	my $dt = shift;
	my $errMsg;
	my ($mon, $day, $year);

	($mon, $day, $year) = &getDate($dt);
	if ($year < 1997) {
		$errMsg .= "Invalid year: $year<BR>";
	}

	if ($mon < 1 || $mon > 12) {
		$errMsg .= "Invalid month: $mon<BR>";
	}
	my $endDay  = &daysInMonth($mon, $year);
	if ($day < 1 || $day > $endDay) {
		$errMsg .= "Invalid day: $day<BR>";
	}

	return $errMsg;
}

sub getDate
{
	my $dt = shift;
	my ($mon, $day, $year);
	($mon, $day, $year) = split(/\//, $dt);

	if ($year < 100) {
		$year += 1900;
	}
	if ($year < 1950) {
		$year += 100;
	}
	return ($mon, $day, $year);
}

sub getCurDate
{
	my ($day,$mon,$year);
	($day,$mon,$year) = (localtime(time))[3,4,5];
	$mon++;
	$year += 1900;

	return ($mon, $day, $year);
}

sub fmtDate
{
	my $dt = shift;
	my ($day,$mon,$year);
	if ($dt) {
		($mon,$day,$year) = &getDate($dt);
	} else {
		($mon,$day,$year) = &getCurDate();
	}

	return "$mon/$day/$year";
}

sub fmtTime
{
	my $time = shift;
	unless ($time) {
		$time = time;
	}
	my ($hour,$min,$sec);
	($sec,$min,$hour) = localtime($time);
	$time = sprintf("%02d:%02d:%02d", $hour,$min,$sec);
	return $time;
}

sub htmlNext
{
	my $err = shift;
	if ($err) {
		my $ad = $input{'id'};
		my $action = $input{'a'};
		if ($action eq 'd') {	# delete
			print STDOUT "<P><B>Count not delete advertisement with ID = <B>$adId</B>";
		} elsif ($action eq 'e') {	# edit
			&htmlEdit($ad);
		} else {
			&htmlAdd($ad);
		}
		&htmlEnd;
	} else {
		if ($input{'rh'} eq 'i') {
			print STDOUT "Location: ${adcafeUrlCgi}adcafe_inactive.cgi\n\n";	# admin stats
		} else {
			print STDOUT "Location: ${adcafeUrlCgi}adcafe_admin.cgi\n\n";	# admin stats
		}
	}
}

sub htmlError
{
	my $msg = shift;
	&htmlStart($input{'a'});
	$msg = "<FONT SIZE=+1 $adcafeFontErrColor>Input Errors</FONT><BR><FONT $adcafeFontErrColor>$msg</FONT><HR SIZE=1>";
	print STDOUT $msg;
}

sub htmlStart
{
	my $action = shift;
	my %descAction = ('d'=>'Deletion',	'e'=>'Update', 'a'=>'Add', ''=>'Add');
	my $title = "AdCafe Ad $descAction{$action}";
	&htmlHeader($title);
}

sub htmlEnd
{
	print STDOUT '<P><CENTER>';
	if ($adcafeTotalCd ne 'a') {	# live totals
		my $dsc = ($adcafeTotalCd eq 'b') ? 'Live Totals' : 'Totals';
		print STDOUT "<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_totals.cgi\" style=\"$adcafeLinkColor\"><B>&nbsp; $dsc &nbsp;</B></a>&#0124;";
	}
	if ($adcafeTotalCd ne 'd') {	# batch totals
		my $dsc = ($adcafeTotalCd eq 'b') ? 'Batch Totals' : 'Totals';
		print STDOUT "<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_tots.cgi\" style=\"$adcafeLinkColor\"><B>&nbsp; $dsc &nbsp;</B></a>&#0124;";
	}

	print STDOUT <<EOT; 
<A STYLE="text-decoration: none" HREF="${adcafeUrlCgi}adcafe_daily.cgi" style="$adcafeLinkColor"><B>&nbsp; Daily Snapshot &nbsp;</B></a>&#0124;
<A STYLE="text-decoration: none" HREF="${adcafeUrlCgi}adcafe_admin.cgi" style=\"$adcafeLinkColor\"><B>&nbsp; Admin &nbsp;</B></a>&#0124;
<A STYLE="text-decoration: none" HREF="${adcafeUrlCgi}adcafe_login.cgi" style=\"$adcafeLinkColor\"><B>&nbsp; Sponsor Login &nbsp;</B></a>
</CENTER>
EOT

	&htmlFooter;
}

sub fmtRawHtml
{
	my $rawHtml = shift;
	$rawHtml =~ s/&/&amp;/g;
	$rawHtml =~ s/>/&gt;/g;
	$rawHtml =~ s/</&lt;/g;
	$rawHtml =~ s/"/&quot;/g;

	return $rawHtml;
}

sub fmtHref
{
	my $href = shift;
	my $delOpt = shift;
	my ($opt, $target, $tmp, $sel);
	unless ($href) {
		$href = "http://\|T\|";
	}
	($href, $opt, $target) = split(/\|/,$href);
	$href =~ s/\xfc/\|/g;
	unless ($opt) {
		$opt = 'T';
	}
	my %tgtDesc = ('T'=>'Same window', 'N'=>'Create new window', 'F'=>'Frame name');
	my @tgts = ('T', 'N', 'F');
	my $tgtList = ($delOpt) ? '' : "<SELECT NAME=tgt SIZE=1>\n";
	if ($delOpt) {
		$tgtList = $tgtDesc{$opt};
	} else {
		while ($tmp = shift @tgts) {
			$sel = ($tmp eq $opt) ? ' SELECTED' : '';
			$tgtList .= "<OPTION VALUE=\"$tmp\"$sel>$tgtDesc{$tmp}\n";
		}
		$tgtList .= "</SELECT>";
	}

	return ($href, $tgtList, $target);
}

sub fmtCond
{
	my $adCond = shift;
	my $delOpt = shift;
	my ($begTime, $endTime, $tmp, $sel, $adDay, $adTime, $adOs, $adBr);
	($adDay, $adTime, $begTime, $endTime, $adBr, $adOs) = split(/\|/, $adCond);
	unless ($adDay) {$adDay = 0;}
	unless ($adTime) {$adTime = 0;}
	unless ($adBr) {$adBr = 0;}
	unless ($adOs) {$adOs = 0;}

	my @timeDesc = ('Always Show', 'Show From', 'Do not Show From');
	my $timeList = ($delOpt) ? '' : "<SELECT NAME=tmo SIZE=1>\n";
	if ($delOpt) {
		$timeList = $timeDesc[$adTime];
	} else {
		for ($tmp = 0; $tmp < 3; $tmp++) {
			$sel = ($tmp eq $adTime) ? ' SELECTED' : '';
			$timeList .= "<OPTION VALUE=\"$tmp\"$sel>$timeDesc[$tmp]\n";
		}
		$timeList .= "</SELECT>";
	}

	my @dayDesc = ('Daily', 'Week Days', 'Weekends');
	my $dayList = ($delOpt) ? '' : "<SELECT NAME=tmd SIZE=1>\n";
	if ($delOpt) {
		$dayList = $dayDesc[$adDay];
	} else {
		for ($tmp = 0; $tmp < 3; $tmp++) {
			$sel = ($tmp eq $adDay) ? ' SELECTED' : '';
			$dayList .= "<OPTION VALUE=\"$tmp\"$sel>$dayDesc[$tmp]\n";
		}
		$dayList .= "</SELECT>";
	}

	my @brDesc = ('All Browsers', 'Only Netscape Navigator', 'Only Internet Explorer', 'Only Others');
	my $brList = ($delOpt) ? '' : "<SELECT NAME=br SIZE=1>\n";
	if ($delOpt) {
		$brList = $brDesc[$adBr];
	} else {
		for ($tmp = 0; $tmp < 4; $tmp++) {
			$sel = ($tmp eq $adBr) ? ' SELECTED' : '';
			$brList .= "<OPTION VALUE=\"$tmp\"$sel>$brDesc[$tmp]\n";
		}
		$brList .= "</SELECT>";
	}

	my @osDesc = ('All Systems', 'Only Windows', 'Only Macintosh', 'Only Others');
	my $osList = ($delOpt) ? '' : "<SELECT NAME=os SIZE=1>\n";
	if ($delOpt) {
		$osList = $osDesc[$adOs];
	} else {
		for ($tmp = 0; $tmp < 4; $tmp++) {
			$sel = ($tmp eq $adOs) ? ' SELECTED' : '';
			$osList .= "<OPTION VALUE=\"$tmp\"$sel>$osDesc[$tmp]\n";
		}
		$osList .= "</SELECT>";
	}

	return ($timeList, $dayList, $begTime, $endTime, $brList, $osList);
}

sub fmtAmt
{
	my $amt = shift; 
	$amt =~ s/\D*//g;
	1 while ($amt =~ s/(.*\d)(\d\d\d)/$1,$2/);

	return $amt;
}
