#!/usr/local/bin/perl

# ==========================================================================
# AdCafe - Advertiser management system
# Copyright (c) 1998 Infohiway
#
# Admin functions
#
# adcafe_admin.cgi
#
# ==========================================================================

require 'adcafe_cfg.cgi';
require 'adcafe_gui.cgi';
require 'adcafe_security.cgi';

MAIN:
{ 
	&getInput;
	$| = 1;
	unless (&okToRun($adcafeLoginAdminCd, $adcafeAdminId)) {
		print STDOUT "Location: ${adcafeUrlCgi}adcafe_login.cgi\n\n";	# sponsor login
		exit;
	}

	$cgiStats = ($adcafeTotalCd eq 'd') ? 'adcafe_stats.cgi' : 'adcafe_statads.cgi';
	&cfgCheck;
	&htmlStart;
	&loadAllSites;
	&loadAllAds;
	&dspSites;
	&dspGroups;
	&dspAds;
	&htmlEnd;

	exit;
}

sub dspAds
{
	my @ads = sort { lc($a) cmp lc($b) } keys %adActive;
	if (@ads) {
		&htmlAdStart;
		my ($ix, $id, $color);
		while ($id = shift @ads) {
			&htmlAd($id, $color);
			$color = ($color) ? '' : $adcafeTblAltColor;
		}
		print STDOUT '</TABLE>';
	} else {
		print STDOUT '<CENTER><B>No Ads Are Currently Setup:</B><P>';
	}
	print STDOUT "<BR><A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_ads.cgi\" style=\"$adcafeLinkColor\"><B>&nbsp; Add New Advertisement &nbsp;</B></A>";
	if ($flagInactiveAds eq 't') {
		print STDOUT " \| <A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_inactive.cgi\" style=\"$adcafeLinkColor\"><B>&nbsp; Inactive Ads &nbsp;</B></a>";
	}
	print STDOUT '</CENTER><HR SIZE=1>';
}

sub htmlAd
{
	my $id = shift;
	my $color = shift;
	my $fileAd = "$adcafeDirData$id\.ad";
	print STDOUT "\n<TR VALIGN=TOP$color><TD><B>$id</B></TD>";
	if (-e $fileAd) {
		open(AD, $fileAd);
		dspAd($id);
		close(AD);
	} else {
		print STDOUT "<TD COLSPAN=5>File missing: $fileAd</TD>";
	}
	print STDOUT '</TR>';
}

sub dspAd
{
	my $id = shift;
	<AD>; <AD>; <AD>; <AD>;
	my $name = <AD>;  chop($name);
	my $pswd = <AD>;  chop($pswd);
	my $href = "<A STYLE=\"text-decoration: none\" HREF=\"$adcafeUrlCgi$cgiStats\?id=$id&lgn=$adcafeLoginAdCd\" onMouseOver=\"window.status=\'$name Totals\'; return true\"><B>$name</B></A>";
	print STDOUT "<TD>$href<BR>$pswd</TD>";
	my $type = <AD>;  chop($type);

	my $time = <AD>;
	chop($time);
	$time = &fmtDate($time);
	print STDOUT "<TD>$time</TD>";

	my ($max, $freq);
	($max, $type, $freq, $exchg) = &fmtType($type);
	print STDOUT "<TD>$max $type<BR>$freq</TD>";

	my $sites = <AD>;
	chop($sites);
	$sites = &fmtSites($sites);
	print STDOUT "<TD>$sites</TD>";

	print STDOUT "<TD><A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_ads.cgi\?a=e&id=$id\" style=\"$adcafeLinkColor\" onMouseOver=\"window.status=\'${adcafeUrlCgi}adcafe_ads.cgi\'; return true\"><B>Edit</B></A>";
	print STDOUT "<BR><A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_ads.cgi\?a=d&id=$id\" style=\"$adcafeLinkColor\" onMouseOver=\"window.status=\'${adcafeUrlCgi}adcafe_ads.cgi\'; return true\"><B>Delete</B></A>"; 
	print STDOUT "<BR><A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_ads.cgi\?a=a&id=$id\" style=\"$adcafeLinkColor\" onMouseOver=\"window.status=\'${adcafeUrlCgi}adcafe_ads.cgi\'; return true\"><B>Copy</B></A>"; 
	print STDOUT "</TD>\n";
}

sub htmlAdStart
{
	print STDOUT <<EOT; 
<CENTER><B>The Following Ads Are Running:</B>
<P>
<TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR$adcafeHdrTblColor>
<TD><B><BR>Id</B></TD>
<TD><B>Name<BR>Password</B></TD>
<TD><B><BR>Start</B></TD>
<TD><B>End after<BR>Frequency</B></TD>
<TD><B><BR>Ad Sites</B></TD>
<TD ALIGN=CENTER><B><BR>Action</B></TD>
</TR>
EOT

}

sub fmtSites
{
	my $sites = shift;
	my @s = split(/\|/, $sites);
	my ($id, $list, $br, $name);
	while ($id = shift @s) {
		($name) = split(/\|/, $siteInfo{$id});
		$list .= "$br$name";
		$br = '<BR>';
	}

	return ($list);
}

sub fmtType
{
	my $adType = shift;
	my ($adMax,$adFreq, $tmp, $sel, $adExchg);
	($adType,$adMax,$adFreq,$adExchg) = split(/\|/, $adType);
	unless ($adType) { $adType = 'H'; }
	unless ($adFreq) { $adFreq = 1; }

	my %typeDesc = ('H'=>'Impressions', 'C'=>'Clicks', 'D'=>'Days', 'A'=>'Never');
	$adMax = ($adType eq 'A') ? '' : $adMax;
	my %freqDesc = ('0'=>'Never', '1'=>'Normal', '2'=>'Double', '3'=>'Triple', '4'=>'Quadruple');

	return ($adMax, $typeDesc{$adType}, $freqDesc{$adFreq}, $adExchg);
}

sub getDate
{
	my $dt = shift;
	my ($mon, $day, $year);
	($mon, $day, $year) = split(/\//, $dt);

	if ($year < 100) {
		$year += 1900;
	}
	if ($year < 1950) {
		$year += 100;
	}
	return ($mon, $day, $year);
}

sub getCurDate
{
	my ($day,$mon,$year);
	($day,$mon,$year) = (localtime($time))[3,4,5];
	$mon++;
	$year += 1900;

	return ($mon, $day, $year);
}

sub fmtDate
{
	my $dt = shift;
	my ($day,$mon,$year);
	if ($dt) {
		($mon,$day,$year) = &getDate($dt);
	} else {
		($mon,$day,$year) = &getCurDate();
	}

	return "$mon/$day/$year";
}

sub dspSites
{
	my @sites = sort { lc$a cmp lc($b) } keys %siteInfo;
	my ($id, $color, $name, $href, $pswd);
	print STDOUT '<CENTER><P>';
	if (@sites) {
		print STDOUT '<B>The Following Sites Have Been Setup:</B><P><TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>';
		print STDOUT "\n<TR$adcafeHdrTblColor><TD ALIGN=CENTER><B>Site ID</B></TD><TD><B>Description / Password</TD><TD ALIGN=CENTER><B>---Action---</B></TD></TR>\n";
		while ($id = shift @sites) {
			($name, $pswd) = split(/\|/, $siteInfo{$id});
			$href = "<A STYLE=\"text-decoration: none\" HREF=\"$adcafeUrlCgi$cgiStats\?id=$id&lgn=$adcafeLoginSiteCd\" onMouseOver=\"window.status=\'$name Totals\'; return true\"><B>$name</B></A>";
			print STDOUT "<TR$color VALIGN=TOP><TD ALIGN=CENTER><B>$id</B></TD><TD>$href<BR>$pswd</TD>";
			print STDOUT "<TD ALIGN=CENTER><A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_sites.cgi\?a=e&id=$id\" style=\"$adcafeLinkColor\" onMouseOver=\"window.status=\'${adcafeUrlCgi}adcafe_sites.cgi\'; return true\"><B>Edit</B></A>";
			print STDOUT "&nbsp;\|&nbsp;<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_sites.cgi\?a=d&id=$id\" style=\"$adcafeLinkColor\" onMouseOver=\"window.status=\'${adcafeUrlCgi}adcafe_sites.cgi\'; return true\"><B>Delete</B></A>";
			print STDOUT "&nbsp;\|&nbsp;<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_all.cgi?site=$id\" style=\"$adcafeLinkColor\" onMouseOver=\"window.status=\'${adcafeUrlCgi}adcafe_all.cgi\'; return true\"><B>View All Ads</B></A>";
			print STDOUT "</TD></TR>\n";
			$color = ($color) ? '' : $adcafeTblAltColor;
		}
		print STDOUT '</TABLE>';
	} else {
		print STDOUT '<B>No Sites Are Currently Setup:</B><P>';
	}
	print STDOUT "<BR><A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_sites.cgi\" style=\"$adcafeLinkColor\"><B>Add New Site</B></A><P>";
	print STDOUT '</CENTER><HR SIZE=1>';
}

sub loadAllAds
{
	my ($file, $id, $tmp);
	%adActive = ();
	while(($id) = each(%siteInfo)) {
		$file = "${adcafeDirData}adsite$id\.cfg";
		if (-e $file) {
			open(SITE, $file);
			<SITE>;	# skip
			while (<SITE>) {
				chop if $_ =~ /\n$/;
				($id, $tmp) = split(/\|/, $_, 2);
				$adActive{$id}++;
			}
			close(SITE);
		}
	}
	$file = "${adcafeDirData}ads\.cfg";
	if (-e $file) {
		open(ADS, $file);
		while (<ADS>) {
			chop if $_ =~ /\n$/;
			unless ($adActive{$_}) {
				$flagInactiveAds = 't';
				last;
			}
		}
		close(ADS);
	}
}

sub cfgCheck
{
	my $file = "${adcafeDirData}adcafe\.cfg";
	unless (-e $file) {
		open(CFG, ">$file");
		close(CFG);
	}
}

sub htmlStart
{
	my $title = "AdCafe Administration";
	&htmlHeader($title);
}

sub htmlEnd
{
	print STDOUT '<P><CENTER>';
	if ($adcafeTotalCd ne 'a') {	# live totals
		my $dsc = ($adcafeTotalCd eq 'b') ? 'Live Totals' : 'Totals';
		print STDOUT "<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_totals.cgi\" style=\"$adcafeLinkColor\"><B>&nbsp; $dsc &nbsp;</B></a>&#0124;";
	}
	if ($adcafeTotalCd ne 'd') {	# batch totals
		my $dsc = ($adcafeTotalCd eq 'b') ? 'Batch Totals' : 'Totals';
		print STDOUT "<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_tots.cgi\" style=\"$adcafeLinkColor\"><B>&nbsp; $dsc &nbsp;</B></a>&#0124;";
	}
	
	print STDOUT "<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_daily.cgi\" style=\"$adcafeLinkColor\"><B>&nbsp; Daily Snapshot &nbsp;</B></a>&#0124;";
	my $msg;
	if ($flagInactiveAds eq 't') {
		$msg = ($flagInactiveGroups eq 't') ? 'Inactive Ads & Groups' : 'Inactive Ads';
	} else {
		$msg = ($flagInactiveGroups eq 't') ? 'Inactive Groups' : '';
	}
	if (length($msg) > 0) {
		print STDOUT "<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_inactive.cgi\" style=\"$adcafeLinkColor\"><B>&nbsp; $msg &nbsp;</B></a>&#0124;";
	}

	print STDOUT <<EOT; 
<A STYLE="text-decoration: none" HREF="${adcafeUrlCgi}adcafe_login.cgi" style=\"$adcafeLinkColor\"><B>&nbsp; Sponsor Login &nbsp;</B></a>
</CENTER>
EOT

	&htmlFooter;
}

sub dspGroups
{
	&loadAllGroups;
	my @grps = sort { lc($a) cmp lc($b) } keys %groupInfo;
	print STDOUT '<CENTER><P>';
	if (@grps) {
		print STDOUT '<B>The Following Groups Have Been Setup:</B><P><TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>';
		my ($group, $name, $pswd, $ads, $color, $href);
		print STDOUT "\n<TR$adcafeHdrTblColor><TD><B>Id</B></TD><TD><B>Name / Password</B></TD><TD><B>Ads in Group</B></TD><TD ALIGN=CENTER><B>Action</B></TD></TR>\n";
		while ($group = shift @grps) {
			($name, $pswd, $ads) = split(/\|/,$groupInfo{$group});
			if (&isGroupActive($ads)) {
				$ads =~ s/\,/ /g;
				$href = "<A STYLE=\"text-decoration: none\" HREF=\"$adcafeUrlCgi$cgiStats\?id=$group&lgn=$adcafeLoginGroupCd\" onMouseOver=\"window.status=\'$name Totals\'; return true\"><B>$name</B></A>";
				print STDOUT "<TR$color VALIGN=TOP><TD>$group</TD><TD>$href<BR>$pswd</TD><TD>$ads</TD>";
				print STDOUT "<TD><A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_grps.cgi\?a=e&id=$group\" style=\"$adcafeLinkColor\" onMouseOver=\"window.status=\'${adcafeUrlCgi}adcafe_grps.cgi\'; return true\"><B>Edit</B></A>";
				print STDOUT "&nbsp;\|&nbsp;<A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_grps.cgi\?a=d&id=$group\" style=\"$adcafeLinkColor\" onMouseOver=\"window.status=\'${adcafeUrlCgi}adcafe_grps.cgi\'; return true\"><B>Delete</B></A>";
				print STDOUT "<BR><A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_allgrp.cgi?grp=$group\" style=\"$adcafeLinkColor\" onMouseOver=\"window.status=\'${adcafeUrlCgi}adcafe_allgrp.cgi\'; return true\"><B>View Group Ads</B></A>";
				print STDOUT "</TD></TR>\n";
				$color = ($color) ? '' : $adcafeTblAltColor;
			} else {
				$flagInactiveGroups = 't';
			}
		}
		print STDOUT '</TABLE>';
	} else {
		print STDOUT '<B>No Groups Have Been Setup:</B><P>';
	}

	print STDOUT "<BR><A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_grps.cgi\" style=\"$adcafeLinkColor\"><B>Add New Group</B></A>";
	if ($flagInactiveGroups eq 't') {
		print STDOUT " \| <A STYLE=\"text-decoration: none\" HREF=\"${adcafeUrlCgi}adcafe_inactive.cgi\" style=\"$adcafeLinkColor\"><B>&nbsp; Inactive Groups &nbsp;</B></a>";
	}
	print STDOUT '</CENTER><HR SIZE=1>';
}

sub isGroupActive
{
	my @ads = split(/\,/, (shift));
	my ($id, $flag);
	while ($id = shift @ads) {
		if ($adActive{$id}) {
			return 't';
		}
	}

	return '';
}
