#!/bin/sh

#----------------------------------------------------------------
#	restart.sh for Urchin1.4 - Linux
#
#	In order to rotate the log files of the webserver
#	Urchin calls this script to restart your webserver
#	which reopens the log files.
#	
#	Please follow the instructions below for your server.
#	This file contains instructions for:
#		Netscape Enterprise 
#		Netscape Fastrack 
#		Apache 
#		NCSA 
#----------------------------------------------------------------
echo "Restarting Webserver...";
#
#
#----------------Netscape Enterprise Instructions----------------
#
#       Nestcape Enterprise:  For each server on the machine
#       there is a directory that contains a "restart" script.
#       Look within the directory where the server is installed.
#       Typical directories are:
#               /opt/netscape/suitespot/https-yourserver/
#               /opt/ns-home/https-yourserver/
#       
#       Uncomment the following line and change the path
#       to reflect the location of your server.  If you
#       have more than one server, copy the line and create
#       an entry for each server.
#
#/opt/netscape/suitespot/https-yourserver/restart
#       
#----------------------------------------------------------------
#
#
#----------------Netscape Fastrack Instructions------------------
#
#       Nestcape Fastrack:  For each server on the machine
#       there is a directory that contains a "restart" script.
#       Look within the directory where the server is installed.
#       Typical directories are:
#               /opt/netscape/suitespot/httpd-yourserver/
#               /opt/ns-home/httpd-yourserver/
#       
#       Uncomment the following line and change the path
#       to reflect the location of your server.  If you
#       have more than one server, copy the line and create
#       an entry for each server.
#
#/opt/netscape/fasttrack/httpd-yourserver/restart
#       
#----------------------------------------------------------------
#
#
#----------------Apache Instructions-----------------------------
#
#       Apache:  The typical Apache configuration is to have
#	one server with one or more virtual hosts.  The current
#	version of Apache does not include a restart script, but
#	does log the process id of the parent process.  To 
#	restart the server we need to signal the process.  You
#	will need to locate the file that contains the PID.
#       A typical location is:
#               /var/run/httpd.pid
#       
#       Uncomment the following line and change the path
#       to reflect the location of your PID file. 
#
/bin/kill -HUP `/bin/cat /var/run/httpd.pid`
#       
#----------------------------------------------------------------
#
#
#----------------NCSA Instructions-------------------------------
#
#       NCSA:  The typical NCSA configuration is to have
#	one server with one or more virtual hosts.  The current
#	version of NCSA does not include a restart script, but
#	does log the process id of the parent process.  To 
#	restart the server we need to signal the process.  You
#	will need to locate the file that contains the PID.
#       Typical locations are:
#               /opt/httpd/logs/httpd.pid
#               /usr/local/httpd/logs/httpd.pid
#       
#       Uncomment the following line and change the path
#       to reflect the location of your PID file. 
#
#/bin/kill -HUP `/bin/cat /opt/httpd/logs/httpd.pid`
#       
#----------------------------------------------------------------
