#!/usr/bin/perl

#
###                         PRIMARY UBB SCRIPT                ##
#
# Ultimate Bulletin Board is copyright Madrona Park, Inc., 1998.
#
#       ------------ postings.cgi -------------
#
#  This file contains the functionality for the UBB
#  postings (new topics, replies, etc.).
#
#  Madrona Park, Inc. offers no
#  warranties on this script.  The owner/licensee of the script is
#  solely responsible for any problems caused by installation of
#  the script or use of the script, including messages that may be
#  posted on the BB.
#
#  All copyright notices regarding the Ultimate Bulletin Board
#  must remain intact on the scripts and in the HTML
#  for the scripts.
#
# For more info on the Ultimate BB, 
# see http://www.UltimateBB.com
#
###############################################################
#
#If you are running UBB on IIS,
#you may need to add the following line
#if so, just remove the "#" sign before the print line below
#print "HTTP/1.0 200 OK\n";

print ("Content-type: text/html\n\n");

eval {

 ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file

require "UltBB.setup";
require "cookie-lib.pl";
require "Date.pl";
require "mail-lib.pl";
require "mods.file";
require "Styles.file";
require "ubb_library.pl";
require "ubb_library2.pl";
};

if ($@) {
    print "Error including required files: $@\n";
    print "Make sure these files exist, permissions are set properly, and paths are set correctly.";
 exit;
}

use Socket;

if ($BBStatus eq "OFF") {
&StandardHTML("Sorry, this bulletin board is temporarily unavailable, while we perform some routine maintenance.  Please try back again later.  Feel free to email us at <A HREF=\"mailto:$BBEmail\">$BBEmail</A>.");
exit;
}

&ReadParse;

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
		if ($Name eq "forum") {
			$Forum = $Value;
			$Forum =~ s/\/\\//g;
			$ForumCoded = &HTMLIFY($Forum);
			$ForumCoded =~ tr/ /+/;
			$Forum = &UNHTMLIFY($Forum);
	}
		if ($Name eq "TopicSubject") {
			$TopicSubject = $Value;
			$TopicSubject =~ s/<.+?>//g;
				$TopicSubject = &UNHTMLIFY($TopicSubject);
	}
		if ($Name eq "UserName") {
		$UserName = $Value;
		$UserNameFile = $UserName;
		$UserNameFile =~ s/ /_/g; #remove spaces
	}
	if ($Name eq "BypassCookie") {
		$BypassCookie = $Value;
	}
	if ($Name eq "category") {
			$category = $Value;
	}
		if ($Name eq "PasswordConfirm") {
			$PasswordConfirm = $Value;
		}

		if ($Name eq "number") {
			$number = $Value;
	}
		if ($Name eq "DaysPrune") {
			$DaysPrune = $Value;
	}
	if ($Name eq "topic") {
			$topic = $Value;
	}

	if ($Name eq "Email") {
			$Email = $Value;
			$Email =~tr/A-Z/a-z/; 
	}
	if ($Name eq "URL") {
			$URL = &CleanThis($Value);
			$URL = &PipeCleaner($URL);
	}
	if ($Name eq "Permissions") {
			$Permissions = $Value;
	}
	if ($Name eq "Occupation") {
			$Occupation = &CleanThis($Value);
			$Occupation = &PipeCleaner($Occupation);
	}
	if ($Name eq "Location") {
			$Location = &CleanThis($Value);
			$Location = &PipeCleaner($Location);
	}
	if ($Name eq "TotalPosts") {
		$TotalPosts = $Value;
	}
	if ($Name eq "Status") {
		$Status = $Value;
	}
	if ($Name eq "Interests") {
			$Interests = &CleanThis($Value);
			$Interests = &PipeCleaner($Value);
	}
		if ($Name eq "sendto") {
			$sendto = $Value;
	}
}  # end FOREACH $row

if ($VariablesPath eq "") {
	$VariablesPath = $CGIPath;
}

#adjust bgcolor variables
if ($BGColor ne ""){
$BGColor = qq(bgcolor="$BGColor");
}
if ($AltColumnColor1 ne ""){
$AltColumnColor1 = qq(bgcolor="$AltColumnColor1");
}
if ($AltColumnColor2 ne ""){
$AltColumnColor2 = qq(bgcolor="$AltColumnColor2");
}
if ($CategoryStripColor ne ""){
$CategoryStripColor = qq(bgcolor="$CategoryStripColor");
}
if ($TableColorStrip ne ""){
$TableColorStrip = qq(bgcolor="$TableColorStrip");
}
if ($PageBackground ne ""){
$PageBackground = qq(background="$NonCGIURL/$PageBackground");
}

if ($TableBorderColor ne ""){
$TableWidth2 = "100%";
$BorderTop = qq(<table border=0 cellpadding=0 cellspacing=0 width="$TableWidth"><TR><td bgcolor="$TableBorderColor">);
$BorderBottom = qq(</td></tr></table> );
}  else {
$TableWidth2 = $TableWidth;
$BorderTop = "";
$BorderBottom = "";
}

$ReplyMessage = $in{'ReplyMessage'};
$Message = $in{'Message'};

@censored = split(/ /, $censorwords);

$TopicSubject = &CensorCheck("$TopicSubject");

$SubjectCoded = &HTMLIFY($TopicSubject);
$SubjectCoded =~ tr/ /+/;
	
if ($in{'action'} eq "reply") {
 &Reply;
 }  
 
if ($in{'action'} eq "postreply") {
 &PostReply;
 }  
 
if ($in{'action'} eq "newtopic") {
 &NewTopic;
 }  
 
if ($in{'action'} eq "posttopic") {
 &PostTopic;
 }  

if ($in{'action'} eq "closethread") {
 &CloseThread;
 }  
 
if ($in{'action'} eq "editpost") {
@mess = &OpenThread("$topic");
$stats = $mess[0];
@statline = split(/\|\|/, $stats);

if ($statline[1] =~ /X/) {
	&StandardHTML("Sorry, but this thread is closed... you may not edit any posts in a closed thread.<P><CENTER>Use your Back button.</CENTER>");
}  else {
 &EditPost;
 } 
 } #end editpost check
 
if ($in{'action'} eq "submitedit") {
 &SubmitEdit;
 } 
  
sub ForwardWithCookies {

my $URLwc = shift;
my $TEXTwc = shift;

print <<CONFIRM;
<HTML><HEAD>
<meta http-equiv="Refresh" content="2; URL=$URLwc">
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE

expireDate = new Date;
if (expireDate.getYear() < 100) {
expireDate.setYear(expireDate.getYear() + 1900 + 1);
} else {
expireDate.setYear(expireDate.getYear()+1);
}

var userName = getCookie("UserName");
var password = getCookie("Password");
var nameStorage = getCookie("NameStorage");

if (password == null) {    

var CookieName = escape("$UserName");
var CookiePW = escape("$in{'Password'}");

	if ((password == null) || (nameStorage == "no")) {
	  	document.cookie = "UserName=" + CookieName + ";";
		document.cookie = "Password=" + CookiePW + ";";
	}
	if ((password == null) && (nameStorage == "yes")) {
	  	document.cookie = "UserName=" + CookieName + ";expires=" + expireDate.toGMTString() + ";";
document.cookie = "Password=" + CookiePW + ";expires=" + expireDate.toGMTString() + ";";
	}
	
}
function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length;
            return unescape(dc.substring(begin, end));        }
}
return null;
}
// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</HEAD>
 <BODY $BGColor $PageBackground text="$TextColor" link="$LinkColor" alink="$ActiveLinkColor" vlink="$VisitedLinkColor">
<br><br>
<ul><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">
<B>$TEXTwc Please wait two seconds.
<br><br></font><FONT SIZE="1" FACE="$FontFace" COLOR="$LinkColor">
<A HREF="$URLwc">Click here if you do not want to wait any longer (or if your browser does not automatically forward you).</A>
</B>
</FONT>
</ul></body></html>
CONFIRM
}  ## END Forward With Cookies sr
 
sub Reply {
#open thread message
@threadguts = &OpenThread("$topic");
$statline = $threadguts[0];
@stats = split(/\|\|/, $statline);

# if thread is closed, say so
if ($stats[1] =~ /X/) {
&StandardHTML("Sorry, but this thread is closed.  No additional replies are permitted on this topic.  You are free to start a new topic, however.<P>Use your back button to return.");
}  else {

@thisforum = &GetForumRecord($number);
$CustomTitle = $thisforum[9];
$PostPermissions = $thisforum[6];

if (($PostPermissions ne "private") && ($PostPermissions !~ /\&/)) {
&StandardHTML("We can not allow any new topics until your bulletin board administrator resets all forum variables. This board has not been completely updated yet.");
exit;
}

if ($PostPermissions eq "private") {
	$ReplyRestrict = "restrict";
}  else {
($junk, $ReplyRestrict) = split("&", $PostPermissions);
}

if ($ReplyRestrict eq "none") {
&StandardHTML("Sorry, replies to topics are not permitted in this forum.  Use your back button to return to the forum.");
exit;
}

#chomp the last field to remove carriage returns
$UBBImages = "$thisforum[10]";

if ($CustomTitle eq "") {
$CustomTitle = "$BBTitle";
}

&CheckCoding;

if ($ReplyRestrict eq "all") {
$RegistrationWording = qq(Registration is recommended, but not required, in order to post messages in this forum. Unless registered, you will not be able to edit messages after they are submitted.);
$RegistrationOffWording = qq(<tr $TableColorStrip><td colspan=2><FONT SIZE="1" FACE="$FontFace" color="$TableStripTextColor">If you are not registered, leave the password field below blank.</font></td></tr>);
}  else {
$RegistrationWording = qq(You must be registered in order to post a topic or reply in this forum.);
$RegistrationOffWording = "";
}
	if ($AllowSignature eq "YES") {
	$ShowSignature = qq(<INPUT TYPE="CHECKBOX" NAME="Signature" VALUE="yes"> <B>Show Signature:</B> include your profile  signature.  Only registered users may have signatures.);
	}  else {
	$ShowSignature = "";
	}
	
#check to see if this forum is has restrictions on who can post to it-
if ($ReplyRestrict eq "restrict") {
	$LWADisclaimer = qq(Only administrators, moderators, and authorized registered users.);
$LWAField = qq(<tr $TableColorStrip><td colspan=2><B><FONT SIZE="1" FACE="$FontFace" COLOR="$TableStripTextColor">If you are an administrator or moderator, you do not need to type a forum password.  If you are not, you must supply the forum password in order to post a message in this forum, unless you have been given specific permission by your administrator.</FONT></B></td></tr><tr $TableColorStrip><td><FONT SIZE="$TextSize" FACE="$FontFace" color="$TableStripTextColor">Forum Password:</FONT></td><td><INPUT TYPE="TEXT" NAME="ForumPassword"
SIZE=10 MAXLENGTH=25></td></tr>);
	&ReplyFormHTML;
	} else {
	if ($ReplyRestrict eq "all") {
		$LWADisclaimer = "Anyone may post a reply.";
		$LWAField = "";
	}
		if ($ReplyRestrict eq "allreg") {
		$LWADisclaimer = "Any registered users may post a reply.";
		$LWAField = "";
	}
		&ReplyFormHTML;
}

&GenerateThread;
&ReplyFormBottom;

} #end if/else thread is closed
}  ## END Reply SR #####


sub PostReply {
@thisforum = &GetForumRecord($number);
$LWA = $thisforum[6];
$PrivateMax = $thisforum[13];
chomp($PrivateMax);
$LWAPW = $thisforum[7];
$UBBCodeAllow = $thisforum[5];
$HTMLAllow = $thisforum[4];
$UBBImages = $thisforum[10];
$ModNotify = $thisforum[11];
$ForumStatus = $thisforum[3];
chomp($ModNotify);

if ($LWA eq "private") {
	$ReplyRestrict = "restrict";
	&get_cookie;  #retrieves all current cookies
	$PasswordPrivate = "$cookie{PasswordPrivate}";
	$UserNamePrivate = "$cookie{UserNamePrivate}";
	$NumbersPrivate = "$cookie{ForumNumberPrivate}";
	&VerifyID;
	
	if ($ProceedNow ne "true") {
		&StandardHTML("This is a private forum and you have not been properly authorized to post to this forum.");
		exit;
	}
}  else {
	($junk, $ReplyRestrict) = split("&", $LWA);
}

if ($ReplyRestrict eq "none") {
&StandardHTML("Sorry, but replies are not permitted in this forum.  Use your back button to return to the forum.");
exit;
}

#verify that forum fields are complete

if (($in{'UserName'} eq "") || ($in{'ReplyMessage'} eq "") || ($topic eq "")) {
	&StandardHTML("You did not complete all required form fields! Please go back and re-enter.");
}
elsif (($ReplyRestrict ne "all") && ($in{'Password'} eq "")) {
		&StandardHTML("You did not complete all required form fields!  Please go back and re-enter.");

	}  else {

## See if this is an LWA Forum
if ($ReplyRestrict eq "restrict") {
$NameFound = "no";
$ProfileNumber = &GetUserNumber($in{'UserName'});
if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}

if ($NameFound eq "yes") {

	@theprofile = &OpenProfile("$ProfileNumber.cgi");
	if ($in{'Password'} eq "$theprofile[1]") {
		$Permission = "$theprofile[4]";
		($GenPerms, $SpecificPerms) = split(/\&/, $Permission);
		$Status = $theprofile[8];
		$EmailView = $theprofile[11];
		&CheckTheStatus;
		&CheckPermissions;
		
		if ($SpecificPerms ne "") {
			chomp($specificPerms);
			@accessarray = split(",", $SpecificPerms);
			foreach $uno(@accessarray) {
				if ($uno eq "$number") {
					$PermissionGranted = "true";
				}
			}
		}
		#check forumpassword
		if ($in{'ForumPassword'} eq "$thisforum[12]") {
			$PermissionGranted = "true";
		}
	   	if (($AdminPermission eq "true") || ($ModStatus eq "true")) {
	   &DoPostTheReply;
	   }
	   elsif ($PermissionGranted eq "true") {
	   &DoPostTheReply;
	   }  else {
	   &StandardHTML("Sorry, but you are not authorized to post a reply in this particular forum.  Only moderators, administrators, and users granted proper permission may post replies in this forum.");
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again. Use your Back button.");
	}
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
}  ##END IF/ELSE NAME CHECK BLOCK
} else {
	   &DoPostTheReply;
	   
}#end if/else LWA = yes

} #end if/else field check
}  ## END Post Reply SR

sub DoPostTheReply {

##get current date/time
&GetDateTime;

##verify user name/password if necessary
$match = "no";
$verified = "false";

if (($ReplyRestrict eq "all") && ($in{'Password'} eq "")) {
#check to make sure they aren't using a registered name
&GetMemberListArray;
$lcthename = lc($UserName);

$_ = $lcthename;

if ((m/^\s/) || (m/\s$/) || (m/_{2,}/) || (m/\|\!/)) {
&StandardHTML("The User Name you attempted to use is illegal for one of the following reasons:<P><blockquote>1.  You may not begin or end a User Name with a space.  You may not have two or more consecutive spaces.<p>2.  You may not use a name with a pipestem followed by an exclamation point.</B></blockquote><p><CENTER>Use your back button to try again.</center>");
exit;
}

foreach $regname(@members) {
$lcregname = lc($regname);
if ($lcthename eq "$lcregname")  {
&StandardHTML("Sorry, but the name you attempted to use has been reserved by a registered member.  You do not have to register, but you must use a different name.  Please use your back button to try again.");
exit;
}
}

$match = "yes";
$verified = "true";
$PermissionToWrite = "true";
$UserNameRegister = "false";
}  else {

$ProfileNumber = &GetUserNumber($UserName);
if ($ProfileNumber ne "") {
	$match = "yes";
} else {
	$match = "no";
}

if ($match eq "yes") {
	@profilestats2 = &OpenProfile("$ProfileNumber.cgi");
	if ($profilestats2[1] eq "$in{'Password'}") {
				$verified = "true";
				$Email = "$profilestats2[2]";
				$Status = "$profilestats2[8]";
				$TotalPosts = "$profilestats2[7]";
				$Permission = "$profilestats2[4]";
				$EmailView = "$profilestats2[11]";
				$Signature = "$profilestats2[12]";
	}  #END IF profilestats
} #END IF match eq yes
	
if ($match eq "no") {
&StandardHTML("Sorry, but we have no one registered with the UserName you typed ($UserName).  Please try again.  Use your Back button.");
}

if ($match eq "yes" && $verified eq "false") {
&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
}
} #end if/else lwa =includenonreg

if (($match eq "yes") && ($verified eq "true")) {

if ($in{'Password'} ne "") {
&CheckPermissions;
}

   if ($PermissionToWrite eq "true") {

##create filenumber for reply 
@replier = &OpenThread("$topic");
@revreplier = reverse(@replier);

$statline = $replier[0];
$fatherline = $replier[1];
@papa = split(/\|\|/, $fatherline);
@stats = split(/\|\|/, $statline);

if ($stats[1] eq "X") {
&StandardHTML("You are attempting to post a reply to a thread that is now closed.");
exit;
}  

$replytotal = $stats[2];
$replytotal++;               #add one to reply total

$lastpost = $revreplier[0];
@lastpost = split(/\|\|/, $lastpost);

$lastnumber = $lastpost[1];
$lastnumber++;  #add 1 to last post number
$newreplynum = sprintf("%6d", $lastnumber);
$newreplynum =~tr/ /0/;

#now we have to add the new message to the thread file

## IF HTML is not allowed, render HTML useless
if ($HTMLAllow eq "is not") {
		$ReplyMessage =~ s/</&lt;/g;
		$ReplyMessage =~ s/>/&gt;/g;
 }
 
$ReplyMessage = &CensorCheck("$ReplyMessage");
$ReplyMessage2 = "$ReplyMessage";
$ReplyMessage = &Truncate("$ReplyMessage");

#convert newlines/carriage returns to HTML
$ReplyMessage = &ConvertReturns("$ReplyMessage");

#Smiley/Frown conversion---
$ReplyMessage = &Smilies("$ReplyMessage");

#UBB Code-ify (if allowed)
if ($UBBCodeAllow eq "is") {
$ReplyMessage = &UBBCode("$ReplyMessage");
} #END UBB CODE 

#Check for Signature
if ($UserNameRegister ne "false") {
if (($AllowSignature eq "YES") && ($in{'Signature'} eq "yes")) {
$ReplyMessage .= ("<P>------------------<BR>$Signature");
}
}

$ReplyMessage= &PipeCleaner("$ReplyMessage"); 

($ThreadNo, $junk) = split(/\./, $topic);

## if email should not be displayed, don't
if (($EmailBlock eq "ON") || ($EmailView eq "no") || ($UserNameRegister eq "false")) {
$PostEmail = "";
}  else {
$PostEmail = "$Email";
}

#Get IP Number if IP logging is on
if (($IP eq "ON") || ($IP eq "LOGONLY")) {
	$IPNumber = $ENV{'REMOTE_ADDR'};
}


if (($ReplyRestrict eq "all") && ($UserNameRegister eq "true")) {
	$RegStatus = "reg";
}
elsif (($ReplyRestrict eq "all") && ($UserNameRegister eq "false")) {
$RegStatus = "unreg";
}  else {
$RegStatus = "reg";
}

$ReplyLine = ("Z||$newreplynum||$UserName||$HyphenDate||$Time||$PostEmail||$ReplyMessage||$IPNumber||$RegStatus");

push(@replier, $ReplyLine);

foreach $line(@replier) {
chomp($line);
if ($line =~ /^A/) {
	chomp($stats[4]);
	$newstats = "A||$stats[1]||$replytotal||$stats[3]||$stats[4]";
	push(@updated, $newstats);
} else {
	push(@updated, $line);
}
}

#check to make sure files are writeable!!
if ($RegStatus eq "reg") {
unless (-w "$MembersPath/$ProfileNumber.cgi") {
chmod (0777, "$MembersPath/$ProfileNumber.cgi");
}
}

unless (-w "$ForumsPath/$ExactPath/$topic")  {
chmod (0777, "$ForumsPath/$ExactPath/$topic");
}

if (-w "$ForumsPath/$ExactPath/$topic")  {
#if topic file is writeable---

if (($LWA eq "private") && ($PrivateMax eq "yes")) {
	$GoTo = "$CGIURL/forumdisplay.cgi?action=displayprivate&number=$number&topic=$ThreadNo";
	$FileExt = "cgi";
} else {
		$GoTo = "$NonCGIURL/$ExactPath/HTML/$ThreadNo.html";
		$FileExt = "html";
	}
&ForwardWithCookies("$GoTo", "Thanks for posting your message, $UserName!  We are now sending you back automatically to this topic.");

&Lock("lock.file");
open (REPLY, ">$ForumsPath/$ExactPath/$topic");
foreach $post(@updated) {
chomp($post);
print REPLY ("$post\n");
}
close (REPLY);
&Unlock("lock.file");
chmod (0666, "$ForumsPath/$ExactPath/$topic");

if ($RegStatus eq "reg") {
##Add reply to user's profile (total posts)
$TotalPosts++;
#Bump user up to Member if Total Posts reaches $MemberMinimum
if (($TotalPosts >= $MemberMinimum)  && ($Status eq "Junior Member")) {
$profilestats2[8] = "Member";
} 

$profilestats2[7] = $TotalPosts;
&Lock("lock.file");
open (MEMBERSHIP, ">$MembersPath/$ProfileNumber.cgi") or die("Unable to open Members directory.");
foreach $instance(@profilestats2) {
	chomp($instance);
	print MEMBERSHIP ("$instance\n");
}
close (MEMBERSHIP);
&Unlock("lock.file");
chmod (0777, "$MembersPath/$ProfileNumber.cgi");
}

#update last time file
&Lock("lock.file");
open (LASTTIME, ">$ForumsPath/$ExactPath/lasttime.file") or die("Unable to open LastTime.file");
print LASTTIME ("$HyphenDate\n");
print LASTTIME ("$Time\n");
close (LASTTIME);
&Unlock("lock.file");
chmod (0666, "$ForumsPath/$ExactPath/lasttime.file");

#update threads summary file
&CurrentDate;
if (-e "$ForumsPath/$ExactPath/forum$number.threads") {
&UpdateForumSummary($number, $topic);
}  else {
&ForumSummary($number);
}


##CREATE HTML FILE FOR NEW THREAD
&CreateThreadHTML("Forum$number", "$topic");

## UPDATE INDEX
$Message = "$ReplyMessage";
if ($ForumStatus eq "On") {
	if ($LWA eq "private") {
		&AppendPrivateIndex("$number", "$topic", "$LWAPW");
} else {
&AppendIndex("$number", "$topic");
}
}

##determine last topic number and increment by 1

open (FORUMCOUNT, "$ForumsPath/$ExactPath/lastnumber.file"); 
    @forumcounter = <FORUMCOUNT>;
close (FORUMCOUNT);

$lastthreadnum = $forumcounter[0];
chomp($lastthreadnum);
$totthreadcount = $forumcounter[1];
chomp($totthreadcount);
$totpostcount = $forumcounter[2];
chomp($totpostcount);

$totpostcount++;

&Lock("lock.file");
open (FORUMCOUNT, ">$ForumsPath/$ExactPath/lastnumber.file"); 
print FORUMCOUNT ("$lastthreadnum\n");
print FORUMCOUNT ("$totthreadcount\n");
print FORUMCOUNT ("$totpostcount\n");
close (FORUMCOUNT);
&Unlock("lock.file");
chmod (0666, "$ForumsPath/$ExactPath/lastnumber.file");

($topicnum, $junk) = split(/\./, $topic);

# If Forum is set to Moderator Notify,
# need to send notification to forum moderator
if ($ModNotify eq "yes") {
$ModName = ("Forum" . "$number" . "Moderator");
$ModName = $$ModName;
if (($ModName ne "")  && ($ModName !~ m/none/i)) {
$ProfNumber = &GetUserNumber($ModName);
@ModProfile = &OpenProfile("$ProfNumber.cgi");
$sendto = $ModProfile[2];
chomp($sendto);
$subject = "Moderator Notification: New Post in $Forum";

if ($sendto =~ /\S+\@\S+\.\S+/) {
$ReplyMessage =~ s/<BR>/\n/ig;
$ReplyMessage =~ s/<P>/\n\r\n/ig;
$ReplyMessage =~ s/<.+?>//g;

$message = "Hello, $ModName!  \n\r\n$UserName has just replied to the topic entitled - $TopicSubject - in the $Forum forum of $BBName. \n\r\nThis topic is located at $NonCGIURL/$ExactPath/HTML/$topicnum.html\n\r\nHere is what the user posted:\n\r\n$ReplyMessage";

if ($SMTPEmail eq "On") {
&SendEmail;
}  else {
&send_mail("$BBEmail", "$sendto", "$subject", "$message");
}
} #if email is in valid format
} # end moderator name check- if blank, do not send email
} #end mod notify block

## IF TOPIC SET TO NOTIFY, THEN WE NEED TO GENERATE AN
## EMAIL MESSAGE TO SEND TO THE AUTHOR OF THE TOPIC

if ($stats[1] =~ /N/) {
$TopicWriter = $papa[2];
	#don't send if person replying is same as topic writer
	if ($TopicWriter ne "$UserName") {
	$ProfNum = &GetUserNumber($TopicWriter);
@topicw = &OpenProfile("$ProfNum.cgi");

$sendto = "$topicw[2]";
chomp($sendto);
$subject = "Notification: Reply to Your BB Topic";
$message = "Hello, \n\r\n $UserName has just replied to your topic entitled - $TopicSubject - in the $Forum forum of $BBName. \n\r\n This BB is located at $CGIURL/Ultimate.cgi";
if ($sendto =~ /\S+\@\S+\.\S+/) {
if ($SMTPEmail eq "On") {
&SendEmail;
	}  else {
&send_mail("$BBEmail", "$sendto", "$subject", "$message");
	}
}
	} #end if topic writer ne username
}  # end if extension = n

}  else {
#if topic file is still not writeable,
# then web host may be preventing writing new files-- don't process then

&StandardHTML("Sorry, we could not post your reply to this topic.  Contact your bulletin board administrator and inform them that they may have may run out of available disk space.  Their web host may be preventing them from posting new files.");
}

} else {

&StandardHTML("Sorry, but you no longer have permission to post a note on the bulletin board.  Either the administrator of the BB or one of the moderators has removed your posting privileges.");

} #END Check Permission block
}
} # end Do Post The Reply

sub NewTopic {
@thisforum = &GetForumRecord($number);
$CustomTitle = "$thisforum[9]";
$UBBImages = "$thisforum[10]";
$PostPermissions = $thisforum[6];


if ($PostPermissions eq "private") {
	$TopicRestrict = "restrict";
}  else {
($TopicRestrict, $junk) = split(/\&/, $PostPermissions);
}

if (($PostPermissions ne "private") && ($PostPermissions !~ /\&/)) {
&StandardHTML("We can not allow any new topics until your bulletin board administrator resets all forum variables. This board has not been completely updated yet.");
exit;
}
if ($CustomTitle eq "") {
$CustomTitle = "$BBTitle";
}

&CheckCoding;

if ($TopicRestrict eq "all") {
$RegistrationWording = qq(Registration is recommended, but not required, in order to post messages in this forum. Unless registered, you will not be able to edit messages after they are submitted.);
$RegistrationOffWording = qq(<tr $TableColorStrip><td colspan=2><FONT SIZE="1" FACE="$FontFace" color="$TableStripTextColor">If you are not registered, leave the password field below blank.</font></td></tr>);
}  else {
$RegistrationWording = qq(You must be registered in order to post a topic or reply in this forum.);
$RegistrationOffWording = "";
}

## if email is enabled, show notification wording

	if ($UseEmail eq "ON")  {
	$EmailNotificationHTML = qq(<INPUT TYPE="CHECKBOX" NAME="EmailNotification" VALUE="yes"> <B>Email Notification:</B> emails sent to you whenever someone replies. Only registered users are eligible.);
	}  else {
	$EmailNotificationHTML = "";
	}
	
	if ($AllowSignature eq "YES") {
	$ShowSignature = qq(<INPUT TYPE="CHECKBOX" NAME="Signature" VALUE="yes"> <B>Show Signature:</B> include your profile  signature.  Only registered users may have signatures.);
	}  else {
	$ShowSignature = "";
	}

#check to see if this forum is there are posting restrictions
if ($TopicRestrict eq "restrict") {
$LWADisclaimer = qq(Only administrators, moderators, and authorized registered users.);
$LWAField = qq(<tr $TableColorStrip><td colspan=2><B><FONT SIZE="1" FACE="$FontFace" COLOR="$TableStripTextColor">If you are an administrator or moderator, you do not need to type a forum password.  If you are not, you must supply the forum password in order to post a message in this forum, unless you have been given specific permission by your administrator.</FONT></B></td></tr><tr $TableColorStrip><td><FONT SIZE="$TextSize" FACE="$FontFace" color="$TableStripTextColor">Forum Password:</FONT></td><td><INPUT TYPE="TEXT" NAME="ForumPassword"
SIZE=10 MAXLENGTH=25></td></tr>);
	} else {
	if ($TopicRestrict eq "all") {
		$LWADisclaimer = "Anyone may post a topic.";
		$LWAField = "";
	}
		if ($TopicRestrict eq "allreg") {
		$LWADisclaimer = "Any registered users may post a topic.";
		$LWAField = "";
	}
}
	&TopicFormHTML;
}  ## END NEWTOPIC SR ##

sub PostTopic {
		
@thisforum = &GetForumRecord($number);
$LWA = $thisforum[6];
$LWAPassword = &decodeURL($thisforum[7]);
$UBBCodeAllow = $thisforum[5];
$HTMLAllow = $thisforum[4];
$UBBImages = $thisforum[10];
$ModNotify = $thisforum[11];
$ForumStatus = $thisforum[3];
$PrivateMax = $thisforum[13];
chomp($PrivateMax);

#set proper path if forum is private
if ($LWA eq "private") {
	$ThisPath = "Forum$number/private-$LWAPassword";
}  else {
	$ThisPath = "Forum$number";
}

if ($LWA eq "private") {
	$TopicRestrict = "restrict";
	&get_cookie;  #retrieves all current cookies
	$PasswordPrivate = "$cookie{PasswordPrivate}";
	$UserNamePrivate = "$cookie{UserNamePrivate}";
	$NumbersPrivate = "$cookie{ForumNumberPrivate}";
	&VerifyID;
	
	if ($ProceedNow ne "true") {
		&StandardHTML("This is a private forum and you have not been properly authorized to post to this forum.");
		exit;
	}
}  else {
($TopicRestrict, $junk) = split("&", $LWA);
}

## Verify form input
if (($in{'UserName'} eq "") || ($in{'TopicSubject'} eq "") || ($in{'Message'} eq "")) {
		&StandardHTML("You did not complete all required form fields!  Please go back and re-enter.");
}
elsif (($TopicRestrict ne "all") && ($in{'Password'} eq "")) {
		&StandardHTML("You did not complete all required form fields!  Please go back and re-enter.");
	
	}  else {

if ($TopicRestrict eq "restrict")  {
$NameFound = "no";
$ProfileNumber = &GetUserNumber($in{'UserName'});
if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}

if ($NameFound eq "yes") {

	@theprofile = &OpenProfile("$ProfileNumber.cgi");
	if ($in{'Password'} eq "$theprofile[1]") {
		$Permission = "$theprofile[4]";
		($GenPerms, $SpecificPerms) = split(/\&/, $Permission);
		$Status = $theprofile[8];
		$EmailView = $theprofile[11];
		&CheckTheStatus;
		&CheckPermissions;
		
		if ($SpecificPerms ne "") {
			chomp($specificPerms);
			@accessarray = split(",", $SpecificPerms);
			foreach $uno(@accessarray) {
				if ($uno eq "$number") {
					$PermissionGranted = "true";
				}
			}
		}
		#check forumpassword
		if ($in{'ForumPassword'} eq "$thisforum[12]") {
			$PermissionGranted = "true";
		}
		
	   	if (($AdminPermission eq "true") || ($ModStatus eq "true")) {
	   &DoPostTheTopic;
	   }
	   elsif ($PermissionGranted eq "true") {
	   &DoPostTheTopic;
	   }  else {
	   &StandardHTML("Sorry, but you are not authorized to post a new topic in this particular forum.  Only moderators, administrators, and authorized users may post new topics in this forum.");
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again. Use your Back button.");
	}
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
}  ##END IF/ELSE NAME CHECK BLOCK
} else {
	   &DoPostTheTopic;
	   
}#end if/else LWA = yes

} #end if/else field check
}  ## END POST TOPIC SR ###
 
sub DoPostTheTopic {

##get current date/time
&GetDateTime;

##verify user name/password if necessary
$match = "no";
$verified = "false";

if (($TopicRestrict eq "all") && ($in{'Password'} eq "")) {
#check to make sure they aren't using a registered name
&GetMemberListArray;
$lcthename = lc($UserName);
$_ = $lcthename;
if ((m/^\s/) || (m/\s$/) || (m/_{2,}/) || (m/\|\!/)) {
&StandardHTML("The User Name you attempted to use is illegal for one of the following reasons:<P><blockquote>1.  You may not begin or end a User Name with a space.  You may not have two or more consecutive spaces.<p>2.  You may not use a name with a pipestem followed by an exclamation point.</B></blockquote><p><CENTER>Use your back button to try again.</center>");
exit;
}

foreach $regname(@members) {
$lcregname = lc($regname);
if ($lcthename eq "$lcregname") {
&StandardHTML("Sorry, but the name you attempted to use has been reserved by a registered member.  You do not have to register, but you must use a different name.  Please use your back button to try again.");
exit;
}
}

$match = "yes";
$verified = "true";
$PermissionToWrite = "true";
$UserNameRegister = "false";
}  else {

$ProfileNumber = &GetUserNumber($in{'UserName'});
if ($ProfileNumber ne "") {
	$match = "yes";
} else {
	$match = "no";
}
if ($match eq "yes") {
	@profilestats2 = &OpenProfile("$ProfileNumber.cgi");
		chomp($profilestats2[1]);
	if ($profilestats2[1] eq "$in{'Password'}") {
				$verified = "true";
				$Email = "$profilestats2[2]";
				$Status = "$profilestats2[8]";
				$EmailView = "$profilestats2[11]";
				$TotalPosts = "$profilestats2[7]";
				$Permission = "$profilestats2[4]";
				$EmailView = "$profilestats2[11]";
				$Signature = "$profilestats2[12]";
	}  #END IF profilestats
} #END IF match eq yes
	
if ($match eq "no") {
&StandardHTML("Sorry, but we have no one registered with the UserName you typed.  Please try again.  Use your Back button.");
}

if ($match eq "yes" && $verified eq "false") {
&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
}
} #end if/else lwa =includenonreg

if (($match eq "yes") && ($verified eq "true")) {

if ($in{'Password'} ne "") {
&CheckPermissions;
}

if ($PermissionToWrite eq "true") {

##determine last topic number and increment by 1
if (-e "$ForumsPath/$ThisPath/lastnumber.file") {
open (FORUMCOUNT, "$ForumsPath/$ThisPath/lastnumber.file"); 
    @forumcounter = <FORUMCOUNT>;
close (FORUMCOUNT);
$lastthreadnum = $forumcounter[0];
chomp($lastthreadnum);
$totthreadcount = $forumcounter[1];
chomp($totthreadcount);
$totpostcount = $forumcounter[2];
chomp($totpostcount);
}  else {
$lastthreadnum = 0;
$totthreadcount = 0;
$totpostcount = 0;
}

$count = $lastthreadnum + 0;

if (($in{'EmailNotification'} eq "yes")  && ($UserNameRegister ne "false")) {
	$Notes = "N";
}  else {
	$Notes = "";
}

if ($count > 0) {
$lastthreadnum++;
$newtopic = sprintf("%6d", $lastthreadnum);
$newtopic =~tr/ /0/;
}  else {
$newtopic = "000001";
}
##create filenumber for new topic
$newtopicfile = ("$newtopic.cgi");

#now we have to add the message to the forum directory

## IF HTML is not allowed, render HTML useless
if ($HTMLAllow eq "is not") {
		$Message =~ s/</&lt;/g;
		$Message =~ s/>/&gt;/g;
 }
	
$Message = &CensorCheck("$Message");
$Message = &Truncate("$Message");

#convert newlines/carriage returns to <br> and <p> html tags
$Message = &ConvertReturns("$Message");
$Message = &Smilies("$Message");

#UBB Code-ify (if allowed)
if ($UBBCodeAllow eq "is") {
$Message = &UBBCode("$Message");
} #end if UBB Code allowed

#Check for Signature
if ($UserNameRegister ne "false") {
if (($AllowSignature eq "YES") && ($in{'Signature'} eq "yes")) {
$Message .= ("<P>------------------<BR>$Signature");
}
}

$Message= &PipeCleaner("$Message"); 

## if email should not be displayed, don't

if (($EmailBlock eq "ON") || ($EmailView eq "no") || ($TopicRestrict eq "any" && $UserNameRegister eq "false")) {
$PostEmail = "";
}  else {
$PostEmail = "$Email";
}

$TopicSubject = &PipeCleaner("$TopicSubject"); 

#Get IP Number if IP logging is on
if (($IP eq "ON") || ($IP eq "LOGONLY")) {
	$IPNumber = $ENV{'REMOTE_ADDR'};
}

#create file lines
$StatsLine = "A||$Notes||0||$UserName||$TopicSubject";

if (($TopicRestrict eq "all") && ($UserNameRegister eq "true")) {
	$RegStatus = "reg";
}
elsif (($TopicRestrict eq "all") && ($UserNameRegister eq "false")) {
$RegStatus = "unreg";
}  else {
$RegStatus = "reg";
}

$FatherLine = "Z||000000||$UserName||$HyphenDate||$Time||$PostEmail||$Message||$IPNumber||$RegStatus";

### test to make sure member file is writeable!
if ($RegStatus eq "reg") {
unless (-w "$MembersPath/$ProfileNumber.cgi") {
chmod (0777, "$MembersPath/$ProfileNumber.cgi");
}
}

&ForwardWithCookies("$CGIURL/forumdisplay.cgi?action=topics&forum=$ForumCoded&number=$number&DaysPrune=$DaysPrune", "Thanks for posting your message, $UserName!  We are now taking you back automatically to the topic list for $Forum.");

&Lock("lock.file");
open (FORUM, ">$ForumsPath/$ThisPath/$newtopicfile"); 
print FORUM ("$StatsLine\n");
print FORUM ("$FatherLine\n");
close (FORUM);
&Unlock("lock.file");

chmod (0666, "$ForumsPath/$ThisPath/$newtopicfile");
if ($RegStatus ne "unreg") {
##Add reply to user's profile (total posts)
$TotalPosts++;
#Bump user up to Member if Total Posts reaches $MemberMinimum
if (($TotalPosts == $MemberMinimum)  && ($Status eq "Junior Member")) {
$profilestats2[8] = "Member";
}

$profilestats2[7] = $TotalPosts;

&Lock("lock.file");
open (MEMBERS, ">$MembersPath/$ProfileNumber.cgi") or die("Unable to open Members directory.");
foreach $instance(@profilestats2) {
	chomp($instance);
	print MEMBERS ("$instance\n");
}
close (MEMBERS);
&Unlock("lock.file");
chmod (0777, "$MembersPath/$ProfileNumber.cgi");
}  # end includenonreg check


##CREATE HTML FILE FOR NEW THREAD
&CreateThreadHTML("Forum$number", "$newtopicfile");

#update last time file
&Lock("lock.file");
open (LASTTIME, ">$ForumsPath/$ThisPath/lasttime.file") or die("Unable to open LastTime.file");
print LASTTIME ("$HyphenDate\n");
print LASTTIME ("$Time\n");
close (LASTTIME);
&Unlock ("lock.file");
chmod (0666, "$ForumsPath/$ThisPath/lasttime.file");

#update last number file for forum
$totthreadcount++;
$totpostcount++;

&Lock("lock.file");
open (FORUMCOUNT, ">$ForumsPath/$ThisPath/lastnumber.file"); 
print FORUMCOUNT ("$newtopic\n");
print FORUMCOUNT ("$totthreadcount\n");
print FORUMCOUNT ("$totpostcount\n");
close (FORUMCOUNT);
&Unlock ("lock.file");
chmod (0666, "$ForumsPath/$ThisPath/lastnumber.file");


#update threads summary file
&CurrentDate;
if (-e "$ForumsPath/$ThisPath/forum$number.threads") {
open (CHECKIT, "$ForumsPath/$ThisPath/forum$number.threads"); 
@checkthis = <CHECKIT>;
close(CHECKIT);
$TotalCheck = @checkthis;
$PreCount = $totthreadcount - 1;
if ($TotalCheck == $PreCount) {
&AppendForumSummary($number, $newtopicfile);
} else {
&ForumSummary($number);
}
}  else {
&ForumSummary($number);
}

## UPDATE INDEX
if ($ForumStatus eq "On") {
	if ($LWA eq "private") {
&AppendPrivateIndex("$number", "$newtopicfile", "$LWAPassword");
}  else {
&AppendIndex("$number", "$newtopicfile");
}
}

# If Forum is set to Moderator Notify,
# need to send notification to forum moderator
if ($ModNotify eq "yes") {
$ModName = ("Forum" . "$number" . "Moderator");
$ModName = $$ModName;
if (($ModName ne "") && ($ModName !~ m/none/i)) {
$ProfNumber = &GetUserNumber($ModName);
@ModProfile = &OpenProfile("$ProfNumber.cgi");
$sendto = $ModProfile[2];
chomp($sendto);
$subject = "Moderator Notification: New Topic in $Forum";
$message = "Hello, $ModName!  \n\r\n$UserName has just created a new topic entitled - $TopicSubject - in the $Forum forum of $BBName. \n\r\n This BB is located at $CGIURL/Ultimate.cgi";

if ($SMTPEmail eq "On") {
&SendEmail;
}  else {
&send_mail("$BBEmail", "$sendto", "$subject", "$message");
}
} # end check for moderator name
} #end mod notify block

} else {
&StandardHTML("Sorry, but you do not have permission to post this topic.  Either your posting privileges have been removed or you are trying to post to a forum that has limitations on the types of members that can post to it.");
}

}


} #end do post the topic sr

sub GenerateThread {
# @threadguts contains the thread info

	$PostFolder = "$NonCGIURL/posticon.gif";
	$TopicSubject = $stats[4];
	chomp ($TopicSubject);
	
	&ThreadReplyTop;
			$AlternateColor = "$AltColumnColor1";
	foreach $post(@threadguts) {
		unless ($post =~ /^A/) {
		@thispost = split(/\|\|/, $post);
		
$UNCoded = $thispost[2];
$UNCoded =~ tr/ /+/;

$theDate = "$thispost[3]";
#format date
if ($DateFormat eq "Euro") {
@datearray = split(/-/, $theDate);
chomp($datearray[2]);
$ThisDate = "$datearray[1]-$datearray[0]-$datearray[2]";
}  else {
$ThisDate = "$theDate";
}
$theTime = "$thispost[4]";

#format time option 1
	if ($TimeFormat eq "24HR")  {
		@timearray = split(/ /, $theTime);
		chomp($timearray[1]);
		($gethour, $getmin) = split(/:/, $timearray[0]);
		
		if ($timearray[1] eq "PM") {		
			if ($gethour < 12) {
				$gethour = ($gethour  + 12);
			}
		}
		
		if ($AMpm eq "AM") {		
			if ($gethour == 12) {
				$gethour = "0";
			}
		}
	$gethour = sprintf ("%2d", $gethour);
	$gethour =~tr/ /0/;
	$getmin = sprintf ("%2d", $getmin);
	$getmin =~tr/ /0/;
	
		$FormatTime = "$gethour:$getmin";
	} else {
		$FormatTime = "$theTime";
	}

	$Author = $thispost[2];
	$ReplyMess = $thispost[6];
	chomp($ReplyMess);
	
	&ThreadReplyLoop;
	if ($AlternateColor eq "$AltColumnColor1") {
		$AlternateColor = "$AltColumnColor2";
	}  else {
		$AlternateColor = "$AltColumnColor1";
	}
}
}

}  ## end Generate Thread sr

sub SubmitEdit {

#verify that forum fields are complete

if (($in{'UserName'} eq "") || ($in{'Password'} eq "") || ($in{'EditedMessage'} eq "")) {
		&StandardHTML("You did not complete all required form fields! Remember that only registered users may edit their own posts.  Please go back and re-enter.");
	}  else {

## check UBB and HTML status for this forum
@thisforum = &GetForumRecord($number);
 chomp($thisforum[10]);
 ##
$UBBCodeAllow = $thisforum[5];
$HTMLAllow = $thisforum[4];
$UBBImages = $thisforum[10];
 
 ##
$ForumStatus = "$thisforum[3]";
$LWA = $thisforum[6];
$PrivateMax = $thisforum[13];
chomp($PrivateMax);

if ($LWA eq "private") {
	&get_cookie;  #retrieves all current cookies
	$PasswordPrivate = "$cookie{PasswordPrivate}";
	$UserNamePrivate = "$cookie{UserNamePrivate}";
	$NumbersPrivate = "$cookie{ForumNumberPrivate}";
	&VerifyID;
	
	if ($ProceedNow ne "true") {
		&StandardHTML("This is a private forum and you have not been properly authorized to edit posts in this forum.");
		exit;
	}
}
&CheckCoding;

$Moderator = ("Forum" . "$number" . "Moderator");
$Moderator = $$Moderator;

## Get current message from file
@editthread = &OpenThread("$topic");

GETAUTHOR: foreach $line(@editthread) {
chomp($line);
#locate proper post within thread --
	if ($line =~ /^Z\|\|$in{'ReplyNum'}/) {
		@editline = split(/\|\|/, $line);
		$postUserName = $editline[2];
		last GETAUTHOR;
	}
} #end loop through thread

$postdate = $editline[3];
$posttime = $editline[4];
$postemail = $editline[5];
$origmessage = $editline[6];
$IPnum = $editline[7];
$regstatus = $editline[8];
chomp($regstatus);
chomp($origmessage);

$Password = &decodeURL($in{'Password'});

$ProfileNumber = &GetUserNumber($UserName);
@profileinfo = &OpenProfile("$ProfileNumber.cgi");   
	
if (($postUserName eq "$UserName")  || ($Moderator eq "$UserName") || ($profileinfo[4] =~ m/Admin/)) {
#check password
	if ($profileinfo[1] eq "$Password") {
		&DoTheEdit;
	}  else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
	}

}  else {
&StandardHTML("Sorry, but you are not authorized to perform this function.  Use your Back button.");
}
} #end Missing fields check if/else
}  #end SubmitEdit sr

sub DoTheEdit {
## format the edited message
$EditedMessage = $in{'EditedMessage'};

## IF HTML is not allowed, render HTML useless
if ($HTMLAllowed eq "no") {
		$EditedMessage =~ s/</&lt;/g;
		$EditedMessage =~ s/>/&gt;/g;
 }
 
$EditedMessage = &CensorCheck("$EditedMessage");
#truncate extra long words
$EditedMessage = &Truncate("$EditedMessage");
#convert newlines/carriage returns to HTML
$EditedMessage = &ConvertReturns("$EditedMessage");
#Smiley/Frown conversion---
$EditedMessage = &Smilies("$EditedMessage");
#UBB Code-ify (if allowed)
if ($UBBCodeAllow eq "is") {
$EditedMessage = &UBBCode("$EditedMessage");
} #END UBB CODE 

&GetDateTime;

if ($DateFormat eq "US") {
	$EditDate = $HyphenDate;
}
elsif ($DateFormat eq "Euro") {
	$EditDate = "$EuroDate"
}
elsif ($DateFormat eq "USX") {
	$EditDate = &DateFormat("$HyphenDate", "USExpanded");
} else {
	$EditDate = &DateFormat("$HyphenDate", "EuroExpanded");
}

# append edit note to the message
$EditedMessage .= qq(<p>[This message has been edited by $UserName (edited $EditDate).]);

$EditedMessage= &PipeCleaner("$EditedMessage"); 

$EditLine = "Z||$in{'ReplyNum'}||$postUserName||$postdate||$posttime||$postemail||$EditedMessage||$IPnum||$regstatus";

foreach $one(@editthread) {
	chomp($one);
		if ($one =~ /^Z\|\|$in{'ReplyNum'}/) {
			push (@revised, $EditLine);
		}  else {
			push (@revised, $one);
		}
}

#open thread for writing

&Lock("lock.file");
open (POST, ">$ForumsPath/$ExactPath/$topic");
foreach $thisone(@revised) {
chomp($thisone);
print POST ("$thisone\n");
}
close(POST);
&Unlock("lock.file");

($TopicNum, $junk) = split(/\./, $topic);

if (($LWA eq "private") && ($PrivateMax eq "yes")) {
	$GoTo = "$CGIURL/forumdisplay.cgi?action=displayprivate&number=$number&topic=$TopicNum";
}  else {
	$GoTo = "$NonCGIURL/$ExactPath/HTML/$TopicNum.html";
}
&Forward("$GoTo", "Thanks for editing the message, $UserName!  We are now sending you back automatically to the thread list for this topic.");

chomp($origmessage);
$OrigText = &Indexify("$origmessage");

##CREATE HTML FILE FOR Revised THREAD
&CreateThreadHTML("Forum$number", "$topic");

## Update Index
if ($ForumStatus eq "On") {
&UpdateIndex("$number", "$topic", "$OrigText", "$EditedMessage");
}
}  # end DoTheEdit sr

### HTML CODE ####

sub ReplyFormHTML {
print <<REPLYFORM;
<HTML><HEAD><TITLE>$BBName - Reply to Topic</TITLE>
</HEAD>
 <BODY $BGColor $PageBackground text="$TextColor" link="$LinkColor" alink="$ActiveLinkColor" vlink="$VisitedLinkColor">
<FONT SIZE="$TextSize" FACE="$FontFace">
$Header
</font>
<table border=0 width=$TableWidth>
<TR><TD>
<A HREF="Ultimate.cgi?action=intro&BypassCookie=true"><IMG SRC="$NonCGIURL/$CustomTitle"  BORDER=0></A></td>
<td align=center>

<table border=0>
<TR><TD><FONT Face="$FontFace" size="$TextSize"><B>Forum:</B></font></td><TD><FONT Face="$FontFace" size="$TextSize">$Forum</FONT></td></tr>
<TR><TD><FONT Face="$FontFace" size="$TextSize"><B>Topic:</B></font></td><TD><FONT Face="$FontFace" size="$TextSize">$TopicSubject</FONT></td></tr></table>

</td></tr></table>
<FONT SIZE="1" FACE="$FontFace"><A HREF="$CGIURL/Ultimate.cgi?action=agree">Want to register?</a></FONT>

<FORM ACTION="postings.cgi" NAME="REPLIER" METHOD="POST">
<center>
$BorderTop
<table border=0 cellpadding=4 cellspacing=1 width=$TableWidth2>
<tr $TableColorStrip>
<td valign=top>
<FONT SIZE="2" FACE="$FontFace" COLOR="$TableStripTextColor">
Who Can Post?
</font>
</td>
<td valign=top><FONT SIZE="2" FACE="$FontFace" COLOR="$TableStripTextColor">
$LWADisclaimer
</font>
</td></tr>
<tr $TableColorStrip>
<td valign=top>
<FONT SIZE="2" FACE="$FontFace" COLOR="$TableStripTextColor">
About Registration
</font>
</td>
<td valign=top><FONT SIZE="2" FACE="$FontFace" COLOR="$TableStripTextColor">
$RegistrationWording
</font>
</td></tr>

<tr $AltColumnColor2><td valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Your UserName:</B></FONT></td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="UserName" VALUE="" SIZE=25 MAXLENGTH=25>
</td>
</tr>
$RegistrationOffWording
<tr $AltColumnColor2>
<td valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Your Password:</B></FONT></td>
<td valign=top><INPUT TYPE="PASSWORD" NAME="Password" VALUE="" SIZE=13 MAXLENGTH=13>&nbsp;&nbsp;<FONT SIZE="1" FACE="$FontFace"><A HREF="Ultimate.cgi?action=lostpw">Forget your password?</A></font>
</td></tr>
$LWAField
<TR $AltColumnColor2><TD valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Your Reply:</B></FONT>
<p><BR>
<FONT SIZE="1" FACE="$FontFace" COLOR="$VisitedLinkColor">
$ISHTML<BR>
<A HREF="$NonCGIURL/ubbcode.html" target=_new>$ISUBB</A><BR>
$UBBImagesWording</p></font>
</td>
<td>
<TEXTAREA NAME="ReplyMessage" ROWS=10 COLS=45 WRAP="VIRTUAL"></TEXTAREA>
</td></tr>
<TR $AltColumnColor2>
<td valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace">
<B>Options</B>
</FONT></td>
<td valign=top><FONT SIZE="1" FACE="$FontFace">
$ShowSignature</font>
</td></tr>
</table>
$BorderBottom
</center>
<P>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="postreply">
<INPUT TYPE="HIDDEN" NAME="TopicSubject" VALUE="$TopicSubject">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$Forum">
<INPUT TYPE="HIDDEN" NAME="number" VALUE="$number">
<INPUT TYPE="HIDDEN" NAME="topic" VALUE="$topic">
<CENTER>
 <FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">
<P>
If you have previously registered, but forgotten your password, <A HREF="Ultimate.cgi?action=lostpw">click here</A>.
</font>
<p>
<INPUT TYPE="Submit" NAME="SUBMIT" VALUE="Submit Reply">
<INPUT TYPE="RESET" NAME="RESET" VALUE="Clear Fields">
</form>
<P>
<FONT SIZE="1" FACE="$FontFace" COLOR="#FF0000">*If HTML and/or <A HREF="$NonCGIURL/ubbcode.html" target=_new>UBB Code</A> are enabled, this means you can use use HTML and/or UBB Code in your message.</FONT>

<br>
REPLYFORM
} # end ReplyFormHTML


sub ReplyFormBottom {
print<<REPLYFORMBOTTOM;
</table>

<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE

var dc = document.cookie;
var testUserName = getCookie("UserName");
var testPassword = getCookie("Password");

if (document.cookie) {

	if (testUserName == null) {  
document.REPLIER.UserName.focus();
	} else {
	document.REPLIER.UserName.value = getCookie("UserName");
document.REPLIER.Password.value = getCookie("Password");
document.REPLIER.ReplyMessage.focus();
	}
}  else {
document.REPLIER.UserName.focus();
}


function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length;
            return unescape(dc.substring(begin, end));        }
}
return null;
}

// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
<P><center>
REPLYFORMBOTTOM

&PageBottomHTML;
}  ## END Reply Form Bottom sr

sub TopicFormHTML {
print <<FORM;
<HTML>
<HEAD>
<TITLE>$BBName - Post New Topic</TITLE>
</HEAD>
 <BODY $BGColor $PageBackground text="$TextColor" link="$LinkColor" alink="$ActiveLinkColor" vlink="$VisitedLinkColor">
<FONT SIZE="$TextSize" FACE="$FontFace" color="$TextColor">
$Header
</font>

<table border=0>
<TR><TD>
<A HREF="Ultimate.cgi?action=intro&BypassCookie=true"><IMG SRC="$NonCGIURL/$CustomTitle"  BORDER=0></A></td>
<td><FONT SIZE="$TextSize" FACE="$FontFace">
<B>Post New Topic for Forum:<br>&nbsp;&nbsp;&nbsp;<FONT COLOR="$LinkColor">$Forum</FONT></FONT></B>
</td></tr></table>

<FONT SIZE="1" FACE="$FontFace"><A HREF="$CGIURL/Ultimate.cgi?action=agree">Want to register?</a></FONT>

<FORM ACTION="postings.cgi" METHOD="POST" NAME="PostTopic">
<center>

$BorderTop
<table border=0 cellpadding=4 cellspacing=1 width=$TableWidth2>
<tr $TableColorStrip>
<td valign=top>
<FONT SIZE="2" FACE="$FontFace" COLOR="$TableStripTextColor">
Who Can Post?
</font>
</td>
<td valign=top><FONT SIZE="2" FACE="$FontFace" COLOR="$TableStripTextColor">
$LWADisclaimer
</font>
</td></tr>
<tr $TableColorStrip>
<td valign=top>
<FONT SIZE="2" FACE="$FontFace" COLOR="$TableStripTextColor">
About Registration
</font>
</td>
<td valign=top><FONT SIZE="2" FACE="$FontFace" COLOR="$TableStripTextColor">
$RegistrationWording
</font>
</td></tr>

<tr $AltColumnColor2>
<td >
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Your UserName:</B></FONT></td><td><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td></tr>
$RegistrationOffWording

<tr $AltColumnColor2>
<td>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Your Password:</B></FONT></td><td><INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>&nbsp;&nbsp;<FONT SIZE="1" FACE="$FontFace"><A HREF="Ultimate.cgi?action=lostpw">Forget your password?</A></font></td></tr>

$LWAField
<TR $AltColumnColor2>
<td NOWRAP>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Subject:</B></FONT></td>
<td><INPUT TYPE="TEXT" NAME="TopicSubject" VALUE="" SIZE=40 MAXLENGTH=85></td></tr>

<tr $AltColumnColor2>
<td valign=top NOWRAP>
<FONT SIZE="$TextSize" FACE="$FontFace"><B>Message:</B></FONT>
<p><BR>
<FONT SIZE="1" FACE="$FontFace" COLOR="$VisitedLinkColor">
$ISHTML<BR>
<A HREF="$NonCGIURL/ubbcode.html" target=_new>$ISUBB</A><BR>$UBBImagesWording</p></font>
</td>
<td>
<TEXTAREA NAME="Message" ROWS=10 COLS=45 WRAP="VIRTUAL">
</TEXTAREA></td></tr>

<TR $AltColumnColor2>
<td valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace">
<B>Options</B>
</FONT></td>
<td valign=top><FONT SIZE="1" FACE="$FontFace">
$EmailNotificationHTML
<BR>
$ShowSignature</font>
</td></tr>
</table>
$BorderBottom
</center>

<P>
<INPUT TYPE="HIDDEN" NAME="number" VALUE="$number">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$Forum">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="posttopic">
<CENTER>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit New Topic">
<INPUT TYPE="RESET" NAME="Reset" VALUE="Clear Fields">
</form></center>
<br>

<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
var dc = document.cookie;
var testUserName = getCookie("UserName");
var testPassword = getCookie("Password");

if (document.cookie) {

	if (testPassword == null) {  
document.PostTopic.UserName.focus();
	} else {
	document.PostTopic.UserName.value = getCookie("UserName");
document.PostTopic.Password.value = getCookie("Password");
document.PostTopic.TopicSubject.focus();
	}
}  else {
document.PostTopic.UserName.focus();
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length;
            return unescape(dc.substring(begin, end));        }
}
return null;
}

// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>

<FONT SIZE="1" FACE="$FontFace" COLOR="$VisitedLinkColor">*If HTML and/or <A HREF="$NonCGIURL/ubbcode.html" target=_new>UBB Code</A> are enabled, this means you can use use HTML and/or UBB Code in your message.</FONT>
<P>
<center>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TextColor">
If you have previously registered, but forgotten your password, <A HREF="Ultimate.cgi?action=lostpw">click here</A>.</ul>
<P>
FORM
&PageBottomHTML;
}  ## END Topic Form LWA HTML

sub ThreadReplyTop {
print<<otherHTML;
<center>
<table width=$TableWidth border=0 cellpadding=5>
<TR $TableColorStrip>
<TD valign=top width=18%>
<FONT SIZE="1" face="$FontFace" color="$TableStripTextColor"><B>Name</B></FONT>
</TD>
<TD valign=top>
<FONT SIZE="1" face="$FontFace" color="$TableStripTextColor"><B>Post</B></FONT>
</TD>
</TR>
otherHTML
}  

sub ThreadReplyLoop {
print <<REPLYhtml;
<tr $AlternateColor>
	<TD width=18% valign=top>
	<FONT SIZE="$TextSize" face="$FontFace"><B>$Author</B></FONT>
</td>
<TD>
<IMG SRC="$PostFolder" BORDER=0 ALT="">
<FONT SIZE="$TextSize" FACE="$FontFace">
<FONT SIZE="1" color="$TimeColor" face="$FontFace">posted $ThisDate $FormatTime $TimeZone 
</FONT>
<HR>$ReplyMess
</FONT>
</td></tr>
REPLYhtml
}  ## END Thread Disply within Reply Form 


sub CloseThread {	
print<<CLOSE;
<HTML><HEAD><TITLE>$BBName - Request Closing of Thread</TITLE>
</HEAD>
<BODY $PageBackground $BGColor Text="$TextColor" LINK="$LinkColor" alink="$ActiveLinkColor" VLINK="$VisitedLinkColor"><FONT FACE="$FontFace" SIZE="$TextSize" COLOR="$TextColor">
$Header
<CENTER>
<A HREF="Ultimate.cgi?action=intro&BypassCookie=true"><IMG SRC="$NonCGIURL/$BBTitle" BORDER=0></A><BR><B><FONT FACE="$FontFace" SIZE="$TextSize" COLOR="$LinkColor">Request to Close Thread: $TopicSubject</FONT></B>
<p><FONT FACE="$FontFace" SIZE="$TextSize">
<CENTER>Only administrators and the moderator for this forum may close a thread.<BR>Please verify your identity below.</CENTER></font>
<FORM ACTION="ubbmisc.cgi" NAME="CloseThread" METHOD="POST">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="processclose">
<INPUT TYPE="HIDDEN" NAME="topic" VALUE="$topic">
<INPUT TYPE="HIDDEN" NAME="TopicSubject" VALUE="$TopicSubject">
<INPUT TYPE="HIDDEN" NAME="number" VALUE="$number">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$Forum">
<table width=80% border=0>
<TR><TD><B><FONT FACE="$FontFace" SIZE="$TextSize">
Your User Name</FONT>
</B>
</TD>
<TD>
<INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
</tr>
<TR><TD><B><FONT FACE="$FontFace" SIZE="$TextSize">
Your Password</FONT>
</B>
</TD>
<TD>
<INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td>
</tr>
</TABLE>
<P>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Identification">
</form>
</CENTER>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
var dc = document.cookie;
var testUserName = getCookie("UserName");
var testPassword = getCookie("Password");

if (document.cookie) {

	if (testUserName == null) {  
document.CloseThread.UserName.focus();
	} else {
	document.CloseThread.UserName.value = getCookie("UserName");
document.CloseThread.Password.value = getCookie("Password");
	}
}  else {
document.CloseThread.UserName.focus();
}
function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length;
            return unescape(dc.substring(begin, end));        }
}
return null;
}

// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
<p><BR><BR><center>
$Footer
</center></font>
</BODY></HTML>
CLOSE
}

sub EditPost {
#check to make sure edit post is ON
if ($EditOption eq "ON") {
## check UBB and HTML status for this forum
@thisforum = &GetForumRecord($number);

$LWA = $thisforum[6];
$UBBCodeAllow = $thisforum[5];
$HTMLAllow = $thisforum[4];
$UBBImages = $thisforum[10];
#if private... do not display without checking to make sure that the user has permission

if ($LWA eq "private") {
#check for private cookies to see if we can proceed immediately
&get_cookie;  #retrieves all current cookies
	$PasswordPrivate = "$cookie{PasswordPrivate}";
	$UserNamePrivate = "$cookie{UserNamePrivate}";
	$NumbersPrivate = "$cookie{ForumNumberPrivate}";
	
$DIRPW = "$thisforum[7]";
$ExactPath = "Forum$number/private-$DIRPW";
if ($NumbersPrivate ne "") {
&VerifyID;

	if (($ForumPW ne "") && ($ProceedNow ne "true")) {
		&ConfirmIdentity;
		exit;
	}
	
} else {
&StandardHTML("Either your browser does not support cookies or you have turned cookies off in your browser.  Unfortunately, we require that cookies be used in order to allow editing of messages in private forums.  Thus, we cannot process your request to edit this message.");
exit;
}

}  else {
$DIRPW = "";
$ExactPath = "Forum$number";
$ProceedNow = "true";
}

####

if ($ProceedNow eq "true") {

   chomp($thisforum[10]);
$UBBImages = "$thisforum[10]";

&CheckCoding;

## open thread file
@thisthread = &OpenThread("$topic");

## grab the proper message
@matcher = grep(/^Z\|\|$in{'ReplyNum'}/, @thisthread);

$matched = $matcher[0];
@thispost = split(/\|\|/, $matched);

$message = $thispost[6];
chomp($message);
$author = $thispost[2];
chomp($author);
$postdate = $thispost[3];
chomp($postdate);
$posttime = $thispost[4];
chomp($posttime);

&UNHTMLIFY($message);

	$message =~ s/<p>/\n\r\n/isg;
	$message =~ s/<br>/\n/isg;
	$message =~ s/<IMG SRC="$NonCGIURL\/smile.gif">/:\)/isg;
	$message =~ s/<IMG SRC="$NonCGIURL\/frown.gif">/:\(/isg;
$message =~ s/<IMG SRC="$NonCGIURL\/biggrin.gif">/\:D/isg;
$message =~ s/<IMG SRC="$NonCGIURL\/wink.gif">/\;\)/isg;
$message =~ s/<IMG SRC="$NonCGIURL\/redface.gif">/\:o/isg;

if ($UBBCodeAllow eq "is")  {
#convert UBB Code
$message = &EditUBBConvert("$message");
}

print <<EditFORM;
<HTML><HEAD>
<TITLE>
$BBName - Edit this post
</TITLE>
</HEAD>
 <BODY $BGColor $PageBackground text="$TextColor" link="$LinkColor" alink="$ActiveLinkColor" vlink="$VisitedLinkColor">
<FONT SIZE="$TextSize" FACE="$FontFace" color="$TextColor">
$Header</font>
<table border=0>
<TR><TD>
<A HREF="Ultimate.cgi?action=intro&BypassCookie=true"><IMG SRC="$NonCGIURL/$BBTitle"  BORDER=0></A></td>
<td valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace" color="$TextColor">
<B>
Forum: <FONT COLOR="$VisitedLinkColor">$Forum </FONT>
<BR>
Topic: <FONT COLOR="$VisitedLinkColor">$TopicSubject</FONT>
</B>
</FONT>

</td></tr></table>
<CENTER><FONT SIZE="$TextSize" FACE="$FontFace">Note: Only the person that posted this message, the forum's moderator, or an administrator, may edit this message.  Only registered users may edit posts!<br>
</FONT>
</CENTER>
<ul>
<FORM ACTION="postings.cgi" NAME="REPLIER" METHOD="POST">
<table border=0>
<tr><td>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TextColor">Your UserName:</FONT></td>
<td>
<INPUT TYPE="TEXT" NAME="UserName" VALUE="" SIZE=25 MAXLENGTH=25>
</td>
</tr>
<tr>
<td>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TextColor">Your Password:</FONT></td>
<td><INPUT TYPE="PASSWORD" NAME="Password" VALUE=""  SIZE=13 MAXLENGTH=13>&nbsp;&nbsp;<FONT SIZE="1" FACE="$FontFace"><A HREF="Ultimate.cgi?action=lostpw">Forget your password?</A></font>
</td></tr>
<TR><TD valign=top>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TextColor">Message to Edit:</FONT><p>
<FONT SIZE="1" FACE="$FontFace" COLOR="$VisitedLinkColor">
$ISHTML<BR>
$ISUBB<BR>
$UBBImagesWording</p></font></td>
<td><FONT SIZE="1" FACE="$FontFace" COLOR="$VisitedLinkColor">Originally posted by $author on $postdate $posttime<BR></FONT>
<TEXTAREA NAME="EditedMessage" ROWS=10 COLS=45 WRAP="VIRTUAL">$message</TEXTAREA>
</td></tr>
</table>
<p>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="submitedit">
<INPUT TYPE="HIDDEN" NAME="TopicSubject" VALUE="$TopicSubject">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$Forum">
<INPUT TYPE="HIDDEN" NAME="ReplyNum" VALUE="$in{'ReplyNum'}">
<INPUT TYPE="HIDDEN" NAME="number" VALUE="$number">
<INPUT TYPE="HIDDEN" NAME="topic" VALUE="$topic">
<CENTER>
 <FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">

</font>
<p>
<INPUT TYPE="Submit" NAME="SUBMIT" VALUE="Submit Edited Post">
<INPUT TYPE="RESET" NAME="RESET" VALUE="Clear Fields">
</form>
<P>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
var dc = document.cookie;
var testUserName = getCookie("UserName");
var testPassword = getCookie("Password");

if (document.cookie) {

	if (testUserName == null) {  
document.REPLIER.UserName.focus();
	} else {
	document.REPLIER.UserName.value = getCookie("UserName");
document.REPLIER.Password.value = getCookie("Password");
document.REPLIER.EditedMessage.focus();
	}
}  else {
document.REPLIER.UserName.focus();
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length;
            return unescape(dc.substring(begin, end));        }
}
return null;
}

// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>

<FONT SIZE="1" FACE="$FontFace" COLOR="#FF0000">*If HTML and/or <A HREF="$NonCGIURL/ubbcode.html" target=_new>UBB Code</A> are enabled, this means you can use use HTML and/or UBB Code in your message.</FONT>
</ul>
<P>
EditFORM

&PageBottomHTML;
} else {
&StandardHTML("Sorry, but the edit option has been disabled by your bulletin board administrator.");
}

}  else {
&StandardHTML("Sorry, but you are not authorized to edit any posts in this forum.");
}

}  # end edit display

sub CheckCoding {

if ($thisforum[4] eq "is") {
	$ISHTML = "*HTML is ON";
	$HTMLAllowed = "yes";
}  else {
	$ISHTML = "*HTML is OFF";
	$HTMLAllowed = "no";
}
 
if ($thisforum[5] eq "is") {
	$ISUBB = "*UBB Code is ON";
	$UBBAllowed = "yes";
}  else {
	$ISUBB = "*UBB Code is OFF";
	$UBBAllowed = "no";
}

if (($UBBImages eq "OFF") && ($UBBAllowed eq "yes")) {
	$UBBImagesWording = "\[IMG\] UBB Code Not Allowed!";
}

}


sub VerifyID {

##check ID using username set as cookie
$NameFound = "no";
$ProfileNumber = &GetUserNumber($UserNamePrivate);

if ($NumbersPrivate ne "") {
	if ($NumbersPrivate =~ /B/) {
	@CheckAccess = split("B", $NumbersPrivate);
	}  else {
		@CheckAccess = $NumbersPrivate;
	}
	
	CHECKER: foreach $checker(@CheckAccess) {
		chomp($checker);
		if ($checker eq "$number") {
			$ProceedNow = "true";
			last CHECKER;
		}
	}
}  

if ($ProceedNow ne "true") {

	if ($ProfileNumber ne "") {
		$NameFound = "yes";
		} else {
		$NameFound = "no";
	}
	
		@thisprofile = &OpenProfile("$ProfileNumber.cgi");
if ($PasswordPrivate eq "$thisprofile[1]") {
		$Permission = "$thisprofile[4]";
		$Status = $thisprofile[8];
		($GenPerms, $SpecificPerms) = split(/\&/, $Permission);
		
		if (($Status eq "Administrator") || ($Status eq "Moderator")) {
	  		$ProceedNow = "true";
	   }
		if (($SpecificPerms ne "") && ($ProceedNow ne "true")){
			chomp($specificPerms);
			@accessarray = split(",", $SpecificPerms);
			CHECKARRAY: foreach $uno(@accessarray) {
				if ($uno eq "$number") {
					$ProceedNow = "true";
					last CHECKARRAY;
				}
			}
		}
	}
}

} #end VerifyID

