#!/usr/bin/perl

#
### CONTROL PANEL UBB SCRIPT - EDIT/PRUNE FUNCTIONS ##
#
# Ultimate Bulletin Board is copyright Madrona Park, Inc., 1997, 1998, 1999.
#
#       ------------ edit.cgi -------------
#
#  This file contains most of the edit/prune functionality for the
#  UBB... used in the control panel.
#
# Madrona Park, Inc. offers no
#  warranties on this script.  The owner/licensee of the script is
#  solely responsible for any problems caused by installation of
#  the script or use of the script, including messages that may be
#  posted on the BB.
#
#  All copyright notices regarding the Ultimate Bulletin Board
#  must remain intact on the scripts and in the HTML
#  for the scripts.
#
# For more info on the Ultimate BB, 
# see http://www.UltimateBB.com
#
###############################################################
#If you are running UBB on IIS,
#you may need to add the following line
#if so, just remove the "#" sign before the print line below
#print "HTTP/1.0 200 OK\n";

eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file

require "UltBB.setup";
require "Date.pl";
require "Styles.file";
require "mods.file";
require "ubb_library.pl";
require "ubb_library2.pl";
};

if ($@) {
    print "Error including required files: $@\n";
    print "Make sure these files exist, permissions are set properly, and paths are set correctly.";
 exit;
}


print ("Content-type: text/html\n\n");

&ReadParse;

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	
	if ($Name eq "UserName") {
			$UserName = $Value;
			$UserNameFile = $UserName;
			$UserNameFile =~ s/ /_/g; #remove spaces
			}
	
	if ($Name eq "Password") {
			$Password = $Value;
			}
}  ## END FOREACH $row


#create random numbers for headers/footers
$RandomNumber = &MakeRandomNumber;
$RandomNumber2 = $RandomNumber + 100074;

if ($Header ne "") {
$Header =~ s/UBBrandomX/$RandomNumber/isg;
$Header =~ s/UBBrandomY/$RandomNumber2/isg;
}
if ($Footer ne "") {
$Footer =~ s/UBBrandomX/$RandomNumber/isg;
$Footer =~ s/UBBrandomY/$RandomNumber2/isg;
}

#adjust bgcolor variables
if ($BGColor ne ""){
$BGColor = qq(bgcolor="$BGColor");
}
if ($AltColumnColor1 ne ""){
$AltColumnColor1 = qq(bgcolor="$AltColumnColor1");
}
if ($AltColumnColor2 ne ""){
$AltColumnColor2 = qq(bgcolor="$AltColumnColor2");
}
if ($CategoryStripColor ne ""){
$CategoryStripColor = qq(bgcolor="$CategoryStripColor");
}
if ($TableColorStrip ne ""){
$TableColorStrip = qq(bgcolor="$TableColorStrip");
}
if ($PageBackground ne ""){
$PageBackground = qq(background="$NonCGIURL/$PageBackground");
}

if ($TableBorderColor ne ""){
$TableWidth2 = "100%";
$BorderTop = qq(<table border=0 cellpadding=0 cellspacing=0 width="$TableWidth"><TR><td bgcolor="$TableBorderColor">);
$BorderBottom = qq(</td></tr></table> );
}  else {
$TableWidth2 = $TableWidth;
$BorderTop = "";
$BorderBottom = "";
}
if ($in{'EditFunction'} eq "Prune") {
	&DoPrune(PruneByDate);
}

if ($in{'EditFunction'} eq "PruneUser") {
	&DoPrune(PruneByUser);
}
if ($in{'EditFunction'} eq "Delete") {
	&DoDelete;
}

if ($in{'EditFunction'} eq "ContinueIndexUpdate") {
	&UpdateTheIndex($in{'number'}, $in{'threadpoint'});
}
if ($in{'EditFunction'} eq "Edit") {
	&DoEdit;
}

if ($in{'EditFunction'} eq "AdminEditThisForum") {
	&AdminEditForum;
}
if ($in{'EditFunction'} eq "GetEditThreads") {
	&GetEditThreads;
}
if ($in{'EditFunction'} eq "GetExactEditMessage") {
	&GetExactEditMessage;
}
if ($in{'EditFunction'} eq "DoMessageEdit") {
	&DoMessageEdit;
}
if ($in{'EditFunction'} eq "PruneThisForum") {
	&PruneThisForum;
	}
if ($in{'EditFunction'} eq "SubmitPrune") {
	&SubmitPrune;
	}
if ($in{'EditFunction'} eq "DoSubjectEdit") {
	&DoSubjectEdit;
	}
if ($in{'EditFunction'} eq "DoDeleteThread") {
	&DoDeleteThread;
	}

sub SubmitPrune {
$UNCheck = $in{'UserNameCheck'};
$ProfileNumber = &GetUserNumber($UNCheck);

@checkauthority = &OpenProfile("$ProfileNumber.cgi");

if ($in{'PasswordCheck'} eq "$checkauthority[1]") {
$Status = "$checkauthority[8]";
	&CheckTheStatus;
	$ModMatch = &CheckModStatus($in{'ForumNumber'}, $in{'UserNameCheck'});
	   if (($AdminStatus eq "true") || ($ModMatch eq "yes")) {
			&DoThePrune;
		}  else {
			&StandardHTML("Sorry, but you are not authorized to perform this function.  Use your Back button.");
		}
		
	} else {

		&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
	}
}  ## End SubmitPrune sr

	
sub DoPrune {
my $Type = shift;

#check to make sure we have enough parameters
if ($Type eq "PruneByUser") {
if (($in{'DeleteName'} eq "") || ($in{'DeleteRegName'} eq "")) {
&StandardHTML("You either forgot to enter the name of the user whose posts you wish to delete or you forgot to check whether the name was registered or not.");
$MissingData = "true";
exit;
}

}

if ($MissingData ne "true") {

$NameFound = "no";
## identify user-- moderator/administrator/neither
$ProfileNumber = &GetUserNumber($in{'UserName'});
if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}

if ($NameFound eq "yes") {
@profilestats = &OpenProfile("$ProfileNumber.cgi");
	
	if ($Password eq "$profilestats[1]") {
	$Status = "$profilestats[8]";
	&CheckTheStatus;
	   if ($AdminStatus eq "true") {
	   &PruneThis(Admin, $Type);
	   } 
	    elsif ($ModStatus eq "true") {
	   &PruneThis(Mod, $Type);
	   }
	   else  {
	   &StandardHTML("Sorry, but you are not authorized to perform this function.  Use your Back button.");
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
	}
}  else {
&StandardHTML("Sorry, but no one is registered with the User Name you listed.  Please try again.  Use your Back button.");
}  ##END IF/ELSE NAME CHECK BLOCK
} #end if missing date ne true
}  ## END DoPrune

sub DoMessageEdit {
## confirm that user is authorized
$UNCheck = $in{'UserNameCheck'};

$ProfileNumber = &GetUserNumber($UNCheck);

@profilestats = &OpenProfile("$ProfileNumber.cgi");

if ($in{'PasswordCheck'} eq "$profilestats[1]") {
	$Status = "$profilestats[8]";
	&CheckTheStatus;
	$ModMatch = &CheckModStatus($in{'forum'}, $in{'UserNameCheck'});
	
	   if (($AdminStatus eq "true") || ($ModMatch eq "yes")){
			&PerformTheEdit;
		}  else {
			&StandardHTML("Sorry, but you are not authorized to perform this function.  Use your Back button.");
}

}  else {
&StandardHTML("Sorry, the password you supplied is incorrect.  Please use your back button to try again!");
} # END IF/ELSE
}  ## End DoMessageEdit sr


sub GetExactEditMessage {
$TopicNumber = substr($in{'topic'}, 0, 6);
($junk, $number) = split(/orum/, $in{'forum'});

@message = &OpenThread($in{'topic'});
@stats = split(/\|\|/, $message[0]);

	$ThreadSubject = $stats[4];
	chomp($ThreadSubject);

if (($in{'DeleteThread'} eq "yes") && ($in{'EditSubject'} eq "yes")) {
	&StandardHTML("You accidentally checked \"delete entire thread\" and \"edit subject\"... You can't do both.  Go back and try again.");
}

elsif ($in{'DeleteThread'} eq "yes") {

&JSEditMessageTopHTML;
			
print<<otherHTML;
<p><B>
<FONT COLOR="#008080">Thread Subject: $ThreadSubject</FONT>
<P>
<center>
<FORM ACTION="edit.cgi" METHOD="POST" NAME="Edit">
<FONT SIZE="2" FACE="Verdana, Arial">Clicking the button below will permanently delete this entire thread.<br>
</FONT>
<P>
<table border=0>
<TR><TD>
<FONT Size="2" FACE="Verdana, Arial" COLOR="#800000"><B>For security reasons, re-enter your UserName & Password: <BR>
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT>
<P>
<INPUT TYPE="HIDDEN" NAME="TopicNumber" VALUE="$TopicNumber">
<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="DoDeleteThread">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$in{'forum'}">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Delete Entire Thread Now">
</form>
</CENTER>
<TD>
otherHTML
	}
	
	elsif ($in{'EditSubject'} eq "yes") {
	
&JSEditMessageTopHTML;
			
print<<otherHTML;
<p><center>
<FORM ACTION="edit.cgi" METHOD="POST" NAME="Edit">
<B><FONT SIZE="2" FACE="Verdana, Arial">Edit the subject, re-enter your UserName & Password, and then click Submit button.<br>
</FONT></B><BR>
<table width=600 border=0>
<TR>
<td>
<FONT SIZE="2" FACE="Verdana, Arial" COLOR="#800000"><B>Thread Subject:</B></FONT>
</td>
<td>
<INPUT TYPE="TEXT" NAME="NewSubject" VALUE="$ThreadSubject" SIZE=40 MAXLENGTH=120>
</td>
<tr>
<td colspan=2><CENTER><B>
<FONT Size="2" FACE="Verdana, Arial" COLOR="#800000"><B>For security reasons, re-enter your UserName & Password: <BR>
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT>
<P>
<INPUT TYPE="HIDDEN" NAME="TopicNumber" VALUE="$TopicNumber">
<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="DoSubjectEdit">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$in{'forum'}">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Edited Thread Subject">
</form>
</CENTER>
</td>
otherHTML
	} else {
	
&JSEditMessageTopHTML;

print<<otherHTML;
<p><center>
<FORM ACTION="edit.cgi" METHOD="POST" NAME="Edit">
<B><FONT SIZE="2" FACE="Verdana, Arial">Edit the message, re-enter your UserName and Password, and then click Submit button.<br>
To delete the message, check this box. <FONT FACE="Verdana, Arial" COLOR="#FF0000">--></FONT> <INPUT TYPE="CHECKBOX" NAME="DeleteMessage" VALUE="yes">
otherHTML

GETPOST: foreach $row(@message) {
	@row = split(/\|\|/, $row);
	if (($row[0] ne "A") && ($row[1] eq "$in{'EditMessageNumber'}")) {
	
	$message = $row[6];
	chomp($message);

	&UNHTMLIFY($message);

	$message =~ s/<p>/\n\r\n/isg;
	$message =~ s/<br>/\n/isg;
	$message =~ s/<IMG SRC="$NonCGIURL\/smile.gif">/:\)/isg;
	$message =~ s/<IMG SRC="$NonCGIURL\/frown.gif">/:\(/isg;
	$message =~ s/<IMG SRC="$NonCGIURL\/biggrin.gif">/\:D/isg;
	$message =~ s/<IMG SRC="$NonCGIURL\/wink.gif">/\;\)/isg;
	$message =~ s/<IMG SRC="$NonCGIURL\/redface.gif">/\:o/isg;		

#convert UBB Code
$UBBImages = "ON";
$OverrideImages = "no";
$message = &EditUBBConvert("$message");

	last GETPOST;
	}	
}

## if this is a topic, then warn that all replies will also be deleted
if ($in{'EditMessageNumber'} eq "000000") {
print ("<BR><font face=\"Verdana, Arial\" SIZE=\"2\" COLOR=\"\#800000\">Warning: This message is the topic.  If you delete this, all the replies to it will also be deleted!!</font>");
}

print<<FormBottom;
</FONT></B><BR>
<table width=100% border=0>
<TR bgcolor="#F1DBD6">
<td>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000000"><B>Author</B></FONT>
</td>
<td>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000000"><B>Message</B></font>
</td>
</tr>
<tr bgcolor="#f7f7f7">
<td width=150 valign=top>
<FONT SIZE="2" face="Verdana, Arial" COLOR="#000000"><B>$row[2]</B></FONT>
</td>
<td valign=top>
<FONT SIZE="2" FACE="Verdana, Arial">
<FONT SIZE="1" color="#008080" face="Verdana, Arial">posted $row[3] $row[4] $TimeZone</FONT>
<br>
<TEXTAREA NAME="MessageText" ROWS=10 COLS=45 WRAP="VIRTUAL">$message
</TEXTAREA>
</FONT>
</td></tr>
<tr>
<td colspan=3><CENTER><BR>
<FONT Size="2" FACE="Verdana, Arial" COLOR="#800000"><B>For security reasons, re-enter your UserName & Password: <BR>
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT>
<P>
<INPUT TYPE="HIDDEN" NAME="MessageNumber" VALUE="$in{'EditMessageNumber'}">
<INPUT TYPE="HIDDEN" NAME="topic" VALUE="$in{'topic'}">
<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="DoMessageEdit">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$in{'forum'}">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Edited Message">
</form>
</CENTER>
</td></tr>
FormBottom
}
&BOTTOMHTML;

}  ## End GetExactEdit Message

sub GetEditThreads {

#open thread file
($junk, $number) = split(/orum/, $in{'forum'});
@thread = &OpenThread("$in{'topic'}");
@stats = split(/\|\|/, $thread[0]);

$UNCoded = $stats[3];
$UNCoded =~ tr/ /+/;
$TopicSubject = $stats[4];
chomp($TopicSubject);
	$SubjectCoded = &HTMLIFY($TopicSubject);
			$SubjectCoded =~ tr/ /+/;

&EditMessageTopHTML;

print<<NearTopHTML;
<p><center>
<FORM ACTION="edit.cgi" METHOD="POST">
<table border=1>
<tr>
<TD colspan=2 align=center>
<FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><B>Thread Subject: $TopicSubject  </B></FONT>
</td>
<tr>
<td>
<INPUT TYPE="CHECKBOX" NAME="EditSubject" VALUE="yes">
</td>
<td>
<FONT SIZE="1" FACE="Verdana, Arial"><B>Check here to edit the subject title.</B></FONT>
</td></tr>
<td>
<INPUT TYPE="CHECKBOX" NAME="DeleteThread" VALUE="yes">
</td>
<td>
<FONT SIZE="1" FACE="Verdana, Arial"><B>Check here to delete the entire thread.</B></FONT>
</td>
</tr>
<TR><TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<B>Otherwise, select the message to be edited/deleted below.</B></font>
</td></tr>
</table>
<BR>
<B><FONT SIZE="2" FACE="Verdana, Arial">
<table width=100% border=0>
<TR bgcolor="#F1DBD6">
<td>&nbsp;
</td>
<td>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000000"><B>Author</B></FONT>
</td>
<td>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000000"><B>Message</B></font>
</td>
</tr>
NearTopHTML

$AltColor = "#f7f7f7";

#Print each post in thread----
foreach $post(@thread) {
	unless ($post =~ m/^A/) {
		my @line = split(/\|\|/, $post);
				

#format date
if ($DateFormat eq "Euro") {
@datearray = split(/-/, $line[3]);
chomp($datearray[2]);
$ThisDate = "$datearray[1]-$datearray[0]-$datearray[2]";
}  else {
$ThisDate = "$line[3]";
}

#format time 
	if ($TimeFormat eq "24HR")  {
		@timearray = split(/ /, $line[4]);
		chomp($timearray[1]);
		($gethour, $getmin) = split(/:/, $timearray[0]);
		
		if ($timearray[1] eq "PM") {		
			if ($gethour < 12) {
			$gethour = ($gethour  + 12);
			}
		}
	if ($AMpm eq "AM") {		
		if ($gethour == 12) {
			$gethour = "0";
		}
	}
	$gethour = sprintf ("%2d", $gethour);
	$gethour =~tr/ /0/;
	$getmin = sprintf ("%2d", $getmin);
	$getmin =~tr/ /0/;
	
		$FormatTime = "$gethour:$getmin";
	} else {
		$FormatTime = "$line[4]";
	}
	chomp($line[6]);  
	
print<<gutsHTML;
<tr bgcolor="$AltColor">
<td valign=top>
<INPUT TYPE="RADIO" NAME="EditMessageNumber" VALUE="$line[1]" SELECTED>
</td>
<td width=150 valign=top>
<FONT SIZE="2" face="Verdana, Arial" COLOR="#000000"><b>$line[2]</b></FONT>
</td>
<td valign=top>
<FONT SIZE="2" FACE="Verdana, Arial">
<FONT SIZE="1" color="#008080" face="Verdana, Arial">posted $ThisDate $FormatTime $TimeZone</FONT>
<br>$line[6]
</FONT>
</td>
</tr>
gutsHTML

if ($AltColor eq "#f7f7f7") {
$AltColor = "#dedfdf";
} else {
$AltColor = "#f7f7f7";
}
	} #end unless $post starts with A
} #End foreach $post


print<<FormBottom;
<tr>
<td colspan=3><CENTER><BR>

<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="GetExactEditMessage">
<INPUT TYPE="HIDDEN" NAME="topic" VALUE="$in{'topic'}">
<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$in{'forum'}">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Retrieve Message to be Edited">
</form>
</CENTER>
</td>
</tr>
FormBottom

&BOTTOMHTML;
} ## END GetEditThreads sr


sub AdminEditForum {

&EditMessageTopHTML;

print<<MoreHTML;
<p><center>
<B><FONT SIZE="2" FACE="Verdana, Arial">Select the topic in which the post is located.</FONT></B>
<table border=0>
<tr bgcolor="#F1DBD6">
<td width=300>
<FONT SIZE="1" FACE="Verdana, Arial" color="#808080">Topic</FONT>
</td>
<td>
<FONT SIZE="1" FACE="Verdana, Arial" color="#808080">Originator</FONT>
</td>
<td><FONT SIZE="1" FACE="Verdana, Arial" color="#808080">
Replies
</FONT>
</td>
<td><FONT SIZE="1" FACE="Verdana, Arial" color="#808080">
Last Post
</FONT>
</td>
MoreHTML

@finalarray = &DoPruneGathering("Edit"); 

@sortarray = sort(@finalarray);

foreach $keptthread(@sortarray) {

@threadfacts = split(/\|\|\|/, $keptthread);

chomp($threadfacts[5]); #Replies Total

if ($DateFormat eq "Euro") {
$Month = substr($threadfacts[0], 4, 2);
$Day = substr($threadfacts[0], 6, 2);
$Year = substr($threadfacts[0], 2, 2);
$TheDate = "$Day-$Month-$Year";
}  else {
$TheDate = "$threadfacts[2]";
}
	
print <<GUTS;
<TR>
<TD width=300><A HREF="edit.cgi?EditFunction=GetEditThreads&forum=$in{'ForumNumber'}&topic=$threadfacts[1]"><IMG SRC="$NonCGIURL/closed.gif" WIDTH=14 HEIGHT=11 BORDER=0></a>
<FONT SIZE="2" FACE="Verdana, Arial">
<A HREF="edit.cgi?EditFunction=GetEditThreads&forum=$in{'ForumNumber'}&topic=$threadfacts[1]">$threadfacts[3]</A>
</FONT>
</td>
<td>
<FONT SIZE="2" FACE="Verdana, Arial">$threadfacts[4]</FONT>
</td>
<td align=center>
<FONT SIZE="2" FACE="Verdana, Arial">$threadfacts[5]</FONT>
</td>
<td>
<FONT SIZE="2" FACE="Verdana, Arial">$TheDate</FONT>
</td>
GUTS
}  ## END FOREACH

&BOTTOMHTML;
}  ## END AdminEditForum sr


sub PruneThisForum {

&JSPruneMessageTopHTML;

if ($in{'Style'} eq "PruneByDate") {
print<<MoreHTML;
<p><center>
<FORM ACTION="edit.cgi" METHOD="POST" NAME="Edit">
<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="SubmitPrune">
<INPUT TYPE="HIDDEN" NAME="ForumNumber" VALUE="$in{'ForumNumber'}">
<INPUT TYPE="HIDDEN" NAME="Style" VALUE="$in{'Style'}">
<INPUT TYPE="HIDDEN" NAME="DaysPrune" VALUE="$in{'DaysPrune'}">
<B>
<P>
To exclude a thread from being pruned, uncheck the box next to the thread on the left and then click the "Prune Me" button on the bottom.</FONT></B>
<table border=0>
<tr bgcolor="#FFFCEC">
<td width=300 valign=bottom>
<FONT SIZE="1" FACE="Verdana, Arial" color="#808080">Topic</FONT>
</td>
<td valign=bottom>
<FONT SIZE="1" FACE="Verdana, Arial" color="#808080">Originator</FONT>
</td>
<td valign=bottom><FONT SIZE="1" FACE="Verdana, Arial" color="#808080">
Replies
</FONT>
</td>
<td valign=bottom><FONT SIZE="1" FACE="Verdana, Arial" color="#808080">
Last Post
</FONT>
</td>
MoreHTML


@finalarray = &DoPruneGathering("Prune"); 

@sortarray = sort(@finalarray);

foreach $keptthread(@sortarray) {

@threadfacts = split(/\|\|\|/, $keptthread);

$RepliesFormat = $Replies + 0;
chomp($threadfacts[5]);

if ($DateFormat eq "Euro") {
$Month = substr($threadfacts[0], 4, 2);
$Day = substr($threadfacts[0], 6, 2);
$Year = substr($threadfacts[0], 2, 2);
$TheDate = "$Day-$Month-$Year";
}  else {
$TheDate = "$threadfacts[2]";
}

print <<GUTS;
<TR>
<TD width=300>
<INPUT TYPE="CHECKBOX" NAME="PruneThis:::$threadfacts[1]" VALUE="yes" CHECKED>
<IMG SRC="$NonCGIURL/closed.gif" WIDTH=14 HEIGHT=11 BORDER=0>
<FONT SIZE="2" FACE="Verdana, Arial">
$threadfacts[3]
</FONT>
</td>
<td>
<FONT SIZE="2" FACE="Verdana, Arial">$threadfacts[4]</FONT>
</td>
<td align=center>
<FONT SIZE="2" FACE="Verdana, Arial">$threadfacts[5]</FONT>
</td>
<td>
<FONT SIZE="2" FACE="Verdana, Arial">$TheDate</FONT>
</td>
GUTS
}  ## END FOREACH

print<<FORMbottom;
<tr>
<td colspan=4><CENTER>
<FONT Size="2" FACE="Verdana, Arial" COLOR="#800000"><B>For security reasons, re-enter your UserName & Password: <BR>
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT><p>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Prune Me!"></CENTER>
</form>
</td></tr>
FORMbottom
}  else {
#if style = prunebyuser---

if ($in{'ForumNumber'} eq "ALL") {
	$ForumWording = "ALL FORUMS";
} else {
	$ForumWording = $in{'ForumNumber'};
}

if ($in{'RegName'} eq "no") {
$RegWording = "(unregistered name)";
}  else {
$RegWording = "";
}
print<<MoreHTML;
<p><center>
<FORM ACTION="edit.cgi" METHOD="POST" NAME="Edit">
<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="SubmitPrune">
<INPUT TYPE="HIDDEN" NAME="Style" VALUE="$in{'Style'}">
<INPUT TYPE="HIDDEN" NAME="ForumNumber" VALUE="$in{'ForumNumber'}">
<INPUT TYPE="HIDDEN" NAME="MatchUser" VALUE="$in{'MatchUser'}">
<INPUT TYPE="HIDDEN" NAME="RegName" VALUE="$in{'RegName'}">
<P>

<table border=1>
<TR bgcolor="#C6CFA0">
<TD colspan=2 align=center>
<FONT SIZE="2" FACE="Verdana, Arial"><B>To delete all of the posts by $in{'MatchUser'} $RegWording in $ForumWording,<BR> press the SUBMIT button below.</B></FONT>
</TD></tr> 
<tr bgcolor="#8EA3B7">
<td colspan=2 align=center>
<FONT Size="2" FACE="Verdana, Arial"><B>For security reasons, re-enter your UserName & Password:</b></font></td></tr>
<tr bgcolor="#8EA3B7">
<TD width=150><FONT Size="1" FACE="Verdana, Arial">UserName:</FONT></td><td><INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25></td></tr>
<tr bgcolor="#8EA3B7">
<TD width=150><FONT Size="1" FACE="Verdana, Arial">Password</FONT></td><td><INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></td></tr>
<tr bgcolor="#C6CFA0">
<TD align=center colspan=2>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Prune!"></td></tr></form>
MoreHTML
}

&BOTTOMHTML;


}  ## END PruneThisForm sr

sub DoEdit {
## identify user-- moderator/administrator/neither
$NameFound = "no";

$ProfileNumber = &GetUserNumber($UserName);
if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}

if ($NameFound eq "yes") {
@profilestats = &OpenProfile("$ProfileNumber.cgi");
	
	if ($Password eq "$profilestats[1]") {
	$Status = "$profilestats[8]";
	&CheckTheStatus;
	   if ($AdminStatus eq "true") {
	   &EditThis(Admin);
	   } 
	    elsif ($ModStatus eq "true") {
	   &EditThis(Mod);
	   }
	   else  {
	   &StandardHTML("Sorry, but you are not authorized to perform this function.  Use your Back button.");
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
	}
}  else {
&StandardHTML("Sorry, but no one is registered with the User Name you listed.  Please try again.  Use your Back button.");

}  ##END IF/ELSE NAME CHECK BLOCK

}  ## END Do EDIT subroutine

sub EditThis {

$Type = shift;

print<<EditHTML;
<HTML>
<HEAD>
	<TITLE>Ultimate Bulletin Board - $BBName</TITLE>
	<script language="JavaScript"> 
<!-- HIDE
var testUserNameCP = getCookie("UserNameCP");
var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if (testUserNameCP == null) {
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";";
		document.cookie = "PasswordCP=" + CookiePWCP + ";";
	}


function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length;
            return unescape(dc.substring(begin, end));        }
}
return null;
}
//-->
</script>
	
</HEAD>

<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000">
<BR><center>
<FONT SIZE="5" FACE="Courier New"><B>Edit BB Post</B></FONT>
</center>
<FONT SIZE="2" FACE="Verdana, Arial">
<p>
<B>
You may edit posts from any of the forums listed below.  Please select one.
</B>
<P>
<FORM ACTION="edit.cgi" METHOD="POST">
<center>
<table border=0>
<TR>
<TD valign=top><FONT SIZE="2" FACE="Verdana, Arial"><B>
<SELECT NAME="ForumNumber" SIZE=1>
EditHTML


if ($Type eq "Mod") {
#Get List of All Forums
$ForumTotal = &GetTotalForums;
for ($x = 1; $x <= $ForumTotal; $x++) {
@thisforum = &GetForumRecord($x);
$ForumModerator = ("Forum" . "$x" . "Moderator");
$ForumModerator = $$ForumModerator;

	if ($ForumModerator eq "$UserName") {
print<<Forum1HTML;
<OPTION VALUE="Forum$x">$thisforum[1]
Forum1HTML
	}
} #End for $x--

} #end if Mod


if ($Type eq "Admin") {
$ForumTotal = &GetTotalForums;

for ($x = 1; $x <= $ForumTotal; $x++) {
@thisforum = &GetForumRecord($x);

print<<ForumHTML;
<OPTION VALUE="Forum$x">$thisforum[1]
ForumHTML

} #END for $x -------

}


print<<EDITbottomHTML;
</select></FONT></B>
</td>
<tr>
<td><FONT SIZE="2" FACE="Verdana, Arial" color="#800000"><B>Search posts going back <INPUT TYPE="TEXT" NAME="DaysPrune" VALUE="20" SIZE=3 MAXLENGTH=3> days.</B></FONT>
</td>
</table>
<P><BR>
<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="AdminEditThisForum">
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Forum Choice Now">

</FORM>
<BR><BR><BR>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#C0C0C0">&copy; Madrona Park, Inc., 1998-1999.
</FONT>
</CENTER>
</BODY>
</HTML>
EDITbottomHTML
}  ## END EditThis sr

sub PruneThis {
my $Type = shift;
my $Style = shift;

if ($Style eq "PruneByDate") {
$matchfound = "true";
$Criteria = qq(<tr bgcolor="#C6CFA0">
<td><FONT SIZE="2" FACE="Verdana, Arial"><B>Prune threads with last post older than:</B></FONT></td>
<TD><FONT SIZE="2" FACE="Verdana, Arial"><B><INPUT TYPE="TEXT" NAME="DaysPrune" VALUE="60" SIZE=3 MAXLENGTH=3> days.</B></FONT>
</td></tr>);
}  else {
&GetMemberListArray;  #returns members array
$Criteria = qq(<tr bgcolor="#C6CFA0">
<td><FONT SIZE="2" FACE="Verdana, Arial"><B>Prune all threads posted by:</B></FONT></td><td><SELECT NAME="MatchUser">);
$CheckAgainst = &decodeURL($in{'DeleteName'});
$CheckAgainst =~ s/([\^|\.|\$|\*\|\?|\(|\)|\{|\}|\[|\]|\\|\&|\%|\@|\+|\}|\{])/\\$1/isg;

if ($in{'DeleteRegName'} eq "yes") {

foreach $one(@members) {

if ($one =~ /$CheckAgainst/i) {
$matchfound = "true";
$Criteria .= qq(<OPTION value="$one">$one);
}
}

}  else {
$matchfound = "true";
$Criteria .= qq(<OPTION value="$CheckAgainst">$CheckAgainst - unregistered name);
}

$Criteria .= qq(</SELECT></td></tr>);
}

if ($matchfound eq "true") {

print<<PruneHTML;
<HTML>
<HEAD>
	<TITLE>Ultimate Bulletin Board - $BBName</TITLE>
	<SCRIPT LANGUAGE="JavaScript"> 
<!-- HIDE
var testUserNameCP = getCookie("UserNameCP");
var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if (testUserNameCP == null) {
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";";
		document.cookie = "PasswordCP=" + CookiePWCP + ";";
	}


function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length;
            return unescape(dc.substring(begin, end));        }
}
return null;
}
//-->
</script>
	
</HEAD>

<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000">
<br><center>

<FONT SIZE="5" FACE="Courier New"><B>Prune BB Posts</B></FONT>
</center>
<FONT SIZE="2" FACE="Verdana, Arial">

<p><B>
You may prune posts from any of the forums listed below.  Please select one.
</B>
<P>
<FORM ACTION="edit.cgi" METHOD="POST">
<center>
<table border=1 width=95%>
<TR bgcolor="#C6CFA0">
<TD>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Prune From Forums: </B></FONT>
</td>
<TD valign=top><SELECT NAME="ForumNumber" SIZE=1>
PruneHTML


if ($Type eq "Mod") {
#Get List of All Forums
$ForumTotal = &GetTotalForums;
for ($x = 1; $x <= $ForumTotal; $x++) {
@thisforum = &GetForumRecord($x);
$ForumModerator = ("Forum" . "$x" . "Moderator");
$ForumModerator = $$ForumModerator;

	if ($ForumModerator eq "$UserName") {
print<<Forum1HTML;
<OPTION VALUE="Forum$x">$thisforum[1]
Forum1HTML
	}
} #End for $x--

} #end if Mod


if ($Type eq "Admin") {
$ForumTotal = &GetTotalForums;
if ($Style eq "PruneByUser") {
print<<ForumHTML;
<OPTION VALUE="ALL">All Forums
ForumHTML
}
for ($x = 1; $x <= $ForumTotal; $x++) {
@thisforum = &GetForumRecord($x);

print<<ForumHTML;
<OPTION VALUE="Forum$x">$thisforum[1]
ForumHTML

} #END for $x -------

}

print<<EDITbottomHTML;
</select>
</td>
$Criteria
</table>
<P><BR>
<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="PruneThisForum">
<INPUT TYPE="HIDDEN" NAME="RegName" VALUE="$in{'DeleteRegName'}">

<INPUT TYPE="HIDDEN" NAME="Style" VALUE="$Style">
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Forum Choice Now">

</FORM>
<BR><BR><BR>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000000">Ultimate Bulletin Board<BR>&copy; Madrona Park, Inc., 1998-1999.
</FONT>
</CENTER>
</BODY>
</HTML>
EDITbottomHTML
}  else {
&StandardHTML("Sorry, we could not find any users that matched that name.  Please go back and try again.");
}
}  ## END  sr


sub PruneAsAdmin {

print<<PruneHTML;
<HTML>
<HEAD>
	<TITLE>Ultimate Bulletin Board - $BBName</TITLE>
	<script language="JavaScript"> 
<!-- HIDE
var testUserNameCP = getCookie("UserNameCP");
var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if (testUserNameCP == null) {
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";";
		document.cookie = "PasswordCP=" + CookiePWCP + ";";
	}


function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length;
            return unescape(dc.substring(begin, end));        }
}
return null;
}
//-->
</script>
</HEAD>

<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000">
<BR><center>
<FONT SIZE="5" FACE="Courier New"><B>Prune BB Posts</B></FONT>
</center>
<FONT SIZE="2" FACE="Verdana, Arial">
<p><B>
As an administrator, you can prune posts by date in any forum.  Please select a forum below.
</B>
<P>
<FORM ACTION="edit.cgi" METHOD="POST">
<center>
<table border=0>
<TR>
<TD valign=top><FONT SIZE="2" FACE="Verdana, Arial"><B>
PruneHTML

$ForumTotal = &GetTotalForums;
for ($x = 1; $x <= $ForumTotal; $x++) {
@thisforum = &GetForumRecord($x);

if ($thisforum[3] eq "On") {
print<<ForumHTML;
<INPUT TYPE="RADIO" NAME="ForumNumber" VALUE="Forum$x">
$thisforum[1]<br>
ForumHTML
}
} #END for $x -------

print<<EDITbottomHTML;
</FONT></B>
</td>
<tr>
<td><FONT SIZE="2" FACE="Verdana, Arial" color="#800000"><B>Prune threads with last post older than <INPUT TYPE="TEXT" NAME="DaysPrune" VALUE="60" SIZE=3 MAXLENGTH=3> days.</B></FONT>
</td>
</table>
<P><BR>
<INPUT TYPE="HIDDEN" NAME="EditFunction" VALUE="PruneThisForum">
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Forum Choice Now">

</FORM>
<BR><BR><BR>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#C0C0C0">&copy; Madrona Park, Inc., 1998-1999.
</FONT> 
</CENTER>
</BODY>
</HTML>
EDITbottomHTML
}  ## END PruneAsAdmin sr


sub DoDeleteThread {
## confirm UN/password
$UNCheck = $in{'UserNameCheck'};
$ProfileNumber = &GetUserNumber($UNCheck);

@checkprofile = &OpenProfile("$ProfileNumber.cgi");
if ($in{'PasswordCheck'} eq "$checkprofile[1]") {
$Status = "$checkprofile[8]";
	&CheckTheStatus;
		$ModMatch = &CheckModStatus($in{'forum'}, $in{'UserNameCheck'});
	   if (($AdminStatus eq "true") || ($ModMatch eq "yes")) {
			&PerformTheDelete;
		}  else {
			&StandardHTML("Sorry, but you are not authorized to perform this function.  Use your Back button.");
		}

}  else {
&StandardHTML("Sorry, the password you supplied is incorrect.  Please use your back button to try again!");

} # END IF/ELSE
}


sub JSEditMessageTopHTML {
print<<TOP;
<HTML>
<HEAD><TITLE>Ultimate Bulletin Board - $BBName</title>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
function SetCursor() {
var testUserNameCP = getCookie("UserNameCP");

if (testUserNameCP != null) {  
	document.Edit.UserNameCheck.value = getCookie("UserNameCP");
document.Edit.PasswordCheck.value = getCookie("PasswordCP");
	}  else {
	document.Edit.UserNameCheck.focus();
}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}

// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>

</head>
 <BODY BGCOLOR="#FFFFFF" link="#000080" vlink="#808000" topmargin=0 onLoad="SetCursor()">
<b><FONT SIZE="2" FACE="Verdana, Arial">
<BR><center>
<FONT SIZE="5" FACE="Courier New"><B>Edit Message</B>
</FONT>
</center>
TOP
}  ## END JSEditMessageTopHTML


sub EditMessageTopHTML {
print<<TOP;
<HTML>
<HEAD><TITLE>Ultimate Bulletin Board - $BBName</title>
</head>
 <BODY BGCOLOR="#FFFFFF" link="#000080" vlink="#808000" topmargin=0>
<b><FONT SIZE="2" FACE="Verdana, Arial">
<BR><center>
<FONT SIZE="5" FACE="Courier New"><B>Edit Message</B>
</FONT>
</center>
TOP
}  ## END EditMessageTopHTML

sub PruneMessageTopHTML {
print<<TOP;
<HTML>
<HEAD><TITLE>Ultimate Bulletin Board - $BBName</title>
</head>
 <BODY BGCOLOR="#FFFFFF" link="#000080" vlink="#808000" topmargin=0>
<b><FONT SIZE="2" FACE="Verdana, Arial">
<br><center>
<FONT SIZE="5" FACE="Courier New"><B>Prune Messages</B>
</FONT>
</center>
TOP
}  ## END PruneMessageTopHTML


sub JSPruneMessageTopHTML {
print<<TOP;
<HTML>
<HEAD><TITLE>Ultimate Bulletin Board - $BBName</title>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
function SetCursor() {
var testUserNameCP = getCookie("UserNameCP");

if (testUserNameCP != null) {  
	document.Edit.UserNameCheck.value = getCookie("UserNameCP");
document.Edit.PasswordCheck.value = getCookie("PasswordCP");
	}  else {
	document.Edit.UserNameCheck.focus();
}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}

// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</head>
 <BODY BGCOLOR="#FFFFFF" link="#000080" vlink="#808000" topmargin=0 onLoad="SetCursor()">
<b><FONT SIZE="2" FACE="Verdana, Arial">
<center>
<FONT SIZE="5" FACE="Courier New" color="#000080"><B>Prune Messages</B>
</FONT>
</center>
TOP
}  ## END JSPruneMessageTopHTML

sub BOTTOMHTML {
print<<BOTTOM;
</table>
<center><FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000000">Powered by: Ultimate Bulletin Board<br>
&copy; Madrona Park, Inc., 1998-1999.
</FONT>
</center>
</body></html>
BOTTOM
} ## END BottomHTML sr

sub DoPruneGathering {
my $type = shift;

#get Forum Messages
($trash, $number) = split(/orum/, $in{'ForumNumber'});
@thisforum = &GetForumRecord($number);

if ($thisforum[6] eq "private") {
	$ExactPath = "Forum$number/private-$thisforum[7]";
} else {
	$ExactPath = "Forum$number";
}
opendir (FORUMDIR, "$ForumsPath/$ExactPath"); 
    @forummsgs = readdir(FORUMDIR);
closedir (FORUMDIR);

@messages = grep(/\.[ubb|cgi]/, @forummsgs);

## do date pruning 

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime (time);

$mon++;

$year = $year + 1900;

#convert Closing and Current Dates to Julian Dates
$CurrentJulian = &jday($mon, $mday, $year);
$CloseJulian = $CurrentJulian - $in{'DaysPrune'};

@finalarray = @blank;

#configure memo date to Julian
		
foreach $item(@messages) {
	
open(THREAD, "$ForumsPath/$ExactPath/$item");
my @thethreadguts = <THREAD>;
close(THREAD);
@threadguts = sort(@thethreadguts);

my @reverseit = reverse(@threadguts);
my @lastpost = split(/\|\|/, $reverseit[0]);
my @stats = split(/\|\|/, $threadguts[0]);
my $recentdate = $lastpost[3];

($Mo, $Day, $Yr) = split(/-/, $recentdate);

if ($Yr < 96) {
	$Yr = ("20" . "$Yr");
}  else {
	$Yr = ("19" . "$Yr");
}
my $dateline = "$Yr$Mo$Day";
$CheckJulian = &jday($Mo, $Day, $Yr);
	if ($type eq "Prune") {
	if ($CheckJulian <= $CloseJulian) {
		my $Author = $stats[3];
		my $Subject = $stats[4];
		chomp($Subject);
		my $Replies = $stats[2];
		
		# $dateline used for sorting only
		$EditLine = "$dateline|||$item|||$recentdate|||$Subject|||$Author|||$Replies";
		push (@finalarray, $EditLine);
	}  	
	}  else {
			if ($CheckJulian >= $CloseJulian) {
		my $Author = $stats[3];
		my $Subject = $stats[4];
		chomp($Subject);
		my $Replies = $stats[2];
		
		# $dateline used for sorting only
		$EditLine = "$dateline|||$item|||$recentdate|||$Subject|||$Author|||$Replies";
		push (@finalarray, $EditLine);
			}  	
	
	}
} #end FOREACH $item
return(@finalarray);
}  ## End DoPruneGathering


sub DoSubjectEdit {
## confirm UN/password
$UNCheck = $in{'UserNameCheck'};
$ProfileNumber = &GetUserNumber($UNCheck);

@checkprofile = &OpenProfile("$ProfileNumber.cgi");
if ($in{'PasswordCheck'} eq "$checkprofile[1]") {
$Status = "$checkprofile[8]";
	&CheckTheStatus;
	$ModMatch = &CheckModStatus($in{'forum'}, $in{'UserNameCheck'});
	   if (($AdminStatus eq "true") || ($ModMatch eq "yes")) {
			&UpdateTheSubject;
		}  else {
			&StandardHTML("Sorry, but you are not authorized to perform this function.  Use your Back button.");
		}

}  else {
&StandardHTML("Sorry, the password you supplied is incorrect.  Please use your back button to try again!");

} # END IF/ELSE
}  ## End DoSubjectEdit sr

sub PerformTheEdit {
($trash, $number) = split(/Forum/, $in{'forum'});
@thisforum = &GetForumRecord($number);

($ThreadNumber, $junk) = split(/\./, $in{'topic'});

@oldmessage = &OpenThread($in{'topic'});
@stats = split(/\|\|/, $oldmessage[0]);
$TopicSubject = $stats[4];
chomp($TopicSubject);
$TotReplies = $stats[2];

$Forum = $thisforum[1];
$ForumCoded = &HTMLIFY($Forum);
$ForumCoded =~ tr/ /+/;
$Status = $thisforum[3];
$LWA = $thisforum[6];
$PrivateMax = $thisforum[13];
chomp($PrivateMax);
$UBBCodeAllow = $thisforum[5];
$HTMLAllow = $thisforum[4];
$UBBImages = $thisforum[10];
if ($LWA eq "private") {
	$ExactPath = "Forum$number/private-$thisforum[7]";
}  else {
	$ExactPath = "Forum$number";
}

if ($in{'DeleteMessage'} eq "yes") {
&EditMessageTopHTML;

if ($in{'MessageNumber'} ne "000000") {
#subtract one from reply total
$ReplyTotal = $stats[2];
$ReplyTotal--;

#create revised stat line for thread
$newstatline = "A||$stats[1]||$ReplyTotal||$stats[3]||$TopicSubject";
chomp($newstatline);

@newthread = @blank;
#loop thru thread, remove deleted post
foreach $uno(@oldmessage) {
	chomp($uno);
	if ($uno =~ m/^A/) {
		push(@newthread, $newstatline);
	} 
	elsif ($uno !~ m/^Z\|\|$in{'MessageNumber'}/) {
		push(@newthread, $uno);
	}
}

#write new thread to file
&Lock("lock.file");
open (NEWBIE, ">$ForumsPath/$ExactPath/$in{'topic'}");
for $theline(@newthread) {
chomp($theline);
print NEWBIE "$theline\n";
}
close(NEWBIE);
&Unlock("lock.file");

##CREATE HTML FILE FOR Revised THREAD
&CreateThreadHTML("$in{'forum'}", "$in{'topic'}");

#update forum summary file and threads file
&UpdateForumDetails($number);

#update total post total on lastnumber.file
&UpdateForumTotals("$number", 0, 1, "no");

#update Index----
&UpdateTheIndex($number, 0);

print<<otherHTML;
<p><center>
<B><FONT SIZE="2" FACE="Verdana, Arial">The message has been successfully deleted!</FONT></B><BR><p>
<table border=0 cellpadding=20>
<tr>
<td><FONT SIZE="2" FACE="Verdana, Arial"><A HREF="$NonCGIURL/controlpanel.html">Control Panel</A></FONT></td>
<td><FONT SIZE="2" FACE="Verdana, Arial"><A HREF="$CGIURL/Ultimate.cgi?action=intro">Bulletin Board</A></FONT></td>
otherHTML

} else {

# DELETE ENTIRE THREAD, SINCE IT IS THE TOPIC POST BEING REMOVED

#delete UBB & HTML FILES
unlink "$ForumsPath/$ExactPath/$in{'topic'}";
unlink "$ForumsPath/$ExactPath/HTML/$ThreadNumber.html";
unlink "$ForumsPath/$ExactPath/HTML/$ThreadNumber.cgi";

#Remove Deleted Thread Messages From Index - RETURN HERE
&RemoveThreadFromIndex($number, $ThreadNumber);

#update forum summary file and lasttime file
&UpdateForumDetails($number);

#update lastnumber.file
$TotReplies = $TotReplies + 0;
$TotThreadPosts = $TotReplies + 1;
&UpdateForumTotals("$number", 1, $TotThreadPosts, "yes");


print<<otherHTML;
<p><center>
<B><FONT SIZE="2" FACE="Verdana, Arial">The topic and all of its replies have been successfully deleted!</FONT></B><BR><p>
<table border=0 cellpadding=20>
<tr>
<td><FONT SIZE="2" FACE="Verdana, Arial"><A HREF="$NonCGIURL/controlpanel.html">Control Panel</A></FONT></td>
<td><FONT SIZE="2" FACE="Verdana, Arial"><A HREF="$CGIURL/Ultimate.cgi?action=intro">Bulletin Board</A></FONT></td>
otherHTML
}
&BOTTOMHTML;

}  else  {

#  ELSE EDIT MESSAGE -------------

# @oldmessage contains thread array
# @stats contains stats array for thread
@updated = @blank;
foreach $row(@oldmessage) {
chomp($row);
@rowinfo = split(/\|\|/, $row);
	if (($rowinfo[0] ne "A") && ($rowinfo[1] eq "$in{'MessageNumber'}")) {
$oldmessage = $rowinfo[6];
chomp($oldmessage);

$MessageText = $in{'MessageText'};
$MessageText = &ConvertReturns($MessageText);
$MessageText = &Smilies($MessageText);
$UBBImages = "ON";
$OverrideImages = "no";
$MessageText = &UBBCode($MessageText);

$MessageText .= ("<p>[Note: This message has been edited by $in{'UserNameCheck'}]");
$postUserName = $rowinfo[2];
$postdate = $rowinfo[3];

$newrow = "Z||$rowinfo[1]||$postUserName||$postdate||$rowinfo[4]||$rowinfo[5]||$MessageText";
push(@updated, $newrow);
} else {
push(@updated, $row);
}
}  #end foreach $row

&Lock("lock.file");
open (FORUM, ">$ForumsPath/$ExactPath/$in{'topic'}"); 
foreach $printit(@updated) {
chomp($printit);
print FORUM ("$printit\n");
}
close (FORUM);
&Unlock("lock.file");
chmod(0666, "$ForumsPath/$ExactPath/$in{'topic'}");

#update the associated HTML FILE
&CreateThreadHTML("$in{'forum'}", "$in{'topic'}");

## Update the INDEX
&UpdateIndex("$number", "$in{'topic'}", "$oldmessage", "$MessageText");

#Update forum summary file
&CurrentDate;
&ForumSummary($number);

&StandardHTML("Edit successfully completed!");
}
} #End PerformTheEdit sr

sub DoThePrune {

if ($in{'Style'} ne "PruneByUser") {

($trash, $number) = split(/orum/, $in{'ForumNumber'});
@thisforum = &GetForumRecord($number);
$LWA = $thisforum[6];
$PrivateMax = $thisforum[13];
chomp($PrivateMax);

if ($LWA eq "private") {
	$ExactPath = "Forum$number/private-$thisforum[7]";
}  else {
	$ExactPath = "Forum$number";
}

@DeleteList = @blank;
foreach $row(@in) {
		($Name2, $Value2) = split ("=", $row);
			$Name2 = &decodeURL($Name2);
			$Value2 = &decodeURL($Value2);
			
			$_ = "$Name2";
			if (/PruneThis/) {
				($Trash, $DeleteThread) = split(/:::/, $Name2);
 				push(@DeleteList, $DeleteThread);
			}
}
		
foreach $tobepruned(@DeleteList) {
	#delete ubb file
	unlink "$ForumsPath/$ExactPath/$tobepruned";
	
	($ThreadNum, $junk) = split(/\./, $tobepruned);
	unlink "$ForumsPath/$ExactPath/HTML/$ThreadNum.html";
	unlink "$ForumsPath/$ExactPath/HTML/$ThreadNum.cgi";
}


#update forum summary file and threads file
&UpdateForumDetails($number);

#update forumnumber.file
&SetForumNumbers($number);

#update the index

$Status = $thisforum[3];
&UpdateTheIndex($number, 0);
}  else {

#prune by user!!

#open index file to search for entries by user
if ($in{'ForumNumber'} eq "ALL") {
open (INDEX, "$NonCGIPath/forumindex.file");
	@index1 = <INDEX>;
close (INDEX);

open (INDEX2, "$MembersPath/pindex/privateforumindex.cgi");
	@index2 = <INDEX2>;
close (INDEX2);

@index = (@index1, @index2);

}  else {
($trash, $number) = split(/orum/, $in{'ForumNumber'});
@thisforum = &GetForumRecord($number);

if ($thisforum[6] eq "private") {
$IndexPath = "$MembersPath/pindex/privateforumindex.cgi";
}  else {
$IndexPath = "$NonCGIPath/forumindex.file";
}

@good = @blank;
open (INDEX, "$IndexPath");
	@index = <INDEX>;
close (INDEX);

}
#now we have the complete index... just need to search in it

SEARCHMATCHES: foreach $line(@index) {
	$Bad = "no";
	@indie = split(/\|/, $line);

# Username Search Routine---
$MatchUser = &decodeURL($in{'MatchUser'});

	unless ($indie[2] eq "$MatchUser") {
			$Bad = "yes";
		}
# Forum Search Routine---
if (($in{'ForumNumber'} ne "ALL") && ($Bad ne "yes")) {
	unless ($indie[0] eq "$number") {
		$Bad = "yes";
	}
}

if ($Bad ne "yes") {
(@testit) = split(/\|/, $line);
$testit = ("$testit[0]" . "$testit[1]");
$Duplicate = "";

if (@good) {
	for $dupcheck(@good) {
(@testit2) = split(/\|/, $dupcheck);
$testit2 = ("$testit2[0]" . "$testit2[1]");
		if ($testit eq "$testit2") {
			$Duplicate = "true";
		}
	}
}

if ($Duplicate ne "true") {
push(@good, $line);
}
} #end if $Bad
} #end foreach $line

# now we have array or threads containing posts by user

$TotalPostsFound = @good;
if ($TotalPostsFound > 0) {

foreach $one(@good) {
@threadmatch = split(/\|/, $one);

#put forum numbers into array- for use later
$Dupe = "";

foreach $fnum(@cf) {
chomp($fnum);
if ($threadmatch[0] eq "$fnum"){
	$Dupe = "true";
}
}

if ($Dupe ne "true") {
push(@cf, $threadmatch[0]);
}

@forumfacts = &GetForumRecord($threadmatch[0]);
if ($forumfacts[6] eq "private") {
	$ExactPath = "Forum$forumfacts[8]/private-$forumfacts[7]";
}  else {
	$ExactPath = "Forum$forumfacts[8]";
}

#delete from thread, recreate HTML page
open (THISONE, "$ForumsPath/$ExactPath/$threadmatch[1].cgi");
@threadinfo = <THISONE>;
close (THISONE);

@tinfo = sort(@threadinfo);
@rinfo = reverse(@tinfo);

@revised = @blank;
$DeleteThread = "";
$Count = -1;
CHECKTHREAD: foreach $row(@rinfo) {

	@rowinfo = split(/\|\|/, $row);
if ($row =~ /^Z/) {
	if ($rowinfo[2] eq "$MatchUser") {
		if ($rowinfo[1] eq "000000") {
				$DeleteThread = "true";
			last CHECKTHREAD;
		}
	}  else {
			$Count++;
		push(@revised, $row);
		
	}
}  else {
	chomp($rowinfo[4]);
	$newline = "A||$rowinfo[1]||$Count||$rowinfo[3]||$rowinfo[4]";
	push(@revised, $newline);
}

} #end for each row of thread

	if ($DeleteThread eq "true") {
		unlink("$ForumsPath/$ExactPath/$threadmatch[1].cgi");
		unlink("$ForumsPath/$ExactPath/HTML/$threadmatch[1].html");
unlink("$ForumsPath/$ExactPath/HTML/$threadmatch[1].cgi");
	}  else {
	#revise ubb & HTML files
		@sortrevised = sort(@revised);
		&Lock("lock.file");
		open(NEWUBB, ">$ForumsPath/$ExactPath/$threadmatch[1].cgi");
		foreach $uno(@sortrevised) {
			chomp($uno);
			print NEWUBB "$uno\n";
		}
	close(NEWUBB);
	&Unlock("lock.file");
chmod(0666, "$ForumsPath/$ExactPath/$threadmatch[1].cgi");

	##CREATE HTML FILE FOR REVISED THREAD
	$Forum = $forumfacts[1];
	$ForumCoded = &HTMLIFY($Forum);
	$ForumCoded =~ tr/ /+/;

$number = $threadmatch[0];
my $ThisForum = ("Forum" . "$threadmatch[0]");
my $ThisThread = ("$threadmatch[1]" . ".cgi");
&CreateThreadHTML($ThisForum, $ThisThread);

	}
	
}  # end foreach good array item

#reset threads, index, lasttimes, numbers, etc.

foreach $fno(@cf) {
#update forum summary file and threads file
@theforum = &GetForumRecord($fno);
if ($theforum[6] eq "private") {
	$ExactPath = "Forum$fno/private-$theforum[7]";
}  else {
	$ExactPath = "Forum$fno";
}
&UpdateForumDetails($fno);

#update forumnumber.file
&SetForumNumbers($fno);

#update the index
@thisforum = &GetForumRecord($fno);
$Status = $thisforum[3];
&UpdateTheIndex($fno, 0);
}  #end foreach forum changed

} else {
&StandardHTML("Sorry, we could not find any posts by that user.");
exit;
} # end if totalposts to be pruned > 0
} #end prune by user section
} #end DoThePrune sr

sub UpdateTheSubject {

($trash, $number) = split(/orum/, $in{'forum'});

@thisforum = &GetForumRecord($number);
$ForumStatus = $thisforum[3];
$LWA = $thisforum[6];
$PrivateMax = $thisforum[6];
chomp($PrivateMax);

$Status = $ForumStatus;
$Forum = "$thisforum[1]";
$ForumCoded = &HTMLIFY($Forum);
$ForumCoded =~ tr/ /+/;

	$in{'NewSubject'} =~ s/<.+?>//g;
	$in{'NewSubject'} =~ s/"/&quot;/g;
	$in{'NewSubject'} =~ s/\|/+/g;

$ThreadHead = $in{'TopicNumber'};

@subj = &OpenThread("$ThreadHead.cgi");
@newsubj = @blank;

foreach $row(@subj) {
	chomp($row);
	if ($row =~ m/^A/) {
	@rowstats = split(/\|\|/, $row);
	$newline = "A||$rowstats[1]||$rowstats[2]||$rowstats[3]||$in{'NewSubject'}";
	chomp($newline);
	push(@newsubj, $newline);
	}  else {
		push(@newsubj, $row);
	}
}

&Lock("lock.file");
open(THREAD, ">$ForumsPath/$ExactPath/$ThreadHead.cgi");
foreach $one(@newsubj) {
chomp($one);
print THREAD ("$one\n");
}
close(THREAD);
&Unlock("lock.file");

## Update the HTML file for the thread now
&CreateThreadHTML("$in{'forum'}", "$ThreadHead.cgi");

#update Index
&UpdateTheIndex($number, 0);

#update forum summary file
&CurrentDate;
&ForumSummary($number);

} #end UpdateTheSubject sr


sub PerformTheDelete {
$TopicNumber = $in{'TopicNumber'};

### get $number and $Status variables for updating the index!
	($trash, $number) = split(/orum/, $in{'forum'});
	@thisforum = &GetForumRecord($number);
	$Status = $thisforum[3];
	$LWA = $thisforum[6];
	
### get current stats on thread
@oldmessage = &OpenThread("$TopicNumber.cgi");
@stats = split(/\|\|/, $oldmessage[0]);
$TotReplies = $stats[2];

#delete ubb and html files
unlink "$ForumsPath/$ExactPath/$TopicNumber.cgi"; 
unlink "$ForumsPath/$ExactPath/HTML/$TopicNumber.html";
unlink "$ForumsPath/$ExactPath/HTML/$TopicNumber.cgi";
## Remove Thread From Index
&RemoveThreadFromIndex($number, $TopicNumber);

&EditMessageTopHTML;

print<<otherHTML;
<p><center>
<B><FONT SIZE="2" FACE="Verdana, Arial">The topic and all of its replies have been successfully deleted!</FONT></B><BR><p>
<table border=0 cellpadding=20>
<tr>
<td><FONT SIZE="2" FACE="Verdana, Arial"><A HREF="$NonCGIURL/controlpanel.html">Control Panel</A></FONT></td>
<td><FONT SIZE="2" FACE="Verdana, Arial"><A HREF="$CGIURL/Ultimate.cgi?action=intro">Bulletin Board</A></FONT></td>
otherHTML

&BOTTOMHTML;

#update forum summary file and threads file
&UpdateForumDetails($number);

#update total post total on lastnumber.file
$TotThreadPosts = $TotReplies + 1;
&UpdateForumTotals("$number", 1, $TotThreadPosts, "yes");

} #end perform the delete sr


sub SetForumNumbers {
my $ForumNumber = shift;

opendir (FORUMDIR, "$ForumsPath/$ExactPath"); 
    my @theubbfiles = grep(/\.[cgi|ubb]/, readdir(FORUMDIR));
closedir (FORUMDIR);

my $topiccount = @theubbfiles;
#sort the ubb files
@theseubbfiles = sort(@theubbfiles);
#reverse array so that largest number is first
@ubbfiles = reverse(@theseubbfiles);
my $lastnumber = $ubbfiles[0];
($lastnumber, $junk) = split(/\./, $lastnumber);

##

$ThreadTotal = 0;
#determine number of total posts
foreach $threadfile(@ubbfiles) {
	open(THREAD, "$ForumsPath/$ExactPath/$threadfile");
	@countit = <THREAD>;
close(THREAD);

@countit = grep(/^Z/, @countit);
$ThisTotal = @countit;
$ThreadTotal = $ThreadTotal + $ThisTotal;
}


#print number to lastnumber.file
open (UBB, ">$ForumsPath/$ExactPath/lastnumber.file");
print UBB ("$lastnumber\n");
print UBB ("$topiccount\n");
print UBB ("$ThreadTotal\n");
close (UBB);

chmod (0666, "$ForumsPath/$ExactPath/lastnumber.file");

} #end SetLastThreadNums sr (new in 5.10)


sub UpdateForumDetails {
#updates the threads file for the forum & the lasttime.file
my $ForumNumber = shift;

&CurrentDate;
&ForumSummary($ForumNumber);

# @finalarray = threads file

$numberthreads = @finalarray;
if ($numberthreads > 0) {

@currthreads1 = sort(@finalarray);
@currthreads = reverse(@currthreads1);
$latest = $currthreads[0];
@latest = split(/\|\^\|/, $latest);
$lastdatetime = $latest[5];

$LastYear = substr($lastdatetime, 2, 2);
$LastMon = substr($lastdatetime, 4, 2);
$LastDay = substr($lastdatetime, 6, 2);
$hour = substr($lastdatetime, 8, 2);
$min = substr($lastdatetime, 10, 2);
&NormalTime;
$LatestTime = ("$hour" . ":" . "$min" . " $AMPM");
$HyphenDate = "$LastMon-$LastDay-$LastYear";

#update last time file
&Lock("lock.file");
open (LASTTIME, ">$ForumsPath/$ExactPath/lasttime.file") or die("Unable to open LastTime.file");
print LASTTIME ("$HyphenDate\n");
print LASTTIME ("$LatestTime\n");
close (LASTTIME);
&Unlock("lock.file");

chmod (0666, "$ForumsPath/$ExactPath/lasttime.file");
}   else {
&Lock("lock.file");
open (LASTTIME, ">$ForumsPath/$ExactPath/lasttime.file") or die("Unable to open LastTime.file");
print LASTTIME ("\n");
close (LASTTIME);
&Unlock("lock.file");

chmod (0666, "$ForumsPath/$ExactPath/lasttime.file");

}#end if > 0

} #end setlasttimes

sub UpdateForumTotals {
## Used to subtract from thread and/or posts totals in lastnumber.file

my $number = shift;
my $SubtractThreads = shift;
my $SubtractPosts = shift;
my $UpdateRow1 = shift;

###

open(FORUM, "$ForumsPath/$ExactPath/lastnumber.file");
	@currnumber = <FORUM>;
close(FORUM);

my $threadfilenum = $currnumber[0];
chomp($threadfilenum);
my $totalthreads = $currnumber[1];
chomp($totalthreads);
my $totalposts = $currnumber[2];
chomp($totalposts);

$totalthreads = $totalthreads - $SubtractThreads;
$totalposts = $totalposts - $SubtractPosts;

if ($UpdateRow1 eq "yes") {

opendir (FORUMDIR, "$ForumsPath/$ExactPath"); 
    my @theubbfiles = grep(/\.[cgi|ubb]/, readdir(FORUMDIR));
closedir (FORUMDIR);

#sort the ubb files
@ubbfiles = sort(@theubbfiles);
#reverse array so that largest number is first
@ubbfiles = reverse(@ubbfiles);
my $lastnumber = $ubbfiles[0];
($lastnumber, $junk) = split(/\./, $lastnumber);
$threadfilenum = $lastnumber;
}

&Lock("lock.file");
open(FORUM, ">$ForumsPath/$ExactPath/lastnumber.file");
print FORUM ("$threadfilenum\n");
print FORUM ("$totalthreads\n");
print FORUM ("$totalposts\n");
close(FORUM);
&Unlock("lock.file");

chmod(0666, "$ForumsPath/$ExactPath/lastnumber.file");
}