#!/usr/bin/perl

#
### CONTROL PANEL SCRIPT FOR ULTIMATE BULLETIN BOARD ##
#
# Ultimate Bulletin Board is copyright Madrona Park, Inc., 1997, 1998.
#
#       ------------ cpanel2.cgi -------------
#
#  This file contains some of the control panel functionality for
#  the UBB.  It is called from the controlpanel pages (cp.html).
#
#  NOTE: you MAY NOT distribute this script under any
#  circumstance.  This means that you may not sell, trade, or in
#  any other way give this script to another user who is not
#  licensed to use it.  Madrona Park, Inc. offers no
#  warranties on this script.  The owner/licensee of the script is
#  solely responsible for any problems caused by installation of
#  the script or use of the script, including messages that may be
#  posted on the BB.
#
#  All copyright notices regarding the Ultimate Bulletin Board
#  must remain intact on the scripts and in the HTML
#  for the scripts.
#
# For more info on the Ultimate BB, 
# see http://www.UltimateBB.com
#
###############################################################
#If you are running UBB on IIS,
#you may need to add the following line
#if so, just remove the "#" sign before the print line below
#print "HTTP/1.0 200 OK\n";

print ("Content-type: text/html\n\n");
eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file

require "mods.file";
require "Date.pl";
require "UltBB.setup";
require "Styles.file";
require "ubb_library.pl";
require "ubb_library2.pl";
};


if ($@) {
    print "Error including required files: $@\n";
    print "Make sure these files exist, permissions are set properly, and paths are set correctly.";
 exit;
}

&ReadParse;

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	if ($Name eq "ViewEntire") {
			$ViewEntire = $Value;
		}
	if ($Name eq "NN") {
			$SearchName = $Value;
			$SearchName =~tr/A-Z/a-z/; 
			$SearchNameCoded = $SearchName;
			$SearchNameCoded =~ tr/ /+/;
			}
	if ($Name eq "BBEmail") {
			$BBEmail = $Value;
			$BBEmail =~ s/@/\\@/;
			}
			
	if ($Name eq "Forum1") {
			$Forum1 = $Value;
			$Forum1 =~ s/"/&quot;/g;
		}
	
	if ($Name eq "BBRules") {
			$BBRules = $Value;
			$BBRules =~ s/"/&quot;/g;
			$BBRules =~ s/\@/\\@/g;
			$BBRules = &ConvertReturns($BBRules);
			}
		if ($Name eq "censorwords") {
			$censorwords = $Value;
			$censorwords = &EliminateReturns($censorwords);
			$censorwords =~ s/<BR>//ig;
			$censorwords =~ s/<P>//ig;
			$censorwords =~ s/"/&quot;/g;
			$censorwords =~ s/\@/\\@/g;
			}
			if ($Name eq "EmailBan") {
			$EmailBan = $Value;
			$EmailBan = &EliminateReturns($EmailBan);
			$EmailBan =~ s/<BR>//ig;
			$EmailBan =~ s/<P>//ig;
			$EmailBan =~ s/"/&quot;/g;
			$EmailBan =~ s/\@/\\@/g;
			}
		if ($Name eq "YourCopyrightNotice") {
			$YourCopyrightNotice = $Value;
			$YourCopyrightNotice = &EliminateReturns($YourCopyrightNotice);
			$YourCopyrightNotice =~ s/"/&quot;/g;
			$YourCopyrightNotice =~ s/<BR>//ig;
			$YourCopyrightNotice =~ s/<P>//ig;
			$YourCopyrightNotice =~ s/\@/\\@/g;
			}
		if ($Name eq "Header") {
			$Header = $Value;
			$Header =~ s/"/\\"/g;
			$Header =~ s/\@/\\@/g;
			}
		if ($Name eq "Footer") {
			$Footer = $Value;
			$Footer =~ s/"/\\"/g;
			$Footer =~ s/\@/\\@/g;
			}
	if ($Name eq "ForumStatus1") {
			$ForumStatus1 = $Value;
			}
	if ($Name eq "MyHomePage") {
			$MyHomePage = $Value;
			}
	if ($Name eq "HomePageURL") {
			$HomePageURL = $Value;
			}
	
	if ($Name eq "number") {
			$number = $Value;
			}

	if ($Name eq "UpdateType") {
			$UpdateType = $Value;
			}		
	if ($Name eq "TotalForums") {
			$TotalForums = $Value;
			}
	if ($Name eq "BBName") {
			$BBName = $Value;
			}
	if ($Name eq "ForumsPath") {
			$ForumsPath = $Value;
			}
			if ($Name eq "MembersPath") {
			$MembersPath = $Value;
			}
			if ($Name eq "CGIPath") {
			$CGIPath = $Value;
			}
				if ($Name eq "VariablesPath") {
			$VariablesPath = $Value;
			}
	if ($Name eq "MembersCGIPath") {
			$MembersCGIPath = $Value;
			}
			if ($Name eq "NonCGIPath") {
			$NonCGIPath = $Value;
			}
			if ($Name eq "CGIURL") {
			$CGIURL = $Value;
			}
			if ($Name eq "NonCGIURL") {
			$NonCGIURL = $Value;
			}
		
		if ($Name eq "UserNameCheck") {
			$UserNameCheck = $Value;
			$UserNameCheckFile = $UserNameCheck;
			$UserNameCheckFile =~ s/ /_/g; #remove spaces
			}

		if ($Name eq "UserName") {
			$UserName = $Value;
			$UserName = &UNHTMLIFY($UserName);
			$UserNameFile = $UserName;
			$UserNameFile =~ s/ /_/g; #remove spaces
			$UserNameCoded = $UserName;
			$UserNameCoded = &HTMLIFY($UserNameCoded);
			$UserNameCoded =~ tr/ /+/;
		}
			if ($Name eq "Password") {
			$Password = $Value;
			$PasswordCoded = $Password;
			$PasswordCoded =~ tr/ /+/;
			}
			if ($Name eq "PasswordCheck") {
			$PasswordCheck = $Value;
			$PasswordCheckCoded = $PasswordCheck;
			$PasswordCheckCoded =~ tr/ /+/;
			
			}
				if ($Name eq "action") {
			$action = $Value;
			}
			
} #end foreach loop

if ($VariablesPath eq "") {
	$VariablesPath = "$CGIPath";
}


#adjust bgcolor variables
if ($BGColor ne ""){
$BGColor = qq(bgcolor="$BGColor");
}
if ($AltColumnColor1 ne ""){
$AltColumnColor1 = qq(bgcolor="$AltColumnColor1");
}
if ($AltColumnColor2 ne ""){
$AltColumnColor2 = qq(bgcolor="$AltColumnColor2");
}
if ($CategoryStripColor ne ""){
$CategoryStripColor = qq(bgcolor="$CategoryStripColor");
}
if ($TableColorStrip ne ""){
$TableColorStrip = qq(bgcolor="$TableColorStrip");
}
if ($PageBackground ne ""){
$PageBackground = qq(background="$NonCGIURL/$PageBackground");
}

if ($TableBorderColor ne ""){
$TableWidth2 = "100%";
$BorderTop = qq(<table border=0 cellpadding=0 cellspacing=0 width="$TableWidth"><TR><td bgcolor="$TableBorderColor">);
$BorderBottom = qq(</td></tr></table> );
}  else {
$TableWidth2 = $TableWidth;
$BorderTop = "";
$BorderBottom = "";
}
if ($action eq "mods") {
&Mods;
}

if ($action eq "doupdate") {
##verify that this user is an administrator
$NameFound = "no";

$ProfileNumber = &GetUserNumber($in{'UserName'});
if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}

if ($NameFound eq "yes") {
	@profilestats = &OpenProfile("$ProfileNumber.cgi");
		
	if ($Password eq "$profilestats[1]") {
	$Permission = "$profilestats[4]";
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
#determine number of total forums
@theforums = &OpenForumsFile;
$TotalForums = @theforums;

&ConvertForums2HTML("1", "$TotalForums", "0");
   
	   }  else {
	   &StandardHTML("Sorry, but you are not an administrator.");
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
	}
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
}  ##END IF/ELSE NAME CHECK BLOCK
} #end do update (threads) sr

if ($action eq "setgenvars") {
&SetGenVars;
exit;
}
if ($action eq "doindex") {
   &DoIndex;
   exit;
}

if ($action eq "ContinueUpdate") {
&ConvertForums2HTML("$number", "$TotalForums", "$in{'StartWith'}");
exit;
}

if ($action eq "sendstyle") {
&SendStyle;
exit;
}
if ($action eq "getmatches") {
&GetMatches;
}
if ($action eq "updatepermiss") {
&UpdatePermiss;
exit;
}
if ($action eq "sendvarID") {
&SendVarID;
exit;
}
if ($action eq "continueMC") {
$OldFormat = $in{'OldFormat'};
if (-e "$MembersPath/holdmems.cgi") {
&ContinueMC($in{'startwith'}, $OldFormat);
}  else {
&StandardHTML("We cannot convert any members- nothing to convert.");
}
}

if ($action eq "DoGenVars") {
&DoGenVars;
exit;
}


if ($action eq "ContinueIndexing") {
&ReIndex("$in{'start'}", "$in{'threadpoint'}");
exit;
}


sub SendVarID {
### CHECK USERNAME - must be an admin
##verify that this user is an administrator
#check to see which Member Format is in place, process accordingly
if (-e "$MembersPath/memberslist.cgi") {

$ProfileNumber = &GetUserNumber($in{'UserName'});
if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}

}  else {

$ProfileNumber = $UserNameFile;


$NameFound = "no";
  if (-e "$MembersPath/$ProfileNumber.cgi") {
      $NameFound = "yes";
    } 
}

if ($NameFound eq "yes") {
	@theprofile = &OpenProfile("$ProfileNumber.cgi");
	chomp($theprofile[1]);
	if ($Password eq "$theprofile[1]") {
	$Permission = "$theprofile[4]";
		chomp($Permission);
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   &DoGenVars;
	   }  else {
	    &StandardHTML("Sorry, but you are not an administrator.");
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
	}
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
}  ##END IF/ELSE NAME CHECK BLOCK

} # end SendVarsID sr

sub DoGenVars {

if ((-e "$CGIPath/edit.cgi") && (-e "$MembersPath/memberslist.cgi")  && ($in{'UserName'} eq "")) {
	&StandardHTML("You must identify yourself.  Your bulletin board has already been configured.  Go back and enter your username and password.");
}  else {

			$BBRules =~ s/&quot;/"/ig;
			$BBRules =~ s/<BR>/\n/ig;
			$BBRules =~ s/<p>/\n\n/ig;


if ($ForumDisplayMax eq "") {
	$FDM40 = "SELECTED";
}
elsif ($ForumDisplayMax == 25) {
	$FDM25 = "SELECTED";
}
elsif ($ForumDisplayMax == 35) {
	$FDM35 = "SELECTED";
}
elsif ($ForumDisplayMax == 40) {
	$FDM40 = "SELECTED";
}
elsif ($ForumDisplayMax == 50) {
	$FDM50 = "SELECTED";
}
elsif ($ForumDisplayMax == 75) {
	$FDM75 = "SELECTED";
}  else {
	$FDMNONE = "SELECTED";
}

if ($DaysPruneDefault eq "") {
	$Days20 = "SELECTED";
}
elsif ($DaysPruneDefault == 1) {
	$Days1 = "SELECTED";
}
elsif ($DaysPruneDefault == 2) {
	$Days2 = "SELECTED";
}
elsif ($DaysPruneDefault == 5) {
	$Days5 = "SELECTED";
}
elsif ($DaysPruneDefault == 10) {
	$Days10 = "SELECTED";
}
elsif ($DaysPruneDefault == 20) {
	$Days20 = "SELECTED";
}
elsif ($DaysPruneDefault == 30) {
	$Days30 = "SELECTED";
}
elsif ($DaysPruneDefault == 45) {
	$Days45 = "SELECTED";
}
elsif ($DaysPruneDefault == 60) {
	$Days60 = "SELECTED";
}
elsif ($DaysPruneDefault == 75) {
	$Days75 = "SELECTED";
}
elsif ($DaysPruneDefault == 100) {
	$Days100 = "SELECTED";
}  else {
	$Days365 = "SELECTED";
}
		
if ($CategoryView eq "yes") {
	$CategoryViewOn = "CHECKED";
}  else {
	$CategoryViewOff = "CHECKED";
}

if ($CategoriesOnly eq "true") {
	$CategoriesOnlyOn = "CHECKED";
}  else {
	$CategoriesOnlyOff = "CHECKED";
}		
if ($SMTPEmail eq "Off") {
	$SMTPOff = "CHECKED";
}  else {
	$SMTPOn = "CHECKED";
}
if ($EmailVerify eq "ON") {
	$EmailVerifyOn = "CHECKED";
}  else {
	$EmailVerifyOff = "CHECKED";
}

if ($EditOption eq "ON") {
	$EditOptionOn = "CHECKED";
}  else {
	$EditOptionOff = "CHECKED";
}						
if ($ForumDescriptions eq "yes") {
	$ForumDescriptionsOn = "CHECKED";
}  else {
	$ForumDescriptionsOff = "CHECKED";
}
		
if ($IP eq "ON") {
	$IPOn = "CHECKED";
}
elsif ($IP eq "LOGONLY") {
	$IPLO = "CHECKED";
}  else {
	$IPOff = "CHECKED";
}
		
if ($Censor eq "ON") {
	$CensorOn = "CHECKED";
}  else {
	$CensorOff = "CHECKED";
}
		
if ($AdminTitle eq "") {
	$AdminTitle = "Administrator";
}
if ($ModeratorTitle eq "") {
	$ModeratorTitle = "Moderator";
}		
if ($MemberTitle eq "") {
	$MemberTitle = "Member";
}
if ($JrMemberTitle eq "") {
	$JrMemberTitle = "Junior Member";
}

if ($DisplayMemberTotal eq "true") {
	$MemberTotalOn = "CHECKED";
}  else {
	$MemberTotalOff = "CHECKED";
}		
if ($BBStatus eq "OFF") {
	$BBStatusOff = "CHECKED";
}  else {
	$BBStatusOn = "CHECKED";
}
if ($ForumTotalOption eq "Both") {
	$FTOBoth = "CHECKED";
}
elsif  ($ForumTotalOption eq "Topics"){
	$FTOTopics = "CHECKED";
}	else {
$FTOPosts = "CHECKED";
}



if ($AllowSignature eq "YES") {
	$AllowSigYes = "CHECKED";
}  else {
	$AllowSigNo = "CHECKED";
}	
if ($UseEmail eq "ON") {
	$EmailOn = "CHECKED";
}  else {
	$EmailOff = "CHECKED";
}		
		
if ($EmailBlock eq "ON") {
	$EmailBlockOn = "CHECKED";
}  else {
	$EmailBlockOff = "CHECKED";
}		
		
		
if ($ReverseThreads eq "ON") {
	$ReverseThreadOn = "CHECKED";
}  else {
	$ReverseThreadOff = "CHECKED";
}		
if ($TimeFormat eq "24HR") {
	$Time24HR = "CHECKED";
}  else {
	$TimeAMPM = "CHECKED";
}		
if ($DateFormat eq "Euro") {
	$DateEuro = "CHECKED";
}
elsif ($DateFormat eq "EuroX") {
	$DateEuroX = "CHECKED";
}
elsif ($DateFormat eq "USX") {
	$DateUSX = "CHECKED";
}  else {
	$DateUS = "CHECKED";
}

if ($EmailCheck eq "true") {
	$EmailTrue = "CHECKED";
}  else {
	$EmailFalse = "CHECKED";
}
if ($CGIPath eq "") {
	@cgipath = split(/\//, $ENV{'SCRIPT_FILENAME'});
	pop(@cgipath);
	$CGIPath = join("\/", @cgipath);
	$VariablesPath = $CGIPath;
	$MembersPath = ("$CGIPath" . "/Members");
}
if ($NonCGIPath eq "") {
	$NonCGIPath = "$ENV{'DOCUMENT_ROOT'}/ubb";
	$ForumsPath = "$ENV{'DOCUMENT_ROOT'}/ubb";
}

if ($NonCGIURL eq "") {
	$NonCGIURL = "http://$ENV{'HTTP_HOST'}/ubb";
	$CGIURL = "http://$ENV{'HTTP_HOST'}";
	$HomePageURL = "http://$ENV{'HTTP_HOST'}";
	$BBEmail = "$ENV{'SERVER_ADMIN'}";
}

if ($MemberMinimum eq "") {
	$MemberMinimum = "31";
}

if ($TimeZoneOffset eq "") {
	$TimeZoneOffset = "0";
}


#check sendmail address--
if ($SendMailLocation eq "") {
if (-e "/usr/bin/sendmail") {
$SendMailLocation = "/usr/bin/sendmail";
}
elsif (-e "/usr/sbin/sendmail") {
$SendMailLocation = "/usr/sbin/sendmail";
}
elsif (-e "/usr/lib/sendmail") {
$SendMailLocation = "/usr/lib/sendmail";
}  else {
$SendMailLocation = "";
}
}

if (-e "$MembersPath/emailfile.cgi") {
$DiagnosticWording = qq[<INPUT TYPE="CHECKBOX" NAME="Diagnostic" VALUE="yes" CHECKED> <B>Check here to reset thread counts & last post time counters (not necessary unless you think your post counts or last post times are not correct on your forum summary page)];
$EmailFile = "";
}  else {
$EmailFile = qq(<INPUT TYPE="HIDDEN" NAME="EmailFile" VALUE="add">);
$DiagnosticWording = "";
}

$PageTitle = "Set Variables";
&HEADERHTML;

print<<THIS;
To check your environmental variables, <A HREF="cpanel.cgi?action=env">click here</A>.
<P>
Socket Test: To check to see if the Socket module is included on the Perl installation on your web server, <A HREF="ubbmisc.cgi?action=sockettest">click here</A>. If you receive an error or a blank page, then Socket may not be installed (<A HREF="http://www.ultimatebb.com/home/faq.html#socket" target="_blank">Read This</A>, if Socket is not installed.).
<P>
<b>Note: if you are configuring your system for the first time, you MUST start with General Variables below!</B>

<P><HR>
<B>Variables: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <A HREF="#GENVAR">General Variables</A> | <A HREF="cpanel.cgi?action=style">Styles</a> | <A HREF="cpanel.cgi?action=logintoforums">Forums</a></B>
<HR>

<BR>
<BR>
<U><B><FONT SIZE="4" FACE="Courier New" COLOR="#800000"><A NAME="GENVAR">General Variables</A></FONT></B></U>
<P>
<FORM ACTION="cpanel2.cgi" NAME="THEFORM" METHOD="POST">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="setgenvars">
$EmailFile
<table border=0 cellpadding=0 cellspacing=0   width=100%><TR><td bgcolor="#000000">

<table border=0 width=100%>
<TR bgcolor="#000000"><TD COLSPAN=2 align=center><B><FONT SIZE="2" FACE="Verdana, Arial" color="#FFFF00">absolute paths</FONT></B>
</TD></TR>
<TR bgcolor="#FCF0C0">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<B>Absolute paths reflect the physical locations of directories on a server.  They are the complete locations, not the locations from the web root, but from the server root.  Absolute paths on Win32/NT servers are displayed differently than on UNIX systems.  For instance, note the following samples for UNIX and NT:
<p>
For UNIX servers:  &nbsp;&nbsp;&nbsp;&nbsp;<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#FF0000">/usr/home/yourdomain/www/cgi-bin</font>
<BR>
For Win32/NT servers:&nbsp;&nbsp;&nbsp;&nbsp; <FONT SIZE="1" FACE="Verdana, Arial" COLOR="#FF0000">C:/home/yourdomain/cgi-bin</FONT>
<P>
Note: the paths listed above are examples, not your actual paths.
<P>
If you are installing on Win32/NT, be sure to use the format above for your absolute paths (note the forward slashes, rather than backward slashes).
<BR>
If you are installing for the first time, the UBB will attempt to provide complete or partial absolute paths for you.  These paths may not be accurate or complete, but they will give you a headstart.  All absolute path fields MUST be provided for your UBB to run.</B></FONT>
</td></tr>
<tr bgcolor="#dedfdf">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Absolute Path for your UBB CGI DIRECTORY</B><br></FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="CGIPath" VALUE="$CGIPath" SIZE=40 MAXLENGTH=250>
</td></tr>

<tr bgcolor="#f7f7f7">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Absolute Path of your UBB NON CGI Directory</B><br></FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="NonCGIPath" VALUE="$NonCGIPath" SIZE=40 MAXLENGTH=250>
</td></tr>

<tr bgcolor="#dedfdf">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Absolute Path to Members Directory</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor">This path should end in /Members (as in "/usr/home/yourdomain/www/cgi-bin/Members")</FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="MembersPath" VALUE="$MembersPath" SIZE=40 MAXLENGTH=250>
</td></tr>
<tr bgcolor="#f7f7f7">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Absolute Path to Directory Where Your Custom Variable Files  Reside</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080"><B>You should use the same absolute path that you used for your CGI directory above</B>.  If for some reason you cannot write to files in your CGI directory, however, you should place these files (UltBB.setup, forums.cgi, mods.file, Styles.file) in a directory below the web root so that they cannot be accessed by anyone from the browser. </FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="VariablesPath" VALUE="$VariablesPath" SIZE=40 MAXLENGTH=250>
</td></tr>
</table>
<P>
<table border=0 width=100%>
<TR bgcolor="#000000"><TD COLSPAN=2 align=center><B><FONT SIZE="2" FACE="Verdana, Arial" color="#FFFF00">URLs</FONT></B>
</TD></TR>

<TR bgcolor="#FCF0C0">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<B>Please provide the following complete hyperlinks.  Use complete hyperlinks, such as http://www.yourdomain.com/cgi-bin, rather than relative links such as "/cgi-bin"</B></FONT>
</td></tr>

<tr bgcolor="#dedfdf">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>URL for your UBB CGI Directory</B><br></FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="CGIURL" VALUE="$CGIURL" SIZE=40 MAXLENGTH=250>
</td></tr>

<tr bgcolor="#f7f7f7">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>URL for your UBB Non-CGI Directory</B><br></FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="NonCGIURL" VALUE="$NonCGIURL" SIZE=40 MAXLENGTH=250>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your Home Page URL</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">The complete URL for your home page (not the bulletin board).  This will be used for links back to your homepage.</FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="HomePageURL" VALUE="$HomePageURL" SIZE=40 MAXLENGTH=250>
</td></tr>
</table>
<P>

<table border=0 width=100%>
<TR bgcolor="#000000"><TD COLSPAN=2 align=center><B><FONT SIZE="2" FACE="Verdana, Arial" color="#FFFF00">Display Options</FONT></B>
</TD></TR>

<TR bgcolor="#FCF0C0">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<B>Please complete the following fields, which provide information such as your BB Name, the name of your home page, the email address to be displayed, headers and footers to use on each page, etc.</B></FONT>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your Email Address</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">This is email address that will be shown so that users can contact you</FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="BBEmail" VALUE="$BBEmail" SIZE=30 MAXLENGTH=250>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Name of Your Bulletin Board</B><br></FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="BBName" VALUE="$BBName" SIZE=30 MAXLENGTH=250>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Name of Your Home Page</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">The name of your homepage, which will listed for links back to your homepage.</FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="MyHomePage" VALUE="$MyHomePage" SIZE=30 MAXLENGTH=250>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Default Topic View (Days)</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">The default number of days for the "Show Topics Going Back X Days" option.  Users are able to customize this through preferences, but this is the default that will be given, otherwise.  Recommended: 20.</FONT>
</td>
<td width=50% valign=top>
<SELECT NAME="DaysPruneDefault">
	<OPTION value="1" $Days1>Show topics from last day
	<OPTION value="2" $Days2>Show topics from last 2 days
	<OPTION value="5" $Days5>Show topics from last 5 days
	<OPTION value="10" $Days10>Show topics from last 10 days
	<OPTION value="20" $Days20>Show topics from last 20 days
	<OPTION value="30" $Days30>Show topics from last 30 days
	<OPTION value="45" $Days45>Show topics from last 45 days
	<OPTION value="60" $Days60>Show topics from last 60 days
	<OPTION value="75" $Days75>Show topics from last 75 days
	<OPTION value="100" $Days100>Show topics from last 100 days
	<OPTION value="365" $Days365>Show topics from the last year
</SELECT>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Header</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">You can add your own customized header graphic, ad banner, text, etc.  This header will appear at the top of each primary UBB page.  This is completely optional.  Leave this field blank if you don't need to use it.</FONT>
</td>
<td width=50% valign=top>
<TEXTAREA NAME="Header" COLS="30" ROWS="5" WRAP="VIRTUAL">$Header</TEXTAREA>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Footer</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">You can add your own customized footer graphic, ad banner, text, etc.  This header will appear near the bottom of each primary UBB page.  This is completely optional.  Leave this field blank if you don't need to use it.</FONT>
</td>
<td width=50% valign=top>
<TEXTAREA NAME="Footer" COLS="30" ROWS="5" WRAP="VIRTUAL">$Footer</TEXTAREA>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Category Display Option</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">If you are using categories, you can have your forums displayed under each category when users first enter your UBB.  To elect to display categories on your introductory page, select "yes".  If you are not using categories for your forums, you should not select this option.</FONT></td>
<td width=50% valign=top>
<CENTER><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080">
<INPUT TYPE="RADIO" NAME="CategoryView" VALUE="yes" $CategoryViewOn> yes 
<INPUT TYPE="RADIO" NAME="CategoryView" VALUE="no" $CategoryViewOff> no
</FONT></CENTER>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Display Categories Only on First Page?</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">If you have numerous forums and/or categories, you may want to have a list of CATEGORIES ONLY when users first enter your UBB. <B>The individuals forums, which normally appear first, would thus be suppressed.</B>  Users would click on the category of choice to be taken to the list of forums within that forum.   In order to start with the category list only, click "yes" to the right.</FONT></td>
<td width=50% valign=top>
<CENTER><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080">
<INPUT TYPE="RADIO" NAME="CategoriesOnly" VALUE="true" $CategoriesOnlyOn> yes 
<INPUT TYPE="RADIO" NAME="CategoriesOnly" VALUE="false" $CategoriesOnlyOff> no
</FONT></CENTER>
</td></tr>


<TR bgcolor="#dedfdf">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Display Forum Descriptions?</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">If you have many forums, you may not want to display your forum descriptions.  If not, check no.</FONT></td>
<td width=50% valign=top>
<CENTER><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><INPUT TYPE="RADIO" NAME="ForumDescriptions" VALUE="yes" $ForumDescriptionsOn> yes
<INPUT TYPE="RADIO" NAME="ForumDescriptions" VALUE="no" $ForumDescriptionsOff> no
</FONT></CENTER>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Bulletin Board Rules</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">You can customize the exact wording for your bulletin board's rules.  Just edit the wording in the box to the right.</FONT>
</td>
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>$BBName Rule Wording:</B><br></FONT>
<TEXTAREA NAME="BBRules" ROWS=8 COLS=35 wrap="virtual">$BBRules
</TEXTAREA>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your Copyright Wording</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">This wording will appear in smaller print directly above the copyright wording concerning the UBB program itself. You can leave this blank or provide any wording you like.</FONT>
</td>
<td width=50% valign=top>
<TEXTAREA NAME="YourCopyrightNotice" ROWS=3 COLS=30 WRAP="VIRTUAL">$YourCopyrightNotice
</TEXTAREA>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Block Public Display of User Email Addresses?</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">The default option is to have registered user's email addresses viewable on the pages for which the user has posted a note.  You may prevent all user email addresses from being displayed by selecting "Block Email Address Display" in the field to the right.  These addresses will still be available to you if you check the user's info in the "User Info/Permissions" area of the Control Panel.</FONT>
</td><td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><INPUT TYPE="RADIO" NAME="EmailBlock" VALUE="ON" $EmailBlockOn> Block Public Display of User Email Addresses<BR>
<INPUT TYPE="RADIO" NAME="EmailBlock" VALUE="OFF" $EmailBlockOff> Show User Email Addresses</FONT>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Allow Signatures?</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">You may allow your users to use their own unique signatures when they post messages.  Note: your users will be permitted to use UBB Code (but not HTML) in their signature files.  The UBB Code Image tag will not be permitted, however.</FONT>
</td><td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><INPUT TYPE="RADIO" NAME="AllowSignature" VALUE="YES" $AllowSigYes> Allow Signatures<BR>
<INPUT TYPE="RADIO" NAME="AllowSignature" VALUE="NO" $AllowSigNo> Don't Allow Signatures</FONT>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Show Total Topics/Posts/Both?</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">On the first UBB display page that lists all of your forums, you may display either the total topics within each forum, the total posts within each forum, or both the total topics and total posts.</FONT>
</td><td width=50% valign=top>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080"><INPUT TYPE="RADIO" NAME="ForumTotalOption" VALUE="Topics" $FTOTopics> Show Total Topics Only<BR>
<INPUT TYPE="RADIO" NAME="ForumTotalOption" VALUE="Posts" $FTOPosts> Show Total Posts Only<BR>
<INPUT TYPE="RADIO" NAME="ForumTotalOption" VALUE="Both" $FTOBoth> Show Both Total Topics and Total Posts
</FONT>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Reverse Thread Order?</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">The standard (recommended) way to display threads is chronologically from original topic to the latest reply.  You can reverse this, if you prefer, to have threads displayed in reverse, from latest post to oldest post.  This is for the HTML thread pages only.</FONT>
</td><td width=50% valign=top>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080"><INPUT TYPE="RADIO" NAME="ReverseThreads" VALUE="FALSE" $ReverseThreadOff> Keep Preferred Order<BR>
<INPUT TYPE="RADIO" NAME="ReverseThreads" VALUE="TRUE" $ReverseThreadOn> Reverse Thread Order
</FONT>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Display Member Total?</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">You may add a counter to your UBB intro page (the first page visitors see when the enter your UBB) that displays the total number of registered users on your UBB.</FONT>
</td><td width=50% valign=top>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080"><INPUT TYPE="RADIO" NAME="DisplayMemberTotal" VALUE="true" $MemberTotalOn> Display Member Total<BR>
<INPUT TYPE="RADIO" NAME="DisplayMemberTotal" VALUE="false" $MemberTotalOff> Do Not Display Member Total
</FONT>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Maximum Topics Displayed Per Page</B><BR></FONT>
</td><td width=50% valign=top>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">Select one of the options below.<BR><SELECT NAME="ForumDisplayMax">
	<OPTION value="25" $FDM25>25 Topics Maximum Per Page
	<OPTION value="35" $FDM35>35 Topics Maximum Per Page
	<OPTION value="40" $FDM40>40 Topics Maximum Per Page
	<OPTION value="50" $FDM50>50 Topics Maximum Per Page
	<OPTION value="75" $FDM75>75 Topics Maximum Per Page
	<OPTION value="NONE" $FDMNONE>No Maximum Per Page

</SELECT>
</FONT>
</td></tr>
</table>
<P>
<table border=0 width=100%>
<TR bgcolor="#000000"><TD COLSPAN=2 align=center><B><FONT SIZE="2" FACE="Verdana, Arial" color="#FFFF00">Email Options</FONT></B>
</TD></TR>

<TR bgcolor="#FCF0C0">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<B>The UBB provides two methods for handling all functions that involve email.  The preferred method is to use your SMTP email server via the Perl Sockets module.  This is the most efficient means of delivering email.  To use this, you must have an email account on the server that you are using (or have access to an SMTP email server that will allow you to relay to it).  You must also have the Perl Socket module installed (that is a standard module in Perl 5, but some web hosts do not include it).  An alternative means of delivering email is with UNIX sendmail. You must be using a UNIX web server in oder to use Sendmail.</B></FONT>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Email On/Off</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">To enable all functions that send email to users, set this field to on.  If for some reason email features don't seem to be working for your system, you may simply turn them off.</FONT>
<CENTER><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><INPUT TYPE="RADIO" NAME="UseEmail" VALUE="ON" $EmailOn> on
<INPUT TYPE="RADIO" NAME="UseEmail" VALUE="OFF" $EmailOff> off</FONT></CENTER>
</td>
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Email Server Name</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">This is the SMTP email server that will be used to send email from the UBB.  Use whatever you use for your email account (check your email settings under "SMTP server").  This is used for the Sockets option.  If you are using Sendmail to perform your Email functions (see next row for Email Process options), you may leave this field blank.
</FONT><BR>
<INPUT TYPE="TEXT" NAME="EmailServer" VALUE="$EmailServer" SIZE=25 MAXLENGTH=50>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Email Process To Use</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">Select the Email Method (described above) you wish to use.  Note that the sendmail option will not work with Win32/NT web servers.  You also must know the location of your web server's sendmail program in order to use the sendmail option.  If you select Sendmail, be sure to complete the field to the right.</FONT>
<CENTER><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080">
<INPUT TYPE="RADIO" NAME="SMTPEmail" VALUE="On" $SMTPOn> SMTP Email/Sockets<BR>
<INPUT TYPE="RADIO" NAME="SMTPEmail" VALUE="Off" $SMTPOff> SendMail</FONT></CENTER>
</td>
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>SendMail Location</B></font><P><FONT SIZE="1" FACE="Verdana, Arial">If you are using the Sendmail Email option, you must designate the location of the UNIX sendmail program on your web server below.  You must list the absolute path to the sendmail program.  For example, your sendmail location may be: /usr/bin/sendmail<BR></FONT>
<BR>
<INPUT TYPE="TEXT" NAME="SendMailLocation" VALUE="$SendMailLocation" SIZE=25 MAXLENGTH=50>
</td></tr>

</table>
<P>

<table border=0 width=100%>
<TR bgcolor="#000000"><TD COLSPAN=2 align=center><B><FONT SIZE="2" FACE="Verdana, Arial" color="#FFFF00">Date/Time Display Options</FONT></B>
</TD></TR>

<TR bgcolor="#FCF0C0">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<B>The UBB can display dates and times in a number of different formats.  Remember that the times listed are based on the location of your web server, which may be different than the time zone where you reside/work.  You can change the time zone displayed by using the Time Zone Offset field.  For instance, if you are on the East Coast of the US, but your server is on the West Coast of the US, you could use EST as your Time Zone to display, but you would have to offset the server time to reflect that (by typing a 3 in the Time Zone Offset field, reflecting the 3 hours difference).  If the Time Zone difference is negative, use a negative number (as in -2).</B></FONT>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Time Zone</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">The time of each posting is based on the time zone where your server is located.  If you want your users to know the time zone, provide it here (e.g., ET, CT, PT, etc.).  You may also leave this blank if you would prefer not to show a time zone.  You may type a different time zone than your server uses, but if you do so be sure to provide a time zone offset in the next field.</FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="TimeZone" VALUE="$TimeZone" SIZE=20 MAXLENGTH=35>
</td></tr>


<TR bgcolor="#dedfdf">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Server Time Zone Offset</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">You can offset the time drawn from your web server.  For instance, if your server time is EST (US), but you want all time to reflect Pacific Time (US), you would have to offset your server time by placing the time zone difference in this field (for this example, that would be -3.  You would place -3 in this field).  The default is for there to be no server time zone offset (0).</FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="TimeZoneOffset" VALUE="$TimeZoneOffset" SIZE=3 MAXLENGTH=4>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Date Format</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">European Format is DD-MM-YR, while US format is MM-DD-YR.  Expanded formats include full month name.</FONT>
</td>
<td width=50%>
<FONT SIZE="1" FACE="Verdana, Arial">
<INPUT TYPE="RADIO" NAME="DateFormat" VALUE="US" $DateUS> US Format (e.g., 04-25-98)<BR>
<INPUT TYPE="RADIO" NAME="DateFormat" VALUE="USX" $DateUSX> Expanded US Format (e.g., April 25, 1998)<BR>
<INPUT TYPE="RADIO" NAME="DateFormat" VALUE="Euro" $DateEuro> European Format (e.g., 25-04-98)<BR>
<INPUT TYPE="RADIO" NAME="DateFormat" VALUE="EuroX" $DateEuroX> Expanded European Format (e.g., 25 April 1998)
</font>
</td></tr>
<TR bgcolor="#dedfdf">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Time Format</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">You can have time displayed in AM/PM format, or in 24-hour format.</FONT>
</td>
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial">
<INPUT TYPE="RADIO" NAME="TimeFormat" VALUE="AMPM" $TimeAMPM> Use AM/PM Time Format<BR>
<INPUT TYPE="RADIO" NAME="TimeFormat" VALUE="24HR" $Time24HR> User 24-Hour Format Time (eg, 23:15)
</font>
</td></tr>
</table>
<P>

<table border=0 width=100%>
<TR bgcolor="#000000"><TD COLSPAN=2 align=center><B><FONT SIZE="2" FACE="Verdana, Arial" color="#FFFF00">Registration Options</FONT></B>
</TD></TR>

<TR bgcolor="#FCF0C0">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<B>Below are registration options for your UBB.</B></FONT>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Verify User Email Address During Registration?</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">For tighter security, you may want to require that your registered users have valid email addresses.  This is accomplished by mailing their password to them at the email address they register.  To enable email verification during registration, click yes in the field to the right.</FONT>
</td><td valign=top width=50%>
<CENTER><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><INPUT TYPE="RADIO" NAME="EmailVerify" VALUE="ON" $EmailVerifyOn> yes
<INPUT TYPE="RADIO" NAME="EmailVerify" VALUE="OFF" $EmailVerifyOff> no</FONT></CENTER>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Email Duplicate Check</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">The default option is to require unique email addresses for each registered user.  This means that no two users can have the same email address. You can disable this requirement by checking the "Unique Email Not Required" box.</FONT>
</td>
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><INPUT TYPE="RADIO" NAME="EmailCheck" VALUE="true" $EmailTrue> Unique Email Required<br>
<INPUT TYPE="RADIO" NAME="EmailCheck" VALUE="false" $EmailFalse> Unique Email Not Required
</FONT>
</td></tr>


<TR bgcolor="#f7f7f7">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Email Ban List</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">You may ban certain email addresses from registrering on your bulletin board.  To ban a specific email, type the full email address (as in, waldo\@whereiswaldo.com).  To ban all email addresses from certain domains, such as hotmail, simply type the domain name (as in hotmail.com)- that will prevent anyone using a hotmail address from registering.  Separate each banned email with a space (not commas) (as in, waldo\@whereiswaldo.com  hotmail.com jack\@whoami.net freemail.com).</FONT>
</td>
<td width=50% valign=top>
<TEXTAREA NAME="EmailBan" ROWS=4 COLS=30 WRAP="VIRTUAL">$EmailBan
</TEXTAREA>
</td></tr>

</table>
<P>
<table border=0 width=100%>
<TR bgcolor="#000000"><TD COLSPAN=2 align=center><B><FONT SIZE="2" FACE="Verdana, Arial" color="#FFFF00">Miscellaneous Options</FONT></B>
</TD></TR>

<TR bgcolor="#FCF0C0">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<B>Below are numerous configuration options for your UBB.</B></FONT>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Turn Your UBB Off?</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">From time to time, you may want to turn your bulletin board off to the public while you perform maintenance, update versions, etc.  When you turn your BB off, visitors will receive a message that states that the bulletin board is temporarily unavailable.</FONT>
</td>
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><INPUT TYPE="RADIO" NAME="BBStatus" VALUE="ON" $BBStatusOn> Bulletin Board Open
<BR>
<INPUT TYPE="RADIO" NAME="BBStatus" VALUE="OFF" $BBStatusOff> Bulletin Board Closed
</FONT>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Minimum Number of Messages For Full Member Status</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">Registered users are initially called Junior Members.  After a certain number of postings, the member will be automatically upgraded to full Member.  The default is 31 messages, but you can reset this value here.</FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="MemberMinimum" VALUE="$MemberMinimum" SIZE=5 MAXLENGTH=5>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Use Alternate User Titles?</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">There are four status options for users: administrators, moderators, members, and junior members.  You can have these four user classes appear as alternate titles, if you like.  For instance, if you have a Star Wars site, you may want your administrators to be called "Star Fleet Captain", your moderators to be called "First Mate", your Members to be called "Lieutenant" and your Junior Members to be called "Ensign".</FONT>
</td>
<td width=50% valign=top>
<FONT SIZE="1" FACE="Verdana, Arial">
Administrator:<BR>
<INPUT TYPE="TEXT" NAME="AdminTitle" VALUE="$AdminTitle" SIZE=20 MAXLENGTH=60>
<P>
Moderator:<BR>
<INPUT TYPE="TEXT" NAME="ModeratorTitle" VALUE="$ModeratorTitle" SIZE=20 MAXLENGTH=60>
<P>
Member:<BR>
<INPUT TYPE="TEXT" NAME="MemberTitle" VALUE="$MemberTitle" SIZE=20 MAXLENGTH=60>
<P>
Junior Member:</font>
<BR><INPUT TYPE="TEXT" NAME="JrMemberTitle" VALUE="$JrMemberTitle" SIZE=20 MAXLENGTH=60>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Censor Option</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">You may have certain words censored on your BB.  Words you choose to censor will be replaced by asterisks.  All subjects and messages will be affected. To activate the censor function, check the "yes" button below.  To deactivate, press the "no" button.  List all censored words in the field to the right.</FONT>
<CENTER><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><INPUT TYPE="RADIO" NAME="Censor" VALUE="ON" $CensorOn> yes
<INPUT TYPE="RADIO" NAME="Censor" VALUE="OFF" $CensorOff> no
</FONT></CENTER>
</td>
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Censor Words</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">Type all words you want censored in the field below.  Do not use commas to separate words, just use spaces.  For example, type "dog cat boy", rather than "dog, cat, boy."  If you type "dog", all words containing the string "dog" would be censored (dogma, for instance, would appear as "***ma").  To censor more accurately, you can require that censors occur only for exact words.  You can do this by placing a censor word in curly braces, as in {dog}.  Signifying "dog" in the curly braces would mean that dogma would appear as dogma, but dog would appear as "***".  Thus your censor list may appear as: cat {dog} {barn} barn<BR>Do not use quotation marks and make sure you use curly braces, not parentheses, when specifying exact words.
</FONT><BR>
<TEXTAREA NAME="censorwords" ROWS=3 COLS=30 WRAP="VIRTUAL">$censorwords
</TEXTAREA>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Allow User Editing of Messages?</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">Administrators and moderators can always edit and delete messages.  You may want to allow your users to edit their own messages.  They will not be able to edit other users' messages.  To do so, select "yes" to the right.</FONT>
</td><td width=50%>
<CENTER><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><INPUT TYPE="RADIO" NAME="EditOption" VALUE="ON" $EditOptionOn> yes
<INPUT TYPE="RADIO" NAME="EditOption" VALUE="OFF" $EditOptionOff> no</FONT></CENTER>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Log/Display IP Numbers For Posts?</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">For security reasons, you may wish to display the IP number of the person posting a message. The default is OFF.  You may log the IP to file only- in wish case the IP number is not viewable on the bulletin board, but is logged to your .ubb files, or you may have the IP numbers logged and displayed publicly on the bulletin board.</FONT>
</td><td width=50%>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080"><INPUT TYPE="RADIO" NAME="IP" VALUE="ON" $IPOn> IP Logged & Displayed on BB <BR>
<INPUT TYPE="RADIO" NAME="IP" VALUE="LOGONLY" $IPLO> IP Logged But Not Displayed On BB<BR>
<INPUT TYPE="RADIO" NAME="IP" VALUE="OFF" $IPOff> IP Log/Display Off</FONT>
</td></tr>

</table>

</td></tr></table>
<P>
<FONT SIZE="1" FACE="Verdana, Arial">
$DiagnosticWording</FONT></B>
<P>
<br>
<CENTER><FONT Size="2" FACE="Verdana, Arial" COLOR="#000080"><B>Enter your UserName & Password:</font>
<P>
<FONT Size="1" FACE="Verdana, Arial" COLOR="#808000">(NOTE: if you are configuring your BB for the first time, type your default UserName and Password here)</font>
<p>
<FONT Size="2" FACE="Verdana, Arial" COLOR="#000080">
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT></B></CENTER>
<p><center>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit General Variables"></center>
</form>
</BODY></HTML>
THIS
}
} #end do genvars


sub SendStyle {
### CHECK USERNAME - must be an admin
##verify that this user is an administrator
$NameFound = "no";
$ProfileNumber = &GetUserNumber($in{'UserName'});
if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}

if ($NameFound eq "yes") {

	@theprofile = &OpenProfile("$ProfileNumber.cgi");
	
	if ($Password eq "$theprofile[1]") {
	$Permission = "$theprofile[4]";
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   &DoProcessStyle;
	   }  else {
	    &StandardHTML("Sorry, but you are not an administrator.");
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
	}
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
}  ##END IF/ELSE NAME CHECK BLOCK



################
sub DoProcessStyle {
open (FILE, ">$VariablesPath/Styles.file") or die("Unable to open setup file for writing.");

foreach $one(@in) {
	($Name, $Value) = split ("=", $one);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	$Value =~ s/\@/\\@/g;
	$Value =~ s/"/\\"/g;
		if (($Name ne "UserName") && ($Name ne "Password")) {
	print FILE ("\$$Name = \"$Value\";\n");
	}
}

	print FILE ("1;\n");
close (FILE);
chmod (0777, "$VariablesPath/Styles.file");

$ConfirmLine = "The Ultimate Bulletin Board Style variables have been updated.<P>Note that in order to have these changes reflected in old threads, you need to update those threads.  You can do this using the \"Update Threads\" control panel option.  Depending on the number of threads you have stored on your system, the updating process can be time-consuming.  It is thus recommended that you do not update your threads until after you have made all control panel setting changes.<br>";
&ConfirmHTML2;
} ## END DO PROCESS VARS


}  ## END SendStyle subroutine

sub UpdatePermiss {

$ProfileNumber = &GetUserNumber($in{'UserNameCheck'});

@theprofile = &OpenProfile("$ProfileNumber.cgi");

if ($in{'PasswordCheck'} eq "$theprofile[1]") {
	$Status = "$theprofile[8]";
	&CheckStatus;
	   if ($AdminStatus eq "true") {
			&UpdateThePermissions;
		}  else {
			&StandardHTML("Sorry, but you are not authorized to perform this function.  Use your Back button.");
		} #end if adminstatus is true 
}  else {
&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
}
}  ## END UPdatePermiss SR ###


sub GetMatches {

##verify that this user is an administrator
$NameFound = "no";
$ProfileNumber = &GetUserNumber($in{'UserName'});
if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}

if ($NameFound eq "yes") {
	@theprofile = &OpenProfile("$ProfileNumber.cgi");
			
	if ($Password eq "$theprofile[1]") {
	$Permission = "$theprofile[4]";
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   	   
if ($ViewEntire eq "Yes") {
	&GetAll;
	} else {
	&DoSearch;
	}
	   }  else {
	    &StandardHTML("Sorry, but you are not an administrator.");
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
	}
		
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
}  ##END IF/ELSE NAME CHECK BLOCK

}  #end GetMatches SR ###


sub GetAll {
&GetMemberListArray; #returns @members array

@themembers = sort(@members);
$TotalProfiles = @themembers;
	
my $MaxDisplay = 50;  
if ($in{'StartPoint'} eq "") {
	$StartPoint = 1;
	if ($TotalProfiles <= $MaxDisplay) {
		$EndPoint = $TotalProfiles;
		$Done = "true";
	} else {
	$Done = "";
	$EndPoint = $MaxDisplay;
	}
	$EP = $EndPoint - 1;

} else {

$StartPoint = $in{'StartPoint'};
$EndPoint = $StartPoint + $MaxDisplay;
$EndPoint = $EndPoint - 1;
	if ($TotalProfiles <= $EndPoint) {
		$EndPoint = $TotalProfiles;
		$Done = "true";
	}  else {
		$Done = "";
	}

}

$SP = $StartPoint - 1;
$EP = $EndPoint - 1;
@themembers = @themembers[$SP..$EP];

if ($Done ne "true") {
$NextStart = $EndPoint + 1;
$NextWording = qq(<A HREF="cpanel2.cgi?action=getmatches&StartPoint=$NextStart&UserName=$UserNameCoded&Password=$PasswordCoded&NN=$SearchNameCoded&Email=$in{'Email'}&Math=$in{'Math'}&Posts=$in{'Posts'}&ViewEntire=$in{'ViewEntire'}">[Next Matches]</A>);
} else {
$NextWording = "";
}
if ($TotalProfiles == 0) {
$StartPoint = 0;
}
	
if ($TotalProfiles > 0) {	

&PermissionsTopHTML;

print<<PermGuts;
<p>
There are currently $TotalProfiles registered bulletin board members.
Make any changes necessary and then click on "Submit" to modify any/all user records.  Check the delete box on the left for all registrations you want deleted.<br><br>

<FORM ACTION="cpanel2.cgi" METHOD="POST" NAME="PERMISS" onSubmit="return Check(this)">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="updatepermiss">

<center>
Click on name for profile details and advanced permission settings.
<BR>
<table width=95%>
<TR>
<TD colspan=6><FONT FACE="Verdana, Arial" SIZE="1">Displaying Matches $StartPoint - $EndPoint ($TotalProfiles total) &nbsp;&nbsp;&nbsp;&nbsp; $NextWording</FONT>
</td>
</tr>
<tr bgcolor="#cccc99">
<td valign=bottom>
<FONT SIZE="1" FACE="Verdana, Arial">
<B>Delete?</B></font>
</td>
<td valign=bottom width=140><FONT SIZE="1" FACE="Verdana, Arial"><B>User Name<BR>Reg. Number<BR>Date Registered</B></FONT></td>
<td valign=bottom ><FONT SIZE="1" FACE="Verdana, Arial" COLOR="#FF0000"><B>Able to post notes?</B></FONT></td>
<td valign=bottom><FONT SIZE="1" FACE="Verdana, Arial" COLOR="#FF0000"><B>Authorized Administrator?</B></FONT></td>
<td valign=bottom><FONT SIZE="1" FACE="Verdana, Arial"><B>Status</B></FONT></td>
<td valign=bottom><FONT SIZE="1" FACE="Verdana, Arial"><B>Total Posts</B></FONT></td>
</tr>
PermGuts

for $line(@themembers) {
$ProfileNumber = &GetUserNumber($line);
@searchrow = &OpenProfile("$ProfileNumber.cgi");

$UNCoded = $searchrow[0];
$UNCoded =~ tr/ /+/;
$Posts = $searchrow[7];
$Permission = $searchrow[4];
&CheckPermissions;
$DateReg = $searchrow[10];
$WriteYes = "";
$WriteNo = "";
$AdminYes="";
$AdminNo="";

if ($searchrow[8] eq "Administrator") {
	$ThisStatus = "$AdminTitle";
}
elsif ($searchrow[8] eq "Moderator") {
	$ThisStatus = "$ModeratorTitle";
}
elsif ($searchrow[8] eq "Member") {
	$ThisStatus = "$MemberTitle";
}  else {
	$ThisStatus = "$JrMemberTitle";
}
if ($AdminWrite eq "true") {
   $WriteYes = "CHECKED";
}  else {
   $WriteNo = "CHECKED";
}
if ($AdminPermission eq "true") {
   $AdminYes = "CHECKED";
}  else {
   $AdminNo = "CHECKED";
}

if ($AltColor eq "") {
	$AltColor = "#dedfdf";
}
if ($AltColor eq "#f7f7f7") {
	$AltColor = "#dedfdf";
}  else {
$AltColor = "#f7f7f7";
}

print <<GUTS;
<tr bgcolor="$AltColor">
<td align=center>
<INPUT TYPE="CHECKBOX" NAME="Delete::$ProfileNumber" VALUE="yes">
</td>
<td><FONT SIZE="1" FACE="Verdana, Arial"><A HREF="cpanel.cgi?action=getbio4admin&UserNumber=$ProfileNumber" target=_blank>$searchrow[0]</A><BR>$ProfileNumber<BR>$DateReg</font></td>
<td><FONT SIZE="1" FACE="Verdana, Arial">
<INPUT TYPE="RADIO" NAME="AdminWrite::$ProfileNumber" VALUE="true" $WriteYes>Yes &nbsp;&nbsp;
<INPUT TYPE="RADIO" NAME="AdminWrite::$ProfileNumber" VALUE="false" $WriteNo>No
</FONT>
</td>
<td><FONT SIZE="1" FACE="Verdana, Arial">
<INPUT TYPE="RADIO" NAME="AdminPermission::$ProfileNumber" VALUE="true" $AdminYes>Yes &nbsp;&nbsp;
<INPUT TYPE="RADIO" NAME="AdminPermission::$ProfileNumber" VALUE="false" $AdminNo>No
</FONT>
</td>
<td><FONT SIZE="1" FACE="Verdana, Arial">$ThisStatus</FONT></td>
<td><FONT SIZE="1" FACE="Verdana, Arial">$searchrow[7]</FONT></td>
</tr>
GUTS

####
} #end FOREACH

print <<ENDHTML;
</table>
</center>
<br>
<CENTER><FONT Size="2" FACE="Verdana, Arial" COLOR="#800000"><B>For security reasons, re-enter your UserName & Password: <BR>
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT></B></CENTER>
<p>
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Permission Changes Now">
</form><FONT COLOR="#C0C0C0">
<BR><BR>Powered by: Ultimate Bulletin Board<br>
&copy; Madrona Park, Inc., 1999.<BR><BR>.</CENTER>
</FONT>
</FONT>
</body>
</html>
ENDHTML
}  else {
&StandardHTML("Sorry, but we couldn't find any users that matched your search criteria.  Please go back and try again!");
}
}  ## END GET ALL SR ##

sub DoSearch {
open (MEMBERLIST, "$MembersPath/memberslist.cgi"); 
    my @themembers = <MEMBERLIST>;
close (MEMBERLIST);
open (EMAILFILE, "$MembersPath/emailfile.cgi"); 
    my @theemails = <EMAILFILE>;
close (EMAILFILE);

foreach $dos(@themembers) {
($thename, $thenum) = split(/\|\!\!\|/, $dos);
chomp($thenum);
$Line = "$thenum&$thename";
push(@sortmems, $Line);
}
foreach $dos2(@theemails) {
($theemail, $thenum) = split(/\|\|/, $dos2);
chomp($thenum);
$Line = "$thenum&$theemail";
push(@sortemails, $Line);
}
$TotalMembers = @sortmems;
$CheckEmail = "$in{'Email'}";
$Search = 0;
$arraycount = 0;

foreach $memberinfo(@sortmems) {
($junk, $member) = split(/\&/, $memberinfo);
chomp($member);
my @searchfile = @blank;
my $ProfileOpened = "";
my $bad = "no";

#start UserName check block
	if ($SearchName ne "") {
		unless ($member =~ /$SearchName/i) {
			$bad = "yes";
		}
	} 
#do email check
	if (($CheckEmail ne "") && ($bad ne "yes")) {
	$ThisEmailRow = $sortemails[$arraycount];
	($junk, $thisemail) = split(/\&/, $ThisEmailRow);
chomp($thisemail);
		unless ($thisemail =~ /$CheckEmail/i) {
			$bad = "yes";
		}
	} #end if do check of email

	# Check number of posts
	
	if (($in{'Posts'} ne "") && ($bad ne "yes")) {
		$ProfileOpened = "true";
		$ProfileNumber = &GetUserNumber($member);
		@searchfile = &OpenProfile("$ProfileNumber.cgi");
		
		$PostNumber = $searchfile[7];
		$Math = $in{'Math'};
		if ($Math eq "GT") {
			unless ($PostNumber >= $in{'Posts'}) {
				$bad = "yes";
		}
		}
		if ($Math eq "LT") {
			unless ($PostNumber <= $in{'Posts'}) {
				$bad = "yes";	
			}  
		}
		if ($Math eq "EQ") {
			unless ($PostNumber == $in{'Posts'}) {
				$bad = "yes";
			}
		}
		
	} 

#start validation block

$arraycount++;
if ($bad ne "yes")  {
$Search++;
if ($ProfileOpened ne "true") {
		$ProfileNumber = &GetUserNumber($member);
		@searchfile = &OpenProfile("$ProfileNumber.cgi");
}

$line = ("$searchfile[0]" .  "|||" .  "$searchfile[2]" .  "|||"  . "$searchfile[4]" . "|||" . "$searchfile[8]" . "|||" . "$searchfile[7]" . "|||" . "$searchfile[10]" . "|||" . "$ProfileNumber");
push (@thefinal, $line);
}  

#close validation block

}  #end FOREACH $member


if ($Search > 0) {	

@final = sort(@thefinal);

	$TotalProfiles = @final;
	
## ONLY DISPLAY 50 at a time--
my $MaxDisplay = 50;  #maximum number to view per screen
if ($in{'StartPoint'} eq "") {
	$StartPoint = 1;
	if ($TotalProfiles <= $MaxDisplay) {
		$EndPoint = $TotalProfiles;
		$Done = "true";
	} else {
	$Done = "";
	$EndPoint = $MaxDisplay;
	}
	$EP = $EndPoint - 1;


} else {

$StartPoint = $in{'StartPoint'};
$EndPoint = $StartPoint + $MaxDisplay;
$EndPoint = $EndPoint - 1;
	if ($TotalProfiles <= $EndPoint) {
		$EndPoint = $TotalProfiles;
		$Done = "true";
	}  else {
		$Done = "";
	}

}

$SP = $StartPoint - 1;
$EP = $EndPoint - 1;
@final = @final[$SP..$EP];

if ($Done ne "true") {
$NextStart = $EndPoint + 1;
$NextWording = qq(<A HREF="cpanel2.cgi?action=getmatches&StartPoint=$NextStart&UserName=$UserNameCoded&Password=$PasswordCoded&NN=$SearchNameCoded&Email=$in{'Email'}&Math=$in{'Math'}&Posts=$in{'Posts'}&ViewEntire=$in{'ViewEntire'}">[Next Matches]</A>);
} else {
$NextWording = "";
}
if ($TotalProfiles == 0) {
$StartPoint = 0;
}

&PermissionsTopHTML;

print <<HTML_TOP;
<P>
Make any changes necessary and then click on "Submit" to modify any/all user records.  Check the delete box on the left for all registrations you want deleted.<br><br>

<FORM ACTION="cpanel2.cgi" METHOD="POST" NAME="PERMISS"  onSubmit="return Check(this)">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="updatepermiss">
<center>
Click on name for profile details and advanced permission settings.
<table width=95%>
<TR>
<TD colspan=6><FONT FACE="Verdana, Arial" SIZE="1">Displaying Matches $StartPoint - $EndPoint ($TotalProfiles total) &nbsp;&nbsp;&nbsp;&nbsp; $NextWording</FONT>
</td>
</tr>
<tr bgcolor="#cccc99">
<td valign=bottom>
<FONT SIZE="1" FACE="Verdana, Arial">
<B>Delete?</B></font>
</td>
<td valign=bottom><FONT SIZE="1" FACE="Verdana, Arial"><B>User Name<BR>Reg. Number<BR>Date Registered</B></FONT></td>
<td valign=bottom ><FONT SIZE="1" FACE="Verdana, Arial" COLOR="#FF0000"><B>Able to post notes?</B></FONT></td>
<td valign=bottom><FONT SIZE="1" FACE="Verdana, Arial" COLOR="#FF0000"><B>Authorized Administrator?</B></FONT></td>
<td valign=bottom><FONT SIZE="1" FACE="Verdana, Arial"><B>Status</B></FONT></td>
<td valign=bottom><FONT SIZE="1" FACE="Verdana, Arial"><B>Total Posts</B></FONT></td>
</tr>
HTML_TOP

foreach $line2(@final) {
		
	@searchrow = split (/\|\|\|/, $line2);
	
$UNCoded = $searchrow[0];
$UNCoded =~ tr/ /+/;

$Permission = $searchrow[2];
$DateReg = $searchrow[5];
$ProfileNum = $searchrow[6];
chomp($ProfileNum);

if ($searchrow[3] eq "Administrator") {
	$ThisStatus = "$AdminTitle";
}
elsif ($searchrow[3] eq "Moderator") {
	$ThisStatus = "$ModeratorTitle";
}
elsif ($searchrow[3] eq "Member") {
	$ThisStatus = "$MemberTitle";
}  else {
	$ThisStatus = "$JrMemberTitle";
}

&CheckPermissions;
$WriteYes = "";
$WriteNo = "";
$AdminYes="";
$AdminNo="";

if ($AdminWrite eq "true") {
   $WriteYes = "CHECKED";
}  else {
   $WriteNo = "CHECKED";
}
if ($AdminPermission eq "true") {
   $AdminYes = "CHECKED";
}  else {
   $AdminNo = "CHECKED";
}
if ($AltColor eq "") {
	$AltColor = "#dedfdf";
}
if ($AltColor eq "#f7f7f7") {
	$AltColor = "#dedfdf";
} else {
$AltColor = "#f7f7f7"
}

print <<GUTS;
<tr bgcolor=$AltColor>
<td align=center>
<INPUT TYPE="CHECKBOX" NAME="Delete::$ProfileNum" VALUE="yes">
</td>
<td><FONT SIZE="1" FACE="Verdana, Arial"><A HREF="cpanel.cgi?action=getbio4admin&UserNumber=$ProfileNum" target=_blank>$searchrow[0]</A><BR>$ProfileNum<BR>$DateReg</font></td>
<td><FONT SIZE="1" FACE="Verdana, Arial">
<INPUT TYPE="RADIO" NAME="AdminWrite::$ProfileNum" VALUE="true" $WriteYes>Yes &nbsp;&nbsp;
<INPUT TYPE="RADIO" NAME="AdminWrite::$ProfileNum" VALUE="false" $WriteNo>No
</FONT>
</td>
<td><FONT SIZE="1" FACE="Verdana, Arial">
<INPUT TYPE="RADIO" NAME="AdminPermission::$ProfileNum" VALUE="true" $AdminYes>Yes &nbsp;&nbsp;
<INPUT TYPE="RADIO" NAME="AdminPermission::$ProfileNum" VALUE="false" $AdminNo>No
</FONT>
</td>
<td><FONT SIZE="1" FACE="Verdana, Arial">$ThisStatus</FONT></td>
<td><FONT SIZE="1" FACE="Verdana, Arial">$searchrow[4]</FONT></td></tr>
GUTS

} #end FOREACH

print <<ENDHTML;
</table>
<br>
<FONT Size="2" FACE="Verdana, Arial" COLOR="#800000"><B>For security reasons, re-enter your UserName & Password: <BR>
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT></B></CENTER><P>
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Permission Changes Now">
</form><FONT COLOR="#C0C0C0">
<BR><BR>Powered by: Ultimate Bulletin Board<BR>
&copy; Madrona Park, Inc., 1999.<BR><BR>.</CENTER>
</FONT>
</FONT>
</body>
</html>
ENDHTML
}  else {
&StandardHTML("Sorry, but we couldn't find any users that matched your search criteria.  Please go back and try again!");
}
}  ##END DOSEARCH SR ###
sub SetGenVars {
### CHECK USERNAME - must be an admin
##verify that this user is an administrator

#check to see which Member Format is in place, process accordingly
if (-e "$MembersPath/memberslist.cgi") {
$ProfileNumber = &GetUserNumber($in{'UserNameCheck'});
if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}
}  else {

$ProfileNumber = $UserNameCheckFile;

$NameFound = "no";
  if (-e "$MembersPath/$ProfileNumber.cgi") {
      $NameFound = "yes";
    } 
}

####

if ($NameFound eq "yes") {
	@profilestats = &OpenProfile("$ProfileNumber.cgi");
			chomp($profilestats[1]);
	if ($in{'PasswordCheck'} eq "$profilestats[1]") {
	$Permission = "$profilestats[4]";
	chomp($Permission);
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   &DoProcessGenVars;
	   }  else {
	    &StandardHTML("Sorry, but you are not an administrator.");
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again. Use your Back button.");
	}
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. <P>If you are configuring your bulletin board for the first time, this is probably due to the fact that you did not set the proper variable for your CGI Directory absolute path.<P>Use your Back button to try again.");
}  ##END IF/ELSE NAME CHECK BLOCK

}  ##END Set Gen Vars

sub DoProcessGenVars {
if ((-e "$in{'NonCGIPath'}/ubbcode.html") && (-e "$in{'CGIPath'}/cpanel.cgi")) {

if ($in{'CategoriesOnly'} eq "true") {
	$in{'CategoryView'} = "yes";
}

open (FILE, ">$in{'VariablesPath'}/UltBB.setup") or die("Unable to open setup file for writing.");

foreach $one(@in) {
	($Name, $Value) = split ("=", $one);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	$Value =~ s/\@/\\@/g;
	$Value =~ s/"/\\"/g;
	if (($Name eq "EmailBan") || ($Name eq "$YourCopyrightNotice") || ($Name eq "BBEmail") || ($Name eq "censorwords")) {
	$Value = &EliminateReturns($Value);
}
	if ($Name eq "BBRules")  {
	$Value = &ConvertReturns($Value);
}
		if (($Name ne "UserNameCheck") && ($Name ne "PasswordCheck") && ($Name ne "Submit")) {
	print FILE ("\$$Name = \"$Value\";\n");
	}
}

	print FILE ('$ForumsPath = ' . '"' . $in{'NonCGIPath'} . '";');
	print FILE ("\n1;\n");
close (FILE);



# create forum directories and set permissions on directories
unless (-e "$in{'NonCGIPath'}/Forum7") {
chmod(0777, "$in{'NonCGIPath'}");
chmod(0755, "$in{'CGIPath'}");
chmod(0777, "$in{'MembersPath'}");
chmod(0777, "$in{'MembersPath'}/Admin5.cgi");
mkdir ("$in{'NonCGIPath'}/Forum1", 0777);
chmod(0777, "$in{'NonCGIPath'}/Forum1");
mkdir ("$in{'NonCGIPath'}/Forum2", 0777);
chmod(0777, "$in{'NonCGIPath'}/Forum2");
mkdir ("$in{'NonCGIPath'}/Forum3", 0777);
chmod(0777, "$in{'NonCGIPath'}/Forum3");
mkdir ("$in{'NonCGIPath'}/Forum4", 0777);
chmod(0777, "$in{'NonCGIPath'}/Forum4");
mkdir ("$in{'NonCGIPath'}/Forum5", 0777);
chmod(0777, "$in{'NonCGIPath'}/Forum5");
mkdir ("$in{'NonCGIPath'}/Forum6", 0777);
chmod(0777, "$in{'NonCGIPath'}/Forum6");
mkdir ("$in{'NonCGIPath'}/Forum7", 0777);
chmod(0777, "$in{'NonCGIPath'}/Forum7");
mkdir ("$in{'NonCGIPath'}/Forum8", 0777);
chmod(0777, "$in{'NonCGIPath'}/Forum8");
mkdir ("$in{'NonCGIPath'}/Forum9", 0777);
chmod(0777, "$in{'NonCGIPath'}/Forum9");
}

###############################################
## Perform diagnostic checks/update if necessary
if (-e "$NonCGIPath/ubbdiagnostic.file") {

open(DIAG, "$NonCGIPath/ubbdiagnostic.file");
@diag = <DIAG>;
close(DIAG);

foreach $diagline(@diag) {
	if ($diagline =~ m/SetLastTimes/) {
		$SLT = "true";
	}
	if ($diagline =~ m/ConvertAnnouncements/) {
		$CA = "true";
	}
	if ($diagline =~ m/ConvertToUBBFiles/) {
		$CTUF = "true";
	}
	if ($diagline =~ m/CreateLastForumNums/) {
		$CLFN = "true";
	}
}


if ($CTUF ne "true") {
	&RenameMess;
}

if ($CA ne "true") {
	&MoveAnnc;
}

if ($SLT ne "true") {
	&SetLastTimes;
}

if ($CLFN ne "true") {
	&SetLastThreadNums;
}
}  else {

$DidIt = "true";
#convert message files to ubb files
&RenameMess;
#move announcements to ANNC subdirectories
&MoveAnnc;
#reset last time files
&SetLastTimes;
#create last thread number file in each forum
&SetLastThreadNums;

#create ubbdiagnostic file--
open(DIAG, ">$NonCGIPath/ubbdiagnostic.file");
print DIAG ("SetLastTimes\n");
print DIAG ("ConvertAnnouncements\n");
print DIAG ("ConvertToUBBFiles\n");
print DIAG ("CreateLastForumNums\n");
close(DIAG);
chmod (0777, "$NonCGIPath/ubbdiagnostic.file");
}

if (($in{'Diagnostic'} eq "yes") && ($DidIt ne "true")) {
&SetLastTimesCycle;
}  else {

## END DIAGNOSTIC CHECK/UPDATE
#check to see if members are in proper format
&ConvertMembers;

$UserName = "$UserNameCheck";
$UserName =~ tr/ /+/;
$Password = "$PasswordCheck";
$Password =~ tr/ /+/;
unlink("$MembersPath/holdmems.cgi");
unlink("$CGIPath/temp.file");
unlink("$MembersPath/temp.file");
$ConfirmLine = "The Ultimate Bulletin Board General Variables have been updated.<P>
Note that in order to have these changes reflected in old threads, you need to update those threads.  You can do this using the \"Update Threads\" control panel option.  Depending on the number of threads you have stored on your system, the updating process can be time-consuming.  It is thus recommended that you do not update your threads until after you have made all control panel setting changes.<P>";
&ConfirmHTML2;
exit;
}

}  else {
&StandardHTML("Sorry, but you have not set the correct absolute path variables.  Please use your back button to try again.  We cannot process your variables without the proper absolute paths.");
}
} ## END DO PROCESS GENERAL VARS SR

sub DoIndex {
##verify that this user is an administrator
$NameFound = "no";
$ProfileNumber = &GetUserNumber($in{'UserName'});
if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}

if ($NameFound eq "yes") {
	@profilestats = &OpenProfile("$ProfileNumber.cgi");
			
	if ($Password eq "$profilestats[1]") {
	$Permission = "$profilestats[4]";
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   &ReIndex("1", "0");
 	   }  else {
	    &StandardHTML("Sorry, but you are not an administrator.");
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
	}
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
}  ##END IF/ELSE NAME CHECK BLOCK
} # end DoIndex sr


sub Mods {
##verify that this user is an administrator
$NameFound = "no";
$ProfileNumber = &GetUserNumber($in{'UserName'});
if ($ProfileNumber ne "") {
	$NameFound = "yes";
} else {
	$NameFound = "no";
}


if ($NameFound eq "yes") {
	@profilestats = &OpenProfile("$ProfileNumber.cgi");
			
	if ($Password eq "$profilestats[1]") {
	$Permission = "$profilestats[4]";
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   &DoProcess;
	   }  else {
	    &StandardHTML("Sorry, but you are not an administrator.");
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again. Use your Back button.");
	}
	
	
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
}  ##END IF/ELSE NAME CHECK BLOCK

sub DoProcess {

&GetMemberListArray;  #returns @members array

## now we have our current Member list (in filename format)

foreach $row(@in) {
	$row = decodeURL($row);
	($Name, $Value) = split ("=", $row);
	if ($Name =~ m/NewMod/) {
	($Trash, $Number) = split(/Mod/, $Name);
	$Combine = ("$Number" . "::" . "$Value");
	push (@GoodMods, $Combine);
	}
} # end foreach $row

#now Moderator names are in order

for (@GoodMods) {
	$modmatch = "false";
	($ForumNumber, $ModName) = split(/::/, $_);
	if (($ModName ne "none") && ($ModName ne "")) {
			for $matcher(@members) {
			chomp($matcher);
				if ($matcher eq "$ModName") {
					$modmatch = "true";
		$ModName =~ s/([\^|\.|\$|\*\|\?|\(|\)|\{|\}|\[|\]|\\|\&|\%|\@|\+|\}|\{|\"])/\\$1/isg;

$modline = ('$Forum' . "$ForumNumber" . 'Moderator = "' . "$ModName" . '"' . ";\n");
		push(@modarray, $modline);
				} #end if modcoded
			} #end for $matcher

	if ($modmatch ne "true") {
		$error = "true";
		$errorline = ("$errorline" .  "The moderator name \"$_\" is not a valid UserName.<br>");
	} # end if $modmatch
} # if not "none"
} # end for

if ($error ne "true") {
	open (MODS, ">$VariablesPath/mods.file") || die("Unable to open Mods file.");
		print MODS (@modarray);
		print MODS ("1;\n");
	close (MODS);

## UPDATE MEMBER PROFILES FOR ALL MODERATORS

foreach $thischeck(@GoodMods) {
	($ForumNumber, $ModName) = split(/::/, $thischeck);
	if (($ModName ne "none") && ($ModName ne "")) {
		$ProfileNumber = &GetUserNumber($ModName);
		@modprof = &OpenProfile("$ProfileNumber.cgi");
		$Status = $modprof[8];
			&CheckStatus;
			if ($AdminStatus ne "true") {
					$modprof[8] = "Moderator";
			open (UPDATE, ">$MembersPath/$ProfileNumber.cgi");
	foreach $thisline(@modprof) {
		chomp($thisline);
		print UPDATE ("$thisline\n");
	}
		close (UPDATE);
			}  ## END IF modprof
	}  # END if not "none"
} # end for


## Delete Moderator status from users who are no longer Moderators

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	if ($Name =~ m/OldMod/) {
	push (@OldMods, $Value);
	}
} # end foreach $row

for $oldie(@OldMods) {
	$SaveOldie = "no";
	for $checkthis(@GoodMods) {
		($ForumNum, $TheGoodModName) = split(/::/, $checkthis);
		if ($oldie eq "$TheGoodModName") {
		$SaveOldie = "yes";
		}
	}
	if (($SaveOldie ne "yes") && ($oldie ne "none") && ($oldie ne "")) {
		$OldieFile = "$oldie";
		$OldieFile =~ s/ /_/g; #remove spaces
		$ProfileNumber = &GetUserNumber($oldie);
		@oldmod = &OpenProfile("$ProfileNumber.cgi");  #only change
			$Status = $oldmod[8];
			$TotalPosts = $oldmod[7];
			&CheckStatus;
			
			if ($AdminStatus ne "true") {
				if ($TotalPosts < $MemberMinimum) {
					$Status = "Junior Member";
				}  else {
					$Status = "Member";
				}
				###
				$oldmod[8] = "$Status";
				
				open (UPDATE, ">$MembersPath/$ProfileNumber.cgi");
				foreach $separate(@oldmod) {
					chomp($separate);
					print UPDATE ("$separate\n");
				}
			close (UPDATE);
		}  ## END IF ADMIN status ne true
	}

} 


$ConfirmLine = "The forum moderators have been successfully updated.";
&ConfirmHTML2;

} else {

print<<Error;
<HTML><BODY BGCOLOR="#FFFFFF" link="#000080" vlink="#808000">
<br><br><FONT Size="$TextSize" FACE="$FontFace"><B>
Sorry, we could not process the Moderator updates, due to the following error(s).
<P>
<FONT COLOR="#FF0000">$errorline</FONT>
<p>
Use your back button to go back to the Moderator page, or use the links below.
<p>
Return to: <br>
<ul>
<A HREF="$NonCGIURL/controlpanel.html">Control Panel</A><br>
<A HREF="$CGIURL/Ultimate.cgi?action=intro">Bulletin Board</A>
</ul>
</B></FONT>
</BODY></HTML>
Error

}#end if/else error ne true
}  ## END DO PROCESS SR

}  # END MODS SR


sub CheckStatus {

		if ($Status =~ m/Administrator/) {
			$AdminStatus = "true";
			} else {
			$AdminStatus = "false";
		}
		

		if ($Status =~ m/Moderator/) {
			$ModStatus = "true";
		} else {
			$ModStatus = "false";
		}
		if ($Permission =~ m/Write/) {
			$AdminWrite = "true";
		} else {
			$AdminWrite = "false";
		}

} #end CheckStatus




sub HEADERHTML {

if ($in{'UserName'} eq "") {
$UserName = "";
$Password = "";

}
print<<HEADER;
<HTML>
<HEAD>
	<TITLE>$BBName</TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE

var testUserNameCP = getCookie("UserNameCP");

var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if ((testUserNameCP == null) && (CookieUNCP != "")){
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";";
		document.cookie = "PasswordCP=" + CookiePWCP + ";";
	} 
	
function SetCursor() {
var thisUserNameCP = getCookie("UserNameCP");
var thisPasswordCP = getCookie("PasswordCP");

if (thisUserNameCP != null) {  
thisUserNameCP = unescape(thisUserNameCP);
thisPasswordCP = unescape(thisPasswordCP);

	document.THEFORM.UserNameCheck.value = thisUserNameCP;
document.THEFORM.PasswordCheck.value = thisPasswordCP;
	}  
}

function Check(form)  {
if ((form.Password.value == "") || (form.UserName.value == ""))  {
	alert ("You forgot to fill in the Username and/or Password fields.  These are required entries!");
	return false
	}  else  {
	return true
	}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}
// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</HEAD>
<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000" onLoad="SetCursor()">
<BR>
<center>
<FONT SIZE="5" FACE="Courier New"><B>$PageTitle</B></FONT>
</center>
<P>
<FONT SIZE="2" FACE="Verdana, Arial">
HEADER
} #end HEADERHTML sr

sub HEADER2HTML {
print<<HEADER2HTML;
<HTML>
<HEAD>
	<TITLE>$BBName</TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE

var testUserNameCP = getCookie("UserNameCP");
var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if (testUserNameCP == null) {
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";";
		document.cookie = "PasswordCP=" + CookiePWCP + ";";
	}

function SetCursor() {
var thisUserNameCP = getCookie("UserNameCP");
var thisPasswordCP = getCookie("PasswordCP");

if (thisUserNameCP != null) {  
thisUserNameCP = unescape(thisUserNameCP);
thisPasswordCP = unescape(thisPasswordCP);

	document.THEFORM.UserNameCheck.value = thisUserNameCP;
document.THEFORM.PasswordCheck.value = thisPasswordCP;
	}  
}


function Check(form)  {
if ((form.PasswordCheck.value == "") || (form.UserNameCheck.value == ""))  {
	alert ("You forgot to fill in the Username and/or Password fields.  These are required entries!");
	return false
	}  else  {
	return true
	}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}
// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</HEAD>
<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000" onLoad="SetCursor()">
<BR><center>
<FONT SIZE="5" FACE="Courier New"><B>$PageTitle</B></FONT>
</center>
<p>
HEADER2HTML
} #end HEADERHTML2 sr


sub UpdateThePermissions {
@deletefile = @blank;

foreach $row2(@in) {
	($Name, $Value) = split ("=", $row2);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	
		$matchAW = $row2 =~ m/AdminWrite/;
		if ($matchAW eq "1")  {
		    ($type, $UserNumber) = split(/::/, $Name);
			if ($Value eq "true") {
			       $Value = "Write";
				   }  else {
				      $Value = "";
			}
			
			$changeline = ("$UserNumber|$Value");
			$skippush = "no";
			
			if ($arraylength > 0) {
			$arrayline = 0;
			   foreach $checker(@changes) {
			       ($this, $that) = split(/\|/, $checker);
				   
				   if ($this eq "$UserNumber") {
				       $skippush = "yes";
				       $changes[$arrayline] = ("$UserNumber|$that$Value");
					} 
					$arrayline++;
			}  # foreach checker
		} ## if array length greater than 0
		
	if ($skippush eq "no") {
		    push(@changes, $changeline);
			}
          		   
			$arraylength = @changes;
			
}  ## IF match = 1

		$matchAP = $row2 =~ m/AdminPermission/;
		if ($matchAP eq "1")  {
		    ($type, $UserNumber) = split(/::/, $Name);
			if ($Value eq "true") {
			       $Value = "Admin";
				   }  else {
				      $Value = "";
			}
			
			$changeline = ("$UserNumber|$Value");
			$skippush = "no";
			
			if ($arraylength > 0) {
			$arrayline = 0;
			   foreach $checker(@changes) {
			       ($this, $that) = split(/\|/, $checker);
				   
				   if ($this eq "$UserNumber") {
				       $skippush = "yes";
				       $changes[$arrayline] = ("$UserNumber|$that$Value");
					} 
					$arrayline++;
			}  # foreach checker
		} ## if array length greater than 0
		
	if ($skippush eq "no") {
		    push(@changes, $changeline);
			}
          		   
			$arraylength = @changes;
			
}  ## IF match = 1

	$matchDelete = $row2 =~ m/Delete/;
		if ($matchDelete eq "1")  {
		    ($type, $UserNumber) = split(/::/, $Name);
			if ($Value eq "yes") {
			       $Value = "Delete";
				   }  else {
				      $Value = "";
			}
			
			$changeline = ("$UserNumber|$Value");
			$skippush = "no";
			
			if ($arraylength > 0) {
			$arrayline = 0;
			   foreach $checker(@changes) {
			       ($this, $that) = split(/\|/, $checker);
				   
				   if ($this eq "$UserNumber") {
				       $skippush = "yes";
				       $changes[$arrayline] = ("$UserNumber|$that$Value");
					} 
					$arrayline++;
			}  # foreach checker
		} ## if array length greater than 0
		
	if ($skippush eq "no") {
		    push(@changes, $changeline);
			}
          		   
			$arraylength = @changes;
			
}  ## IF match = 1
	}  # end foreach row2

##have array of changes now
##open each profile to make changes
@deletefile = @blank;
foreach $updatename(@changes) {
($thisnumber, $ThisPerm) = split(/\|/, $updatename);
chomp($ThisPermission);
chomp($thisnumber);

	if ($ThisPerm =~ m/Delete/) {
	push(@deletelist, $thisnumber);		unlink("$MembersPath/$thisnumber.cgi");
	}  else {
		#in case file permissions are off...
		@theprofile = @blank;
		chmod (0777, "$MembersPath/$thisnumber.cgi");
		@theprofile = &OpenProfile("$thisnumber.cgi");    
	chomp($theprofile[0]);
		chomp($theprofile[1]);
			chomp($theprofile[2]);
				chomp($theprofile[3]);
					chomp($theprofile[5]);
						chomp($theprofile[7]);
							chomp($theprofile[9]);
								chomp($theprofile[10]);
chomp($theprofile[14]);
chomp($theprofile[13]);
chomp($theprofile[12]);
chomp($theprofile[11]);
						
		if ($ThisPerm =~ m/Admin/) {
			$UserStatus = "Administrator";
		} else { 
			open (MODS, "$VariablesPath/mods.file");
				@modslist = <MODS>;
			close (MODS);

			$ModsTotal = @modslist;
@modsarray = @blank;
			for ($x = 1; $x <= $ModsTotal; $x++) {
				$GetModerator = ("Forum" . "$x" . "Moderator");
				$Moderator = $$GetModerator;
				push(@modsarray, $Moderator);
			}
	$Modfound = "";
			CHECKMODS: foreach $uno(@modsarray) {
			chomp($uno);
				if ($uno eq "$theprofile[0]") {
					$UserStatus = "Moderator";
					$Modfound = "yes";
					last CHECKMODS;
				}
			}
		if ($Modfound ne "yes") {
			if ($theprofile[7] < $MemberMinimum) {
				$UserStatus = "Junior Member";
				}  else {
				$UserStatus = "Member";
				}
		}
	} # end if/else admin
chomp($theprofile[4]);
($junk, $currentaccess) = split(/\&/, $theprofile[4]);
chomp($currentaccess);
$PermissionLine = ("$ThisPerm" . "&" . "$currentaccess");
&Lock("lock.file");
	open (MEMBERSHIP, ">$MembersPath/$thisnumber.cgi") or die("Unable to open Members directory.");

	print MEMBERSHIP ("$theprofile[0]\n");
	print MEMBERSHIP ("$theprofile[1]\n");
	print MEMBERSHIP ("$theprofile[2]\n");
	print MEMBERSHIP ("$theprofile[3]\n");
	print MEMBERSHIP ("$PermissionLine\n");
	print MEMBERSHIP ("$theprofile[5]\n");
	print MEMBERSHIP ("$theprofile[6]\n");
	print MEMBERSHIP ("$theprofile[7]\n");
	print MEMBERSHIP ("$UserStatus\n");
	print MEMBERSHIP ("$theprofile[9]\n");
	print MEMBERSHIP ("$theprofile[10]\n");
	print MEMBERSHIP ("$theprofile[11]\n");
	print MEMBERSHIP ("$theprofile[12]\n");
	print MEMBERSHIP ("$theprofile[13]\n");
	print MEMBERSHIP ("$theprofile[14]\n");
close (MEMBERSHIP);
&Unlock("lock.file");
chmod (0777, "$MembersPath/$thisnumber.cgi");
}  # END IF match del
}  ## FOREACH

#update the memberslist.cgi file
if ($deletelist[0] ne "") {
&UpdateMembersList;
}

$ConfirmLine = "We have made the changes you requested.";
&ConfirmHTML;

} # End UpdateThePermissions sr

sub RenameMess {

#convert old files to new files--- (new in 5.10)
@sortforums = &OpenForumsFile;

for (@sortforums) {

@thisforuminfo = split(/\|/, $_);
chomp($thisforuminfo[8]);
$x = "$thisforuminfo[8]";

opendir (FORUMDIR, "$ForumsPath/Forum$x"); 
    @thesefiles = readdir(FORUMDIR);
closedir (FORUMDIR);

@thefiles = grep(/\.(n|m)/, @thesefiles);
@files = sort(@thefiles);
$oldfiletotal = @files;

foreach $one(@files) {
$Notes = "";

if ($one =~ /^\d\d\d\d\d\d-000000/) {
#it is a father
open (FATHER, "$ForumsPath/Forum$x/$one");
@father = <FATHER>;
close (FATHER);

($threadnum, $junk, $junk2, $replies) = split(/-/, $one);
($replies, $junk3) = split(/\./, $replies);
$TotReplies = substr($replies, 0, 6);
$TotReplies = $TotReplies + 0;

if ($one =~ /X/) {
	$Notes = "X";
	}
if ($one =~ /n/) {
	$Notes .= "N";
	}

chomp($father[0]);
chomp($father[1]);
chomp($father[2]);
$Subject = $father[3];
chomp($Subject);
$email = $father[4];
chomp($email);
chomp($father[5]);

$StatsLine = "A||$Notes||$TotReplies||$father[0]||$Subject";

$NewFatherName = "$threadnum.cgi";
$FatherLine = "Z||000000||$father[0]||$father[1]||$father[2]||$email||$father[5]";

open (RENAMEPOP, ">$ForumsPath/Forum$x/$NewFatherName");
print RENAMEPOP ("$StatsLine\n");
print RENAMEPOP ("$FatherLine\n");
close (RENAMEPOP);


chmod (0666, "$ForumsPath/Forum$x/$NewFatherName");
unlink "$ForumsPath/Forum$x/$one";


}  else {
#add to reply file
open (REPLY, "$ForumsPath/Forum$x/$one");
@reply = <REPLY>;
close (REPLY);

($threadnum, $replynum, $junk, $junk2) = split(/-/, $one);
$NewReplyName = "$threadnum.cgi";

#put reply info on one line
$UName = $reply[0];
chomp($UName);
$Date = $reply[1];
chomp($Date);
$TheTime = $reply[2];
chomp($TheTime);
$Subject = $reply[3];
chomp($Subject);
$Email = $reply[4];
chomp($Email);
$Message = $reply[5];
chomp($Message);
$ReplyLine = ("Z||$replynum||$UName||$Date||$TheTime||$Email||$Message");

open (RENAMEPOP, ">>$ForumsPath/Forum$x/$NewReplyName");
print RENAMEPOP ("$ReplyLine\n");
close (RENAMEPOP);

chmod (0666, "$ForumsPath/Forum$x/$NewReplyName");
unlink "$ForumsPath/Forum$x/$one";
}
}

}  # end for each forum
}  # end Rename Mess sr

sub MoveAnnc {
#move annc to sep. ANNC directories- new in 5.10
@sortforums = &OpenForumsFile;

for (@sortforums) {

@thisforuminfo = split(/\|/, $_);
chomp($thisforuminfo[8]);
$x = "$thisforuminfo[8]";

opendir (FORUMDIR, "$ForumsPath/Forum$x"); 
    @files = readdir(FORUMDIR);
closedir (FORUMDIR);

@annc = grep(/\.annc/, @files);


mkdir("$ForumsPath/Forum$x/ANNC", 0777);
chmod (0777, "$ForumsPath/Forum$x/ANNC");

foreach $one(@annc) {

open (ANNC, "$ForumsPath/Forum$x/$one");
@thisann = <ANNC>;
close (ANNC);
	
open (ANNC, ">$ForumsPath/Forum$x/ANNC/$one");
foreach $line(@thisann) {
chomp($line);
print ANNC ("$line\n");
}
close (ANNC);
chmod (0777, "$ForumsPath/Forum$x/ANNC/$one");
}
}  # end for each forum

}  # end Move Annc sr (new in 5.10)

sub SetLastThreadNums {

# set thread number info to lastnumber.file
# new in 5.10
@sortforums = &OpenForumsFile;

for (@sortforums) {
@thisforuminfo = split(/\|/, $_);
chomp($thisforuminfo[8]);
$x = "$thisforuminfo[8]";

if ($thisforum[6] eq "private") {
	$ExactPath = "Forum$x/private-$thisforum[7]";
	} else {
	$ExactPath = "Forum$x";
	}

opendir (FORUMDIR, "$ForumsPath/$ExactPath"); 
    @files = readdir(FORUMDIR);
closedir (FORUMDIR);

@theubbfiles = grep(/\.[cgi|ubb]/, @files);
$topiccount = @theubbfiles;
#sort the ubb files
@sortubbfiles = sort(@theubbfiles);
#reverse array so that largest number is first
@ubbfiles = reverse(@sortubbfiles);
my $lastnumber = $ubbfiles[0];
($lastnumber, $junk) = split(/\./, $lastnumber);

$ThreadTotal = 0;
#determine number of total posts
foreach $threadfile(@ubbfiles) {
	open(THREAD, "$ForumsPath/$ExactPath/$threadfile");
	@thecountit = <THREAD>;
close(THREAD);

@countit = grep(/^Z/, @thecountit);
$ThisTotal = @countit;
$ThreadTotal = $ThreadTotal + $ThisTotal;
}

if (-e "$ForumsPath/$ExactPath/lastnumber.file") {
chmod (0666, "$ForumsPath/$ExactPath/lastnumber.file");
}

#print number to lastnumber.file
open (UBB, ">$ForumsPath/$ExactPath/lastnumber.file");
print UBB ("$lastnumber\n");
print UBB ("$topiccount\n");
print UBB ("$ThreadTotal\n");
close (UBB);

chmod (0666, "$ForumsPath/$ExactPath/lastnumber.file");
}  # end for each forum
} #end SetLastThreadNums sr

sub UpdateMembersList {

open (TEMP, ">$MembersPath/temp.file");
print TEMP "temp";
close(TEMP);

open (MEMBERLIST, "$MembersPath/memberslist.cgi"); 
    my @thesemembers = <MEMBERLIST>;
close (MEMBERLIST);

foreach $thisline(@thesemembers) {
	chomp($thisline);
	my @thisprofile = split(/\|\!\!\|/, $thisline);
	$DeleteLine = "";
	
	foreach $deletenum(@deletelist) {
		chomp($deletenum);
		if ($deletenum eq "$thisprofile[1]") {
			$DeleteLine = "true";
		}
	}
	if ($DeleteLine ne "true") {
		push(@newlist, $thisline);
	}

}

&Lock("lock.file");
open (LIST, ">$MembersPath/memberslist.cgi");
	foreach $uno(@newlist) {
		chomp($uno);
		print LIST "$uno\n";
	}
close (LIST);
&Unlock ("lock.file");
chmod (0777, "$MembersPath/memberslist.cgi");

#update email file too

open (EMAILLIST, "$MembersPath/emailfile.cgi"); 
    my @doemails = <EMAILLIST>;
close (EMAILLIST);

foreach $thisline2(@doemails) {
	chomp($thisline2);
	my @profiles2 = split(/\|\|/, $thisline2);
	$DeleteLine = "";
	
	foreach $deletenum(@deletelist) {
		chomp($deletenum);
		if ($deletenum eq "$profiles2[1]") {
			$DeleteLine = "true";
		}
	}
	if ($DeleteLine ne "true") {
		push(@emaillist, $thisline2);
	}

}

&Lock("lock.file");
open (LIST, ">$MembersPath/emailfile.cgi");
	foreach $uno2(@emaillist) {
		chomp($uno2);
		print LIST "$uno2\n";
	}
close (LIST);
&Unlock ("lock.file");
chmod (0777, "$MembersPath/emailfile.cgi");
unlink("$MembersPath/temp.file");
}  #end update Members List


sub ConvertMembers {

#check to see if memberlist.cgi exists- if not, create it
if (-e "$in{'MembersPath'}/memberslist.cgi") {
	$ConversionOne = "done";
}
if (-e "$in{'MembersPath'}/emailfile.cgi") {
	$ConversionTwo = "done";
}

if ($ConversionOne ne "done") {
	$OldFormat = "true";
}

if ($ConversionTwo ne "done") {

open (TEMP, ">$CGIPath/temp.file");
print TEMP "temp closure - delete this file if you have problems with your UBB";
close(TEMP);
chmod(0777, "$CGIPath/temp.file");

#create private index directory
mkdir ("$in{'MembersPath'}/pindex", 0777);
chmod(0777, "$in{'MembersPath'}/pindex");

mkdir ("$in{'MembersPath'}/OldMembers", 0777);
chmod(0777, "$in{'MembersPath'}/OldMembers");

#batch old members files to memberslist.cgi
opendir (MEMS, "$in{'MembersPath'}");
@thememberarray = readdir(MEMS);
closedir (MEMS);
if ($OldFormat eq "true") {
@memberarray = grep(/\.cgi/, @thememberarray);
}  else {
@memberarray = grep(/\d\d\.cgi/, @thememberarray);
}

@sortmems = sort(@memberarray);

#store names/numbers in a temporary file
open (MEM, ">$in{'MembersPath'}/holdmems.cgi");
foreach $memone(@sortmems) {
chomp($memone);
print MEM ("$memone\n");
}
close (MEM);
chmod (0777, "$in{'MembersPath'}/holdmems.cgi");

my $Count = 0;
my $thisnumber = 0;
$SubTotal = @sortmems;
$MemTotal = $SubTotal - 1;

$Maximum = 39;
if ($MemTotal > $Maximum) {
$Max = $Maximum;
$Continue = "true";
$StartWith = $Maximum + 1;
$StartDisplay = 1;
$EndDisplay = $StartWith;
}  else {
$Max = $MemTotal;
}
	@adjmembers = @sortmems[0... $Max];
	
foreach $oneeach(@adjmembers) {
$Count++;
$thisnumber = sprintf("%8d", $Count);
$thisnumber =~tr/ /0/;

open (THIS, "$in{'MembersPath'}/$oneeach");
	@thismember = <THIS>;
close (THIS);
$memberline = $thismember[0];
chomp($memberline);

if ($OldFormat eq "true") {
@memberstats = split(/\|/, $memberline);
}  else {
$OldFormat = "false";
@memberstats = @thismember;
}

$ThisEmail = $memberstats[2];
$ThisName = $memberstats[0];
chomp($ThisEmail);
chomp($ThisName);

if ($OldFormat ne "true") {
($thisnumber, $junk) = split(/\./, $oneeach);
}

$thisline = ("$ThisName|!!|$thisnumber");
$thisline2 = ("$ThisEmail||$thisnumber");
push (@memberlist, $thisline);
push (@emailfile, $thisline2);

#rename old members files

rename("$in{'MembersPath'}/$oneeach", "$in{'MembersPath'}/OldMembers/$oneeach");

if (-e "$in{'MembersPath'}/$oneeach") {
unlink("$in{'MembersPath'}/$oneeach");
}
&Lock ("lock.file");
open (THISONE, ">$in{'MembersPath'}/$thisnumber.cgi");
foreach $line(@memberstats) {
chomp($line);
	print THISONE "$line\n";
}
close (THISONE);
&Unlock ("lock.file");
chmod (0777, "$in{'MembersPath'}/$thisnumber.cgi");

}
&Lock ("lock.file");
open (LIST, ">$in{'MembersPath'}/memberslist.cgi");
	foreach $uno(@memberlist) {
		chomp($uno);
		print LIST "$uno\n";
	}
close (LIST);
&Unlock ("lock.file");
chmod (0777, "$in{'MembersPath'}/memberslist.cgi");

&Lock ("lock.file");
open (LIST, ">$in{'MembersPath'}/emailfile.cgi");
	foreach $dos(@emailfile) {
		chomp($dos);
		print LIST "$dos\n";
	}
close (LIST);
&Unlock ("lock.file");
chmod (0777, "$in{'MembersPath'}/emailfile.cgi");

if ($Continue eq "true") {
&ContinueMCWording("$OldFormat");
exit;
}


}  else {

$UserName = "$UserNameCheck";
$UserName =~ tr/ /+/;
$Password = "$PasswordCheck";
$Password =~ tr/ /+/;
unlink("$in{'MembersPath'}/holdmems.cgi");
$ConfirmLine = "The Ultimate Bulletin Board General Variables have been updated.<P>
Note that in order to have these changes reflected in old threads, you need to update those threads.  You can do this using the \"Update Threads\" control panel option.  Depending on the number of threads you have stored on your system, the updating process can be time-consuming.  It is thus recommended that you do not update your threads until after you have made all control panel setting changes.<P>";
&ConfirmHTML2;
exit;
}

} #end ConvertMembers

sub ContinueMCWording {
my $ThisOldFormat = shift;

$UserNameCheckCoded = $in{'UserNameCheck'};
$UserNameCheckCoded =~ tr/ /+/;
print<<TheMail;
<HTML><HEAD>
<meta http-equiv="Refresh" content="2; URL=$CGIURL/cpanel2.cgi?action=continueMC&startwith=$StartWith&UserName=$UserNameCheckCoded&Password=$PasswordCheckCoded&OldFormat=$ThisOldFormat">
</head>
<BODY bgcolor=#FFFFFF>
<center>
<FONT FACE="Verdana, Arial" SIZE="2"><B>
<FONT FACE="Courier New" SIZE="5" COLOR="Maroon"><B>Processing....Please Wait!</B></FONT>
<P>
We are converting all of your old Member files to a new format.  Please be patient!
<P>
We just converted Members <FONT FACE="Verdana" SIZE="3" COLOR="Navy">$StartDisplay</font> to <FONT FACE="Verdana" SIZE="3" COLOR="Navy">$EndDisplay</font>...
<P><FONT FACE="Courier New" SIZE="5" COLOR="Maroon"><B>
PLEASE WAIT - WE ARE STILL PROCESSING... Do Not Interrupt The Process Yet!</B></FONT>
</center>
</FONT>
</BODY>
</HTML>
TheMail
}

sub ContinueMC {
$StartWith = shift;
$OldFormat = shift;

open (MEM, "$MembersPath/holdmems.cgi");
@members = <MEM>;
close (MEM);

@sortmems = sort(@members);

$MemTotal = @sortmems;
$MemTotal--;

$StartWith = $StartWith + 0;
$Maximum = 249;
$MaximumNumber = $StartWith + $Maximum;

if ($MemTotal > $MaximumNumber) {
$Max = $MaximumNumber;
$Continue = "true";
$StartDisplay = $StartWith + 1;
$EndDisplay = $Max + 1;
}  else {
$Max = $MemTotal;
}
	@adjmembers = @sortmems[$StartWith... $Max];
	
	$Count = $StartWith; #arraynumber
	
foreach $thisuno(@adjmembers) {
chomp($thisuno);
$Count++;
if ($OldFormat eq "true") {
$thisnumber = sprintf("%8d", $Count);
$thisnumber =~tr/ /0/;
}

open (THIS, "$MembersPath/$thisuno");
	@thismember = <THIS>;
close (THIS);

rename("$MembersPath/$thisuno", "$MembersPath/OldMembers/$thisuno");

if (-e "$MembersPath/$thisuno") {
unlink("$MembersPath/$thisuno");
}

$memberline = $thismember[0];
chomp($memberline);
if ($OldFormat eq "true") {
@memberstats = split(/\|/, $memberline);
}  else {
@memberstats = @thismember;
($thisnumber, $junk) = split(/\./, $thisuno);
}

$ThisEmail = $memberstats[2];
$ThisName = $memberstats[0];
chomp($ThisEmail);
chomp($ThisName);

$thisline = ("$ThisName|!!|$thisnumber");
push (@memberlist, $thisline);
$thisline2 = ("$ThisEmail||$thisnumber");
push (@emailfile, $thisline2);
#rename old members files
&Lock ("lock.file");
open (THISONE, ">$MembersPath/$thisnumber.cgi");
foreach $line(@memberstats) {
chomp($line);
	print THISONE "$line\n";
}
close (THISONE);
&Unlock ("lock.file");
chmod (0777, "$MembersPath/$thisnumber.cgi");

}
&Lock ("lock.file");
open (LIST, ">>$MembersPath/memberslist.cgi");
	foreach $uno(@memberlist) {
		chomp($uno);
		print LIST "$uno\n";
	}
close (LIST);
&Unlock ("lock.file");
chmod (0666, "$MembersPath/memberslist.cgi");

&Lock ("lock.file");
open (LIST, ">>$MembersPath/emailfile.cgi");
	foreach $uno2(@emailfile) {
		chomp($uno2);
		print LIST "$uno2\n";
	}
close (LIST);
&Unlock ("lock.file");
chmod (0666, "$MembersPath/emailfile.cgi");
if ($Continue eq "true") {
$StartWith = $EndDisplay;
&ContinueMCWording($OldFormat);;
exit;
}  else {

$UserName = "$UserName";
$UserName =~ tr/ /+/;
$Password = "$Password";
$Password =~ tr/ /+/;

unlink("$MembersPath/temp.file");
unlink("$MembersPath/holdmems.cgi");
unlink("$CGIPath/temp.file");
$ConfirmLine = "The Ultimate Bulletin Board General Variables have been updated and all Member records have been converted.<P>
Note that in order to have these changes reflected in old threads, you need to update those threads.  You can do this using the \"Update Threads\" control panel option.  Depending on the number of threads you have stored on your system, the updating process can be time-consuming.  It is thus recommended that you do not update your threads until after you have made all control panel setting changes.<P>";
&ConfirmHTML2;
exit;
}
}  # end continue MC