#!/usr/bin/perl
#
### CONTROL PANEL SCRIPT FOR ULTIMATE BULLETIN BOARD ##
#
# Ultimate Bulletin Board is copyright Madrona Park, Inc., 1998-1999.
#
#       ------------ cpanel.cgi -------------
#
#  This file contains some of the control panel functionality for
#  the UBB.  It is called from the controlpanel pages (cp.html).
#
#  Madrona Park, Inc. offers no
#  warranties on this script.  The owner/licensee of the script is
#  solely responsible for any problems caused by installation of
#  the script or use of the script, including messages that may be
#  posted on the BB.
#
#  All copyright notices regarding the Ultimate Bulletin Board
#  must remain intact on the scripts and in the HTML
#  for the scripts.
#
# For more info on the Ultimate BB, 
# see http://www.UltimateBB.com
#
###############################################################
#If you are running UBB on IIS,
#you may need to add the following line
#if so, just remove the "#" sign before the print line below
#print "HTTP/1.0 200 OK\n";

print ("Content-type: text/html\n\n");
eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file

require "UltBB.setup";
require "mods.file";
require "Styles.file";
require "ubb_library.pl";
require "ubb_library2.pl";

};

if ($@) {
    print "Error including required files: $@\n";
    print "Make sure these files exist, permissions are set properly, and paths are set correctly.";
 exit;
}

my $ThisVersion = "5R3R4";

&ReadParse;

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);

	if ($Name eq "action") {
			$action = $Value;
	}
	if ($Name eq "ViewEntire") {
			$ViewEntire = $Value;
			}
	
	if ($Name eq "NN") {
			$NN = $Value;
			$NN =~tr/A-Z/a-z/;   
			}
	if ($Name eq "Email") {
			$Email = $Value;
			$Email =~tr/A-Z/a-z/;  
		}
	if ($Name eq "UserName") {
			$UserName = $Value;
		}
	if ($Name eq "Password") {
			$Password = $Value;
		}
} #end foreach loop

if ($VariablesPath eq "") {
			$VariablesPath = $CGIPath;
		}
if ($action eq "setmods") {
   &SetMods;
}
if ($action eq "versioncheck") {
   &VersionCheck("$ThisVersion");
}
if ($action eq "UpdateThreads") {
   &UpdateThreads;
}
if ($action eq "prune") {
   &Prune;
}
if ($action eq "digest") {
   &Digest;
}
if ($action eq "index") {
   &Index;
}

if ($action eq "updatepermissforums") {
   &UpdatePermissForums;
}
if ($action eq "addforums") {
   &AddForums;
}
if ($action eq "variables") {
   &Variables;
}

if ($action eq "permissions") {
   &Permissions;
}

if ($action eq "env") {
   &Env;
}

if ($action eq "mail") {
   &Mail;
}
if ($action eq "style") {
   &Styles;
}

if ($action eq "logintoforums") {
   &LogIntoForums;
}

if ($action eq "getbio4admin") {
   &GetBio4Admin($in{'UserNumber'});
}


sub Styles {
if ($profilegif eq "") {
	$profilegif = "profile.gif";
}
if ($mailgif eq "") {
	$mailgif = "email.gif";
}
if ($CopyrightTextColor eq "") {
	$CopyrightTextColor = "#C0C0C0";
}

if ($TextSize eq "") {
	$TextSize = "2";
}



if ($TextColor eq "") {
	$TextColor = "#000000";
}
if ($LinkColor eq "") {
	$LinkColor = "#000080";
}
if ($VisitedLinkColor eq "") {
	$VisitedLinkColor = "#808000";
}
if ($ActiveLinkColor eq "") {
	$ActiveLinkColor = "#800000";
}
if ($TableStripTextColor eq "") {
	$TableStripTextColor = "#000080";
}


if ($BBTitle eq "") {
	$BBTitle = "bbtitle1.jpg";
}
if ($BBTopic eq "") {
	$BBTopic = "topic1.jpg";
}
if ($BBReply eq "") {
	$BBReply = "reply1.jpg";
}
if ($ThreadClosed eq "") {
	$ThreadClosed = "threadclose1.jpg";
}
if ($TableWidth eq "") {
	$TableWidth = "95%";
}
if ($FDTextSize eq "") {
	$FDTextSize = "1";
}
if ($TimeColor eq "") {
	$TimeColor = "#800080";
}
if ($BBTitleFontColor eq "") {
	$BBTitleFontColor = "#800000";
}


$PageTitle = "Set Fonts/Colors/Graphics";
&HEADERHTML;

print<<StyleHTML;
<B>
You can easily change the font face and/or color, graphics, and background colors used throughout your bulletin board using this control panel page.  Note: these changes affect only the bulletin board pages, not any of the control panel pages.  For all colors, we recommend using hexadecimal codes (i.e, #FFFFFF for "white", etc.).
</B>
</FONT>
<P>
<FORM ACTION="cpanel2.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">

<table border=0 >
<TR>
<TD colspan=3 bgcolor="#dedfdf">
<FONT FACE="Verdana" SIZE="2"><B>Color Options</B></FONT>
</TD>
</TR>
<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Page Background Color</B><br>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#FF0000">Format - #FFFFFF</FONT>
</FONT>
</td>
<td valign=top NOWRAP>
<SELECT name="BGColorChoice" onChange="forms[0].BGColor.value=options[selectedIndex].value">
StyleHTML

&Colors;

print<<Style2;
<INPUT TYPE="TEXT" NAME="BGColor" VALUE="$BGColor" SIZE=7 MAXLENGTH=7>
</td></tr>
<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Text Color</B><br></FONT>
</td>
<td valign=top NOWRAP>
<SELECT name="TextColorChoice" onChange="forms[0].TextColor.value=options[selectedIndex].value">
Style2

&Colors;

print<<Style3;
<INPUT TYPE="TEXT" NAME="TextColor" VALUE="$TextColor" SIZE=7 MAXLENGTH=7>
</td></tr>
<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Link Color</B><br></FONT>
</td>
<td valign=top NOWRAP>
<SELECT name="LinkColorChoice" onChange="forms[0].LinkColor.value=options[selectedIndex].value">
Style3

&Colors;

print<<Style4;
<INPUT TYPE="TEXT" NAME="LinkColor" VALUE="$LinkColor" SIZE=7 MAXLENGTH=7>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Active Link Color</B><br></FONT>
</td>
<td valign=top NOWRAP>
<SELECT name="ActiveLinkColorChoice" onChange="forms[0].ActiveLinkColor.value=options[selectedIndex].value">
Style4

&Colors;

print<<Style47;
<INPUT TYPE="TEXT" NAME="ActiveLinkColor" VALUE="$ActiveLinkColor" SIZE=7 MAXLENGTH=7>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Visited Link Color</B><br></FONT>
</td>
<td valign=top NOWRAP>
<SELECT name="VisitedLinkColorChoice" onChange="forms[0].VisitedLinkColor.value=options[selectedIndex].value">
Style47

&Colors;

print<<Style45;
<INPUT TYPE="TEXT" NAME="VisitedLinkColor" VALUE="$VisitedLinkColor" SIZE=7 MAXLENGTH=7>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Table Border Color</B></font><br><FONT SIZE="1" FACE="Verdana, Arial">Leave blank if you do not want a border on tables</FONT>
</td>
<td valign=top NOWRAP>
<SELECT name="TableBorderColorChoice" onChange="forms[0].TableBorderColor.value=options[selectedIndex].value">
Style45

&Colors;

print<<Style5;
<INPUT TYPE="TEXT" NAME="TableBorderColor" VALUE="$TableBorderColor" SIZE=7 MAXLENGTH=7>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Table Header Strip Text Color </B><br></FONT>
</td>
<td valign=top NOWRAP>
<SELECT name="TableStripColorChoice" onChange="forms[0].TableStripTextColor.value=options[selectedIndex].value">
Style5

&Colors;

print<<Style6;
<INPUT TYPE="TEXT" NAME="TableStripTextColor" VALUE="$TableStripTextColor" SIZE=7 MAXLENGTH=7>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Table Header Strip Background Color</B><br></FONT>
</td>
<td valign=top NOWRAP>
<SELECT name="TableColorStripChoice" onChange="forms[0].TableColorStrip.value=options[selectedIndex].value">
Style6

&Colors;

print<<Style7;
<INPUT TYPE="TEXT" NAME="TableColorStrip" VALUE="$TableColorStrip" SIZE=7 MAXLENGTH=7>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Time Color</B><br><FONT SIZE="1" COLOR="#800000" FACE="Verdana, Arial">Used for the time field on the main forum summary page and the forum pages and for the "posted by" line for each thread</FONT></FONT>
</td>
<td valign=top NOWRAP>
<SELECT name="TimeColorChoice" onChange="forms[0].TimeColor.value=options[selectedIndex].value">
Style7

&Colors;

print<<Style8;
<INPUT TYPE="TEXT" NAME="TimeColor" VALUE="$TimeColor" SIZE=7 MAXLENGTH=7>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>First Alternating Table Column Color</B><br></FONT>
</td>
<td valign=top NOWRAP>
<SELECT name="AltColumnColor1Choice" onChange="forms[0].AltColumnColor1.value=options[selectedIndex].value">
Style8

&Colors;

print<<Style85;
<INPUT TYPE="TEXT" NAME="AltColumnColor1" VALUE="$AltColumnColor1" SIZE=7 MAXLENGTH=7>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Second Alternating Table Column Color</B><br></FONT>
</td>
<td valign=top NOWRAP>
<SELECT name="AltColumnColor2Choice" onChange="forms[0].AltColumnColor2.value=options[selectedIndex].value">
Style85

&Colors;

print<<Style9;
<INPUT TYPE="TEXT" NAME="AltColumnColor2" VALUE="$AltColumnColor2" SIZE=7 MAXLENGTH=7>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Category Strip Color</B><br></FONT>
</td>
<td valign=top NOWRAP>
<SELECT name="CategoryStripColorChoice" onChange="forms[0].CategoryStripColor.value=options[selectedIndex].value">
Style9

&Colors;

print<<Style10;
<INPUT TYPE="TEXT" NAME="CategoryStripColor" VALUE="$CategoryStripColor" SIZE=7 MAXLENGTH=7>
</td></tr>
<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Copyright Text Color</B><br></FONT>
</td>
<td valign=top NOWRAP>
<SELECT name="CopyrightTextColorChoice" onChange="forms[0].CopyrightTextColor.value=options[selectedIndex].value">
Style10

&Colors;

print<<Style11;
<INPUT TYPE="TEXT" NAME="CopyrightTextColor" VALUE="$CopyrightTextColor" SIZE=7 MAXLENGTH=7>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>BB Title Font Color</B><br></FONT>
</td>
<td valign=top NOWRAP>
<SELECT name="BBTitleFontColorChoice" onChange="forms[0].BBTitleFontColor.value=options[selectedIndex].value">
Style11

&Colors;

print<<Style12;
<INPUT TYPE="TEXT" NAME="BBTitleFontColor" VALUE="$BBTitleFontColor" SIZE=7 MAXLENGTH=7>
</td></tr>

<tr>
<td bgcolor="#dedfdf"colspan=3><B><FONT FACE="Verdana" SIZE="2">Miscellaneous Graphic Options</FONT></B></TD>
</TR>
<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Font Face (e.g., Verdana)<FONT SIZE="1" FACE="Verdanam, Arial" color="#FF0000"><br>We recommend you use a backup font as well.  For example: to use Verdana as your first choice, with Arial as a conditional font for those users that don't have Verdana as a font on their system, you would type "Verdana, Arial")</FONT></B><br></FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="FontFace" VALUE="$FontFace" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Table Width</B><br></FONT><FONT SIZE="1" FACE="Verdana, Arial" color="#FF0000">You may use either exact pixels (recommended: 600) or a percentage (recommended: 90%)</FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="TableWidth" VALUE="$TableWidth" SIZE=5 MAXLENGTH=7>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Text Size</B><br></FONT><FONT SIZE="1" FACE="Verdana, Arial" color="#FF0000">We recommend using size 2... but depending on your font face, you may want to alter this.</FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="TextSize" VALUE="$TextSize" SIZE=1 MAXLENGTH=1>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Forum Description Text Size</B><br></FONT><FONT SIZE="1" FACE="Verdana, Arial" color="#FF0000">The default setting is for the Forum Description wording to appear as your standard Text Size (which you set above).  You may set the size for the forum descriptions to another size, however, if you prefer. For example, setting the size to 1, when the normal text size is 2 will make the Forum Names appear more prominent.</FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="FDTextSize" VALUE="$FDTextSize" SIZE=1 MAXLENGTH=1>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Page Background Graphic</B><br></FONT><FONT SIZE="1" FACE="Verdana, Arial" color="#FF0000">Not recommended to be used, but you can add a background graphic to your pages.  If you do so, you should upload the graphic into your NON CGI directory and place the name of the background graphic in this field.  For example, background.gif.</FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="PageBackground" VALUE="$PageBackground" SIZE=30 MAXLENGTH=200>
</td></tr>
</table>

<P>

<TABLE BORDER=0>
<tr>
<td bgcolor="#dedfdf"colspan=3><B><FONT FACE="Verdana" SIZE="2"> Graphic Images</B>
<P>
You can choose from 6 coordinated graphic sets, or substitute your own graphics. There are 3 main graphics used- the title or logo graphic that appears at the top of most pages, a "Post New Topic" graphic, a "Post Reply" graphic, and a "Closed Thread" graphic.  All graphics available were created by the very talented <A HREF="mailto:kvail\@prime-web.com">Karen Vail</A>.
<P>
The graphic sets are pictured <A HREF="$NonCGIURL/graphicsets.html">here</A>.  To use one of these graphics, just type in the name of the graphic in the corresponding field.  To use one of your own graphics, type in its own unique name in the corresponding field.  Also, if you use your own graphics, be sure to FTP the images into your Non CGI directory.
<P>
Recommended graphic sizes: if you are creating your own graphics, we recommend that the following sizes (in pixels) be used (in order to fit with layout of the BB): <ul>
<LI> Title/logo graphic- 300 wide by 75 high 
<LI> Post New Topic graphic - 80 wide by 17 high
<LI> Post Reply graphic - 75 wide by 17 high
<LI> Thread Close graphic - 75 wide by 17 high
</ul><br>
Don't forget: if you are using your own custom graphics instead of one of the standard graphics shown above, be sure to upload (FTP) your custom graphics to your UBB NON CGI directory.  You may want to check out the <A HREF="http://www.ultimatebb.com/home/graphics.shtml">UBB Graphics Shop</A> to see graphics created by others for use on the Ultimate Bulletin Board.
</FONT></TD>
</TR>
<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Title Graphic:</B></FONT></td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="BBTitle" VALUE="$BBTitle" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Post New Topic Graphic:</B></FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="BBTopic" VALUE="$BBTopic" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Post Reply Graphic:</B></FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="BBReply" VALUE="$BBReply" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Thread Closed Graphic:</B></FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="ThreadClosed" VALUE="$ThreadClosed" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Profile Graphic:</B></FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="profilegif" VALUE="$profilegif" SIZE=25 MAXLENGTH=50>
</td></tr>

<tr bgcolor="#f7f7f7">
<TD width=5 bgcolor="#000080">&nbsp;
</TD>
<td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Email Graphic:</B></FONT>
</td>
<td valign=top>
<INPUT TYPE="TEXT" NAME="mailgif" VALUE="$mailgif" SIZE=25 MAXLENGTH=50>
</td></tr>
</table>

<P>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="sendstyle">

<CENTER>

<FONT COLOR="#FF0000" face="Verdana, Arial" Size="2">Verify Your Identity<BR>  (only administrators can make these changes)<br></FONT>
<table border=0>
<TR>
<TD>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your User Name</B></FONT>
</td>
<td><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
<TR>
<td>
<B><FONT SIZE="2" FACE="Verdana, Arial">Your Password</FONT></B>
</td>
<td>
<INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td>
</table>

<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Style Changes Now">

</FORM>

<BR><BR><BR>

</CENTER>

<CENTER><FONT SIZE="1" FACE="Verdana, Arial" COLOR="#C0C0C0">Ultimate Bulletin Board, &copy; Madrona Park, Inc., 1998-1999.</FONT></CENTER>
</BODY>
</HTML>
Style12
}  ## END Styles subroutine

sub UpdateThreads {
$PageTitle = "Update Threads";
&HEADERHTML;

print<<Threads;
<FONT SIZE="2" FACE="Verdana, Arial" COLOR="#FF0000">Note: only administrators may update HTML threads. <P>
After you make changes to your control panel settings, these changes take affect immediately for all new pages.  Older HTML pages, however, are not updated until you update them here.  You should run this function after you have made all changes to your control panel settings.
</FONT>
<FORM ACTION="cpanel2.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="doupdate">
<table border=0>
<TR>
<TD>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your User Name</B></FONT>
</td>
<td><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td></tr>
<TR>
<td>
<B><FONT SIZE="2" FACE="Verdana, Arial">Your Password</FONT></B>
</td>
<td>
<INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td></tr>
<TR>
<td>
<B><FONT SIZE="2" FACE="Verdana, Arial">Update Cycle Rate</FONT></B><BR><FONT SIZE="1" FACE="Verdana, Arial">Depending on your server and the number of messages you have stored, you can determine whether to have the UBB update your topic pages (threads) in large chunks or small chunks.  The default setting is 150 topics at a time, per forum.  If you are unable to complete the update process, you may want to try lowering the cycle rate.  Conversely, if you have no trouble at 150, you may want to try setting the rate higher to reduce the amount of time spent on the update.</FONT>
</td>
<td valign=top>
<SELECT NAME="Cycle">
	<OPTION>30
	<OPTION>60
	<OPTION>100
	<OPTION SELECTED>150
	<OPTION>200
	<OPTION>230
	<OPTION>300
</SELECT>
</td></tr>
</table>
<p>
<center>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Update Threads Now!">
</CENTER>

</FORM>
</BODY></HTML>
Threads

}  ## END UpdateThreads SR ##



sub Index {
$PageTitle = "Create/Update Index";
&HEADERHTML;

print<<Index;
<FONT SIZE="2" FACE="Verdana, Arial" COLOR="#FF0000">Note: only administrators may set or update your index.  The index is used for all searches.  If you are upgrading from a version that did not have a search engine included, you MUST create your index before any searches will work.  Just click on the button below!  If you ever have problems, or if your index becomes corrupted for some reason, you can easily create it again here. Otherwise, you do not have to update your index... the UBB is always updating the index automatically, after you originally create it!</FONT>
<FORM ACTION="cpanel2.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="doindex">
<table border=0>
<TR>
<TD>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your User Name</B></FONT>
</td>
<td><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
<TR>
<td>
<B><FONT SIZE="2" FACE="Verdana, Arial">Your Password</FONT></B>
</td>
<td>
<INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td>
</table>
<p>
<center>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Create/Update Index Now!">
</CENTER>

</FORM>
</BODY></HTML>
Index

}  ## END INDEX SR ##


sub LogIntoForums {
$PageTitle = "Set Forum Variables";
&HEADERHTML;

print<<ForumLoginHTML;
To set/add forums or forum variables, you must be an administrator.  Please identify yourself below.
<P><center>
<FORM ACTION="cpanel3.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
<table border=1>
<TR>
<TD>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your User Name</B></FONT>
</td>
<td><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
<TR>
<td>
<B><FONT SIZE="2" FACE="Verdana, Arial">Your Password</FONT></B>
</td>
<td>
<INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td>
</table>
<P>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="forums">
<INPUT TYPE="HIDDEN" NAME="StartPoint" VALUE="0">
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Identification Now">
</center>
</FORM>
<BR><BR><BR>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#C0C0C0">Copyright, Madrona Park, Inc., 1998-1999.
</FONT>
</CENTER>
</BODY>
</HTML>
ForumLoginHTML

}  # end logintoforums sr


sub VersionCheck {
my $VersionNumber = shift;

$PageTitle = "Version Check";

print<<ForumLoginHTML;
<HTML>
<HEAD>
	<TITLE>$BBName</TITLE>
</HEAD>
<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000">
<BR>
<center>
<FONT SIZE="5" FACE="Courier New"><B>$PageTitle</B></FONT>
</center>
<FONT SIZE="2" FACE="Verdana, Arial">
<blockquote>
To compare the current version of the UBB that you are using with the latest released UBB version, press the button below.
</blockquote><center>
<FORM ACTION="http://www.ultimatebb.com/home/version.cgi" METHOD="POST" NAME="THEFORM">
<P>
<INPUT TYPE="HIDDEN" NAME="Yours" VALUE="$VersionNumber">
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Get Version Information Now!">
</center>
</FORM>
<BR><BR><BR>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#C0C0C0">Copyright, Madrona Park, Inc., 1998-1999.
</FONT>
</CENTER>
</BODY>
</HTML>
ForumLoginHTML

}  # end version check sr
sub Env {
print<<TOP;
<HTML><BODY BGCOLOR="#FFFFFF">
<BR><BR>
<CENTER><FONT SIZE="5" FACE="Courier New" ><B>Your Environmental Variables</b></FONT></CENTER>
<P>
<font face="Verdana, Arial" size="2">
Use these to help you figure out your absolute file paths, and other system information.<P>
<FONT face="Verdana, Arial" size="2" COLOR="#800000"><B>Perl Info:</b></FONT><BR>
You are using <b>Perl Version $]</b>
<P>
<FONT face-"Verdana, Arial" size="2" COLOR="#800000"><B>Your Environmental Variables:</b></FONT>
<BR>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#008080">Note: "DOCUMENT_ROOT" shows your absolute path to your root web directory.  "SCRIPT_FILENAME" shows you absolute path of your CGI directory.  If your SCRIPT_FILENAME shows "/www/whatever/whatever/cgi-bin/cpanel.cgi", your Absolute Path variable for your CGI directory would be "/www/whatever/whatever/cgi-bin".</FONT><P>
TOP
for $key (keys(%ENV)) {
printf("%-10.20s: <b>$ENV{$key}</B><BR>", $key);
}

print<<BOTTOM;
</FONT></BODY></HTML>
BOTTOM
}  # END ENV SR



sub AddForums {

# check to see how many forums are currently listed
@forums = &OpenForumsFile;
$ForumTotal = @forums;
$ForumCounter = $ForumTotal + 1;
$PageTitle = "Add New Forum";
&HEADERHTML;

print<<ForumHTML;
<B>
You can add a new forum by completing the form below.  You currently have $ForumTotal forums.  
<P>
</B>
<P>
<FORM ACTION="cpanel3.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
<FONT COLOR="#FF0000">First Identify Yourself (only administrators can add new forums)<br></FONT>
<table border=0>
<TR>
<TD>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your User Name</B></FONT>
</td>
<td><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
<TR>
<td>
<B><FONT SIZE="2" FACE="Verdana, Arial">Your Password</FONT></B>
</td>
<td>
<INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td>
</table>
<hr>
<table border=0 width=95%><TR><TD>
<B><FONT SIZE="3" FACE="Verdana, Arial" COLOR="#800000">Set New Forum Variables Below</FONT></B></td><TD align=center><FONT SIZE="2" FACE="Verdana, Arial">[<A HREF="forumterms.html" target=_new>forum variable terms</A>]</FONT></td></TR></table>
<P>

<table border=0 width=100%>
<tr bgcolor="#D3CE87">
<td colspan=2 valign=top>
<FONT SIZE="2" FACE="Verdana, Arial">
<B>Forum $ForumCounter</B></td></tr>
<TR bgcolor="#D5D2BB">
<TD>
<FONT SIZE="1" FACE="Verdana, Arial"><B>Name:</B></FONT></td>
<td><INPUT TYPE="TEXT" NAME="Name" VALUE="Forum Name" SIZE=30 MAXLENGTH=100></td></tr>
<tr bgcolor="#C7C6BA"><td><FONT SIZE="1" FACE="Verdana, Arial"><B>
Category:</B></FONT></td>
<td><INPUT TYPE="TEXT" NAME="Category" VALUE="" SIZE=30 MAXLENGTH=100></td></tr>

<tr bgcolor="#D5D2BB"><td><FONT SIZE="1" FACE="Verdana, Arial"><B>
Custom Title Graphic:</B><BR>Leave field blank if you want to use your primary title graphic (set in the Styles area).</FONT></td>
<td><INPUT TYPE="TEXT" NAME="TitleGraphic" VALUE="" SIZE=30 MAXLENGTH=100></td></tr>

<TR bgcolor="#C7C6BA"><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>Status:</B></FONT></td>
<td><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="Status" VALUE="On" CHECKED> On &nbsp;&nbsp;&nbsp;&nbsp;
<INPUT TYPE="RADIO" NAME="Status" VALUE="Off"> Off</B></FONT></td></tr>

<TR bgcolor="#D5D2BB"><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>HTML Allowed?</B></FONT></td><TD><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="HTML" VALUE="is"> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="HTML" VALUE="is not" CHECKED> No</B></FONT></td></tr>

<TR bgcolor="#C7C6BA"><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>UBB Code Allowed?</B></FONT></td><TD><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="UBB" VALUE="is" CHECKED> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="UBB" VALUE="is not"> No</B></FONT></td></tr>

<TR bgcolor="#D5D2BB"><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>UBB Code Images Allowed?</B></FONT></td><TD><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="UBBImages" VALUE="ON" CHECKED> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="UBBImages" VALUE="OFF"> No</B></FONT></td></tr>

<TR bgcolor="#C7C6BA" ><TD><FONT SIZE="1" FACE="Verdana, Arial"><B>Moderator Notification? <BR></B><FONT SIZE="1" FACE="Verdana, Arial">If yes, an email will be sent to the moderator every time someone posts a note to the forum (not recommended!)</FONT></FONT></td><TD valign=top><FONT SIZE="1" FACE="Verdana, Arial"><B><INPUT TYPE="RADIO" NAME="ModNotify" VALUE="yes"> Yes &nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="ModNotify" VALUE="no" CHECKED> No</B></FONT></td></tr>

<TR bgcolor="#D5D2BB"><TD valign=top>
<FONT SIZE="1" FACE="Verdana, Arial" color="#800000"><B>Access Limits</B></font><BR><FONT SIZE="1" FACE="Verdana, Arial">You may make the forum completely private- which means that only admins, moderators and those that you grant permission to view (using the User Permissions area in this control panel) may view and post notes in the forum.  If you set a forum password, you can also grant access to private forums and other restricted access forums to those that know the forum password.
<P>
If you do not need to make the forum completely private, you may still restrict posting permissions in various ways. 
<P>
<BR><FONT SIZE="1" FACE="Verdana, Arial" COLOR="#800000">Forum Password:</font> <INPUT TYPE="TEXT" NAME="forumpw" VALUE="" SIZE=12 MAXLENGTH=12>
</FONT>
</td><TD valign=top>
<FONT SIZE="1" FACE="Verdana, Arial"><B>
<CENTER>Completely Private - Read/Write</CENTER><P>
<INPUT TYPE="CHECKBOX" NAME="Private" VALUE="private">
Restrict Viewing and Writing of Posts To Admins, Moderators, those you grant specefic permission to (in User Permissions) and other authorized<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#800000">*</FONT> users
<P>
If private, you can select maximum privacy, which means that all topics are displayed dynamically, checking user identification before displyaing any page, or minimum privacy, which means that topics are stored as HTML (not dynamcially created) for improved server performance, but at a security risk.
<blockquote>
<INPUT TYPE="RADIO" NAME="PrivateMax" VALUE="yes" CHECKED>Maximum Security<BR>
<INPUT TYPE="RADIO" NAME="PrivateMax" VALUE="no">Minimum Security
</blockquote>
<HR>
<BR>
<CENTER>Posting Restrictions (With Viewing of Posts Open to All)</CENTER>
<P>
If forum is not completely private, you can determine which users can post topics and replies within the forum.
<P>
Who Can Post Topics?
<BR>
<SELECT NAME="TopicRestrict">
<option value="restrict">Only admins, moderators and authorized users
<option value="allreg" SELECTED>Any registered users
<option value="all">Any users (including unregistered)
</SELECT>
<P>

Who Can Post Replies?
<BR>
<SELECT NAME="ReplyRestrict">
<option value="restrict">Only admins, moderators and authorized users 
<option value="allreg" SELECTED>Any registered users
<option value="all">Any users (including unregistered)
<option value="none">No one can post replies
</SELECT>
</B></FONT>
<P>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#800000">* An authorized user is someone who is not an administrator or moderator who has either been given specific authority to use a private forum or otherwise-restricted forum.  Administrators can give this permission to a user by either specifically assigning the permission to the user in the control panel User Permissions area or by giving the user the Forum Password to gain entrance.  You can set a forum password in the field to the left.</FONT>
</td></tr>

<TR bgcolor="#c7c6ba" ><TD valign=top><FONT SIZE="1" FACE="Verdana, Arial"><B>Forum Description:</B></FONT><BR><FONT SIZE="1" FACE="Verdana, Arial">This is displayed on your the intro page that summarizes all forums when users visit.  Be sure to set Forum Descriptions "on" in the General Variables section, if you want your visitors to see this description.</font></td><td valign=top><TEXTAREA NAME="Description" ROWS=3 COLS=30 wrap="VIRTUAL">$thisforum[2]</TEXTAREA></td></tr>
</table>

</FONT>
<br>
</B></FONT>
</td>
</tr>
</table>
<P><BR>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="addnewforum">
<INPUT TYPE="HIDDEN" NAME="Number" VALUE="$ForumCounter">
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit New Forum Variables Now">
</FORM>
<P>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#C0C0C0">Ultimate Bulletin Board, &copy; Madrona Park Inc., 1998-1999.</FONT>
</CENTER></font>
</BODY>
</HTML>
ForumHTML
}  ## END AddForums

sub Permissions {
$PageTitle = "Permissions Center";
&HEADERHTML;

print<<permissHTML;
If you are an authorized administrator, you can change the access permissions for any registered BB user.  You may add/remove posting permission or designate registered users as Administrators.  
<P>
<FORM ACTION="cpanel2.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="getmatches">
<center>
<table border=1>
<tr bgcolor="#8EA3B7"><TD colspan=2><FONT SIZE="2" FACE="Verdana, Arial">
<B>Administrator Identification:</B></font>
</td></tr>
<tr bgcolor="#8EA3B7"><td><FONT SIZE="1" FACE="Verdana, Arial"><B>Admin UserName: </B></FONT><BR><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
<td>
<FONT SIZE="1" FACE="Verdana, Arial"><B>Admin Password:</B></FONT><BR><INPUT TYPE="PASSWORD" NAME="Password" SIZE=15 MAXLENGTH=15></td>
</tr>
<TR bgcolor="#C6CFA0">
<TD colspan=2 align=center>
<INPUT TYPE="CHECKBOX" NAME="ViewEntire" VALUE="Yes"><FONT SIZE="1" FACE="Verdana, Arial"><B> &nbsp;&nbsp;Check this box to view all registered users, OR:</b></font>
</td></tr>
<TR bgcolor="#C6CFA0" >
<TD colspan=2><CENTER><FONT SIZE="1" FACE="Verdana, Arial"><B>
Search for registered users by:</b></font></CENTER>
</td></tr>

<TR  bgcolor="#C6CFA0">
<TD WIDTH=200 VALIGN=TOP><FONT SIZE="1" FACE="Verdana, Arial"><B>User Name</B></FONT></td>
<td><INPUT TYPE="TEXT" NAME="NN" VALUE="" SIZE=25 MAXLENGTH=25></td></tr>
<TR  bgcolor="#C6CFA0">
<TD WIDTH=200 VALIGN=TOP><FONT SIZE="1" FACE="Verdana, Arial"><B>Email Address</B></FONT></td>
<td><INPUT TYPE="TEXT" NAME="Email" VALUE="" SIZE=30 MAXLENGTH=70></td></tr>
<TR  bgcolor="#C6CFA0">
<TD WIDTH=200 VALIGN=TOP><FONT SIZE="1" FACE="Verdana, Arial"><B>Number of Posts</B></FONT></td>
<td><SELECT NAME="Math">
	<OPTION VALUE="GT"> \>=
	<OPTION VALUE="LT"> \<=
	<OPTION VALUE="EQ"> ==

</SELECT>
<INPUT TYPE="TEXT" NAME="Posts" VALUE="" SIZE=3 MAXLENGTH=5></td></tr>
</table>
<BR>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Retrieve User Info Now">
<INPUT TYPE="RESET" NAME="Reset" VALUE="Erase Fields">
</form>
<p>
<B><A HREF="$NonCGIURL/controlpanel.html">Control Panel</A>  |  <A HREF="$CGIURL/Ultimate.cgi?action=intro">Bulletin Board</A></B>
<br><br><FONT SIZE="1" FACE="Verdana" COLOR="#000000">Powered by: Ultimate Bulletin Board<BR>
&copy; Madrona Park, Inc., 1998-1999.
</FONT></CENTER>
</FONT>
</BODY>
</HTML>
permissHTML
} ## END Permissions ##

sub Variables {
$PageTitle = "Set Variables";
&HEADERHTML;

print<<VARHTML;
<FONT COLOR="#800000">Note: If you are updating from a previous version, you MUST always reset your system in the following order: GENERAL variables, STYLE variables, FORUM Variables, UPDATE THREADS. You do not have to make any changes to those variables, just press the submit button for each and allow all processing to take place.</FONT>
<P>
As an authorized administrator, you may customize your bulletin board on the fly, without having to edit a variable file by hand.  There are many different kinds of variables, all customizable by you, but they fall into three primary groups: general variables, forum variables, and style variables.
<p>
To configure your bulletin board variables for the first time, <A HREF="cpanel2.cgi?action=DoGenVars">click here</A>.
<P>
To revise existing variables, you must first identify yourself, so that we can verify your status as an administrator.

<P><center>
<FORM ACTION="cpanel2.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
<table border=1>
<TR>
<TD>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your User Name</B></FONT>
</td>
<td><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
<TR>
<td>
<B><FONT SIZE="2" FACE="Verdana, Arial">Your Password</FONT></B>
</td>
<td>
<INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td>
</table>
<P>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="sendvarID">
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Identification Now">
</center>
</FORM>
<BR><BR><BR>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000000">Copyright, Madrona Park, Inc., 1998-1999.
</FONT>
</CENTER>
</BODY>
</HTML>
VARHTML
}


sub SetMods {
$PageTitle = "Set Moderators";
&HEADERHTML;

print<<ModTOP;

<FONT SIZE="2" FACE="Verdana, Arial" COLOR="#FF0000">Note: only administrators may set moderators.  Identify yourself below.</FONT>
<FORM ACTION="cpanel2.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="mods">
<table border=1 width=95%>
<TR bgcolor="#8EA3B7">
<TD colspan=2>
<FONT SIZE="1" FACE="Verdana, Arial"><B>Your User Name</B></FONT><BR><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
<td>
<B><FONT SIZE="1" FACE="Verdana, Arial">Your Password</FONT></B><BR><INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td>
</tr>

<TR bgcolor="#C6CFA0">
<TD>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080"><B>Forum Name</B></FONT>
</td>
<td>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080"><B>Current Moderator</B></FONT>
</td>
<td>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080"><B>Change to:</B></FONT>
</td></tr>
ModTOP

#get current moderator info
$ForumTotal = &GetTotalForums;

for ($x = 1; $x <= $ForumTotal; $x++) {

@thisforum = &GetForumRecord($x);

$ForumName = "$thisforum[1]";
$Moderator = ("Forum" . "$x" . "Moderator");
$Moderator = $$Moderator;

print<<MIDMOD;
<TR bgcolor="#C6CFA0">
<TD>
<FONT SIZE="1" FACE="Verdana, Arial"><B>$ForumName</B></FONT>
</td>
<td>
<FONT SIZE="1" FACE="Verdana, Arial">$Moderator</FONT>
</td>
<td>
<INPUT TYPE="HIDDEN" NAME="OldMod$x" VALUE="$Moderator">
<INPUT TYPE="TEXT" NAME="NewMod$x" VALUE="$Moderator" SIZE=25 MAXLENGTH=25>
</td></tr>
MIDMOD

} ##END FOREACH $line


print<<TRUEBOTTOM;
<tr bgcolor="#C6CFA0">
<TD colspan=3 align=center>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Moderator Changes">
</td></tr>
</table>
<P>
</FORM>
<BR>
<CENTER><B><FONT SIZE="1" FACE="Verdana, Arial">Ultimate Bulletin Board<BR>
&copy; Madrona Park, Inc., 1998-1999.</FONT></B></CENTER>
</BODY></HTML>
TRUEBOTTOM

}  ## END SET MODS SR ##


sub Prune {
$PageTitle = "Edit/Delete/Prune Messages";
&HEADERHTML;

print<<PruneHTML;
<B><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#800000">Note: only moderators and administrators may edit or prune messages.  Moderators may only make changes for their particular forums.  Identify yourself below.</FONT></B>
<FORM ACTION="edit.cgi" METHOD="POST" NAME="THEFORM" onSubmit="return Check(this)">
<center>
<table border=0 cellpadding=0 cellspacing=0 width=90%>
<TR><TD bgcolor="#000000">

<table border=0 width=100%>
<tr bgcolor="#8EA3B7"><TD colspan=3><FONT SIZE="2" FACE="Verdana, Arial">
<B>Administrator/Moderator Identification:</B></font>
</td></tr>
<tr bgcolor="#8EA3B7">
<td width=25>&nbsp;</td>
<td><FONT SIZE="1" FACE="Verdana, Arial"><B>User Name: </B></FONT><BR><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
<td>
<FONT SIZE="1" FACE="Verdana, Arial"><B>Password:</B></FONT><BR><INPUT TYPE="PASSWORD" NAME="Password" SIZE=15 MAXLENGTH=15></td>
</tr>
<TR bgcolor="#C6CFA0">
<TD width=25>
<INPUT TYPE="RADIO" NAME="EditFunction" VALUE="Prune" CHECKED></td>
<td colspan=2>
<FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><B>Prune By Date</FONT><FONT SIZE="1" FACE="Verdana, Arial"> - a mass-delete function that will delete all messages from a forum or forums based on a time-period cut-off that you select.</B></FONT>
</b></font>
</td></tr>
<TR bgcolor="#C6CFA0">
<TD width=25 valign=top>
<INPUT TYPE="RADIO" NAME="EditFunction" VALUE="PruneUser"></td>
<td colspan=2>
<FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><B>Prune By User</FONT><FONT SIZE="1" FACE="Verdana, Arial"> - a mass-delete function that will delete all messages posted by a user.
<P>
If you are deleting a <font color="#800000">registered</font> user's posts, you may type all or part of the user's name and we will retreive a list of matching names.  If you are deleting an <font color="#800000">unregistered</font> user's posts, however, you must type the complete name exactly below.
<P>
User Name: &nbsp;&nbsp;&nbsp; <INPUT TYPE="TEXT" NAME="DeleteName" SIZE=20 MAXLENGTH=25>
<BR>
Is the name registered? <INPUT TYPE="RADIO" NAME="DeleteRegName" VALUE="yes"> 
Registered <INPUT TYPE="RADIO" NAME="DeleteRegName" VALUE="no"> Not registered

</B></FONT>
</b></font>
</td></tr>
<TR bgcolor="#C6CFA0">
<td width=25>
<INPUT TYPE="RADIO" NAME="EditFunction" VALUE="Edit">
</td>
<TD colspan=2><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><B>Edit/Delete A Message</FONT><FONT SIZE="1" FACE="Verdana, Arial"> - edit or delete a particular message.  If you edit, a note will appear on the message that it has been altered by an administrator/moderator.</B></FONT>
</td></tr>
</table>
</td></tr></table>
<p>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Choice">
</form>
</center>
</BODY>
PruneHTML
}  ## END Prune SR

sub HEADERHTML {
print<<HEADER;
<HTML>
<HEAD>
	<TITLE>$BBName</TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
function SetCursor() {
var testUserNameCP = getCookie("UserNameCP");

if (testUserNameCP != null) {  
	document.THEFORM.UserName.value = getCookie("UserNameCP");
document.THEFORM.Password.value = getCookie("PasswordCP");
	}  else {
	document.THEFORM.UserName.focus();
}
}

function Check(form)  {
if ((form.Password.value == "") || (form.UserName.value == ""))  {
	alert ("You forgot to fill in the Username and/or Password fields.  These are required entries!");
	return false
	}  else  {
	return true
	}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}
// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</HEAD>
<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000" onLoad="SetCursor()">
<BR>
<center>
<FONT SIZE="5" FACE="Courier New"><B>$PageTitle</B></FONT>
</center>
<FONT SIZE="2" FACE="Verdana, Arial">
<p>
HEADER
} #end HEADERHTML sr

sub GetBio4Admin {
$ProfileNum = shift;
@thisprofile = &OpenProfile("$ProfileNum.cgi");

$EmailField = qq(<A HREF="mailto:$thisprofile[2]">$thisprofile[2]</A>);

$Permissions = $thisprofile[4];
$Status = $thisprofile[8];

if ($Status eq "Administrator") {
	$Status = "$AdminTitle";
}
elsif ($Status eq "Moderator") {
	$Status = "$ModeratorTitle";
}
elsif ($Status eq "Member") {
	$Status = "$MemberTitle";
}  else {
	$Status = "$JrMemberTitle";
}

($standard, $specific) = split(/\&/, $Permissions);


&ViewBioCPHTML;
}  ## END GET BIO sr


sub ViewBioCPHTML {
&PermissionsTopHTML;

$NameCoded = $thisprofile[0];
$NameCoded = &HTMLIFY($NameCoded);
$NameCoded =~ tr/ /+/;

	#check to see if mass mail is allowed
	open (MEMBERLIST, "$MembersPath/memberslist.cgi"); 
    	my @themembers = <MEMBERLIST>;
	close (MEMBERLIST);

	foreach $thisline(@themembers) {
	my @profiles = split(/\|\!\!\|/, $thisline);
	$GetName = $UserName;
	$GetName =~ s/([\^|\.|\$|\*\|\?|\(|\)|\{|\}|\[|\]|\\|\&|\%|\@])/\\$1/isg;
	if ($thisline =~ /^$GetName\|\!\!\|/) {
		chomp($profiles[3]);
		$AllowMassMail = $profiles[3];
	}
}
	
if ($AllowMassMail eq "") {
	$AllowMassMail = "yes";
}

print<<BioHTML;
<P><FONT SIZE="2" FACE="Verdana, Arial"><B>
<BR>
<center>
<table border=0 cellpadding=0 cellspacing=0 width="90%"><TR><td bgcolor="#000000">

<table cellpadding=4 cellspacing=1 border=0  width=100%>
<TR bgcolor="#C6CFA0">
<TD><FONT SIZE="2" FACE="Verdana, Arial">
<IMG SRC="$NonCGIURL/profile.gif" WIDTH=22 HEIGHT=11 BORDER=0 ALT="Profile"> &nbsp;&nbsp;&nbsp;Profile for $thisprofile[0]
</FONT></td><td><FONT SIZE="1" FACE="Verdana, Arial"><A HREF="$CGIURL/search.cgi?action=simplesearch&ForumChoice=ALL&SearchUser=$NameCoded&ExactName=yes">View Posts By This User</A></font></td></tr>
<tr bgcolor="#C6CFA0"><td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Date Registered:</B></FONT></td>
<td><FONT SIZE="2" FACE="Verdana, Arial">$thisprofile[10]</FONT>
</td></tr>
<tr bgcolor="#C6CFA0"><td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Status:</B></FONT></td>
<td><FONT SIZE="2" FACE="Verdana, Arial">$Status</FONT>
</td></tr>
<tr bgcolor="#C6CFA0"><td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Total Posts:</B></FONT></td>
<td><FONT SIZE="2" FACE="Verdana, Arial">$thisprofile[7]</FONT>
</td></tr>
<tr bgcolor="#C6CFA0"><td>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Current Email:</B></FONT></td>
<td><FONT SIZE="2" FACE="Verdana, Arial">$EmailField</FONT>
</td></tr>
<TR bgcolor="#C6CFA0">
<td><FONT SIZE="2" FACE="Verdana, Arial"><B>Homepage:</B></font></td>
<td><FONT SIZE="2" FACE="Verdana, Arial"><A HREF="$thisprofile[3]" target=_top>$thisprofile[3]</A></font>
</td></tr>
<TR bgcolor="#C6CFA0">
<td><FONT SIZE="2" FACE="Verdana, Arial"><B>Occupation:</B></font></td>
<td><FONT SIZE="2" FACE="Verdana, Arial">$thisprofile[5]</font>
</td></tr>
<TR bgcolor="#C6CFA0">
<td><FONT SIZE="2" FACE="Verdana, Arial"><B>Location:</B></font></td>
<td><FONT SIZE="2" FACE="Verdana, Arial">$thisprofile[6]</font>
</td></tr>
<TR bgcolor="#C6CFA0">
<td><FONT SIZE="2" FACE="Verdana, Arial"><B>Interests:</B></font></td>
<td><FONT SIZE="2" FACE="Verdana, Arial">$thisprofile[9]</font>
</td></tr>
<TR bgcolor="#C6CFA0">
<td><FONT SIZE="2" FACE="Verdana, Arial"><B>ICQ Number:</B></font></td>
<td><FONT SIZE="2" FACE="Verdana, Arial">$thisprofile[13]</font>
</td></tr>


<tr bgcolor="#C6CFA0">
<td valign=top><FONT SIZE="2" FACE="Verdana, Arial"><B>
Signature</FONT></B>
</td>
<td>
<TEXTAREA NAME="Signature" ROWS=3 COLS=25>$Signature
</TEXTAREA>
</td></tr>

 <TR bgcolor="#C6CFA0">
	<TD><FONT SIZE="2" FACE="Verdana, Arial"><B>Allow Bulletin Board Administrators and Moderators To Send User Email Notices?</B></FONT></TD>
	<TD><FONT SIZE="2" FACE="Verdana, Arial">$AllowMassMail</FONT>
 </TD></tr>
 

</table>

</td></tr></table>
</center>
</BLOCKQUOTE>
Permissions for this User in Private or Restricted Access Forums:<P>
BioHTML


my $NoAccess = "";
my $DoList = "";
#get users current forum permissions--
if ($Permissions =~ m/Admin/) {
	print "This user is an administrator and thus has permission to view and post to all forums.";
}  
elsif ($Status eq "Moderator") {
print "This user is a Moderator.  Moderators have complete access to all forums for which they moderate.  For forums for which the user is Moderator, full access may not be removed.  We have summarized this user's access in the following private or restricted-access forums.";
}  

print<<ACCESS;
<BR>
<FORM ACTION="cpanel.cgi" METHOD="POST" NAME="PERMISS">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="updatepermissforums">
<INPUT TYPE="HIDDEN" NAME="regnumber" VALUE="$ProfileNum">
<table border=0 width=95%>
<tr bgcolor="#d5d2bb">
<TD><FONT SIZE="1" FACE="Verdana, Arial">Forum Name</font></td><td><FONT SIZE="1" FACE="Verdana, Arial">Forum Status</font></td><td><FONT SIZE="1" FACE="Verdana, Arial">Grant User Permission in this Forum?</font></td></tr>
ACCESS

if  (($specific ne "") || ($Status eq "Administrator") || ($Status eq "Moderator"))  {
@forumaccess = split(",", $specific);
} else {
$NoAccess = "true";
}

#get forum info- find private or limited write forums
@forums = &OpenForumsFile;
@sortfor = sort(@forums);
@sortforums = reverse(@sortfor);

for $each2(@sortforums) {
	@ForumLine = split(/\|/, $each2);
	
		if (($ForumLine[6] eq "private") || ($ForumLine[6] eq "partly") || ($ForumLine[6] eq "yes")) {
if ($ForumLine[6] eq "private") {
	$StatusWord = "Private";
	$Describe1 = "Grant access for this user.";
}
elsif ($ForumLine[6] eq "yes") {
	$StatusWord = "Restriction on Writing Posts and Replies";
	$Describe1 = "Allow this user to post new topics and replies in this forum.";
}  else {
$StatusWord = "Restriction on Writing Topics";
$Describe1 = "Allow this user to post new topics in this forum.";
}
my $ThisMod = "";

if ($Status = "Moderator") {
$Moderator = ("Forum" . "$ForumLine[8]" . "Moderator");
$Moderator = $$Moderator;
if ($Moderator eq "$thisprofile[0]") {
	$ThisMod = "true";
}
}

if ($NoAccess eq "true") {
$CheckMark = "";
}  else {

$CheckMark = "";

foreach $uno(@forumaccess) {
chomp($uno);
$uno =~ tr/ //;
	if ($uno eq "$ForumLine[8]") {
	$CheckMark = "CHECKED";
	}
}

}
if ($Permissions =~ m/Admin/) {
print<<SelectHTML;
<TR>
<TD><FONT SIZE="1" FACE="Verdana, Arial">$ForumLine[1]</FONT></td><td><FONT SIZE="1" FACE="Verdana, Arial">$StatusWord</FONT></td><td><FONT SIZE="1" FACE="Verdana, Arial">User is Administrator!  Unrestricted Access/Permissions in this forum.</font></td></tr>
SelectHTML
}
elsif ($ThisMod eq "true") {
print<<SelectHTML;
<TR>
<TD><FONT SIZE="1" FACE="Verdana, Arial">$ForumLine[1]</FONT></td><td><FONT SIZE="1" FACE="Verdana, Arial">$StatusWord</FONT></td><td><FONT SIZE="1" FACE="Verdana, Arial">User is Moderator!  Unrestricted Access/Permissions in this forum.</font></td></tr>
SelectHTML
}  else {
print<<SelectHTML;
<TR>
<TD><FONT SIZE="1" FACE="Verdana, Arial">$ForumLine[1]</FONT></td><td><FONT SIZE="1" FACE="Verdana, Arial">$StatusWord</FONT></td><td><FONT SIZE="1" FACE="Verdana, Arial"><INPUT TYPE="CHECKBOX" NAME="Access" VALUE="$ForumLine[8]" $CheckMark>
$Describe1</font></td></tr>
SelectHTML
}
}
	
}  #end for loop

print<<theend;
</table>
theend




print<<BioHTML2;
<P>
<CENTER><FONT Size="2" FACE="Verdana, Arial" COLOR="#800000"><B>For security reasons, re-enter your UserName & Password: <BR>
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT></B>
<P>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Forum Permission Changes For This User">
</CENTER>
</form>
</font>
</BODY></HTML>
BioHTML2
}  ## END View BIO HTML sr

sub Colors {
print<<TheColors;
<OPTION value="" selected> Select New Color?
		<OPTION value="#ffffff" > White
        <OPTION value="#ff0000" > Red
        <OPTION value="#00ff00" > Green 
        <OPTION value="#0000ff" > Blue 
        <OPTION value="#ff00ff" > Magenta 
        <OPTION value="#00ffff" > Cyan
        <OPTION value="#ffff00" > Yellow 
        <OPTION value="#000000" > Black 
        <OPTION value="#70db93" > Aquamarine 
        <OPTION value="#a62a2a" > Brown 
        <OPTION value="#b87333" > Copper
        <OPTION value="#ff7f00" > Coral
        <OPTION value="#871f78" > Dark Purple
        <OPTION value="#97694f" > Dark Tan
        <OPTION value="#238e23" > Forest Green
        <OPTION value="#cd7f32" > Gold
        <OPTION value="#a8a8a8" > Grey
        <OPTION value="#9f9f5f" > Khaki
        <OPTION value="#c0d9d9" > Light Blue
		<OPTION value="#808000" > Light Copper
        <OPTION value="#cccccc" > Light Grey
        <OPTION value="#ffffcc" > Light Yellow
        <OPTION value="#32cd32" > Lime Green
        <OPTION value="#8e236b" > Maroon
        <OPTION value="#2f2f4f" > Midnight Blue
		<OPTION value="#000080" > Navy Blue
        <OPTION value="#ff7f00" > Orange
        <OPTION value="#8FBC8F" > Pale Green
        <OPTION value="#BC8F8F" > Pink
        <OPTION value="#E6E8fA" > Silver
        <OPTION value="#3299CC" > Sky Blue
		<OPTION value="#F7F7F7" > UBB Col1 Grey
		<OPTION value="#DEDFDF" > UBB Col2 Grey
        <OPTION value="#CC3299" > Violet
		<OPTION value="" > Other (type code)... 
			</SELECT>&nbsp;&nbsp;
TheColors
} # end colors sr

sub UpdatePermissForums {

$ProfileNumber = &GetUserNumber($in{'UserNameCheck'});

@adminprofile = &OpenProfile("$ProfileNumber.cgi");

if ($in{'PasswordCheck'} eq "$adminprofile[1]") {
	$Status = "$adminprofile[8]";
	&CheckStatus;
	   if ($AdminStatus eq "true") {
			&UpdateThePermForums;
		}  else {
			&StandardHTML("Sorry, but you are not authorized to perform this function.  Use your Back button.");
		} #end if adminstatus is true 
}  else {
&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
}

} #end update permiss forums

sub UpdateThePermForums {

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	
		if ($Name eq "Access") {
			  push(@accessarray, $Value)
		}
}

if (@accessarray) {
$AccessLine = join(",", @accessarray);
}  else {
$AccessLine = "";
}
$profilenum = $in{'regnumber'};
 
@theprofile = &OpenProfile("$profilenum.cgi");
$OldPermission = $theprofile[4];
($general, $specific) = split(/\&/, $OldPermission);
$NewPermission = ("$general" . "&" . "$AccessLine");
$theprofile[4] = $NewPermission;

&Lock("lock.file");
open (MEMBERSHIP, ">$MembersPath/$profilenum.cgi") or die("Unable to open Members directory.");

foreach $one(@theprofile) {
chomp($one);
	print MEMBERSHIP ("$one\n");
}
close (MEMBERSHIP);
&Unlock("lock.file");
chmod (0777, "$MembersPath/$profilenum.cgi");

$ConfirmLine = "We have made the changes you requested.";
&ConfirmHTML;

}  #end updatethepermforums


sub CheckStatus {

		if ($Status =~ m/Administrator/) {
			$AdminStatus = "true";
			} else {
			$AdminStatus = "false";
		}
		

		if ($Status =~ m/Moderator/) {
			$ModStatus = "true";
		} else {
			$ModStatus = "false";
		}
		if ($Permission =~ m/Write/) {
			$AdminWrite = "true";
		} else {
			$AdminWrite = "false";
		}

} #end CheckStatus


sub Mail {
$PageTitle = "Send An Email To Users";
&HEADERHTML;

print<<Index;
<FONT SIZE="2" FACE="Verdana, Arial">Note: only administrators may send a mass email to all registered users.  Note that email will not be sent to registered users who elect not to receive it.  One profile option at your registered users' disposal is to not receive such mailings.
<P>
This email will be sent to each user separately (users will not receive a list of all email addresses).
<P>
If you prefer, you may also use your own bulk mail software program and simply generate a list of email addresses for your registered users (which you can then import into your bulk email program).  To do that instead, check the box under the message box below.</FONT>
<P>
<FORM ACTION="ubbmail.cgi" METHOD="POST" NAME="THEFORM">
<INPUT TYPE="HIDDEN" NAME="start" VALUE="0">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="mailusers">
<table border=0>
<TR>
<TD>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your User Name</B></FONT>
</td>
<td><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
<TR>
<td>
<B><FONT SIZE="2" FACE="Verdana, Arial">Your Password</FONT></B>
</td>
<td>
<INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td></tr>
<TR>
<td valign=top>
<B><FONT SIZE="2" FACE="Verdana, Arial">Your Email Subject:</FONT></B>
</td>
<td><INPUT TYPE="TEXT" NAME="Subject" SIZE=30 MAXLENGTH=90>
</td></tr>
<TR>
<td valign=top>
<B><FONT SIZE="2" FACE="Verdana, Arial">Your Email Message:</FONT></B>
</td>
<td><TEXTAREA NAME="Message" ROWS=10 COLS=25>
</TEXTAREA>
</td></tr>

</table>
<HR>
<FONT SIZE="1" FACE="Verdana, Arial"><INPUT TYPE="CHECKBOX" NAME="createlist" value="yes">&nbsp;&nbsp;
<B>Create Email List Instead: If you would rather simply create a list of registered users' email addresses, check this box (and leave the subject and message fields blank above).  You can then import that list into your own bulk email program.</B>
<CENTER><INPUT TYPE="RADIO" NAME="delimit" VALUE="comma">
Comma-delimited list  &nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="delimit" VALUE="line" CHECKED>Line return list</CENTER>
</FONT>
<HR>
<center>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Send Email Now!">
</CENTER>

</FORM>
</BODY></HTML>
Index

}  ## END MAIL SR ##

sub Digest {
$PageTitle = "Digest Center";
&HEADERHTML;

print<<Index;
<P>
<FONT SIZE="2" FACE="Verdana, Arial">Note: only administrators or moderators may use the Digest Center.
<P>
Digests are summaries of topics posted to a given forum over a certain time period.  These digests will be emailed to a list of subscribers when you so designate.  You cannot have digests sent out automatically at a certain interval.  You must return to this center and select the "Send Digest To Subscribers" option below in order to send a digest.
</FONT>
<P>
<A NAME="currentdigests">Here is a list of your current digests:</A>
<P>
<table border=0 width=100%>
<TR bgcolor="#B0BB9D">
<TD><FONT SIZE="1" FACE="Verdana, Arial">Digest Name</FONT></td>
<TD><FONT SIZE="1" FACE="Verdana, Arial">Forum Number</FONT></td>
<TD><FONT SIZE="1" FACE="Verdana, Arial">Last Digest Sent</FONT></td></tr>
Index

#retrieve current digests...
if (-e "$NonCGIPath/digests/digestsummary.cgi") {
open (DIGESTS, "$NonCGIPath/digests/digestsummary.cgi");
@digestsummary = <DIGESTS>;
close(DIGESTS);

foreach $uno(@digestsummary) {
@thisone = split(/\|/, $uno);
@thisfor = &GetForumRecord($thisone[0]);
my $ForumName = $thisfor[1];
print qq(<tr bgcolor="#C7C6BA"><td><FONT SIZE="1" FACE="Verdana, Arial">$ForumName</font></td><td><FONT SIZE="1" FACE="Verdana, Arial">$thisone[0]</font></td><td><FONT SIZE="1" FACE="Verdana, Arial">$thisone[1]</font></td></tr>);
}

}  else {
	print qq(<tr bgcolor="#C7C6BA"><td align=center colspan=3><FONT SIZE="1" FACE="Verdana, Arial"><B>No Digests Have Been Created.</B></font></td></tr>);
}

print<<Index2;
</table>
<P>
<FORM ACTION="ubbmail.cgi" METHOD="POST" NAME="THEFORM">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="digeststart">
<center>
<table border=0 width=95% cellpadding=0 cellspacing=0><TR><TD bgcolor="#000000">

<table border=0 width=100%>
<TR bgcolor="#B0BB9D">
<TD>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your User Name</B></FONT>
</td>
<td><INPUT TYPE="TEXT" NAME="UserName" SIZE=25 MAXLENGTH=25>
</td>
<TR bgcolor="#B0BB9D">
<td>
<B><FONT SIZE="2" FACE="Verdana, Arial">Your Password</FONT></B>
</td>
<td>
<INPUT TYPE="PASSWORD" NAME="Password" SIZE=13 MAXLENGTH=13>
</td></tr>
<TR bgcolor="#C7C6BA">
<td>
<B><FONT SIZE="2" FACE="Verdana, Arial">What Do You Want To Do?</FONT></B>
</td>
<td>
<SELECT NAME="DigestOption">
	<OPTION value="1">Create New Forum Digest
	<OPTION value="2">Delete Existing Forum Digest
	<OPTION value="3">Add/Remove Subscribers From Digest
	<OPTION value="4">Send Digest to Subscribers
</SELECT>
</td></tr>

</table>

</td></tr></table>
<P>

<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Request Now">
</form>
<P>
<FONT SIZE="1" FACE="Verdana, Arial">&copy <A HREF="http://www.madronapark.com">Madrona Park, Inc.</A>, 1999.</FONT>
</CENTER>

</BODY></HTML>
Index2

}  ## END DIGEST SR ##