#include "stdafx.h"
#include "AspNTUser.h"

void HandleError( NET_API_STATUS res )
{
	ULONG size = 100;
	CString strErr;
	char name[200];
	
	switch( res )
	{
		case NERR_Success:
			break;
	
		case ERROR_ACCESS_DENIED:
			::GetUserName( name, &size );		
			strErr.Format( "Access Denied. User: %s.", name );
			THROW_EXCEPTION( _ERROR_ACCESSDENIED, strErr );
			break;

		case ERROR_PRIVILEGE_NOT_HELD:
			::GetUserName( name, &size );		
			strErr.Format( "Privilege not held. You must have \"Act as Part of the Operating System\" privilege to use this method. User: %s.", name );
			THROW_EXCEPTION( _ERROR_PRIVILEGENOTHELD, strErr );
			break;


		case NERR_InvalidComputer:
			THROW_EXCEPTION( _ERROR_INVALIDCOMPUTER, "Invalid Computer." );
			break;

		case NERR_UserExists:
			THROW_EXCEPTION( _ERROR_USEREXISTS, "User exists." );
			break;

		case NERR_PasswordTooShort:
			THROW_EXCEPTION( _ERROR_PASSWORDTOOSHORT, "Password too short." );
			break;

		case NERR_GroupExists:
			THROW_EXCEPTION( _ERROR_GROUPEXISTS, "Group exists." );
			break;
		
		case NERR_SpeGroupOp:
			THROW_EXCEPTION( _ERROR_SPECIALGROUP, "Operation not allowed on specified special groups." );
			break;

		case NERR_NotPrimary:
			THROW_EXCEPTION( _ERROR_NOTPRIMARY, "Operation allowed only on primary domain." );
			break;

		case NERR_UserNotFound:
			THROW_EXCEPTION( _ERROR_USERNOTFOUND, "User not found." );
			break;

		case NERR_GroupNotFound:
			THROW_EXCEPTION( _ERROR_GROUPNOTFOUND, "Group not found." );
			break;

		case NERR_BadUsername:
			THROW_EXCEPTION( _ERROR_BADUSERNAME, "Bad user name." );
			break;

		case ERROR_NO_SUCH_MEMBER:
			THROW_EXCEPTION( _ERROR_NOSUCHMEMBER, "No such member." );
			break;

		case ERROR_INVALID_PASSWORD:
			THROW_EXCEPTION( _ERROR_INVALIDPASSWORD, "Invalid Password." );
			break;

		case ERROR_LOGON_FAILURE:
			THROW_EXCEPTION( _ERROR_BADUSERPWD, "Unknown user name or bad password." );
			break;

		case ERROR_NO_SUCH_DOMAIN:
			THROW_EXCEPTION( _ERROR_NO_SUCH_DOMAIN, "No such domain." );
			break;

		case ERROR_MEMBER_IN_ALIAS:
		case NERR_UserInGroup:
			// This is not a fatal condition, so don't throw an exception
			//AfxThrowOleDispatchException( ERROR_MEMBER_IN_ALIAS, "Already Member of local group." );
			break;

		default:
			{
				LPVOID lpMsgBuf;	\
				FormatMessage( FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,	\
				NULL, res, MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),	\
				(LPTSTR) &lpMsgBuf, 0, NULL );	\
												\
				THROW_EXCEPTION( _ERROR_UNKNOWN, (char*)lpMsgBuf );	\
				LocalFree( lpMsgBuf );
			}
	}
}